/*
 * Decompiled with CFR 0.152.
 */
package problem;

import constraints.Constraint;
import constraints.CtrHard;
import constraints.CtrRaw;
import constraints.hard.CtrExtension;
import constraints.hard.CtrHardFalse;
import constraints.hard.CtrHardTrue;
import constraints.hard.CtrIntension;
import constraints.hard.extension.CtrExtensionMDD;
import constraints.hard.extension.CtrExtensionOrMDD;
import constraints.hard.extension.CtrExtensionSmart;
import constraints.hard.extension.structures.MDDCD;
import constraints.hard.extension.structures.SmartTuple;
import constraints.hard.global.AllDifferent;
import constraints.hard.global.AllDifferentBound;
import constraints.hard.global.AllDifferentCounting;
import constraints.hard.global.AllDifferentExceptWeak;
import constraints.hard.global.AllDifferentPermutation;
import constraints.hard.global.AllDifferentWeak;
import constraints.hard.global.AllEqual;
import constraints.hard.global.Among;
import constraints.hard.global.CardinalityConstant;
import constraints.hard.global.Circuit;
import constraints.hard.global.Count;
import constraints.hard.global.Cumulative;
import constraints.hard.global.Element;
import constraints.hard.global.ElementMatrix;
import constraints.hard.global.ExactlyKVariable;
import constraints.hard.global.Extremum;
import constraints.hard.global.HammingProximityConstant;
import constraints.hard.global.Lexicographic;
import constraints.hard.global.NValues;
import constraints.hard.global.NValuesVar;
import constraints.hard.global.NotAllEqual;
import constraints.hard.global.ObjVar;
import constraints.hard.global.SumScalarBoolean;
import constraints.hard.global.SumSimple;
import constraints.hard.global.SumWeighted;
import constraints.hard.primitive.CtrPrimitiveBinary;
import dashboard.ControlPanel;
import executables.Resolution;
import heuristics.values.HeuristicValues;
import heuristics.values.HeuristicValuesDirect;
import interfaces.ObserverConstruction;
import interfaces.ObserverDomainReduction;
import interfaces.OptimizationCompatible;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import objectives.OptimizationPilot;
import org.w3c.dom.Document;
import org.xcsp.common.Condition;
import org.xcsp.common.FunctionalInterfaces;
import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Domains;
import org.xcsp.common.domains.Values;
import org.xcsp.common.enumerations.EnumerationCartesian;
import org.xcsp.common.predicates.TreeEvaluator;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeLeaf;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.common.structures.AbstractTuple;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Table;
import org.xcsp.common.structures.Transition;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.definitions.ICtr;
import org.xcsp.modeler.entities.CtrEntities;
import org.xcsp.modeler.entities.ObjEntities;
import org.xcsp.modeler.entities.VarEntities;
import org.xcsp.modeler.implementation.ProblemIMP;
import problem.Compiler3Abscon;
import problem.IdentificationAllDifferent;
import problem.IdentificationAutomorphism;
import problem.ProblemStuff;
import problem.Subproblem;
import problem.Symbolic;
import propagation.order1.PropagationForward;
import propagation.order2.path.PC8;
import search.Solver;
import search.backtrack.RestarterLocalBranching;
import utility.Enums;
import utility.Kit;
import utility.Reflector;
import utility.exceptions.MissingImplementationException;
import variables.Variable;
import variables.VariableInteger;
import variables.VariableSymbolic;
import variables.domains.Domain;

public class Problem
extends ProblemIMP
implements ObserverConstruction {
    public static final Boolean DONT_KNOW = null;
    public static final Boolean STARRED = Boolean.TRUE;
    public static final Boolean UNSTARRED = Boolean.FALSE;
    public static final String AUXILIARY_VARIABLE_PREFIX = "aux_";
    public final Resolution rs;
    public Types.TypeFramework framework;
    public Solver solver;
    public Variable[] variables;
    public Constraint[] constraints;
    public OptimizationPilot optimizationPilot;
    public Variable[] priorityVars = new Variable[0];
    public int nStrictPriorityVars;
    public ProblemStuff stuff;
    public Symbolic symbolic;
    public int nTuplesRemoved;
    public int nValuesRemoved;
    public final List<List<int[]>> symmetryGroupGenerators = new ArrayList<List<int[]>>();
    public final Collection<ObserverDomainReduction> observersDomainReduction = new ArrayList<ObserverDomainReduction>();
    public RestarterLocalBranching.LocalBranchingConstraint localBranchingConstraints;
    public final List<int[]> domainTypes = new ArrayList<int[]>();
    public List<String> undisplay = new ArrayList<String>();
    public final Map<String, Variable> mapForVars = new HashMap<String, Variable>();
    private ProblemIMP.Converter converter = new ProblemIMP.Converter(){

        @Override
        public StringBuilder signatureFor(IVar.Var[] scp) {
            return Variable.signatureFor((Variable[])scp);
        }

        @Override
        public int[][] domValuesOf(IVar.Var[] scp) {
            return Variable.initDomainValues((Variable[])scp);
        }

        @Override
        public Utilities.ModifiableBoolean mode() {
            Enums.EExportMode exportMode = Enums.EExportMode.EXTENSION;
            return new Utilities.ModifiableBoolean(exportMode != Enums.EExportMode.EXTENSION_SUPPORTS && exportMode != Enums.EExportMode.EXTENSION_CONFLICTS ? null : Boolean.valueOf(exportMode == Enums.EExportMode.EXTENSION_SUPPORTS));
        }
    };
    public static final String vfsComment = "Either you set -f=cop or you set -f=csp together with -vfs=v where v is an integer value forcing the value of the objective.";

    private Variable[] prioritySumVars(Variable[] scp, int[] coeffs) {
        int i2;
        assert (coeffs == null || IntStream.range(0, coeffs.length - 1).allMatch(i -> coeffs[i] <= coeffs[i + 1]));
        int LIM = 3;
        Term[] terms = new Term[Math.min(scp.length, 2 * LIM)];
        if (terms.length == scp.length) {
            for (i2 = 0; i2 < terms.length; ++i2) {
                terms[i2] = new Term((long)(coeffs == null ? 1 : coeffs[i2]) * scp[i2].dom.highestValueDistance(), scp[i2]);
            }
        } else {
            for (i2 = 0; i2 < LIM; ++i2) {
                terms[i2] = new Term((long)(coeffs == null ? 1 : coeffs[i2]) * scp[i2].dom.highestValueDistance(), scp[i2]);
            }
            for (i2 = 0; i2 < LIM; ++i2) {
                terms[LIM + i2] = new Term((long)(coeffs == null ? 1 : coeffs[scp.length - 1 - i2]) * scp[scp.length - 1 - i2].dom.highestValueDistance(), scp[scp.length - 1 - i2]);
            }
        }
        if ((terms = (Term[])Stream.of(terms).filter(t -> t.coeff < -2L || t.coeff > 2L).sorted().toArray(Term[]::new)).length > 0) {
            Variable[] t2 = (Variable[])Stream.of(terms).map(term -> term.var).toArray(Variable[]::new);
            if (t2.length > LIM) {
                t2 = Arrays.copyOfRange(t2, t2.length - LIM, t2.length);
            }
            Variable[] tt = new Variable[t2.length];
            for (int i3 = 0; i3 < t2.length; ++i3) {
                tt[i3] = t2[t2.length - 1 - i3];
            }
            return tt;
        }
        return null;
    }

    @Override
    public void onConstructionProblemFinished() {
        Kit.control(Variable.areNumsNormalized(this.variables) && Constraint.areNumsNormalized(this.constraints), () -> "Non normalized nums in the problem");
        for (Variable x : this.variables) {
            x.dom.finalizeConstructionWith(this.variables.length + 1);
            Kit.control(Stream.of(x.ctrs).noneMatch(c -> c.num == -1), () -> "Pb with a non posted constraint ");
        }
        HashSet<String> allIds = new HashSet<String>();
        for (Variable x : this.variables) {
            String name = x.id();
            Kit.control(!allIds.contains(name));
            allIds.add(name);
        }
        Kit.control(this.framework == Types.TypeFramework.COP == (this.optimizationPilot != null), () -> "Not a COP " + (Object)((Object)this.framework) + " " + (this.optimizationPilot == null));
        if (this.rs.cp.experimental.save4Baudouin) {
            Stream.of(this.constraints).forEach(c -> ((CtrHard)c).save4Baudouin());
        }
        if (this.priorityVars.length == 0 && this.annotations.decision != null) {
            this.priorityVars = (Variable[])this.annotations.decision;
        }
        boolean strong = false;
        if (this.framework == Types.TypeFramework.COP && this.rs.cp.valh.optValHeuristic) {
            int[] coeffs;
            Variable[] scp;
            Constraint c2 = (Constraint)((Object)this.optimizationPilot.ctr);
            if (c2 instanceof ObjVar) {
                Variable x = c2.scp[0];
                x.heuristicVal = this.optimizationPilot.minimization ? new HeuristicValuesDirect.First(x, false) : new HeuristicValuesDirect.Last(x, false);
                this.priorityVars = new Variable[]{x};
            } else if (c2 instanceof Extremum.ExtremumCst) {
                if (strong) {
                    for (Variable x : c2.scp) {
                        x.heuristicVal = this.optimizationPilot.minimization ? new HeuristicValuesDirect.First(x, false) : new HeuristicValuesDirect.Last(x, false);
                    }
                }
            } else if (c2 instanceof NValues) {
                assert (c2 instanceof NValues.NValuesLE);
                if (strong) {
                    for (Variable x : c2.scp) {
                        x.heuristicVal = new HeuristicValuesDirect.Values(x, false, c2.scp);
                    }
                }
            } else if (c2 instanceof SumWeighted && (scp = this.prioritySumVars(c2.scp, coeffs = c2 instanceof SumSimple ? null : ((SumWeighted)c2).coeffs)) != null) {
                for (Variable x : scp) {
                    int coeff = c2 instanceof SumSimple ? 1 : coeffs[c2.positionOf(x)];
                    boolean f = this.optimizationPilot.minimization && coeff >= 0 || !this.optimizationPilot.minimization && coeff < 0;
                    System.out.println("before " + x + " " + x.heuristicVal);
                    x.heuristicVal = f ? new HeuristicValuesDirect.First(x, false) : new HeuristicValuesDirect.Last(x, false);
                    System.out.println("after " + x.heuristicVal);
                }
                this.priorityVars = scp;
            }
        }
    }

    @Override
    public void onConstructionSolverFinished() {
        Stream.of(this.variables).forEach(x -> x.dom.setSolver(this.solver));
    }

    public final Range range(int length) {
        return new Range(length);
    }

    @Override
    public final String name() {
        String s = super.name();
        return s.matches("XCSP[23]-.*") ? s.substring(6) : s;
    }

    public final void modifyAskedParameter(int index, Object value) {
        this.parameters.set(index, new AbstractMap.SimpleEntry(value, ((AbstractMap.SimpleEntry)this.parameters.get(index)).getValue()));
    }

    public int askInt(String message, Predicate<Integer> control, IntFunction<String> format, boolean incrementWhenSeries) {
        Integer v = Utilities.toInteger(this.ask(message));
        Utilities.control(v != null, "Value " + v + " for " + message + " is not valid (not an integer)");
        v = v + (incrementWhenSeries ? this.rs.instanceNumber : 0);
        Utilities.control(control == null || control.test(v), "Value " + v + " for " + message + " does not respect the control " + control);
        return (Integer)this.addParameter(v, format == null ? null : format.apply(v));
    }

    public int askInt(String message, Predicate<Integer> control, String format, boolean incrementWhenSeries) {
        return this.askInt(message, control, (int v) -> format, incrementWhenSeries);
    }

    public int askInt(String message, Predicate<Integer> control, boolean incrementWhenSeries) {
        return this.askInt(message, control, (IntFunction<String>)null, incrementWhenSeries);
    }

    public int askInt(String message, String format, boolean incrementWhenSeries) {
        return this.askInt(message, null, format, incrementWhenSeries);
    }

    public int askInt(String message, boolean incrementWhenSeries) {
        return this.askInt(message, null, (IntFunction<String>)null, incrementWhenSeries);
    }

    public final IVar.Var[][] project3(IVar.Var[][][] m) {
        return (IVar.Var[][])IntStream.range(0, m[0][0].length).mapToObj(i -> this.api.select(m, (w, g, p) -> p == i)).toArray(x$0 -> new IVar.Var[x$0][]);
    }

    public void removeCtr(Constraint c) {
        Kit.control(this.constraints == null, () -> "too late");
        this.stuff.collectedCtrsAtInit.remove(c);
        Stream.of(c.scp).forEach(x -> x.collectedCtrs.remove(c));
        CtrEntities.CtrAlone ca = this.ctrEntities.ctrToCtrAlone.get(c);
        this.ctrEntities.allEntities.remove(ca);
        this.ctrEntities.ctrToCtrAlone.remove(c);
    }

    public final CtrEntities.CtrAlone addCtr(Constraint c, Types.TypeClass ... classes) {
        if (this.stuff.collectedCtrsAtInit.isEmpty()) {
            System.out.print("  Loading constraints...");
        }
        if (this.rs.cp.verbose > 1 && !this.rs.cp.competitionMode) {
            int n = this.stuff.collectedCtrsAtInit.size();
            int nDigits = n < 10 ? 1 : (n < 100 ? 2 : (n < 1000 ? 3 : (n < 10000 ? 4 : (n < 100000 ? 5 : (n < 1000000 ? 6 : 7)))));
            IntStream.range(0, nDigits).forEach(i -> System.out.print("\b"));
            System.out.print(n + 1 + "");
        }
        c.num = this.stuff.addCollectedConstraint(c);
        CtrEntities ctrEntities = this.ctrEntities;
        ctrEntities.getClass();
        return new CtrEntities.CtrAlone(ctrEntities, c, classes);
    }

    public void annotateVarhStatic(Variable[] vars) {
        if (this.rs.cp.setingGeneral.enableAnnotations) {
            this.priorityVars = vars;
            this.nStrictPriorityVars = this.priorityVars.length;
        }
    }

    public void annotateValh(IVar.Var[] vars, Class<? extends HeuristicValues> clazz) {
        if (this.rs.cp.setingGeneral.enableAnnotations) {
            Stream.of(vars).forEach(x -> {
                ((Variable)((Object)x)).heuristicVal = Reflector.buildObject(clazz.getSimpleName(), HeuristicValues.class, x, null);
            });
        }
    }

    public void reset() {
        Stream.of(this.variables).forEach(x -> x.reset());
        Stream.of(this.constraints).forEach(c -> c.reset());
        Stream.of(this.constraints).forEach(c -> {
            c.ignored = false;
        });
        this.nValuesRemoved = 0;
        this.nTuplesRemoved = 0;
        if (this.rs.cp.verbose > 0) {
            Kit.log.info("Reset of problem instance");
        }
    }

    public void reduceTo(boolean[] presentVariables, boolean[] presentConstraints) {
        Kit.control(this.symmetryGroupGenerators.size() == 0 && presentVariables.length == this.variables.length && presentConstraints.length == this.constraints.length);
        assert (Variable.firstWipeoutVariableIn(this.variables) == null && Variable.areNumsNormalized(this.variables) && Constraint.areNumsNormalized(this.constraints));
        for (Variable x : this.priorityVars = (Variable[])IntStream.range(0, this.variables.length).filter(i -> presentVariables[i]).mapToObj(i -> this.variables[i]).toArray(Variable[]::new)) {
            x.reset();
        }
        for (int i2 = 0; i2 < this.constraints.length; ++i2) {
            this.constraints[i2].ignored = !presentConstraints[i2];
            if (this.constraints[i2].ignored) continue;
            this.constraints[i2].reset();
        }
        this.nValuesRemoved = 0;
        this.nTuplesRemoved = 0;
        if (this.rs.cp.verbose >= 0) {
            Kit.log.info("Reduction to (#V=" + this.priorityVars.length + ",#C=" + Kit.countIn(true, presentConstraints) + ")");
        }
    }

    private CtrEntities.CtrAlone buildCtrTrue(Variable x, Variable y) {
        return (CtrEntities.CtrAlone)(x instanceof VariableInteger ? this.api.ctrTrue(new VariableInteger[]{(VariableInteger)x, (VariableInteger)y}) : this.api.ctrTrue(new VariableSymbolic[]{(VariableSymbolic)x, (VariableSymbolic)y}));
    }

    public final Constraint addUniversalConstraintDynamicallyBetween(Variable x, Variable y) {
        assert (x.getClass() == y.getClass());
        assert (!Stream.of(y.ctrs).anyMatch(c -> c.scp.length == 2 && c.involves(x)));
        assert (this.solver.propagation instanceof PropagationForward);
        CtrEntities.CtrAlone ca = this.extension(this.vars(new Object[]{x, y}), new int[0][], false, DONT_KNOW);
        Constraint c2 = (Constraint)ca.ctr;
        c2.cloneStructures(false);
        this.constraints = this.stuff.collectedCtrsAtInit.toArray(new Constraint[this.stuff.collectedCtrsAtInit.size()]);
        x.whenFinishedProblemConstruction();
        y.whenFinishedProblemConstruction();
        if (x.isAssigned()) {
            c2.doPastVariable(x);
        }
        if (y.isAssigned()) {
            c2.doPastVariable(y);
        }
        return c2;
    }

    private void makeGraphComplete() {
        if (!this.rs.cp.settingProblem.completeGraph || !this.rs.cp.propagating.clazz.equals(PC8.class.getSimpleName())) {
            return;
        }
        int sizeBefore = this.stuff.collectedCtrsAtInit.size();
        IntStream.range(0, this.variables.length).forEach(i -> IntStream.range(i + 1, this.variables.length).forEach(j -> {
            if (!this.stuff.collectedCtrsAtInit.stream().anyMatch(c -> c.scp.length == 2 && c.involves(this.variables[i], this.variables[j]))) {
                this.buildCtrTrue(this.variables[i], this.variables[j]);
            }
        }));
        this.stuff.nAddedCtrs += this.stuff.collectedCtrsAtInit.size() - sizeBefore;
    }

    private void buildSymmetries() {
        if (this.rs.cp.symmetryBreaking) {
            int nBefore = this.stuff.collectedCtrsAtInit.size();
            for (Constraint c : this.stuff.collectedCtrsAtInit) {
                if (Constraint.getSymmetryMatching(c.key) != null) continue;
                Constraint.putSymmetryMatching(c.key, c.defineSymmetryMatching());
            }
            IdentificationAutomorphism automorphismIdentification = new IdentificationAutomorphism(this);
            for (Constraint c : automorphismIdentification.buildVariableSymmetriesFor(this.variables, this.stuff.collectedCtrsAtInit)) {
                this.addCtr(c, new Types.TypeClass[0]);
            }
            this.stuff.addToMapForAutomorphismIdentification(automorphismIdentification);
            this.symmetryGroupGenerators.addAll(automorphismIdentification.getGenerators());
            this.stuff.nAddedCtrs += this.stuff.collectedCtrsAtInit.size() - nBefore;
        }
    }

    private void inferAllDifferents() {
        if (this.rs.cp.settingCtrs.inferAllDifferentNb > 0) {
            this.stuff.addToMapForAllDifferentIdentification(new IdentificationAllDifferent(this));
        }
    }

    public final void storeConstraintsToArray() {
        this.makeGraphComplete();
        this.buildSymmetries();
        this.inferAllDifferents();
        if (this.rs.cp.lb.enabled) {
            this.localBranchingConstraints = this.symbolic != null ? Reflector.buildObject(RestarterLocalBranching.LocalBranchingConstraint.LBAtLeastEqual.class.getSimpleName(), RestarterLocalBranching.LocalBranchingConstraint.class, this) : Reflector.buildObject(this.rs.cp.lb.neighborhood, RestarterLocalBranching.LocalBranchingConstraint.class, this);
        }
        this.constraints = this.stuff.collectedCtrsAtInit.toArray(new Constraint[0]);
        for (Variable var : this.variables) {
            var.whenFinishedProblemConstruction();
            this.stuff.varDegrees.add(var.deg());
        }
        assert (Variable.areNumsNormalized(this.variables));
        this.rs.clearMapsUsedByConstraints();
    }

    public Variable findVarWithNumOrId(Object o) {
        if (o instanceof Integer) {
            int num = (Integer)o;
            Kit.control(0 <= num && num < this.variables.length, () -> num + " is not a valid variable num. Check your configuration parameters -ins -pr1 or -pr2.");
            Kit.control(this.variables[num].num != -2, () -> "You cannot use the discarded variable whose (initial) num is " + num + ". Check your configuration parameters -ins -pr1 or -pr2.");
            return this.variables[num];
        }
        Variable var = this.mapForVars.get(o);
        Kit.control(var != null, () -> "The variable " + o + " cannot be found. Check your configuration parameters -ins -pr1 or -pr2.");
        Kit.control(var.num != -2, () -> "You cannot use the discarded variable " + o + ". Check your configuration parameters. -ins -pr1 or -pr2.");
        return var;
    }

    private final void addUnaryConstraintsOfUserInstantiation() {
        ControlPanel.SettingVars settings = this.rs.cp.settingVars;
        Kit.control(settings.instantiatedVars.length == settings.instantiatedVals.length, () -> "In the given instantiation, the number of variables (ids or names) is different from the number of values.");
        boolean removeValues = true;
        for (int i = 0; i < settings.instantiatedVars.length; ++i) {
            Variable x = this.findVarWithNumOrId(settings.instantiatedVars[i]);
            int v = settings.instantiatedVals[i];
            Kit.control(x.dom.toPresentIdx(v) != -1, () -> "Value " + v + " not present in domain of " + x + ". Check  -ins.");
            if (removeValues) {
                x.dom.reduceToValueAtConstructionTime(v);
                continue;
            }
            this.equal(x, v);
        }
    }

    private final void reduceDomainsOfIsolatedVariables() {
        boolean reduceIsolatedVars = this.rs.cp.settingVars.reduceIsolatedVars && this.rs.cp.setingGeneral.nSearchedSolutions == 1L && !this.rs.cp.export && !this.rs.cp.symmetryBreaking && this.rs.cp.framework == Types.TypeFramework.CSP;
        ArrayList<Variable> isolatedVars = new ArrayList<Variable>();
        ArrayList<Variable> fixedVars = new ArrayList<Variable>();
        int nRemovedValues = 0;
        for (Variable x : this.stuff.collectedVarsAtInit) {
            if (x.ctrs.length == 0) {
                isolatedVars.add(x);
                if (reduceIsolatedVars) {
                    nRemovedValues += x.dom.size() - 1;
                    x.dom.reduceToValueAtConstructionTime(x.dom.firstValue());
                }
            }
            if (x.dom.size() != 1) continue;
            fixedVars.add(x);
        }
        if (isolatedVars.size() > 0) {
            this.stuff.nIsolatedVars += isolatedVars.size();
            Kit.log.info("Isolated variables : " + Kit.join(isolatedVars, new String[0]));
            Kit.log.info("Nb values removed due to isolated variables : " + nRemovedValues + "\n");
        }
        if (fixedVars.size() > 0) {
            this.stuff.nFixedVars += fixedVars.size();
            Kit.log.info("Fixed variables : " + (fixedVars.size() <= 100 ? Kit.join(fixedVars, new String[0]) : "more than 100") + "\n");
        }
    }

    private final void updateConflictsStructuresIfReducedDomains() {
        if (this.nValuesRemoved > 0) {
            int[] domainFrontiers = Kit.repeat(-1, this.variables.length);
            for (Constraint ctr : this.constraints) {
                if (!(ctr instanceof CtrHard)) continue;
                ((CtrHard)ctr).updateConflictsStructures(domainFrontiers);
            }
        }
    }

    public static int[][] buildTable(Variable[] scp, CtrHard ... ctrs) {
        int[][] vaps = (int[][])Stream.of(ctrs).map(c -> IntStream.range(0, c.scp.length).map(i -> Utilities.indexOf(c.scp[i], scp)).toArray()).toArray(x$0 -> new int[x$0][]);
        int[][] tmps = (int[][])Stream.of(ctrs).map(c -> c.tupleManager.localTuple).toArray(x$0 -> new int[x$0][]);
        ArrayList<int[]> list = new ArrayList<int[]>();
        EnumerationCartesian ec = new EnumerationCartesian(Variable.domSizeArrayOf(scp, true));
        while (ec.hasNext()) {
            int[] tuple = ec.next();
            boolean inconsistent = false;
            for (int i2 = 0; !inconsistent && i2 < ctrs.length; ++i2) {
                int[] vap = vaps[i2];
                int[] t = tmps[i2];
                IntStream.range(0, t.length).forEach(j -> {
                    t[j] = tuple[vap[j]];
                });
                if (ctrs[i2].checkIndexes(t)) continue;
                inconsistent = true;
            }
            if (inconsistent) continue;
            list.add(IntStream.range(0, scp.length).map(i -> scp[i].dom.toVal(tuple[i])).toArray());
        }
        return Kit.intArray2D(list);
    }

    public int[][] buildTable(CtrHard ... ctrs) {
        return Problem.buildTable((Variable[])this.distinctSorted(this.vars(Stream.of(ctrs).map(c -> c.scp).toArray())), ctrs);
    }

    public Problem(ProblemAPI api, String modelVariant, String data, String dataFormat, boolean dataSaving, String[] argsForPb, Resolution rs) {
        super(api, modelVariant, argsForPb);
        this.rs = rs;
        rs.problem = this;
        rs.observersConstruction.add(0, this);
        this.framework = rs.cp.framework;
        this.stuff = new ProblemStuff(this);
        this.rs.output.beforeLoading();
        this.loadDataAndModel(data, dataFormat, dataSaving);
        this.variables = this.stuff.collectedVarsAtInit.toArray(new Variable[this.stuff.collectedVarsAtInit.size()]);
        this.addUnaryConstraintsOfUserInstantiation();
        this.storeConstraintsToArray();
        if (Solver.class.getSimpleName().equals(rs.cp.solving.clazz)) {
            this.optimizationPilot = new OptimizationPilot.OptimizationPilotBasic(this, "#violatedConstraints");
        }
        this.reduceDomainsOfIsolatedVariables();
        this.updateConflictsStructuresIfReducedDomains();
    }

    public final void display() {
        if (this.rs.cp.verbose >= 2) {
            Kit.log.finer("\nProblem " + this.name());
            Stream.of(this.variables).forEach(x -> x.display(this.rs.cp.verbose == 3));
            Stream.of(this.constraints).forEach(c -> c.display(this.rs.cp.verbose == 3));
        }
    }

    public void undisplay(String ... names) {
        this.undisplay = Arrays.asList(names);
    }

    public String lastSolutionX(String PREFIX) {
        String s = "<instantiation id='sol" + this.solver.solManager.nSolutionsFound + "' type='solution'" + (this.framework != Types.TypeFramework.CSP ? " cost='" + this.solver.solManager.bestBound + "'" : "") + ">";
        String list = " " + this.varEntities.allEntities.stream().filter(va -> !this.undisplay.contains(va.id) && !va.id.startsWith(AUXILIARY_VARIABLE_PREFIX)).map(va -> va instanceof VarEntities.VarAlone ? va.id : va.id + Arrays.stream(((VarEntities.VarArray)VarEntities.VarArray.class.cast((Object)va)).sizes).mapToObj(d -> "[]").collect(Collectors.joining(""))).collect(Collectors.joining(" ")) + " ";
        String values = " " + this.varEntities.allEntities.stream().filter(va -> !this.undisplay.contains(va.id) && !va.id.startsWith(AUXILIARY_VARIABLE_PREFIX)).map(va -> va instanceof VarEntities.VarAlone ? Variable.instantiationOf(((VarEntities.VarAlone)VarEntities.VarAlone.class.cast((Object)va)).var, PREFIX) : Variable.rawInstantiationOf(((VarEntities.VarArray)VarEntities.VarArray.class.cast((Object)va)).vars, PREFIX)).collect(Collectors.joining(" ")) + " ";
        return s + "  <list>" + list + "</list>  <values>" + values + "</values>  </instantiation>";
    }

    public final void prettyDisplay() {
        String s;
        boolean displayJ;
        if (!this.rs.cp.competitionMode && this.solver.solManager.nSolutionsFound != 1L && this.rs.cp.verbose < 1) {
            return;
        }
        String PREFIX = this.rs.cp.competitionMode ? "v " : "   ";
        boolean bl = displayJ = !this.rs.cp.competitionMode;
        if (displayJ) {
            s = PREFIX + "{\n";
            s = s + this.varEntities.allEntities.stream().filter(va -> !this.undisplay.contains(va.id)).map(va -> PREFIX + " " + va.id + ": " + (va instanceof VarEntities.VarAlone ? Variable.instantiationOf(((VarEntities.VarAlone)VarEntities.VarAlone.class.cast((Object)va)).var, PREFIX) : Variable.instantiationOf(((VarEntities.VarArray)VarEntities.VarArray.class.cast((Object)va)).vars, PREFIX))).collect(Collectors.joining(",\n"));
            s = s + "\n" + PREFIX + "}";
            Kit.log.config(s + "\n");
        }
        this.solver.solManager.lastSolutionX = s = this.lastSolutionX(PREFIX);
        if (!this.rs.cp.competitionMode) {
            Kit.log.config(PREFIX + s + "\n");
        }
        String[] values = this.varEntities.allEntities.stream().filter(va -> !this.undisplay.contains(va.id)).map(va -> va instanceof VarEntities.VarAlone ? Variable.instantiationOf(((VarEntities.VarAlone)VarEntities.VarAlone.class.cast((Object)va)).var, PREFIX) : Variable.rawInstantiationOf(((VarEntities.VarArray)VarEntities.VarArray.class.cast((Object)va)).vars, PREFIX)).collect(Collectors.joining(" ")).split("\\s+");
        this.api.prettyDisplay(values);
    }

    private String savingName() {
        if (this.rs.cp.settingXml.keepInstanceName) {
            return this.name();
        }
        String s = this.name();
        int start = s.lastIndexOf(File.separator) + 1;
        int end = s.lastIndexOf(".xml.bz2") != -1 ? s.lastIndexOf(".xml.bz2") : (s.lastIndexOf(".xml.lzma") != -1 ? s.lastIndexOf(".xml.lzma") : s.length());
        s = s.substring(start, end) + (this.stuff.nMergedCtrs > 0 ? "_mgd" : "");
        if (this.rs.cp.setingGeneral.limitForSatisfaction != Long.MAX_VALUE) {
            s = s + "_lfs" + this.rs.cp.setingGeneral.limitForSatisfaction;
        }
        return s;
    }

    public final void saveIntoXCSP(Enums.EExportMoment moment) {
        if (!this.rs.cp.export || this.rs.cp.settingXml.exportMoment != moment) {
            return;
        }
        Document document = new Compiler3Abscon(new Subproblem(this)).buildDocument();
        String fileName = this.rs.cp.settingXml.export == Enums.EExport.STD ? null : this.savingName() + ".xml";
        this.save(document, fileName);
        if (this.rs.cp.settingXml.indentAndCompressUnderLinux) {
            this.indentAndCompressXmlUnderLinux(fileName);
        }
    }

    public Class<VariableInteger> classVI() {
        return VariableInteger.class;
    }

    public Class<VariableSymbolic> classVS() {
        return VariableSymbolic.class;
    }

    @Override
    public Types.TypeFramework typeFramework() {
        return this.framework;
    }

    public final Variable addVar(Variable x) {
        Kit.control(!this.mapForVars.containsKey(x.id()), () -> x.id() + " duplicated");
        if (this.stuff.mustDiscard(x)) {
            return null;
        }
        if (this.stuff.collectedVarsAtInit.isEmpty()) {
            System.out.print("\n  Loading variables..." + (this.rs.cp.verbose <= 1 || this.rs.cp.competitionMode ? "\n" : ""));
        }
        if (this.rs.cp.verbose > 1 && !this.rs.cp.competitionMode) {
            int n = this.stuff.collectedVarsAtInit.size();
            int nDigits = n < 10 ? 1 : (n < 100 ? 2 : (n < 1000 ? 3 : (n < 10000 ? 4 : (n < 100000 ? 5 : (n < 1000000 ? 6 : 7)))));
            IntStream.range(0, nDigits).forEach(i -> System.out.print("\b"));
            System.out.print(n + 1 + "");
        }
        x.num = this.stuff.addCollectedVariable(x);
        this.mapForVars.put(x.id(), x);
        return x;
    }

    @Override
    public VariableInteger buildVarInteger(String id, Domains.Dom dom) {
        Object[] values = dom.values;
        VariableInteger x = null;
        if (values.length == 1 && values[0] instanceof Values.IntegerInterval) {
            Values.IntegerInterval ii = (Values.IntegerInterval)values[0];
            int min = Utilities.safeIntWhileHandlingInfinity(ii.inf);
            int max = Utilities.safeIntWhileHandlingInfinity(ii.sup);
            x = new VariableInteger(this, id, min, max);
        } else {
            x = values.length == 3 && values[0] instanceof Values.IntegerValue && values[1] instanceof Values.IntegerValue && values[2] instanceof Values.IntegerValue && ((Values.IntegerValue)values[2]).v == Integer.MAX_VALUE ? new VariableInteger(this, id, Utilities.safeIntWhileHandlingInfinity(((Values.IntegerValue)values[0]).v), Utilities.safeIntWhileHandlingInfinity(((Values.IntegerValue)values[1]).v)) : new VariableInteger(this, id, Values.IntegerEntity.toIntArray((Values.IntegerEntity[])values, Integer.MAX_VALUE));
        }
        return (VariableInteger)this.addVar(x);
    }

    @Override
    public VariableSymbolic buildVarSymbolic(String id, Domains.DomSymbolic dom) {
        return (VariableSymbolic)this.addVar(new VariableSymbolic(this, id, (String[])dom.values));
    }

    public boolean isBasicType(int type) {
        return type == 0 || this.rs.cp.global.priorityType0 && this.rs.cp.export;
    }

    private CtrEntities.CtrEntity unimplemented(String msg) {
        return (CtrEntities.CtrEntity)Kit.exit("\nunimplemented case for " + msg);
    }

    private CtrEntities.CtrEntity unimplementedIf(boolean b, String msg) {
        return b ? this.unimplemented(msg) : null;
    }

    private Variable[] translate(IVar[] t) {
        return t instanceof Variable[] ? (Variable[])t : (Variable[])Stream.of(t).map(x -> (Variable)x).toArray(Variable[]::new);
    }

    private Variable[][] translate2D(IVar[][] m) {
        return m instanceof Variable[][] ? (Variable[][])m : (Variable[][])Stream.of(m).map(t -> this.translate((IVar[])t)).toArray(x$0 -> new Variable[x$0][]);
    }

    private Object unimplementedCase(Object ... objects) {
        System.out.println("\n\n**********************");
        System.out.println("Missing Implementation");
        StackTraceElement[] t = Thread.currentThread().getStackTrace();
        System.out.println("  Method " + t[2].getMethodName());
        System.out.println("  Class " + t[2].getClassName());
        System.out.println("  Line " + t[2].getLineNumber());
        System.out.println("**********************");
        System.out.println(Stream.of(objects).filter(o -> o != null).map(o -> o.toString()).collect(Collectors.joining("\n")));
        System.exit(1);
        return null;
    }

    @Override
    public final CtrEntities.CtrAlone intension(XNodeParent<IVar> tree) {
        Variable[] scp = (Variable[])tree.vars();
        assert (Stream.of(scp).allMatch(x -> x instanceof IVar.Var) || Stream.of(scp).allMatch(x -> x instanceof IVar.VarSymbolic));
        if (scp.length == 1 && !this.rs.mustPreserveUnaryConstraints()) {
            Variable x2 = scp[0];
            TreeEvaluator evaluator = x2 instanceof VariableInteger ? new TreeEvaluator(tree) : new TreeEvaluator(tree, this.symbolic.mapOfSymbols);
            x2.dom.executeOnValues(v -> {
                if (evaluator.evaluate((int)v) != 1L) {
                    x.dom.removeValueAtConstructionTime((int)v);
                }
            });
            ++this.stuff.nRemovedUnaryCtrs;
            CtrEntities ctrEntities = this.ctrEntities;
            ctrEntities.getClass();
            return new CtrEntities.CtrAloneDummy(ctrEntities, "Removed unary constraint by domain reduction", new Types.TypeClass[0]);
        }
        if (!this.rs.cp.export && scp.length <= this.rs.cp.extension.arityLimitForIntensionToExtension && Variable.nValidTuplesBoundedAtMaxValueFor(scp) <= this.rs.cp.extension.validLimitForIntensionToExtension && Stream.of(scp).allMatch(x -> x instanceof IVar.Var)) {
            return this.extension(tree);
        }
        return this.addCtr(new CtrIntension(this, scp, tree), new Types.TypeClass[0]);
    }

    @Override
    protected ProblemIMP.Converter getConverter() {
        return this.converter;
    }

    public final CtrEntities.CtrAlone extension(IVar[] scp, Object tuples, boolean positive, Boolean starred) {
        return this.addCtr(CtrExtension.build(this, this.translate(scp), tuples, positive, starred), new Types.TypeClass[0]);
    }

    @Override
    public final CtrEntities.CtrAlone extension(IVar.Var[] scp, int[][] tuples, boolean positive) {
        if (!this.rs.cp.export && tuples.length == 0) {
            return this.addCtr(positive ? new CtrHardFalse(this, this.translate(scp), "Table constraint with 0 support") : new CtrHardTrue(this, this.translate(scp)), new Types.TypeClass[0]);
        }
        return this.extension(scp, tuples, positive, DONT_KNOW);
    }

    @Override
    public final CtrEntities.CtrAlone extension(IVar.VarSymbolic[] scp, String[][] tuples, boolean positive) {
        return this.extension(scp, tuples, positive, DONT_KNOW);
    }

    @Override
    public final CtrEntities.CtrAlone extension(IVar.Var[] scp, AbstractTuple[] tuples, boolean positive) {
        return (CtrEntities.CtrAlone)this.unimplementedCase(new Object[0]);
    }

    @Override
    public final CtrEntities.CtrAlone regular(IVar.Var[] list, Automaton automaton) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawRegular.buildFrom(this, list, this.varEntities.compactOrdered(list), Stream.of(automaton.transitions).map(t -> t.toString()).collect(Collectors.joining()), automaton.startState, automaton.finalStates), new Types.TypeClass[0]);
        }
        return this.addCtr(new CtrExtensionMDD(this, this.translate(list), automaton), new Types.TypeClass[0]);
    }

    @Override
    public final CtrEntities.CtrAlone mdd(IVar.Var[] list, Transition[] transitions) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawMdd.buildFrom(this, list, this.varEntities.compactOrdered(list), Stream.of(transitions).map(t -> t.toString()).collect(Collectors.joining())), new Types.TypeClass[0]);
        }
        return this.addCtr(new CtrExtensionMDD(this, this.translate(list), transitions), new Types.TypeClass[0]);
    }

    public final CtrEntities.CtrAlone mdd(IVar.Var[] scp, int[][] tuples) {
        return this.addCtr(new CtrExtensionMDD(this, this.translate(scp), tuples), new Types.TypeClass[0]);
    }

    public final CtrEntities.CtrAlone mddOr(IVar.Var[] scp, MDDCD[] t) {
        return this.addCtr(new CtrExtensionOrMDD(this, this.translate(scp), t), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity allDifferent(Variable[] scp) {
        if (scp.length <= 1) {
            CtrEntities ctrEntities = this.ctrEntities;
            ctrEntities.getClass();
            return new CtrEntities.CtrAloneDummy(ctrEntities, "Removed alldiff constraint with scope length = " + scp.length, new Types.TypeClass[0]);
        }
        if (this.isBasicType(this.rs.cp.global.typeAllDifferent)) {
            return this.addCtr(Variable.isPermutationElligible(scp) ? new AllDifferentPermutation(this, scp) : new AllDifferent(this, scp), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeAllDifferent == 1) {
            return this.forall(this.range(scp.length).range(scp.length), (int i, int j) -> {
                if (i < j) {
                    this.addCtr(new CtrPrimitiveBinary.CtrPrimitiveBinaryAdd.NE(this, scp[i], 0, scp[j]), new Types.TypeClass[0]);
                }
            });
        }
        if (this.rs.cp.global.typeAllDifferent == 2) {
            return this.addCtr(new AllDifferentWeak(this, scp), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeAllDifferent == 3) {
            return this.addCtr(new AllDifferentCounting(this, scp), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeAllDifferent == 4) {
            return this.addCtr(new AllDifferentBound(this, scp), new Types.TypeClass[0]);
        }
        throw new MissingImplementationException();
    }

    @Override
    public final CtrEntities.CtrEntity allDifferent(IVar.Var[] list) {
        return this.allDifferent(this.translate(list));
    }

    @Override
    public final CtrEntities.CtrEntity allDifferent(IVar.VarSymbolic[] list) {
        return this.allDifferent(this.translate(list));
    }

    @Override
    public final CtrEntities.CtrEntity allDifferent(IVar.Var[] scp, int[] exceptValues) {
        Kit.control(exceptValues.length >= 1);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawAllDifferent.buildFrom(this, scp, ICtr.LIST, this.varEntities.compact(scp), Kit.join((Object)exceptValues, new String[0])), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeAllDifferent <= 1) {
            return this.forall(this.range(scp.length).range(scp.length), (int i, int j) -> {
                if (i < j) {
                    this.intension((XNodeParent)XNodeParent.or(XNodeParent.ne(scp[i], scp[j]), exceptValues.length == 1 ? XNodeParent.eq(scp[i], exceptValues[0]) : XNodeParent.in(scp[i], exceptValues)));
                }
            });
        }
        if (this.rs.cp.global.typeAllDifferent == 2) {
            return this.addCtr(new AllDifferentExceptWeak(this, this.translate(scp), exceptValues), new Types.TypeClass[0]);
        }
        throw new MissingImplementationException();
    }

    private CtrEntities.CtrAlone distinctVectors(Variable[] t1, Variable[] t2) {
        Kit.control(this.rs.cp.export || Variable.areAllDistinct((Variable[])this.vars(new Object[]{t1, t2})), () -> "For the moment not handled");
        if (this.isBasicType(this.rs.cp.global.typeDistinctVectors2)) {
            return this.addCtr(CtrExtensionSmart.buildDistinctVectors(this, t1, t2), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeDistinctVectors2 == 1) {
            if (this.rs.cp.global.smartTable) {
                return this.addCtr(CtrExtensionSmart.buildDistinctVectors(this, t1, t2), new Types.TypeClass[0]);
            }
            if (this.rs.cp.global.jokerTable) {
                return this.extension((IVar.Var[])this.vars(new Object[]{t1, t2}), constraints.hard.extension.structures.Table.shortTuplesFordNotEqualVectors(t1, t2), true);
            }
        }
        throw new MissingImplementationException();
    }

    private CtrEntities.CtrEntity distinctVectors(Variable[][] lists) {
        if (this.rs.cp.global.typeDistinctVectorsK == 1) {
            return this.forall(this.range(lists.length).range(lists.length), (int i, int j) -> {
                if (i < j) {
                    if (this.rs.cp.global.smartTable) {
                        this.addCtr(CtrExtensionSmart.buildDistinctVectors(this, lists[i], lists[j]), new Types.TypeClass[0]);
                    } else if (this.rs.cp.global.jokerTable) {
                        this.extension((IVar.Var[])this.vars(new Object[]{lists[i], lists[j]}), constraints.hard.extension.structures.Table.shortTuplesFordNotEqualVectors(lists[i], lists[j]), true);
                    } else {
                        this.addCtr(CtrExtensionSmart.buildDistinctVectors(this, lists[i], lists[j]), new Types.TypeClass[0]);
                    }
                }
            });
        }
        throw new MissingImplementationException();
    }

    @Override
    public final CtrEntities.CtrEntity allDifferentList(IVar.Var[] ... lists) {
        Kit.control(lists.length >= 2);
        Variable[][] m = this.translate2D(lists);
        return lists.length == 2 ? this.distinctVectors(m[0], m[1]) : this.distinctVectors(m);
    }

    @Override
    public final CtrEntities.CtrEntity allDifferentMatrix(IVar.Var[][] matrix) {
        if (this.isBasicType(this.rs.cp.global.typeAllDifferentMatrix)) {
            return this.addCtr(CtrRaw.RawAllDifferent.buildFrom(this, this.vars(matrix), ICtr.MATRIX, this.varEntities.compactMatrix(matrix), null), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeAllDifferentMatrix == 1) {
            CtrEntities.CtrArray ctrSet1 = this.forall(this.range(matrix.length), (int i) -> this.allDifferent(matrix[i]));
            CtrEntities.CtrArray ctrSet2 = this.forall(this.range(matrix[0].length), (int i) -> this.allDifferent(this.api.columnOf(matrix, i)));
            return ctrSet1.append(ctrSet2);
        }
        throw new MissingImplementationException();
    }

    @Override
    public CtrEntities.CtrEntity allDifferent(XNode<IVar>[] trees) {
        if (this.rs.cp.export) {
            String s = Stream.of(trees).map(t -> t.toString()).collect(Collectors.joining(" "));
            return this.addCtr(CtrRaw.RawAllDifferent.buildFrom(this, this.scope(Stream.of(trees).map(t -> t.vars())), ICtr.LIST, s, null), new Types.TypeClass[0]);
        }
        return this.forall(this.range(trees.length).range(trees.length), (int i, int j) -> {
            if (i < j) {
                this.different(trees[i], trees[j]);
            }
        });
    }

    private int[][] allEqualTable(Variable[] scp) {
        ArrayList<int[]> table = new ArrayList<int[]>();
        int a = scp[0].dom.first();
        while (a != -1) {
            int v = scp[0].dom.toVal(a);
            boolean support = true;
            for (int i = 1; support && i < scp.length; ++i) {
                if (scp[i].dom.isPresentValue(v)) continue;
                support = false;
            }
            if (support) {
                table.add(Kit.repeat(v, scp.length));
            }
            a = scp[0].dom.next(a);
        }
        return (int[][])table.toArray((T[])new int[0][]);
    }

    @Override
    public final CtrEntities.CtrEntity allEqual(IVar.Var ... scp) {
        return this.addCtr(new AllEqual(this, this.translate(scp)), new Types.TypeClass[0]);
    }

    @Override
    public final CtrEntities.CtrEntity allEqual(IVar.VarSymbolic ... scp) {
        throw new MissingImplementationException();
    }

    @Override
    public final CtrEntities.CtrEntity allEqualList(IVar.Var[] ... lists) {
        Problem.control(lists.length >= 2, new Object[0]);
        throw new MissingImplementationException();
    }

    @Override
    public final CtrEntities.CtrEntity ordered(IVar.Var[] list, int[] lengths, Types.TypeOperatorRel op) {
        Problem.control(list != null && lengths != null && list.length == lengths.length + 1 && op != null, new Object[0]);
        Types.TypeConditionOperatorRel cop = op.toConditionOperator();
        return this.forall(this.range(list.length - 1), (int i) -> CtrPrimitiveBinary.CtrPrimitiveBinaryAdd.buildFrom(this, (Variable)((Object)list[i]), lengths[i], cop, (Variable)((Object)list[i + 1])));
    }

    @Override
    public final CtrEntities.CtrEntity ordered(IVar.Var[] list, IVar.Var[] lengths, Types.TypeOperatorRel op) {
        Problem.control(list != null && lengths != null && list.length == lengths.length + 1 && op != null, new Object[0]);
        return this.forall(this.range(list.length - 1), (int i) -> this.intension((XNodeParent)XNodeParent.build(op.toExpr(), XNodeParent.add(list[i], lengths[i]), list[i + 1])));
    }

    private final CtrEntities.CtrAlone lexSimple(IVar.Var[] t1, IVar.Var[] t2, Types.TypeOperatorRel op) {
        return this.addCtr(Lexicographic.buildFrom(this, this.translate(t1), this.translate(t2), op), new Types.TypeClass[0]);
    }

    @Override
    public final CtrEntities.CtrEntity lex(IVar.Var[][] lists, Types.TypeOperatorRel op) {
        Problem.control(op != null, new Object[0]);
        return this.forall(this.range(lists.length - 1), (int i) -> this.lexSimple(lists[i], lists[i + 1], op));
    }

    @Override
    public final CtrEntities.CtrEntity lexMatrix(IVar.Var[][] matrix, Types.TypeOperatorRel op) {
        Problem.control(op != null, new Object[0]);
        this.forall(this.range(matrix.length - 1), (int i) -> this.lexSimple(matrix[i], matrix[i + 1], op));
        return this.forall(this.range(matrix[0].length - 1), (int j) -> this.lexSimple(this.api.columnOf(matrix, j), this.api.columnOf(matrix, j + 1), op));
    }

    private String idAux() {
        return AUXILIARY_VARIABLE_PREFIX + this.varEntities.allEntities.size();
    }

    public Variable replaceByVariable(XNode<IVar> tree) {
        Object values = tree.possibleValues();
        Domains.Dom dom = values instanceof Range ? this.api.dom((Range)values) : this.api.dom((int[])values);
        IVar.Var aux = this.api.var(this.idAux(), dom, "auxiliary variable", new Types.TypeClass[0]);
        if (Constraint.howManyVarsWithin((Variable[])this.vars(new Object[]{tree}), this.rs.cp.propagating.spaceLimitation) == Integer.MAX_VALUE) {
            int[][] tuples = new TreeEvaluator(tree).computeTuples(Variable.initDomainValues((Variable[])this.vars(new Object[]{tree})));
            this.extension((IVar.Var[])this.vars(new Object[]{tree, aux}), tuples, true);
        } else {
            this.equal(aux, tree);
        }
        return (Variable)((Object)aux);
    }

    private boolean areSimilar(XNode<IVar> tree1, XNode<IVar> tree2) {
        if (tree1.type != tree2.type || tree1.arity() != tree2.arity()) {
            return false;
        }
        if (tree1.arity() == 0) {
            Object value1 = ((XNodeLeaf)tree1).value;
            Object value2 = ((XNodeLeaf)tree2).value;
            return tree1.type == Types.TypeExpr.VAR ? ((Variable)value1).dom.typeIdentifier() == ((Variable)value2).dom.typeIdentifier() : value1.equals(value2);
        }
        return IntStream.range(0, tree1.arity()).allMatch(i -> this.areSimilar(tree1.sons[i], tree2.sons[i]));
    }

    private IVar.Var[] replaceByVariables(XNode<IVar>[] trees) {
        FunctionalInterfaces.IntToDom doms = i -> {
            Object values = trees[i].possibleValues();
            return values instanceof Range ? this.api.dom((Range)values) : this.api.dom((int[])values);
        };
        if (trees.length > 1 && IntStream.range(1, trees.length).allMatch(i -> this.areSimilar(trees[0], trees[i]))) {
            IVar.Var[] aux = this.api.array(this.idAux(), this.api.size(trees.length), doms.apply(0), "auxiliary variables", new Types.TypeClass[0]);
            int[][] tuples = Constraint.howManyVarsWithin((Variable[])this.vars(new Object[]{trees[0]}), this.rs.cp.propagating.spaceLimitation) == Integer.MAX_VALUE ? new TreeEvaluator(trees[0]).computeTuples(Variable.initDomainValues((Variable[])this.vars(new Object[]{trees[0]}))) : (int[][])null;
            for (int i2 = 0; i2 < trees.length; ++i2) {
                if (tuples != null) {
                    this.extension((IVar.Var[])this.vars(new Object[]{trees[i2], aux[i2]}), tuples, true);
                    continue;
                }
                this.equal(aux[i2], trees[i2]);
            }
            return aux;
        }
        IVar.Var[] aux = this.api.array(this.idAux(), this.api.size(trees.length), doms, "auxiliary variables", new Types.TypeClass[0]);
        for (int i3 = 0; i3 < trees.length; ++i3) {
            if (Constraint.howManyVarsWithin((Variable[])this.vars(new Object[]{trees[i3]}), this.rs.cp.propagating.spaceLimitation) == Integer.MAX_VALUE) {
                int[][] tuples = new TreeEvaluator(trees[i3]).computeTuples(Variable.currDomainValues((Variable[])this.vars(new Object[]{trees[i3]})));
                this.extension((IVar.Var[])this.vars(new Object[]{trees[i3], aux[i3]}), tuples, true);
                continue;
            }
            this.equal(aux[i3], trees[i3]);
        }
        return aux;
    }

    private IVar.Var[] replaceByVariables(Stream<XNode<IVar>> trees) {
        return this.replaceByVariables((XNode[])trees.toArray(XNode[]::new));
    }

    private CtrEntities.CtrAlone sum(IVar[] vars, int[] coeffs, Types.TypeConditionOperatorRel op, long limit, boolean inversable) {
        boolean deceq;
        boolean only1;
        Variable[] list = this.translate(vars);
        Term[] terms = new Term[list.length];
        for (int i = 0; i < terms.length; ++i) {
            terms[i] = new Term(coeffs == null ? 1L : (long)coeffs[i], list[i]);
        }
        if (!Variable.areAllDistinct(list)) {
            Set<Map.Entry<Variable, Long>> entries = Stream.of(terms).collect(Collectors.groupingBy(t -> t.var, Collectors.summingLong(t -> (int)t.coeff))).entrySet();
            terms = (Term[])entries.stream().map(e -> new Term((Long)e.getValue(), (Variable)e.getKey())).toArray(Term[]::new);
            Kit.log.info("Sum constraint with several ocurrences of the same variable");
        }
        terms = (Term[])Stream.of(terms).filter(t -> t.coeff != 0L).sorted().toArray(Term[]::new);
        list = (Variable[])Stream.of(terms).map(t -> t.var).toArray(Variable[]::new);
        Kit.control(Stream.of(terms).allMatch(t -> Utilities.isSafeInt(t.coeff)));
        coeffs = Stream.of(terms).mapToInt(t -> (int)t.coeff).toArray();
        if (inversable && coeffs[0] == -1 && coeffs[coeffs.length - 1] == -1) {
            Arrays.fill(coeffs, 1);
            op = op.arithmeticInversion();
            limit = -limit;
        }
        boolean bl = only1 = coeffs[0] == 1 && coeffs[coeffs.length - 1] == 1;
        if (op == Types.TypeConditionOperatorRel.EQ && (deceq = false)) {
            if (only1) {
                this.addCtr(new SumSimple.SumSimpleLE(this, list, limit), new Types.TypeClass[0]);
                this.addCtr(new SumSimple.SumSimpleGE(this, list, limit), new Types.TypeClass[0]);
            } else {
                this.addCtr(new SumWeighted.SumWeightedLE(this, list, coeffs, limit), new Types.TypeClass[0]);
                this.addCtr(new SumWeighted.SumWeightedGE(this, list, coeffs, limit), new Types.TypeClass[0]);
            }
            return null;
        }
        if (only1) {
            return this.addCtr(SumSimple.buildFrom(this, list, op, limit), new Types.TypeClass[0]);
        }
        return this.addCtr(SumWeighted.buildFrom(this, list, coeffs, op, limit), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity sum(IVar[] list, int[] coeffs, Types.TypeConditionOperatorRel op, long limit) {
        return this.sum(list, coeffs, op, limit, true);
    }

    @Override
    public final CtrEntities.CtrEntity sum(IVar.Var[] list, int[] coeffs, Condition condition) {
        Enum op;
        Problem.control(Stream.of(list).noneMatch(x -> x == null), "A variable is null");
        Problem.control(list.length == coeffs.length, "the number of variables is different from the number of coefficients");
        XNode<IVar> rightTerm = condition.rightTerm();
        if (IntStream.of(coeffs).anyMatch(v -> v == 0)) {
            int[] copy = (int[])coeffs.clone();
            Problem.control((coeffs = this.api.selectFromIndexing(coeffs, i -> copy[i] != 0)).length > 0, new Object[0]);
            list = this.api.select(list, i -> copy[i] != 0);
        }
        if (list.length == 1) {
            assert (coeffs[0] != 0);
            if (condition instanceof Condition.ConditionSet) {
                rightTerm = this.api.set(rightTerm);
            }
            XNodeParent<IVar> tree = XNodeParent.build(condition.operatorTypeExpr(), coeffs[0] == 1 ? list[0] : this.api.mul(list[0], coeffs[0]), rightTerm);
            return this.extension(tree);
        }
        if (condition instanceof Condition.ConditionSet) {
            int max;
            op = ((Condition.ConditionSet)condition).operator;
            int[] t = condition instanceof Condition.ConditionIntset ? (int[])rightTerm : null;
            int min = condition instanceof Condition.ConditionIntvl ? ((Range)((Object)rightTerm)).start : t[0];
            int n = max = condition instanceof Condition.ConditionIntvl ? ((Range)((Object)rightTerm)).stop - 1 : t[t.length - 1];
            if (op == Types.TypeConditionOperatorSet.IN) {
                boolean mdd = false;
                if (mdd) {
                    return this.addCtr(new CtrExtensionMDD(this, this.translate(list), coeffs, rightTerm), new Types.TypeClass[0]);
                }
                this.sum(list, coeffs, Types.TypeConditionOperatorRel.GE, min);
                this.sum(list, coeffs, Types.TypeConditionOperatorRel.LE, max);
                if (condition instanceof Condition.ConditionIntset) {
                    int index = 0;
                    for (int v2 = t[0]; v2 < t[t.length - 1]; ++v2) {
                        if (v2 < t[index]) {
                            this.sum(list, coeffs, Types.TypeConditionOperatorRel.NE, v2);
                            continue;
                        }
                        ++index;
                    }
                }
            } else if (condition instanceof Condition.ConditionIntvl) {
                for (int v3 = min; v3 <= max; ++v3) {
                    this.sum(list, coeffs, Types.TypeConditionOperatorRel.NE, v3);
                }
            } else {
                for (int v4 : t) {
                    this.sum(list, coeffs, Types.TypeConditionOperatorRel.NE, v4);
                }
            }
            return null;
        }
        op = ((Condition.ConditionRel)condition).operator;
        if (condition instanceof Condition.ConditionVal) {
            return this.sum(list, coeffs, (Types.TypeConditionOperatorRel)op, (Long)((Object)rightTerm));
        }
        return this.sum(this.vars(new Object[]{list, (Variable)((Object)rightTerm)}), this.api.vals(coeffs, -1), (Types.TypeConditionOperatorRel)op, 0L);
    }

    @Override
    public final CtrEntities.CtrEntity sum(IVar.Var[] list, IVar.Var[] coeffs, Condition condition) {
        Problem.control(Stream.concat(Stream.of(list), Stream.of(coeffs)).noneMatch(x -> x == null), "A variable is null in these arrays");
        Problem.control(list.length == coeffs.length, "The number of variables is different from the number of coefficients");
        if (condition instanceof Condition.ConditionRel && Variable.areAllInitiallyBoolean(this.translate(list)) && Variable.areAllInitiallyBoolean(this.translate(coeffs))) {
            Types.TypeConditionOperatorRel op = ((Condition.ConditionRel)condition).operator;
            Object rightTerm = condition.rightTerm();
            if (condition instanceof Condition.ConditionVal && op != Types.TypeConditionOperatorRel.NE) {
                return this.addCtr(SumScalarBoolean.SumScalarBooleanCst.buildFrom(this, this.translate(list), this.translate(coeffs), op, Utilities.safeInt((long)((Long)rightTerm))), new Types.TypeClass[0]);
            }
            if (condition instanceof Condition.ConditionVar && op != Types.TypeConditionOperatorRel.NE && op != Types.TypeConditionOperatorRel.EQ) {
                return this.addCtr(SumScalarBoolean.SumScalarBooleanVar.buildFrom(this, this.translate(list), this.translate(coeffs), op, (Variable)rightTerm), new Types.TypeClass[0]);
            }
        }
        IVar.Var[] aux = this.replaceByVariables(IntStream.range(0, list.length).mapToObj(i -> this.api.mul(list[i], coeffs[i])));
        return this.sum(aux, Kit.repeat(1, list.length), condition);
    }

    @Override
    public CtrEntities.CtrEntity sum(XNode<IVar>[] trees, int[] coeffs, Condition condition) {
        IVar.Var[] aux = this.replaceByVariables(trees);
        return this.sum(aux, coeffs, condition);
    }

    private CtrEntities.CtrEntity atLeast(IVar.Var[] list, int value, int k) {
        Kit.control(list.length != 0 && k >= 0);
        Variable[] scp = (Variable[])Stream.of(list).filter(x -> ((VariableInteger)x).dom.isPresentValue(value) && ((VariableInteger)x).dom.size() > 1).toArray(Variable[]::new);
        int newK = k - (int)Stream.of(list).filter(x -> ((VariableInteger)x).dom.onlyContainsValue(value)).count();
        if (newK <= 0) {
            CtrEntities ctrEntities = this.ctrEntities;
            ctrEntities.getClass();
            return new CtrEntities.CtrAloneDummy(ctrEntities, "Removed constraint due to newk < 0", new Types.TypeClass[0]);
        }
        if (newK == scp.length) {
            return this.forall(this.range(scp.length), (int i) -> this.equal(scp[i], value));
        }
        if (newK > scp.length) {
            return this.addCtr(new CtrHardFalse(this, this.translate(list), "Constraint atLeast intially unsatisfiable"), new Types.TypeClass[0]);
        }
        return newK == 1 ? this.addCtr(new Count.AtLeast1(this, scp, value), new Types.TypeClass[0]) : this.addCtr(new Count.AtLeastK(this, scp, value, newK), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity atMost(IVar.Var[] list, int value, int k) {
        if (list.length == 0) {
            CtrEntities ctrEntities = this.ctrEntities;
            ctrEntities.getClass();
            return new CtrEntities.CtrAloneDummy(ctrEntities, "atMost with empty set", new Types.TypeClass[0]);
        }
        Kit.control(k >= 0);
        Variable[] scp = (Variable[])Stream.of(list).filter(x -> ((VariableInteger)x).dom.isPresentValue(value) && ((VariableInteger)x).dom.size() > 1).toArray(Variable[]::new);
        int newK = k - (int)Stream.of(list).filter(x -> ((VariableInteger)x).dom.onlyContainsValue(value)).count();
        if (newK < 0) {
            return this.addCtr(new CtrHardFalse(this, this.translate(list), "Constraint atMost intially unsatisfiable"), new Types.TypeClass[0]);
        }
        if (newK == 0) {
            return this.forall(this.range(scp.length), (int i) -> this.different(scp[i], value));
        }
        if (newK >= scp.length) {
            CtrEntities ctrEntities = this.ctrEntities;
            ctrEntities.getClass();
            return new CtrEntities.CtrAloneDummy(ctrEntities, "atMost with newK greater than scp.length", new Types.TypeClass[0]);
        }
        return newK == 1 ? this.addCtr(new Count.AtMost1(this, scp, value), new Types.TypeClass[0]) : this.addCtr(new Count.AtMostK(this, scp, value, newK), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity exactly(IVar.Var[] list, int value, int k) {
        Kit.control(list.length != 0 && k >= 0);
        Variable[] scp = (Variable[])Stream.of(list).filter(x -> ((VariableInteger)x).dom.isPresentValue(value) && ((VariableInteger)x).dom.size() > 1).toArray(Variable[]::new);
        int newK = k - (int)Stream.of(list).filter(x -> ((VariableInteger)x).dom.onlyContainsValue(value)).count();
        Kit.control(newK >= 0, () -> "UNSAT, constraint Exactly with scope " + Kit.join((Object)list, new String[0]) + " has already more than " + k + " variables equal to " + value);
        if (newK == 0) {
            return this.forall(this.range(scp.length), (int i) -> this.different(scp[i], value));
        }
        if (newK == scp.length) {
            return this.forall(this.range(scp.length), (int i) -> this.equal(scp[i], value));
        }
        Kit.control(newK < scp.length, () -> "Instance is UNSAT, constraint Exactly with scope " + Kit.join((Object)list, new String[0]) + " cannot have " + k + " variables equal to " + value);
        return newK == 1 ? this.addCtr(new Count.Exactly1(this, scp, value), new Types.TypeClass[0]) : this.addCtr(new Count.ExactlyK(this, scp, value, newK), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity among(IVar.Var[] list, int[] values, int k) {
        Kit.control(list.length >= k);
        if (list.length == k) {
            for (IVar.Var x : list) {
                Domain dom = ((VariableInteger)x).dom;
                int a = dom.first();
                while (a != -1) {
                    int v = dom.toVal(a);
                    if (!Kit.isPresent(v, values)) {
                        this.different(x, v);
                    }
                    a = dom.next(a);
                }
            }
            return null;
        }
        return this.addCtr(new Among(this, (VariableInteger[])list, values, k), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity count1(VariableInteger[] list, int[] values, Types.TypeConditionOperatorRel op, long limit) {
        int l = Utilities.safeInt(limit);
        if (values.length == 1) {
            if (op == Types.TypeConditionOperatorRel.GE) {
                return this.atLeast(list, values[0], l);
            }
            if (op == Types.TypeConditionOperatorRel.GT) {
                return this.atLeast(list, values[0], l + 1);
            }
            if (op == Types.TypeConditionOperatorRel.LT) {
                return this.atMost(list, values[0], l - 1);
            }
            if (op == Types.TypeConditionOperatorRel.LE) {
                return this.atMost(list, values[0], l);
            }
            if (op == Types.TypeConditionOperatorRel.EQ) {
                return this.exactly(list, values[0], l);
            }
            return this.unimplemented("count");
        }
        if (op == Types.TypeConditionOperatorRel.EQ) {
            return this.among(list, values, l);
        }
        return this.unimplemented("count");
    }

    private CtrEntities.CtrEntity count2(VariableInteger[] list, int[] values, Types.TypeConditionOperatorRel op, VariableInteger limit) {
        if (values.length == 1) {
            if (op == Types.TypeConditionOperatorRel.EQ) {
                return this.addCtr(new ExactlyKVariable(this, list, values[0], limit), new Types.TypeClass[0]);
            }
            return this.unimplemented("count");
        }
        return this.unimplemented("count");
    }

    @Override
    public final CtrEntities.CtrEntity count(IVar.Var[] list, int[] values, Condition condition) {
        list = (IVar.Var[])this.clean(list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCount.buildFrom(this, this.scope(list, condition), this.varEntities.compact(list), Kit.join((Object)values, new String[0]), condition), new Types.TypeClass[0]);
        }
        if (condition instanceof Condition.ConditionVal) {
            return this.count1((VariableInteger[])list, values, ((Condition.ConditionVal)condition).operator, ((Condition.ConditionVal)condition).k);
        }
        if (condition instanceof Condition.ConditionVar) {
            return this.count2((VariableInteger[])list, values, ((Condition.ConditionVar)condition).operator, (VariableInteger)((Condition.ConditionVar)condition).x);
        }
        this.unimplementedIf(condition instanceof Condition.ConditionIntvl, "count");
        return this.unimplemented("count");
    }

    @Override
    public final CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var[] values, Condition condition) {
        list = (IVar.Var[])this.clean(list);
        values = (IVar.Var[])this.clean(values);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCount.buildFrom(this, this.scope(list, values, condition), this.varEntities.compact(list), this.varEntities.compact(values), condition), new Types.TypeClass[0]);
        }
        return this.unimplemented("count");
    }

    @Override
    public CtrEntities.CtrEntity nValues(IVar.Var[] list, Condition condition) {
        Types.TypeConditionOperatorRel op;
        list = (IVar.Var[])this.clean(list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawNValues.buildFrom(this, this.scope(list, condition), this.varEntities.compact(list), null, condition), new Types.TypeClass[0]);
        }
        if (condition instanceof Condition.ConditionVal) {
            Types.TypeConditionOperatorRel op2 = ((Condition.ConditionVal)condition).operator;
            int k = Utilities.safeInt(((Condition.ConditionVal)condition).k);
            if (op2 == Types.TypeConditionOperatorRel.GT && k == 1 || op2 == Types.TypeConditionOperatorRel.GE && k == 2) {
                if (this.isBasicType(this.rs.cp.global.typeNotAllEqual)) {
                    return this.addCtr(new NotAllEqual(this, (VariableInteger[])list), new Types.TypeClass[0]);
                }
                if (this.rs.cp.global.typeNotAllEqual == 1) {
                    VariableInteger[] clone = (VariableInteger[])list.clone();
                    return this.intension((XNodeParent)XNodeParent.or(IntStream.range(0, list.length - 1).mapToObj(i -> XNodeParent.ne(clone[i], clone[i + 1])).toArray(Object[]::new)));
                }
            }
            if (op2 == Types.TypeConditionOperatorRel.LE || op2 == Types.TypeConditionOperatorRel.LT) {
                return this.addCtr(new NValues.NValuesLE(this, (Variable[])((VariableInteger[])list), op2 == Types.TypeConditionOperatorRel.LE ? k : k - 1), new Types.TypeClass[0]);
            }
            if (op2 == Types.TypeConditionOperatorRel.GE || op2 == Types.TypeConditionOperatorRel.GT) {
                return this.addCtr(new NValues.NValuesGE(this, (Variable[])((VariableInteger[])list), op2 == Types.TypeConditionOperatorRel.GE ? k : k + 1), new Types.TypeClass[0]);
            }
        } else if (condition instanceof Condition.ConditionVar && (op = ((Condition.ConditionVar)condition).operator) == Types.TypeConditionOperatorRel.EQ) {
            return this.addCtr(new NValuesVar(this, (Variable[])((VariableInteger[])list), (VariableInteger)((Condition.ConditionVar)condition).x), new Types.TypeClass[0]);
        }
        return this.unimplemented("nValues");
    }

    @Override
    public CtrEntities.CtrEntity nValues(IVar.Var[] list, Condition condition, int[] exceptValues) {
        list = (IVar.Var[])this.clean(list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawNValues.buildFrom(this, this.scope(list, condition), this.varEntities.compact(list), Kit.join((Object)exceptValues, new String[0]), condition), new Types.TypeClass[0]);
        }
        return this.unimplemented("nValues");
    }

    private CtrEntities.CtrArray postClosed(VariableInteger[] list, int[] values) {
        Kit.control(Stream.of(list).anyMatch(x -> !x.dom.areInitValuesSubsetOf(values)));
        return this.forall(this.range(list.length), (int i) -> {
            if (!list[i].dom.areInitValuesSubsetOf(values)) {
                this.api.extension((IVar.Var)list[i], this.api.select(values, v -> list[i].dom.isPresentValue(v)));
            }
        });
    }

    @Override
    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, int[] values, boolean mustBeClosed, int[] occurs) {
        Kit.control(values.length == occurs.length);
        list = (IVar.Var[])this.clean(list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCardinality.buildFrom(this, list, this.varEntities.compact(list), Kit.join((Object)values, new String[0]), mustBeClosed, Kit.join((Object)occurs, new String[0])), new Types.TypeClass[0]);
        }
        if (mustBeClosed && Stream.of(list).anyMatch(x -> !((VariableInteger)x).dom.areInitValuesSubsetOf(values))) {
            this.postClosed((VariableInteger[])list, values);
        }
        return this.addCtr(new CardinalityConstant(this, (VariableInteger[])list, values, occurs), new Types.TypeClass[0]);
    }

    @Override
    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, int[] values, boolean mustBeClosed, IVar.Var[] occurs) {
        Kit.control(values.length == occurs.length && Stream.of(occurs).noneMatch(x -> x == null));
        list = (IVar.Var[])this.clean(list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCardinality.buildFrom(this, this.scope(list, occurs), this.varEntities.compact(list), Kit.join((Object)values, new String[0]), mustBeClosed, this.varEntities.compactOrdered(occurs)), new Types.TypeClass[0]);
        }
        if (mustBeClosed && Stream.of(list).anyMatch(x -> !((VariableInteger)x).dom.areInitValuesSubsetOf(values))) {
            this.postClosed((VariableInteger[])list, values);
        }
        VariableInteger[] clone = (VariableInteger[])list.clone();
        return this.forall(this.range(values.length), (int i) -> this.api.exactly((IVar.Var[])clone, values[i], occurs[i]));
    }

    @Override
    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, int[] values, boolean mustBeClosed, int[] occursMin, int[] occursMax) {
        Kit.control(values.length == occursMin.length && values.length == occursMax.length);
        list = (IVar.Var[])this.clean(list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCardinality.buildFrom(this, list, this.varEntities.compact(list), Kit.join((Object)values, new String[0]), mustBeClosed, this.intervalAsString(occursMin, occursMax)), new Types.TypeClass[0]);
        }
        return this.addCtr(new CardinalityConstant(this, (VariableInteger[])list, values, occursMin, occursMax), new Types.TypeClass[0]);
    }

    @Override
    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, IVar.Var[] values, boolean mustBeClosed, int[] occurs) {
        Kit.control(values.length == occurs.length && Stream.of(values).noneMatch(x -> x == null));
        list = (IVar.Var[])this.clean(list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCardinality.buildFrom(this, this.scope(list, values), this.varEntities.compact(list), this.varEntities.compactOrdered(values), mustBeClosed, Kit.join((Object)occurs, new String[0])), new Types.TypeClass[0]);
        }
        return this.unimplemented("cardinality");
    }

    @Override
    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, IVar.Var[] values, boolean mustBeClosed, IVar.Var[] occurs) {
        Kit.control(values.length == occurs.length && Stream.of(values).noneMatch(x -> x == null) && Stream.of(occurs).noneMatch(x -> x == null));
        list = (IVar.Var[])this.clean(list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCardinality.buildFrom(this, this.scope(list, values, occurs), this.varEntities.compact(list), this.varEntities.compactOrdered(values), mustBeClosed, this.varEntities.compactOrdered(occurs)), new Types.TypeClass[0]);
        }
        return this.unimplemented("cardinality");
    }

    @Override
    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, IVar.Var[] values, boolean mustBeClosed, int[] occursMin, int[] occursMax) {
        Kit.control(values.length == occursMin.length && values.length == occursMax.length && Stream.of(values).noneMatch(x -> x == null));
        list = (IVar.Var[])this.clean(list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCardinality.buildFrom(this, this.scope(list, values), this.varEntities.compact(list), this.varEntities.compactOrdered(values), mustBeClosed, this.intervalAsString(occursMin, occursMax)), new Types.TypeClass[0]);
        }
        return this.unimplemented("cardinality");
    }

    private final CtrEntities.CtrEntity extremum(IVar.Var[] list, Condition condition, boolean minimum) {
        IVar[] vars = (Variable[])this.clean(list);
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawExtremum.buildFrom(this, this.scope(vars, condition), this.varEntities.compact(vars), null, null, null, condition, minimum), new Types.TypeClass[0]);
        }
        if (condition instanceof Condition.ConditionVar) {
            Types.TypeConditionOperatorRel op = ((Condition.ConditionVar)condition).operator;
            if (op != Types.TypeConditionOperatorRel.EQ) {
                return this.unimplemented(minimum ? "minimum" : "maximum");
            }
            Variable y = (Variable)((Condition.ConditionVar)condition).x;
            if (vars.length == 1) {
                return this.equal(y, vars[0]);
            }
            if (Stream.of(vars).anyMatch(x -> x == y)) {
                return this.forall(this.range(vars.length), arg_0 -> this.lambda$extremum$131(y, (Variable[])vars, minimum, arg_0));
            }
            if (this.rs.cp.global.smartTable) {
                return this.addCtr(minimum ? CtrExtensionSmart.buildMinimum(this, (Variable[])vars, y) : CtrExtensionSmart.buildMaximum(this, (Variable[])vars, y), new Types.TypeClass[0]);
            }
            return this.addCtr(minimum ? new Extremum.ExtremumVar.Minimum(this, (Variable[])vars, y) : new Extremum.ExtremumVar.Maximum(this, (Variable[])vars, y), new Types.TypeClass[0]);
        }
        if (condition instanceof Condition.ConditionVal) {
            Types.TypeConditionOperatorRel op = ((Condition.ConditionVal)condition).operator;
            Kit.control(op != Types.TypeConditionOperatorRel.EQ && op != Types.TypeConditionOperatorRel.NE);
            int k = Utilities.safeInt(((Condition.ConditionVal)condition).k);
            if (op == Types.TypeConditionOperatorRel.LT || op == Types.TypeConditionOperatorRel.LE) {
                k = op == Types.TypeConditionOperatorRel.LE ? k : k - 1;
                return this.addCtr(minimum ? new Extremum.ExtremumCst.MinimumCst.MinimumCstLE(this, (Variable[])vars, k) : new Extremum.ExtremumCst.MaximumCst.MaximumCstLE(this, (Variable[])vars, k), new Types.TypeClass[0]);
            }
            if (op == Types.TypeConditionOperatorRel.GT || op == Types.TypeConditionOperatorRel.GE) {
                k = op == Types.TypeConditionOperatorRel.GE ? k : k + 1;
                return this.addCtr(minimum ? new Extremum.ExtremumCst.MinimumCst.MinimumCstGE(this, (Variable[])vars, k) : new Extremum.ExtremumCst.MaximumCst.MaximumCstGE(this, (Variable[])vars, k), new Types.TypeClass[0]);
            }
        }
        return this.unimplemented(minimum ? "minimum" : "maximum");
    }

    private final CtrEntities.CtrEntity extremum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank, Condition condition, boolean minimum) {
        Kit.control(Stream.of(list).noneMatch(x -> x == null));
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawExtremum.buildFrom(this, this.scope(list, index, condition), this.varEntities.compactOrdered(list), startIndex, index, rank, condition, minimum), new Types.TypeClass[0]);
        }
        return this.unimplemented(minimum ? "minimum" : "maximum");
    }

    @Override
    public final CtrEntities.CtrEntity minimum(IVar.Var[] list, Condition condition) {
        return this.extremum(list, condition, true);
    }

    @Override
    public final CtrEntities.CtrEntity minimum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank) {
        return this.extremum(list, startIndex, index, rank, null, true);
    }

    @Override
    public final CtrEntities.CtrEntity minimum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank, Condition condition) {
        return this.extremum(list, startIndex, index, rank, condition, true);
    }

    @Override
    public final CtrEntities.CtrEntity minimum(XNode<IVar>[] trees, Condition condition) {
        IVar.Var[] tmp = this.replaceByVariables(trees);
        return this.minimum(tmp, condition);
    }

    @Override
    public final CtrEntities.CtrEntity maximum(IVar.Var[] list, Condition condition) {
        return this.extremum(list, condition, false);
    }

    @Override
    public final CtrEntities.CtrEntity maximum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank) {
        return this.extremum(list, startIndex, index, rank, null, false);
    }

    @Override
    public final CtrEntities.CtrEntity maximum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank, Condition condition) {
        return this.extremum(list, startIndex, index, rank, condition, false);
    }

    @Override
    public final CtrEntities.CtrEntity maximum(XNode<IVar>[] trees, Condition condition) {
        IVar.Var[] tmp = this.replaceByVariables(trees);
        return this.maximum(tmp, condition);
    }

    @Override
    public final CtrEntities.CtrAlone element(IVar.Var[] list, int value) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawElement.buildFrom(this, list, this.varEntities.compact(list), null, null, null, value), new Types.TypeClass[0]);
        }
        return (CtrEntities.CtrAlone)this.atLeast(list, value, 1);
    }

    @Override
    public final CtrEntities.CtrAlone element(IVar.Var[] list, IVar.Var value) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawElement.buildFrom(this, this.scope(list, value), this.varEntities.compact(list), null, null, null, value), new Types.TypeClass[0]);
        }
        return (CtrEntities.CtrAlone)this.unimplemented("element");
    }

    @Override
    public final CtrEntities.CtrAlone element(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank, int value) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawElement.buildFrom(this, this.scope(list, index), this.varEntities.compactOrdered(list), startIndex, index, rank, value), new Types.TypeClass[0]);
        }
        this.unimplementedIf(startIndex != 0 || rank != null && rank != Types.TypeRank.ANY, "element");
        if (this.rs.cp.global.jokerTable) {
            return this.extension((IVar.Var[])this.vars(new Object[]{index, list}), constraints.hard.extension.structures.Table.shortTuplesForElement(this.translate(list), (Variable)((Object)index), value), true);
        }
        Variable[] lst = (VariableInteger[])Arrays.stream(list).map(v -> (VariableInteger)v).toArray(VariableInteger[]::new);
        return this.addCtr(new Element.ElementConstant(this, lst, (VariableInteger)index, value), new Types.TypeClass[0]);
    }

    @Override
    public final CtrEntities.CtrAlone element(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank, IVar.Var value) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawElement.buildFrom(this, this.scope(list, index, value), this.varEntities.compactOrdered(list), startIndex, index, rank, value), new Types.TypeClass[0]);
        }
        this.unimplementedIf(startIndex != 0 || rank != null && rank != Types.TypeRank.ANY, "element");
        if (this.rs.cp.global.smartTable) {
            return this.addCtr(CtrExtensionSmart.buildElement(this, (VariableInteger[])list, (VariableInteger)index, (VariableInteger)value), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.jokerTable) {
            return this.extension(Utilities.indexOf(value, list) == -1 ? (IVar.Var[])this.vars(new Object[]{index, list, value}) : (IVar.Var[])this.vars(new Object[]{index, list}), constraints.hard.extension.structures.Table.shortTuplesForElement((Variable[])list, (Variable)((Object)index), (Variable)((Object)value)), true);
        }
        Variable[] lst = (VariableInteger[])Arrays.stream(list).map(v -> (VariableInteger)v).toArray(VariableInteger[]::new);
        return this.addCtr(new Element.ElementVariable(this, lst, (VariableInteger)index, (VariableInteger)value), new Types.TypeClass[0]);
    }

    private final CtrEntities.CtrEntity element(int[] list, int startIndex, IVar.Var index, IVar.Var value, int startValue) {
        ArrayList<int[]> l = new ArrayList<int[]>();
        Domain x = ((VariableInteger)index).dom;
        Domain z = ((VariableInteger)value).dom;
        int a = x.first();
        while (a != -1) {
            int v = x.toVal(a) - startIndex;
            if (0 <= v && v < list.length && z.isPresentValue(list[v] - startValue)) {
                l.add(new int[]{v + startIndex, list[v] - startValue});
            }
            a = x.next(a);
        }
        return this.api.extension((IVar.Var[])this.vars(new Object[]{index, value}), Table.clean(l));
    }

    @Override
    public final CtrEntities.CtrEntity element(int[] list, int startIndex, IVar.Var index, Types.TypeRank rank, IVar.Var value) {
        this.unimplementedIf(rank != null && rank != Types.TypeRank.ANY, "element");
        return this.element(list, startIndex, index, value, 0);
    }

    public int[][] jokerTableForElement(IVar.Var[] list, IVar.Var index, IVar.Var value, int startValue) {
        Utilities.control(Utilities.indexOf(index, list) == -1 && index != value, "index cannot be in vector or be the same variable as result");
        int pos = Utilities.indexOf(value, list);
        if (pos != -1) {
            int[] tuple = this.api.repeat(0x7FFFFFFE, 1 + list.length);
            ArrayList<int[]> tuples = new ArrayList<int[]>();
            int a = ((Variable)((Object)index)).dom.first();
            while (a != -1) {
                int v = ((Variable)((Object)index)).dom.toVal(a);
                if (0 <= v && v < list.length) {
                    if (list[v] == value) {
                        if (startValue == 0) {
                            int[] t = (int[])tuple.clone();
                            t[0] = v;
                            tuples.add(t);
                        }
                    } else {
                        int b = ((Variable)((Object)list[v])).dom.first();
                        while (b != -1) {
                            int w = ((Variable)((Object)list[v])).dom.toVal(b);
                            if (((Variable)((Object)value)).dom.isPresentValue(w - startValue)) {
                                int[] t = (int[])tuple.clone();
                                t[0] = v;
                                t[1 + v] = w;
                                t[1 + pos] = w - startValue;
                                tuples.add(t);
                            }
                            b = ((Variable)((Object)list[v])).dom.next(b);
                        }
                    }
                }
                a = ((Variable)((Object)index)).dom.next(a);
            }
            return Kit.intArray2D(tuples);
        }
        return (int[][])Kit.exit("unimplemented case ");
    }

    @Override
    public CtrEntities.CtrEntity element(int[][] matrix, int startRowIndex, IVar.Var rowIndex, int startColIndex, IVar.Var colIndex, IVar.Var value) {
        this.unimplementedIf(startRowIndex != 0 && startColIndex != 0, "element");
        ArrayList<int[]> l = new ArrayList<int[]>();
        Domain x = ((VariableInteger)rowIndex).dom;
        Domain y = ((VariableInteger)colIndex).dom;
        Domain z = ((VariableInteger)value).dom;
        int a = x.first();
        while (a != -1) {
            int b = y.first();
            while (b != -1) {
                int i = x.toVal(a);
                int j = y.toVal(b);
                if (0 <= i && i < matrix.length && 0 <= j && j < matrix[i].length && z.isPresentValue(matrix[i][j])) {
                    l.add(new int[]{i, j, matrix[i][j]});
                }
                b = y.next(b);
            }
            a = x.next(a);
        }
        return this.api.extension((IVar.Var[])this.vars(new Object[]{rowIndex, colIndex, value}), Table.clean(l));
    }

    @Override
    public CtrEntities.CtrEntity element(IVar.Var[][] matrix, int startRowIndex, IVar.Var rowIndex, int startColIndex, IVar.Var colIndex, int value) {
        this.unimplementedIf(startRowIndex != 0 && startColIndex != 0, "element");
        if (rowIndex == colIndex) {
            Kit.control(matrix.length == matrix[0].length);
            IVar.Var[] t = (IVar.Var[])IntStream.range(0, matrix.length).mapToObj(i -> matrix[i][i]).toArray(IVar.Var[]::new);
            return this.element(t, startRowIndex, rowIndex, null, value);
        }
        return this.addCtr(new ElementMatrix(this, (Variable[][])matrix, (Variable)((Object)rowIndex), (Variable)((Object)colIndex), value), new Types.TypeClass[0]);
    }

    @Override
    public CtrEntities.CtrEntity channel(IVar.Var[] list, int startIndex) {
        Kit.control(Stream.of(list).noneMatch(x -> x == null));
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawChannel.buildFrom(this, list, this.varEntities.compactOrdered(list), startIndex, null, null, null), new Types.TypeClass[0]);
        }
        return this.unimplemented("channel");
    }

    @Override
    public CtrEntities.CtrEntity channel(IVar.Var[] list1, int startIndex1, IVar.Var[] list2, int startIndex2) {
        Kit.control(Stream.of(list1).noneMatch(x -> x == null) && Stream.of(list2).noneMatch(x -> x == null));
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawChannel.buildFrom(this, this.scope(list1, list2), this.varEntities.compactOrdered(list1), startIndex1, this.varEntities.compactOrdered(list2), startIndex2, null), new Types.TypeClass[0]);
        }
        Kit.control(startIndex1 == 0 && startIndex2 == 0, () -> "unimplemented case for channel");
        if (list1.length == list2.length) {
            this.allDifferent(list1);
            this.allDifferent(list2);
        }
        return this.forall(this.range(list1.length), (int i) -> this.api.element(list2, list1[i], i));
    }

    @Override
    public final CtrEntities.CtrEntity channel(IVar.Var[] list, int startIndex, IVar.Var value) {
        Kit.control(Stream.of(list).noneMatch(x -> x == null));
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawChannel.buildFrom(this, this.scope(list, value), this.varEntities.compactOrdered(list), startIndex, null, null, value), new Types.TypeClass[0]);
        }
        Kit.control(Variable.areAllInitiallyBoolean((VariableInteger[])list) && ((VariableInteger)value).dom.areInitValuesExactly(this.range(list.length)));
        return this.forall(this.range(list.length), (int i) -> this.intension((XNodeParent)XNodeParent.iff(list[i], XNodeParent.eq(value, i))));
    }

    @Override
    public CtrEntities.CtrEntity stretch(IVar.Var[] list, int[] values, int[] widthsMin, int[] widthsMax, int[][] patterns) {
        Kit.control(values.length == widthsMin.length && values.length == widthsMax.length);
        Kit.control(IntStream.range(0, values.length).allMatch(i -> widthsMin[i] <= widthsMax[i]));
        Kit.control(patterns == null || Stream.of(patterns).allMatch(t -> ((int[])t).length == 2));
        if (this.rs.cp.export) {
            String t2 = patterns == null ? null : ICtr.ICtrExtension.tableAsString(Table.clean(patterns));
            return this.addCtr(CtrRaw.RawStretch.buildFrom(this, list, this.varEntities.compactOrdered(list), Kit.join((Object)values, new String[0]), this.intervalAsString(widthsMin, widthsMax), t2), new Types.TypeClass[0]);
        }
        return this.unimplemented("strtech");
    }

    private CtrEntities.CtrAlone noOverlap(IVar.Var x1, IVar.Var x2, int w1, int w2) {
        if (this.isBasicType(this.rs.cp.global.typeNoOverlap)) {
            return this.addCtr(new CtrPrimitiveBinary.Disjonctive(this, (Variable)((Object)x1), w1, (Variable)((Object)x2), w2), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeNoOverlap == 2) {
            return this.intension((XNodeParent)XNodeParent.or(XNodeParent.le(XNodeParent.add(x1, w1), x2), XNodeParent.le(XNodeParent.add(x2, w2), x1)));
        }
        if (this.rs.cp.global.typeNoOverlap == 10) {
            return this.addCtr(CtrExtensionSmart.buildNoOverlap(this, (Variable)((Object)x1), (Variable)((Object)x2), w1, w2), new Types.TypeClass[0]);
        }
        return (CtrEntities.CtrAlone)Kit.exit("Bad value for the choice of the propagator");
    }

    @Override
    public final CtrEntities.CtrEntity noOverlap(IVar.Var[] origins, int[] lengths, boolean zeroIgnored) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawNoOverlap.buildFrom(this, origins, this.varEntities.compactOrdered(origins), Kit.join((Object)lengths, new String[0]), zeroIgnored), new Types.TypeClass[0]);
        }
        this.unimplementedIf(!zeroIgnored, "noOverlap");
        return this.forall(this.range(origins.length).range(origins.length), (int i, int j) -> {
            if (i < j) {
                this.noOverlap(origins[i], origins[j], lengths[i], lengths[j]);
            }
        });
    }

    @Override
    public final CtrEntities.CtrEntity noOverlap(IVar.Var[] origins, IVar.Var[] lengths, boolean zeroIgnored) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawNoOverlap.buildFrom(this, this.scope(origins, lengths), this.varEntities.compactOrdered(origins), this.varEntities.compactOrdered(lengths), zeroIgnored), new Types.TypeClass[0]);
        }
        return this.unimplemented("noOverlap");
    }

    private void addNonOverlapTuplesFor(List<int[]> list, Domain dom1, Domain dom2, int offset, boolean first, boolean xAxis) {
        int a = dom1.first();
        while (a != -1) {
            int w;
            int v = dom1.toVal(a);
            int b = dom2.last();
            while (b != -1 && v + offset <= (w = dom2.toVal(b))) {
                list.add(xAxis ? this.api.tuple(first ? v : w, first ? w : v, 0x7FFFFFFE, 0x7FFFFFFE) : this.api.tuple(0x7FFFFFFE, 0x7FFFFFFE, first ? v : w, first ? w : v));
                b = dom2.prev(b);
            }
            a = dom1.next(a);
        }
    }

    private int[][] computeTable(Variable x1, Variable x2, Variable y1, Variable y2, int w1, int w2, int h1, int h2) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        this.addNonOverlapTuplesFor(list, x1.dom, x2.dom, w1, true, true);
        this.addNonOverlapTuplesFor(list, x2.dom, x1.dom, w2, false, true);
        this.addNonOverlapTuplesFor(list, y1.dom, y2.dom, h1, true, false);
        this.addNonOverlapTuplesFor(list, y2.dom, y1.dom, h2, false, false);
        return Kit.intArray2D(list);
    }

    private CtrEntities.CtrAlone noOverlap(VariableInteger x1, VariableInteger x2, VariableInteger y1, VariableInteger y2, int w1, int w2, int h1, int h2) {
        if (this.rs.cp.global.smartTable) {
            return this.addCtr(CtrExtensionSmart.buildNoOverlap(this, (Variable)x1, (Variable)y1, (Variable)x2, (Variable)y2, w1, h1, w2, h2), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.jokerTable) {
            return this.extension(this.vars(new Object[]{x1, x2, y1, y2}), this.computeTable(x1, x2, y1, y2, w1, w2, h1, h2), true, true);
        }
        return this.intension((XNodeParent)XNodeParent.or(XNodeParent.le(XNodeParent.add(x1, w1), x2), XNodeParent.le(XNodeParent.add(x2, w2), x1), XNodeParent.le(XNodeParent.add(y1, h1), y2), XNodeParent.le(XNodeParent.add(y2, h2), y1)));
    }

    @Override
    public final CtrEntities.CtrEntity noOverlap(IVar.Var[][] origins, int[][] lengths, boolean zeroIgnored) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawNoOverlap.buildFrom(this, this.vars(origins), this.varEntities.compactMatrix(origins), "(" + Kit.join((Object)lengths, ")(", ",") + ")", zeroIgnored), new Types.TypeClass[0]);
        }
        this.unimplementedIf(!zeroIgnored, "noOverlap");
        return this.forall(this.range(origins.length).range(origins.length), (int i, int j) -> {
            if (i < j) {
                this.noOverlap((VariableInteger)origins[i][0], (VariableInteger)origins[j][0], (VariableInteger)origins[i][1], (VariableInteger)origins[j][1], lengths[i][0], lengths[j][0], lengths[i][1], lengths[j][1]);
            }
        });
    }

    private CtrEntities.CtrAlone noOverlap(VariableInteger x1, VariableInteger x2, VariableInteger y1, VariableInteger y2, VariableInteger w1, VariableInteger w2, VariableInteger h1, VariableInteger h2) {
        if (this.rs.cp.global.smartTable && Stream.of(w1, w2, h1, h2).allMatch(x -> x.dom.initSize() == 2)) {
            return this.addCtr(CtrExtensionSmart.buildNoOverlap(this, (Variable)x1, (Variable)y1, (Variable)x2, (Variable)y2, w1, h1, w2, h2), new Types.TypeClass[0]);
        }
        return this.intension((XNodeParent)XNodeParent.or(XNodeParent.le(XNodeParent.add(x1, w1), x2), XNodeParent.le(XNodeParent.add(x2, w2), x1), XNodeParent.le(XNodeParent.add(y1, h1), y2), XNodeParent.le(XNodeParent.add(y2, h2), y1)));
    }

    @Override
    public final CtrEntities.CtrEntity noOverlap(IVar.Var[][] origins, IVar.Var[][] lengths, boolean zeroIgnored) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawNoOverlap.buildFrom(this, this.scope(new Object[]{origins, lengths}), this.varEntities.compactMatrix(origins), "(" + Kit.join((Object)lengths, ")(", ",") + ")", zeroIgnored), new Types.TypeClass[0]);
        }
        this.unimplementedIf(!zeroIgnored, "noOverlap");
        return this.forall(this.range(origins.length).range(origins.length), (int i, int j) -> {
            if (i < j) {
                this.noOverlap((VariableInteger)origins[i][0], (VariableInteger)origins[j][0], (VariableInteger)origins[i][1], (VariableInteger)origins[j][1], (VariableInteger)lengths[i][0], (VariableInteger)lengths[j][0], (VariableInteger)lengths[i][1], (VariableInteger)lengths[j][1]);
            }
        });
    }

    @Override
    public final CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, IVar.Var[] ends, int[] heights, Condition condition) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCumulative.buildFrom(this, this.scope(origins, ends, condition), this.varEntities.compactOrdered(origins), Kit.join((Object)lengths, new String[0]), ends == null ? null : this.varEntities.compactOrdered(ends), Kit.join((Object)heights, new String[0]), condition), new Types.TypeClass[0]);
        }
        if (ends == null && condition instanceof Condition.ConditionVal) {
            Types.TypeConditionOperatorRel op = ((Condition.ConditionVal)condition).operator;
            Kit.control(op == Types.TypeConditionOperatorRel.LT || op == Types.TypeConditionOperatorRel.LE);
            int limit = Utilities.safeInt(((Condition.ConditionVal)condition).k);
            return this.addCtr(new Cumulative(this, (Variable[])origins, lengths, heights, op == Types.TypeConditionOperatorRel.LT ? limit + 1 : limit), new Types.TypeClass[0]);
        }
        return this.unimplemented("cumulative");
    }

    @Override
    public final CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, IVar.Var[] ends, int[] heights, Condition condition) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCumulative.buildFrom(this, this.scope(origins, lengths, ends, condition), this.varEntities.compactOrdered(origins), this.varEntities.compactOrdered(lengths), ends == null ? null : this.varEntities.compactOrdered(ends), Kit.join((Object)heights, new String[0]), condition), new Types.TypeClass[0]);
        }
        return this.unimplemented("cumulative");
    }

    @Override
    public final CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, IVar.Var[] ends, IVar.Var[] heights, Condition condition) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCumulative.buildFrom(this, this.scope(origins, ends, heights, condition), this.varEntities.compactOrdered(origins), Kit.join((Object)lengths, new String[0]), ends == null ? null : this.varEntities.compactOrdered(ends), this.varEntities.compactOrdered(heights), condition), new Types.TypeClass[0]);
        }
        return this.unimplemented("cumulative");
    }

    @Override
    public final CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, IVar.Var[] ends, IVar.Var[] heights, Condition condition) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCumulative.buildFrom(this, this.scope(origins, lengths, ends, heights, condition), this.varEntities.compactOrdered(origins), this.varEntities.compactOrdered(lengths), ends == null ? null : this.varEntities.compactOrdered(ends), this.varEntities.compactOrdered(heights), condition), new Types.TypeClass[0]);
        }
        return this.unimplemented("cumulative");
    }

    @Override
    public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCircuit.buildFrom(this, list, this.varEntities.compactOrdered(list), startIndex, null), new Types.TypeClass[0]);
        }
        this.unimplementedIf(startIndex != 0, "circuit");
        return this.addCtr(new Circuit(this, this.translate(list)), new Types.TypeClass[0]);
    }

    @Override
    public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex, int size) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCircuit.buildFrom(this, list, this.varEntities.compactOrdered(list), startIndex, size), new Types.TypeClass[0]);
        }
        return this.unimplemented("circuit");
    }

    @Override
    public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex, IVar.Var size) {
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawCircuit.buildFrom(this, this.scope(list, size), this.varEntities.compactOrdered(list), startIndex, size), new Types.TypeClass[0]);
        }
        return this.unimplemented("circuit");
    }

    @Override
    public final CtrEntities.CtrEntity clause(IVar.Var[] list, Boolean[] phases) {
        Utilities.control(Stream.of(list).noneMatch(x -> x == null), "A variable in array list is null");
        Utilities.control(list.length == phases.length, "Bad form of clause");
        Utilities.control(Variable.areAllInitiallyBoolean((VariableInteger[])list), "A variable is not Boolean in the array list.");
        if (this.rs.cp.export) {
            String s = IntStream.range(0, list.length).mapToObj(i -> phases[i] != false ? list[i].id() : "not(" + list[i].id() + ")").collect(Collectors.joining(" "));
            return this.addCtr(CtrRaw.RawClause.buildFrom(this, list, s), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeClause == 1) {
            return this.api.sum(list, Stream.of(phases).mapToInt(p -> p != false ? 1 : -1).toArray(), Types.TypeConditionOperatorRel.NE, -Stream.of(phases).filter(p -> p == false).count());
        }
        return this.unimplemented("clause");
    }

    @Override
    public final CtrEntities.CtrEntity instantiation(IVar.Var[] list, int[] values) {
        Kit.control(list.length == values.length && list.length > 0);
        Kit.control(IntStream.range(0, list.length).noneMatch(i -> !((Variable)((Object)list[i])).dom.isPresentValue(values[i])), () -> "Pb");
        if (this.rs.cp.export) {
            return this.addCtr(CtrRaw.RawInstantiation.buildFrom(this, list, this.varEntities.compactOrdered(list), Kit.join((Object)values, new String[0])), new Types.TypeClass[0]);
        }
        if (this.rs.cp.global.typeInstantiation == 1) {
            return this.forall(this.range(list.length), (int i) -> this.equal(list[i], values[i]));
        }
        return this.unimplemented("instantiation");
    }

    private int[] computeOffsets(IVar[][] lists, IVar[] scp0, IVar[] scp1) {
        return IntStream.range(0, lists.length).map(i -> {
            int pos0 = Stream.of(scp0).filter(x -> Utilities.indexOf(x, lists[i]) >= 0).mapToInt(x -> Utilities.indexOf(x, lists[i])).min().orElse(-1);
            int pos1 = Stream.of(scp1).filter(x -> Utilities.indexOf(x, lists[i]) >= 0).mapToInt(x -> Utilities.indexOf(x, lists[i])).min().orElse(-1);
            Kit.control(pos0 != -1 && pos1 != -1);
            return pos1 - pos0;
        }).toArray();
    }

    private int[] computeCollects(IVar[][] lists, IVar[] scp) {
        return IntStream.range(0, lists.length).map(i -> (int)Stream.of(scp).filter(x -> Utilities.indexOf(x, lists[i]) >= 0).count()).toArray();
    }

    @Override
    public final CtrEntities.CtrEntity slide(IVar[] list, Range range, IntFunction<CtrEntities.CtrEntity> template) {
        Kit.control(range.start == 0 && range.length() > 0);
        if (range.length() == 1) {
            return template.apply(0);
        }
        if (this.rs.cp.export) {
            CtrEntities.CtrAlone[] cas = (CtrEntities.CtrAlone[])range.stream().mapToObj(i -> (CtrEntities.CtrEntity)template.apply(i)).toArray(CtrEntities.CtrAlone[]::new);
            for (int i2 = cas.length - 1; i2 >= 0; --i2) {
                this.removeCtr((CtrHard)cas[i2].ctr);
            }
            IVar[][] scopes = (IVar[][])Stream.of(cas).map(ca -> ca.ctr.scope()).toArray(x$0 -> new IVar[x$0][]);
            Kit.control(IntStream.range(1, scopes.length).noneMatch(i -> scopes[i].length != scopes[0].length));
            IVar[][] lists = new IVar[][]{list};
            boolean circular = Stream.of(scopes[scopes.length - 1]).anyMatch(x -> x == lists[0][0]);
            int[] offsets = this.computeOffsets(lists, scopes[0], scopes[1]);
            int[] collects = this.computeCollects(lists, scopes[0]);
            return this.addCtr(CtrRaw.RawSlide.buildFrom(this, list, circular, lists, offsets, collects, cas), new Types.TypeClass[0]);
        }
        return this.manageLoop(() -> {
            CtrHard[] cfr_ignored_0 = (CtrHard[])IntStream.range(0, range.stop).filter(i -> i % range.step == 0).mapToObj(i -> (CtrHard)((CtrEntities.CtrAlone)template.apply((int)i)).ctr).toArray(CtrHard[]::new);
        });
    }

    @Override
    public final CtrEntities.CtrEntity ifThen(CtrEntities.CtrEntity c1, CtrEntities.CtrEntity c2) {
        Utilities.control(c1 instanceof CtrEntities.CtrAlone && c2 instanceof CtrEntities.CtrAlone, "unimplemented for the moment");
        if (this.rs.cp.export) {
            for (CtrEntities.CtrEntity c : new CtrEntities.CtrEntity[]{c2, c1}) {
                this.removeCtr((Constraint)((CtrEntities.CtrAlone)c).ctr);
            }
            return this.addCtr(CtrRaw.RawIfThen.buildFrom(this, this.scope(((CtrEntities.CtrAlone)c1).ctr.scope(), ((CtrEntities.CtrAlone)c2).ctr.scope()), (CtrEntities.CtrAlone)c1, (CtrEntities.CtrAlone)c2), new Types.TypeClass[0]);
        }
        return (CtrEntities.CtrEntity)Kit.exit("unimplemented case for ifThen");
    }

    @Override
    public final CtrEntities.CtrEntity ifThenElse(CtrEntities.CtrEntity c1, CtrEntities.CtrEntity c2, CtrEntities.CtrEntity c3) {
        Utilities.control(c1 instanceof CtrEntities.CtrAlone && c2 instanceof CtrEntities.CtrAlone && c3 instanceof CtrEntities.CtrAlone, "unimplemented for the moment");
        if (this.rs.cp.export) {
            for (CtrEntities.CtrEntity c : new CtrEntities.CtrEntity[]{c3, c2, c1}) {
                this.removeCtr((Constraint)((CtrEntities.CtrAlone)c).ctr);
            }
            return this.addCtr(CtrRaw.RawIfThenElse.buildFrom(this, this.scope(((CtrEntities.CtrAlone)c1).ctr.scope(), ((CtrEntities.CtrAlone)c2).ctr.scope(), ((CtrEntities.CtrAlone)c3).ctr.scope()), (CtrEntities.CtrAlone)c1, (CtrEntities.CtrAlone)c2, (CtrEntities.CtrAlone)c3), new Types.TypeClass[0]);
        }
        return (CtrEntities.CtrEntity)Kit.exit("unimplemented case for ifThenElse");
    }

    public final CtrEntities.CtrAlone smart(IVar[] scp, SmartTuple ... smartTuples) {
        return this.addCtr(new CtrExtensionSmart(this, this.translate(scp), smartTuples), new Types.TypeClass[0]);
    }

    public CtrEntities.CtrEntity tupleProximityGE(IVar[] scope, int[] tuple, int k, boolean noModidictaion) {
        Kit.control(scope.length != 0);
        if (noModidictaion) {
            return this.addCtr(new HammingProximityConstant.HammingProximityConstantGE(this, (Variable[])scope, tuple, k), new Types.TypeClass[0]);
        }
        ArrayList<IVar> newScope = new ArrayList<IVar>();
        ArrayList<Integer> newTuple = new ArrayList<Integer>();
        int newK = k;
        for (int i2 = 0; i2 < scope.length; ++i2) {
            if (!((Variable)scope[i2]).dom.isPresentValue(tuple[i2])) continue;
            if (((Variable)scope[i2]).dom.size() > 1) {
                newScope.add(scope[i2]);
                newTuple.add(tuple[i2]);
                continue;
            }
            --newK;
        }
        if (newK <= 0) {
            CtrEntities ctrEntities = this.ctrEntities;
            ctrEntities.getClass();
            return new CtrEntities.CtrAloneDummy(ctrEntities, "Removed constraint due to newk <= 0", new Types.TypeClass[0]);
        }
        if (newK == newScope.size()) {
            return this.forall(this.range(scope.length), (int i) -> this.equal(scope[i], tuple[i]));
        }
        Kit.control(newK < newScope.size(), () -> "Instance is UNSAT, constraint with scope " + Kit.join((Object)scope, new String[0]) + " cannot have more than " + k + " variables equal to their corresponding value in " + Kit.join((Object)tuple, new String[0]));
        return this.addCtr(new HammingProximityConstant.HammingProximityConstantGE(this, newScope.toArray(new Variable[newScope.size()]), Kit.intArray(newTuple), newK), new Types.TypeClass[0]);
    }

    public CtrEntities.CtrEntity tupleProximityDistanceSum(IVar[] scope, int[] tuple, int maxDist) {
        return this.addCtr(new HammingProximityConstant.HammingProximityConstantSumLE(this, this.translate(scope), tuple, maxDist), new Types.TypeClass[0]);
    }

    private OptimizationPilot buildOptimizationPilot(Types.TypeOptimization opt, CtrEntities.CtrAlone c) {
        Problem.control(this.optimizationPilot == null, "Only mono-objective currently supported");
        Problem.control(c.ctr instanceof OptimizationCompatible, new Object[0]);
        this.framework = Types.TypeFramework.COP;
        this.rs.cp.toCOP();
        String suffix = Kit.camelCaseOf(this.rs.cp.optimizing.optimizationStrategy.name());
        if (suffix.equals("Decreasing")) {
            return new OptimizationPilot.OptimizationPilotDecreasing(this, opt, (OptimizationCompatible)((Object)c.ctr));
        }
        if (suffix.equals("Increasing")) {
            return new OptimizationPilot.OptimizationPilotIncreasing(this, opt, (OptimizationCompatible)((Object)c.ctr));
        }
        Problem.control(suffix.equals("Dichotomic"), new Object[0]);
        return new OptimizationPilot.OptimizationPilotDichotomic(this, opt, (OptimizationCompatible)((Object)c.ctr));
    }

    private boolean switchToSatisfaction(Types.TypeOptimization opt, Types.TypeObjective obj, int[] coeffs, IVar ... list) {
        long limit = this.rs.cp.setingGeneral.limitForSatisfaction;
        if (limit == Long.MAX_VALUE) {
            return false;
        }
        this.framework = Types.TypeFramework.CSP;
        this.rs.cp.framework = Types.TypeFramework.CSP;
        this.rs.cp.setingGeneral.nSearchedSolutions = 1L;
        if (obj == Types.TypeObjective.EXPRESSION) {
            Problem.control(list.length == 1 && coeffs == null, new Object[0]);
            this.intension((XNodeParent)(opt == Types.TypeOptimization.MINIMIZE ? XNodeParent.le(list[0], limit) : XNodeParent.ge(list[0], limit)));
        }
        if (coeffs != null) {
            Problem.control(obj == Types.TypeObjective.SUM, new Object[0]);
            this.sum(list, coeffs, opt == Types.TypeOptimization.MINIMIZE ? Types.TypeConditionOperatorRel.LE : Types.TypeConditionOperatorRel.GE, limit);
        } else {
            Problem.control(obj.generalizable(), new Object[0]);
            if (opt == Types.TypeOptimization.MINIMIZE) {
                if (obj == Types.TypeObjective.SUM) {
                    this.addCtr(new SumSimple.SumSimpleLE(this, this.translate(list), limit), new Types.TypeClass[0]);
                } else if (obj == Types.TypeObjective.MINIMUM) {
                    this.addCtr(new Extremum.ExtremumCst.MinimumCst.MinimumCstLE(this, this.translate(list), limit), new Types.TypeClass[0]);
                } else if (obj == Types.TypeObjective.MAXIMUM) {
                    this.forall(this.range(list.length), (int i) -> this.lessEqual(list[i], limit));
                } else {
                    this.addCtr(new NValues.NValuesLE(this, this.translate(list), (int)limit), new Types.TypeClass[0]);
                }
            } else if (obj == Types.TypeObjective.SUM) {
                this.addCtr(new SumSimple.SumSimpleGE(this, this.translate(list), limit), new Types.TypeClass[0]);
            } else if (obj == Types.TypeObjective.MINIMUM) {
                this.forall(this.range(list.length), (int i) -> this.greaterEqual(list[i], limit));
            } else if (obj == Types.TypeObjective.MAXIMUM) {
                this.addCtr(new Extremum.ExtremumCst.MaximumCst.MaximumCstGE(this, this.translate(list), limit), new Types.TypeClass[0]);
            } else {
                this.addCtr(new NValues.NValuesGE(this, this.translate(list), (int)limit), new Types.TypeClass[0]);
            }
        }
        return true;
    }

    @Override
    public final ObjEntities.ObjEntity minimize(IVar x) {
        if (!this.switchToSatisfaction(Types.TypeOptimization.MINIMIZE, Types.TypeObjective.EXPRESSION, null, x)) {
            CtrEntities.CtrAlone c = this.addCtr(new ObjVar.ObjVarLE(this, (VariableInteger)x, Math.min(this.rs.cp.optimizing.upperBound, Integer.MAX_VALUE)), new Types.TypeClass[0]);
            this.optimizationPilot = this.buildOptimizationPilot(Types.TypeOptimization.MINIMIZE, c);
        }
        return null;
    }

    @Override
    public final ObjEntities.ObjEntity maximize(IVar x) {
        if (!this.switchToSatisfaction(Types.TypeOptimization.MAXIMIZE, Types.TypeObjective.EXPRESSION, null, x)) {
            CtrEntities.CtrAlone c = this.addCtr(new ObjVar.ObjVarGE(this, (VariableInteger)x, Math.max(this.rs.cp.optimizing.lowerBound, Integer.MIN_VALUE)), new Types.TypeClass[0]);
            this.optimizationPilot = this.buildOptimizationPilot(Types.TypeOptimization.MAXIMIZE, c);
        }
        return null;
    }

    @Override
    public final ObjEntities.ObjEntity minimize(XNode<IVar> tree) {
        return this.minimize(this.replaceByVariable(tree));
    }

    @Override
    public final ObjEntities.ObjEntity maximize(XNode<IVar> tree) {
        return this.maximize(this.replaceByVariable(tree));
    }

    @Override
    public final ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[] list) {
        Problem.control(type.generalizable(), new Object[0]);
        if (!this.switchToSatisfaction(Types.TypeOptimization.MINIMIZE, type, null, list)) {
            int limit = (int)Math.min(this.rs.cp.optimizing.upperBound, type == Types.TypeObjective.NVALUES ? (long)list.length : Integer.MAX_VALUE);
            CtrEntities.CtrAlone c = null;
            c = type == Types.TypeObjective.SUM ? this.addCtr(new SumSimple.SumSimpleLE(this, this.translate(list), limit), new Types.TypeClass[0]) : (type == Types.TypeObjective.MINIMUM ? this.addCtr(new Extremum.ExtremumCst.MinimumCst.MinimumCstLE(this, this.translate(list), limit), new Types.TypeClass[0]) : (type == Types.TypeObjective.MAXIMUM ? this.addCtr(new Extremum.ExtremumCst.MaximumCst.MaximumCstLE(this, this.translate(list), limit), new Types.TypeClass[0]) : this.addCtr(new NValues.NValuesLE(this, this.translate(list), limit), new Types.TypeClass[0])));
            this.optimizationPilot = this.buildOptimizationPilot(Types.TypeOptimization.MINIMIZE, c);
        }
        return null;
    }

    @Override
    public final ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[] list) {
        Problem.control(type.generalizable(), new Object[0]);
        if (!this.switchToSatisfaction(Types.TypeOptimization.MAXIMIZE, type, null, list)) {
            int limit = (int)Math.max(this.rs.cp.optimizing.lowerBound, type == Types.TypeObjective.NVALUES ? 1L : Integer.MIN_VALUE);
            CtrEntities.CtrAlone c = null;
            c = type == Types.TypeObjective.SUM ? this.addCtr(new SumSimple.SumSimpleGE(this, this.translate(list), limit), new Types.TypeClass[0]) : (type == Types.TypeObjective.MINIMUM ? this.addCtr(new Extremum.ExtremumCst.MinimumCst.MinimumCstGE(this, this.translate(list), limit), new Types.TypeClass[0]) : (type == Types.TypeObjective.MAXIMUM ? this.addCtr(new Extremum.ExtremumCst.MaximumCst.MaximumCstGE(this, this.translate(list), limit), new Types.TypeClass[0]) : this.addCtr(new NValues.NValuesGE(this, this.translate(list), limit), new Types.TypeClass[0])));
            this.optimizationPilot = this.buildOptimizationPilot(Types.TypeOptimization.MAXIMIZE, c);
        }
        return null;
    }

    @Override
    public final ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[] list, int[] coeffs) {
        Problem.control(type == Types.TypeObjective.SUM && coeffs != null, new Object[0]);
        if (!this.switchToSatisfaction(Types.TypeOptimization.MINIMIZE, type, coeffs, list)) {
            this.optimizationPilot = this.buildOptimizationPilot(Types.TypeOptimization.MINIMIZE, this.sum(list, coeffs, Types.TypeConditionOperatorRel.LE, this.rs.cp.optimizing.upperBound, false));
        }
        return null;
    }

    @Override
    public final ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[] list, int[] coeffs) {
        Problem.control(type == Types.TypeObjective.SUM && coeffs != null, new Object[0]);
        if (!this.switchToSatisfaction(Types.TypeOptimization.MAXIMIZE, type, coeffs, list)) {
            this.optimizationPilot = this.buildOptimizationPilot(Types.TypeOptimization.MAXIMIZE, this.sum(list, coeffs, Types.TypeConditionOperatorRel.GE, this.rs.cp.optimizing.lowerBound, false));
        }
        return null;
    }

    @Override
    public ObjEntities.ObjEntity minimize(Types.TypeObjective type, XNode<IVar>[] trees) {
        return this.minimize(type, this.replaceByVariables(trees));
    }

    @Override
    public ObjEntities.ObjEntity minimize(Types.TypeObjective type, XNode<IVar>[] trees, int[] coeffs) {
        return this.minimize(type, this.replaceByVariables(trees), coeffs);
    }

    @Override
    public ObjEntities.ObjEntity maximize(Types.TypeObjective type, XNode<IVar>[] trees) {
        return this.maximize(type, this.replaceByVariables(trees));
    }

    @Override
    public ObjEntities.ObjEntity maximize(Types.TypeObjective type, XNode<IVar>[] trees, int[] coeffs) {
        return this.maximize(type, this.replaceByVariables(trees), coeffs);
    }

    @Override
    public void decisionVariables(IVar[] list) {
        if (this.rs.cp.setingGeneral.enableAnnotations) {
            super.decisionVariables(list);
        }
    }

    private /* synthetic */ void lambda$extremum$131(Variable y, Variable[] vars, boolean minimum, int i) {
        if (y != vars[i]) {
            if (minimum) {
                this.lessEqual(y, vars[i]);
            } else {
                this.greaterEqual(y, vars[i]);
            }
        }
    }

    private static class Term
    implements Comparable<Term> {
        long coeff;
        Variable var;

        private Term(long coeff, Variable var) {
            this.coeff = coeff;
            this.var = var;
        }

        @Override
        public int compareTo(Term term) {
            return Long.compare(this.coeff, term.coeff);
        }

        public String toString() {
            return this.coeff + "*" + this.var;
        }
    }
}

