/*
 * Decompiled with CFR 0.152.
 */
package problem;

import constraints.Constraint;
import constraints.hard.CtrExtension;
import constraints.hard.CtrIntension;
import constraints.hard.global.Lexicographic;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import problem.Problem;
import utility.Enums;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public final class IdentificationAutomorphism {
    private Problem pb;
    private int nCurrentNodes;
    private int nCurrentColors;
    private int[] variableNodes;
    private Map<String, Variable> mapOfDomainColors;
    private List<Node> constraintNodes;
    private Map<String, int[]> mapOfRelationColors;
    private Map<Integer, List<Integer>> groupsOfColors;
    private List<List<int[]>> generators;
    private Kit.Stopwatch stopwatch;
    private int nbFusions;
    private String graphFileName;
    private Map<String, Domain> mapOfModifiedDomains;

    public List<List<int[]>> getGenerators() {
        return this.generators;
    }

    public IdentificationAutomorphism(Problem pb) {
        this.pb = pb;
    }

    private void clear() {
        this.variableNodes = null;
        this.mapOfDomainColors.clear();
        this.constraintNodes.clear();
        this.mapOfRelationColors.clear();
        this.groupsOfColors.clear();
    }

    private void addColorNode(int id, int color) {
        this.groupsOfColors.computeIfAbsent(color, k -> new ArrayList()).add(id);
    }

    private String manageDomainKeyOf(Domain dom) {
        if (dom.nRemoved() == 0) {
            return dom.typeName() + "0";
        }
        if (this.mapOfModifiedDomains == null) {
            this.mapOfModifiedDomains = new HashMap<String, Domain>();
        }
        int i = 1;
        while (true) {
            String key;
            Domain d;
            if ((d = this.mapOfModifiedDomains.get(key = dom.typeName() + i)) == null) {
                this.mapOfModifiedDomains.put(key, d);
                return key;
            }
            if (dom.size() == d.size()) {
                boolean equal = true;
                int idx = dom.first();
                while (equal && idx != -1) {
                    if (!d.isPresent(idx)) {
                        equal = false;
                    }
                    idx = dom.next(idx);
                }
                if (equal) {
                    return key;
                }
            }
            ++i;
        }
    }

    private void buildVariableNodes(Variable[] vars) {
        this.mapOfDomainColors = new HashMap<String, Variable>();
        this.variableNodes = new int[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            String key = this.manageDomainKeyOf(vars[i].dom);
            Variable var = this.mapOfDomainColors.get(key);
            if (var == null) {
                this.mapOfDomainColors.put(key, vars[i]);
                ++this.nCurrentColors;
            } else {
                this.variableNodes[i] = this.variableNodes[var.num];
            }
            this.addColorNode(i, this.variableNodes[i]);
        }
        this.nCurrentNodes = this.variableNodes.length;
    }

    private void buildConstraintNodes(Collection<Constraint> ctrs) {
        this.mapOfRelationColors = new HashMap<String, int[]>();
        this.constraintNodes = new ArrayList<Node>();
        for (Constraint ctr : ctrs) {
            int i;
            Variable[] scope = ctr.scp;
            String key = ctr.key;
            int[] t = this.mapOfRelationColors.get(key);
            if (t == null) {
                int[] symmetryMatching = ctr.getSymmetryMatching();
                t = new int[scope.length + 1];
                if (symmetryMatching != null) {
                    t[t.length - 1] = this.nCurrentColors++;
                    int max = 0;
                    for (int i2 = 0; i2 < symmetryMatching.length; ++i2) {
                        if (symmetryMatching[i2] > max) {
                            max = symmetryMatching[i2];
                        }
                        t[i2] = this.nCurrentColors + (symmetryMatching[i2] - 1);
                    }
                    this.nCurrentColors += max;
                } else {
                    for (i = 0; i < t.length; ++i) {
                        ++this.nCurrentColors;
                    }
                }
                this.mapOfRelationColors.put(key, t);
            }
            int v = this.nCurrentNodes;
            this.constraintNodes.add(new Node(this.nCurrentNodes, t[t.length - 1]));
            this.addColorNode(this.nCurrentNodes++, t[t.length - 1]);
            for (i = 0; i < t.length - 1; ++i) {
                this.constraintNodes.add(new Node(this.nCurrentNodes, t[i], new int[]{scope[i].num, v}));
                this.addColorNode(this.nCurrentNodes++, t[i]);
            }
        }
    }

    private void buildGAPEdges(PrintWriter out) {
        out.print('[');
        Iterator<Node> it = this.constraintNodes.iterator();
        while (it.hasNext()) {
            Node node = it.next();
            for (int i = 0; i < node.neighbors.length; ++i) {
                out.print('[');
                out.print(node.id + 1);
                out.print(',');
                out.print(node.neighbors[i] + 1);
                out.print(']');
                if (!it.hasNext() && i >= node.neighbors.length - 1) continue;
                out.print(',');
            }
        }
        out.print(']');
    }

    private void buildGAPGroups(PrintWriter out) {
        out.print('[');
        Collection<List<Integer>> collection = this.groupsOfColors.values();
        Iterator<List<Integer>> it = collection.iterator();
        while (it.hasNext()) {
            List<Integer> list = it.next();
            out.print('[');
            for (int i = 0; i < list.size(); ++i) {
                out.print(list.get(i) + 1);
                if (i >= list.size() - 1) continue;
                out.print(',');
            }
            out.print(']');
            if (!it.hasNext()) continue;
            out.print(',');
        }
        out.print(']');
    }

    private void saveInGAPFormat() {
        try {
            this.graphFileName = "graph" + new Random().nextInt() + ".gap";
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.graphFileName)));
            out.print("AutGroupGraph(UnderlyingGraph(EdgeOrbitsGraph( Group(()),");
            this.buildGAPEdges(out);
            out.print(',');
            out.print(this.nCurrentNodes);
            out.print(")),");
            this.buildGAPGroups(out);
            out.println(");");
            out.close();
        }
        catch (Exception e) {
            Kit.exit(e);
        }
    }

    private List<int[]> parseGenerator(String line) {
        int id;
        String cycle;
        StringTokenizer st2;
        ArrayList<int[]> list = new ArrayList<int[]>();
        StringTokenizer st1 = new StringTokenizer(line, "()");
        while (st1.hasMoreTokens() && (st2 = new StringTokenizer(cycle = st1.nextToken(), ",")).hasMoreTokens() && (id = Integer.parseInt(st2.nextToken()) - 1) < this.variableNodes.length) {
            int[] t = new int[st2.countTokens() + 1];
            t[0] = id;
            for (int i = 1; i < t.length; ++i) {
                t[i] = Integer.parseInt(st2.nextToken()) - 1;
            }
            list.add(t);
        }
        return list;
    }

    private void runSaucy() {
        try {
            String command = System.getenv("HOME") + File.separator + "tools" + File.separator + "saucy-1.1" + File.separator + "saucy -t 20 -g " + this.graphFileName;
            Kit.log.info("Command for symmetry breaking is " + command);
            Process p = Runtime.getRuntime().exec(command);
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            this.generators = new ArrayList<List<int[]>>();
            in.readLine();
            String line = in.readLine().trim();
            while (!line.equals("]")) {
                List<int[]> generator = this.parseGenerator(line);
                if (generator.size() > 0) {
                    this.generators.add(generator);
                }
                line = in.readLine();
            }
            this.displayGenerators();
            in.close();
            p.waitFor();
            p.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Constraint> buildConstraintsFor(Variable[] variables, Collection<Constraint> collectedConstraints) {
        ArrayList<Constraint> constraintList = new ArrayList<Constraint>();
        Enums.ESymmetryBreaking symmetryType = this.pb.rs.cp.settingProblem.symmetryBreaking;
        if (symmetryType == Enums.ESymmetryBreaking.REC) {
            return constraintList;
        }
        boolean mustTryToMerge = symmetryType != Enums.ESymmetryBreaking.LE && symmetryType != Enums.ESymmetryBreaking.LEX;
        for (List<int[]> generator : this.generators) {
            int[] cycle1 = generator.get(0);
            Variable x = variables[cycle1[0]];
            Variable y = variables[cycle1[1]];
            boolean merged = false;
            if (mustTryToMerge) {
                for (Constraint ctr : collectedConstraints) {
                    if (ctr.positionOf(x) == -1 || ctr.positionOf(y) == -1 || ctr.scp.length > 2) continue;
                    if (ctr.scp.length == 2) {
                        merged = true;
                    }
                    if (ctr instanceof CtrExtension) {
                        ((CtrExtension)ctr).logicalAndWithLessThanOrEqual(x, y);
                        ++this.nbFusions;
                        continue;
                    }
                    if (!(ctr instanceof CtrIntension)) continue;
                    ((CtrIntension)ctr).updateWithLessThanOrEqual(x, y);
                    ++this.nbFusions;
                }
            }
            if (symmetryType == Enums.ESymmetryBreaking.LE || symmetryType == Enums.ESymmetryBreaking.LE_MERGED) {
                if (merged) continue;
                constraintList.add(new CtrIntension(this.pb, (Variable[])this.pb.api.vars(x, new Object[]{y}), this.pb.api.le(x, y)));
                continue;
            }
            ArrayList<Variable> list1 = new ArrayList<Variable>();
            ArrayList<Variable> list2 = new ArrayList<Variable>();
            for (int[] cycle : generator) {
                if (cycle.length == 2) {
                    list1.add(variables[cycle[0]]);
                    list2.add(variables[cycle[1]]);
                    continue;
                }
                for (int i = 0; i < cycle.length; ++i) {
                    list1.add(variables[cycle[i]]);
                    list2.add(variables[cycle[(i + 1) % cycle.length]]);
                }
            }
            Comparable[] t1 = list1.toArray(new Variable[list1.size()]);
            Variable[] t2 = list2.toArray(new Variable[list2.size()]);
            Kit.control(Kit.isStrictlyIncreasing((Comparable[])t1));
            constraintList.add(new Lexicographic.LexicographicLE(this.pb, (Variable[])t1, t2));
        }
        return constraintList;
    }

    public List<Constraint> buildVariableSymmetriesFor(Variable[] vars, Collection<Constraint> cons) {
        this.stopwatch = new Kit.Stopwatch();
        this.groupsOfColors = new HashMap<Integer, List<Integer>>();
        this.buildVariableNodes(vars);
        this.buildConstraintNodes(cons);
        this.saveInGAPFormat();
        this.runSaucy();
        this.clear();
        return this.buildConstraintsFor(vars, cons);
    }

    public void putInMap(Map<String, String> map) {
        map.put("nGenerators", this.generators.size() + "");
        map.put("nbFusions", this.nbFusions + "");
        map.put("symmetryWckTime", (double)this.stopwatch.getWckTime() / 1000.0 + "");
    }

    void displayGenerators() {
        for (List<int[]> generator : this.generators) {
            String s = "generator = ";
            for (int[] t : generator) {
                s = s + "[ " + Kit.join((Object)t, new String[0]) + " ]";
            }
            Kit.log.info(s);
        }
    }

    void displayGraph() {
        int i;
        System.out.println("variableNodes");
        for (i = 0; i < this.variableNodes.length; ++i) {
            System.out.println(i + 1 + ":" + this.variableNodes[i] + " ");
        }
        System.out.println("constraintNodes");
        for (i = 0; i < this.constraintNodes.size(); ++i) {
            System.out.println(i + 1 + ":" + this.constraintNodes.get(i) + " ");
        }
    }

    private class Node {
        private int id;
        private int color;
        private int[] neighbors;

        private Node(int id, int color) {
            this.id = id;
            this.color = color;
            this.neighbors = new int[0];
        }

        private Node(int id, int color, int[] neighbors) {
            this.id = id;
            this.color = color;
            this.neighbors = neighbors;
        }

        public String toString() {
            String s = "node " + (this.id + 1) + " color=" + this.color + " neighbors=";
            for (int i = 0; i < this.neighbors.length; ++i) {
                s = s + (this.neighbors[i] + 1) + " ";
            }
            return s;
        }
    }
}

