/*
 * Decompiled with CFR 0.152.
 */
package problem;

import constraints.Constraint;
import constraints.CtrHard;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import problem.Problem;
import utility.Kit;
import utility.sets.SetSparse;
import variables.Variable;
import variables.VariableInteger;

public final class IdentificationAllDifferent {
    private Problem pb;
    private int[][] allNeighbours;
    private int[] degrees;
    private int[] levels;
    public int nBuiltCliques;
    private int[] tmp;
    private SetSparse set;

    private int[][] computeIrreflexivesNeigbours(int nVariables, List<Constraint> constraints) {
        Set[] neighbours = (Set[])Stream.of(this.pb.variables).map(x -> new TreeSet()).toArray(TreeSet[]::new);
        for (Constraint c : constraints) {
            if (c.scp.length != 2 || !((CtrHard)c).isIrreflexive()) continue;
            neighbours[c.scp[0].num].add(c.scp[1].num);
            neighbours[c.scp[1].num].add(c.scp[0].num);
        }
        return Kit.intArray2D(neighbours);
    }

    private int countNeighboursAtLevel(int[] neighbours, int level) {
        return (int)IntStream.of(neighbours).filter(j -> this.levels[j] == level).count();
    }

    private int buildClique(int cliqueId) {
        int i;
        int level = 0;
        int cliqueSize = 0;
        int num = -1;
        for (i = 0; i <= this.set.limit; ++i) {
            if (num != -1 && this.degrees[this.set.dense[i]] <= this.degrees[num]) continue;
            num = this.set.dense[i];
        }
        while (num != -1) {
            int[] neighbours;
            this.levels[num] = -cliqueId;
            this.tmp[cliqueSize++] = num;
            this.set.remove(num);
            for (int j : neighbours = this.allNeighbours[num]) {
                if (this.levels[j] != level) continue;
                this.levels[j] = level + 1;
            }
            ++level;
            for (int j : neighbours) {
                if (this.levels[j] != level) continue;
                this.degrees[j] = this.countNeighboursAtLevel(this.allNeighbours[j], level);
            }
            num = -1;
            for (int j : neighbours) {
                if (this.levels[j] != level || num != -1 && this.degrees[j] <= this.degrees[num]) continue;
                num = j;
            }
        }
        for (i = 0; i <= this.set.limit; ++i) {
            this.levels[this.set.dense[i]] = 0;
        }
        return cliqueSize;
    }

    public IdentificationAllDifferent(Problem pb) {
        int cliqueSize;
        this.pb = pb;
        this.allNeighbours = this.computeIrreflexivesNeigbours(pb.variables.length, pb.stuff.collectedCtrsAtInit);
        this.degrees = IntStream.range(0, pb.variables.length).map(i -> this.allNeighbours[i].length).toArray();
        this.levels = new int[pb.variables.length];
        this.tmp = new int[pb.variables.length];
        this.set = new SetSparse(pb.variables.length, true);
        for (int k = 1; k <= pb.rs.cp.settingCtrs.inferAllDifferentNb && (cliqueSize = this.buildClique(k)) > pb.rs.cp.settingCtrs.inferAllDifferentSize; ++k) {
            IVar.Var[] scp = (VariableInteger[])IntStream.range(0, cliqueSize).mapToObj(i -> pb.variables[this.tmp[i]]).sorted().toArray(VariableInteger[]::new);
            pb.allDifferent(scp);
            ++this.nBuiltCliques;
            this.display(k, cliqueSize);
            assert (this.controlClique((Variable[])scp, pb.stuff.collectedCtrsAtInit));
            for (int i2 = 0; i2 <= this.set.limit; ++i2) {
                this.degrees[this.set.dense[i2]] = this.countNeighboursAtLevel(this.allNeighbours[this.set.dense[i2]], 0);
            }
        }
    }

    private boolean controlClique(Variable[] vars, List<Constraint> constraints) {
        for (int i = 0; i < vars.length; ++i) {
            for (int j = i + 1; j < vars.length; ++j) {
                Variable x = vars[i];
                Variable y = vars[j];
                Kit.control(constraints.stream().anyMatch(c -> c.scp.length == 2 && ((CtrHard)c).isIrreflexive() && c.involves(x, y)), () -> "not a clique with " + x + " " + y);
            }
        }
        return true;
    }

    private void display(int cliqueId, int cliqueSize) {
        System.out.println(" clique " + cliqueId + " of size " + cliqueSize + " {" + IntStream.range(0, this.levels.length).filter(i -> this.levels[i] == -cliqueId).mapToObj(i -> "" + this.pb.variables[i]).collect(Collectors.joining(" ")) + "}");
    }
}

