/*
 * Decompiled with CFR 0.152.
 */
package problem;

import constraints.Constraint;
import constraints.hard.CtrExtension;
import constraints.hard.CtrIntension;
import java.util.Map;
import java.util.stream.Stream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.Compiler;
import org.xcsp.modeler.definitions.ICtr;
import problem.Problem;
import problem.Subproblem;
import utility.Kit;
import utility.exceptions.MissingImplementationException;
import variables.Variable;

public final class Compiler3Abscon
extends Compiler {
    protected final Problem pb;
    protected final Subproblem subpb;

    public Compiler3Abscon(Subproblem subpb) {
        super(subpb.pb.api);
        this.pb = subpb.pb;
        this.subpb = subpb;
        this.ignoreAutomaticGroups = this.pb.rs.cp.settingXml.ignoreAutomaticGroups;
        this.saveImmediatelyStored = this.pb.rs.cp.settingXml.saveImmediatelyStored;
    }

    @Override
    protected Document buildDocument() {
        this.specificAbscon();
        return super.buildDocument();
    }

    @Override
    protected void putInMap(IVar x, Map<IVar, String> map) {
        map.put(x, ((Variable)x).dom.stringListOfValues());
    }

    @Override
    protected Element variables() {
        if (!this.subpb.isFullProblem()) {
            throw new MissingImplementationException();
        }
        return super.variables();
    }

    @Override
    protected void handleCtr(Element parent, ICtr ctr) {
        if (((Constraint)ctr).pb.optimizationPilot != null && ((Constraint)ctr).pb.optimizationPilot.ctr == ctr) {
            return;
        }
        super.handleCtr(parent, ctr);
    }

    @Override
    protected Element constraints() {
        if (!this.subpb.isFullProblem()) {
            throw new MissingImplementationException();
        }
        return super.constraints();
    }

    private void specificAbscon() {
        Kit.control(this.subpb.isFullProblem(), () -> "currently, only full problems handled");
        if (this.pb.ctrEntities.ctrToCtrArray.size() == 0 && !this.ignoreAutomaticGroups) {
            ICtr[] cis;
            ICtr[] ces = (CtrExtension[])Stream.of(this.pb.constraints).filter(c -> c instanceof CtrExtension).map(c -> (CtrExtension)c).toArray(CtrExtension[]::new);
            if (ces.length > 1) {
                this.pb.ctrEntities.newCtrArrayEntity(ces, false, new Types.TypeClass[0]);
            }
            if ((cis = (CtrIntension[])Stream.of(this.pb.constraints).filter(c -> c instanceof CtrIntension).map(c -> (CtrIntension)c).toArray(CtrIntension[]::new)).length > 1) {
                this.pb.ctrEntities.newCtrArrayEntity(cis, false, new Types.TypeClass[0]);
            }
        }
    }
}

