/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.parser;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xcsp.common.Condition;
import org.xcsp.common.Softening;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Domains;
import org.xcsp.common.domains.Values;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeLeaf;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.common.structures.AbstractTuple;
import org.xcsp.parser.WrongTypeException;
import org.xcsp.parser.entries.ParsingEntry;
import org.xcsp.parser.entries.XConstraints;
import org.xcsp.parser.entries.XObjectives;
import org.xcsp.parser.entries.XVariables;

public class XParser {
    public static boolean VERBOSE = false;
    private Document document;
    private XPath xpath = XPathFactory.newInstance().newXPath();
    public Map<String, XVariables.XVar> mapForVars = new HashMap<String, XVariables.XVar>();
    private Map<String, XVariables.XArray> mapForArrays = new HashMap<String, XVariables.XArray>();
    private Map<String, Domains.IDom> cacheForContentToDomain = new HashMap<String, Domains.IDom>();
    public List<ParsingEntry.VEntry> vEntries = new ArrayList<ParsingEntry.VEntry>();
    public List<ParsingEntry.CEntry> cEntries = new ArrayList<ParsingEntry.CEntry>();
    public List<ParsingEntry.OEntry> oEntries = new ArrayList<ParsingEntry.OEntry>();
    public Map<String, Object> aEntries = new HashMap<String, Object>();
    public Types.TypeFramework typeFramework;
    public Types.TypeCombination typeCombination;
    public Types.TypeClass[] discardedClasses;
    private static final char UTF_NE = '\u2260';
    private static final char UTF_LT = '\ufe64';
    private static final char UTF_LE = '\u2264';
    private static final char UTF_GE = '\u2265';
    private static final char UTF_GT = '\ufe65';
    private static final char UTF_LTGT = '\u2276';
    private static final char UTF_COMPLEMENT = '\u2201';
    private List<XConstraints.CChild> leafs;

    private <T extends Enum<T>> T giveAttributeValue(Element elt, String attName, Class<T> clazz, T defaultValue) {
        String s = elt.getAttribute(attName);
        return s.length() == 0 ? defaultValue : Types.valueOf(clazz, s.replaceFirst("\\s+", "_"));
    }

    private Domains.DomBasic parseDomBasic(Element elt, Types.TypeVar type) {
        String content = elt.getTextContent().trim();
        return (Domains.DomBasic)this.cacheForContentToDomain.computeIfAbsent(content, k -> Domains.DomBasic.parse(content, type));
    }

    private Domains.DomSet parseDomSet(Element elt, Types.TypeVar type) {
        Element[] childs = Utilities.childElementsOf(elt);
        String req = childs[0].getTextContent().trim();
        String pos = childs[1].getTextContent().trim();
        String content = String.valueOf(req) + " | " + pos;
        return (Domains.DomSet)this.cacheForContentToDomain.computeIfAbsent(content, k -> Domains.DomSet.parse(req, pos, type));
    }

    private Domains.DomGraph parseDomGraph(Element elt, Types.TypeVar type) {
        Element[] childs = Utilities.childElementsOf(elt);
        Element[] req = Utilities.childElementsOf(childs[0]);
        Element[] pos = Utilities.childElementsOf(childs[1]);
        String reqV = req[0].getTextContent().trim();
        String reqE = req[1].getTextContent().trim();
        String posV = pos[0].getTextContent().trim();
        String posE = pos[1].getTextContent().trim();
        String content = String.valueOf(reqV) + " | " + reqE + " | " + posV + " | " + posE;
        return (Domains.DomGraph)this.cacheForContentToDomain.computeIfAbsent(content, k -> Domains.DomGraph.parse(reqV, reqE, posV, posE, type));
    }

    private Domains.IDom parseDomain(Element elt, Types.TypeVar type) {
        return type.isBasic() ? this.parseDomBasic(elt, type) : (type.isSet() ? this.parseDomSet(elt, type) : this.parseDomGraph(elt, type));
    }

    private int[] giveArraySize(Element elt) {
        StringTokenizer st = new StringTokenizer(elt.getAttribute(Types.TypeAtt.size.name()), "[]");
        return IntStream.range(0, st.countTokens()).map(i -> Integer.parseInt(st.nextToken())).toArray();
    }

    private Element getActualElementToAnalyse(Element elt) {
        try {
            String id = elt.getAttribute(Types.TypeAtt.as.name());
            return id.length() == 0 ? elt : (Element)this.xpath.evaluate("//*[@id='" + id + "']", this.document, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return (Element)Utilities.control(false, "Bad use of 'as'" + elt.getTagName());
        }
    }

    public void parseVariables() {
        HashMap<String, Domains.IDom> cacheForId2Domain = new HashMap<String, Domains.IDom>();
        Element[] elementArray = Utilities.childElementsOf((Element)this.document.getElementsByTagName("variables").item(0));
        int n = elementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Element elt = elementArray[n2];
            ParsingEntry.VEntry entry = null;
            String id = elt.getAttribute(Types.TypeAtt.id.name());
            Types.TypeVar type = elt.getAttribute(Types.TypeAtt.type.name()).length() == 0 ? Types.TypeVar.integer : Types.TypeVar.valueOf(elt.getAttribute(Types.TypeAtt.type.name()));
            Element actualForElt = this.getActualElementToAnalyse(elt);
            Utilities.control(actualForElt != null, "in attribute \"as\" of variable with id \"" + id + "\"");
            Domains.IDom dom = (Domains.IDom)cacheForId2Domain.get(actualForElt.getAttribute(Types.TypeAtt.id.name()));
            if (elt.getTagName().equals("var")) {
                if (dom == null && !type.isQualitative()) {
                    try {
                        dom = this.parseDomain(actualForElt, type);
                        cacheForId2Domain.put(id, dom);
                    }
                    catch (WrongTypeException e) {
                        throw new WrongTypeException("for variable with id \"" + id + "\": " + e.getMessage());
                    }
                }
                entry = XVariables.XVar.build(id, type, dom);
            } else {
                int[] size = this.giveArraySize(elt);
                if (dom == null && !type.isQualitative()) {
                    Element[] childs = Utilities.childElementsOf(actualForElt);
                    if (childs.length > 0 && childs[0].getTagName().equals("domain")) {
                        XVariables.XArray array = new XVariables.XArray(id, type, size);
                        Stream.of(childs).forEach(child -> {
                            Element actualForChild = this.getActualElementToAnalyse((Element)child);
                            Domains.IDom domChild = (Domains.IDom)cacheForId2Domain.get(actualForChild.getAttribute(Types.TypeAtt.id.name()));
                            if (domChild == null) {
                                domChild = this.parseDomain(actualForChild, type);
                                String idChild = child.getAttribute(Types.TypeAtt.id.name());
                                if (idChild.length() > 0) {
                                    cacheForId2Domain.put(idChild, domChild);
                                }
                            }
                            array.setDom(child.getAttribute("for"), domChild);
                        });
                        entry = array;
                    } else {
                        dom = this.parseDomain(actualForElt, type);
                        cacheForId2Domain.put(id, dom);
                        entry = new XVariables.XArray(id, type, size, dom);
                    }
                } else {
                    entry = new XVariables.XArray(id, type, size, dom);
                }
            }
            entry.copyAttributesOf(elt);
            if (!Types.TypeClass.intersect(entry.classes, this.discardedClasses)) {
                this.vEntries.add(entry);
            }
            ++n2;
        }
        for (ParsingEntry.VEntry entry : this.vEntries) {
            if (entry instanceof XVariables.XVar) {
                this.mapForVars.put(entry.id, (XVariables.XVar)entry);
                continue;
            }
            Stream.of(((XVariables.XArray)entry).vars).filter(x -> x != null).forEach(x -> {
                XVariables.XVar xVar = this.mapForVars.put(x.id, (XVariables.XVar)x);
            });
            this.mapForArrays.put(entry.id, (XVariables.XArray)entry);
        }
    }

    private Object parseData(String tok) {
        if (this.mapForVars.get(tok) != null) {
            return this.mapForVars.get(tok);
        }
        if (Character.isDigit(tok.charAt(0)) || tok.charAt(0) == '+' || tok.charAt(0) == '-') {
            String[] t = tok.split("\\.\\.");
            if (t.length == 2) {
                return new Values.IntegerInterval(Utilities.safeLong(t[0]), Utilities.safeLong(t[1]));
            }
            t = tok.split("/");
            if (t.length == 2) {
                return new Values.Rational(Utilities.safeLong(t[0]), Utilities.safeLong(t[1]));
            }
            t = tok.split("\\.");
            if (t.length == 2) {
                return new Values.Decimal(Utilities.safeLong(t[0]), Utilities.safeLong(t[1]));
            }
            return Utilities.safeLong(tok);
        }
        if (tok.charAt(0) == '{') {
            String sub = tok.substring(1, tok.length() - 1);
            return sub.length() == 0 ? new Object[]{} : (Object[])Stream.of(sub.split("\\s*,\\s*")).mapToLong(s -> Utilities.safeLong(s)).toArray();
        }
        if (tok.charAt(0) == '(') {
            return this.parseCondition(tok);
        }
        if (tok.charAt(0) == '%') {
            return new XConstraints.XParameter(tok.equals("%...") ? -1 : Integer.parseInt(tok.substring(1)));
        }
        if (tok.indexOf("(") != -1) {
            return this.parseExpression(tok);
        }
        return tok;
    }

    private Object parseData(Element elt) {
        return this.parseData(elt.getTextContent().trim());
    }

    private Condition parseCondition(String tok) {
        int pos = tok.indexOf(44);
        String left = tok.substring(tok.charAt(0) != '(' ? 0 : 1, pos).trim();
        String right = tok.substring(pos + 1, tok.length() - (tok.charAt(tok.length() - 1) == ')' ? 1 : 0)).trim();
        Types.TypeConditionOperator op = Types.TypeConditionOperator.valueOf(left.trim().toUpperCase());
        return Condition.buildFrom((Object)op, this.parseData(right));
    }

    private Condition parseCondition(Element elt) {
        return this.parseCondition(elt.getTextContent().trim());
    }

    private Condition[] parseConditions(Element elt) {
        return (Condition[])Stream.of(elt.getTextContent().trim().split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(tok -> this.parseCondition((String)tok)).toArray(Condition[]::new);
    }

    public Object[] parseSequence(String seq, String delimiter) {
        ArrayList<Object> list = new ArrayList<Object>();
        String[] stringArray = seq.split(delimiter);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            int pos = tok.indexOf("[");
            XVariables.XArray array = pos == -1 ? null : this.mapForArrays.get(tok.substring(0, pos));
            try {
                if (array != null) {
                    list.addAll(array.getVarsFor(tok));
                } else {
                    list.add(this.parseData(tok));
                }
            }
            catch (WrongTypeException e) {
                throw new WrongTypeException("in sequence \"" + seq + "\": " + e.getMessage());
            }
            ++n2;
        }
        boolean presentVariable = false;
        boolean presentTree = false;
        boolean other = false;
        for (Object e : list) {
            if (e instanceof XVariables.XVar) {
                presentVariable = true;
                continue;
            }
            if (e instanceof XNode) {
                presentTree = true;
                continue;
            }
            other = true;
            break;
        }
        if (!other && presentVariable && presentTree) {
            return list.stream().map(obj -> obj instanceof XVariables.XVar ? new XNodeLeaf(Types.TypeExpr.VAR, obj) : obj).toArray(XNode[]::new);
        }
        return Utilities.specificArrayFrom(list);
    }

    public Object[] parseSequence(Element elt) {
        return this.parseSequence(elt.getTextContent().trim(), "\\s+");
    }

    private Object[][] parseDoubleSequence(Element elt, String delimiter) {
        String content = elt.getTextContent().trim();
        List<Object[]> list = Stream.of(content.split(delimiter)).skip(1L).map(tok -> this.parseSequence((String)tok, "\\s*,\\s*")).collect(Collectors.toList());
        return Utilities.specificArray2DFrom(list);
    }

    private Object[][] parseDoubleSequenceOfVars(Element elt) {
        String content = elt.getTextContent().trim();
        Utilities.control(content.charAt(0) != '%', "It is currently not possible to make abstraction of double sequences of variables");
        if (content.charAt(0) == '(') {
            List<Object[]> list = Stream.of(content.split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(tok -> this.parseSequence((String)tok, "\\s*,\\s*")).collect(Collectors.toList());
            return Utilities.specificArray2DFrom(list);
        }
        XVariables.XArray array = this.mapForArrays.get(content.substring(0, content.indexOf("[")));
        Values.IntegerEntity[] indexRanges = array.buildIndexRanges(content);
        int first = -1;
        int second = -1;
        int i = 0;
        while (first == -1 && i < indexRanges.length) {
            if (!indexRanges[i].isSingleton()) {
                first = i;
            }
            ++i;
        }
        i = indexRanges.length - 1;
        while (second == -1 && i >= 0) {
            if (!indexRanges[i].isSingleton()) {
                second = i;
            }
            --i;
        }
        int length1 = Math.toIntExact(indexRanges[first].width());
        int length2 = Math.toIntExact(indexRanges[second].width());
        Utilities.control(length1 != -1 && length2 != -1, "");
        ArrayList<Object[]> list2D = new ArrayList<Object[]>();
        int[] indexes = Stream.of(indexRanges).mapToInt(it -> (int)it.smallest()).toArray();
        int i2 = 0;
        while (i2 < length1) {
            ArrayList<Object> list = new ArrayList<Object>();
            indexes[first] = i2 + (int)indexRanges[first].smallest();
            int j = 0;
            while (j < length2) {
                indexes[second] = j + (int)indexRanges[second].smallest();
                list.add(array.varAt(indexes));
                ++j;
            }
            list2D.add(Utilities.specificArrayFrom(list));
            ++i2;
        }
        return Utilities.specificArray2DFrom(list2D);
    }

    private Object parseSmartCondition(String s) {
        assert (s.length() > 0);
        char c = s.charAt(0);
        if (c == '*') {
            assert (s.length() == 1);
            return 0x7FFFFFFE;
        }
        if (Utilities.isInteger(s)) {
            return Utilities.toInteger(s);
        }
        if (c == '\u2260') {
            return new Condition.ConditionVal(Types.TypeConditionOperatorRel.NE, Utilities.safeLong(s.substring(1)));
        }
        if (c == '\u2264') {
            return new Condition.ConditionVal(Types.TypeConditionOperatorRel.LE, Utilities.safeLong(s.substring(1)));
        }
        if (c == '\u2265') {
            return new Condition.ConditionVal(Types.TypeConditionOperatorRel.GE, Utilities.safeLong(s.substring(1)));
        }
        if (c == '\ufe64') {
            return new Condition.ConditionVal(Types.TypeConditionOperatorRel.LT, Utilities.safeLong(s.substring(1)));
        }
        if (c == '\ufe65') {
            return new Condition.ConditionVal(Types.TypeConditionOperatorRel.GT, Utilities.safeLong(s.substring(1)));
        }
        Types.TypeConditionOperatorSet op = Types.TypeConditionOperatorSet.IN;
        if (c == '\u2201') {
            op = Types.TypeConditionOperatorSet.NOTIN;
            s = s.substring(1);
            c = s.charAt(0);
        }
        if (s.indexOf("..") != -1) {
            String[] t = s.split("\\.\\.");
            return new Condition.ConditionIntvl(op, Utilities.safeLong(t[0]), Utilities.safeLong(t[1]));
        }
        if (c == '{') {
            assert (s.charAt(s.length() - 1) == '}');
            return new Condition.ConditionIntset(op, Utilities.splitToInts(s.substring(1, s.length() - 1), "\\s"));
        }
        throw new RuntimeException("Unrecognized smart condition " + s);
    }

    private String replaceInternCommas(String s) {
        boolean processing = false;
        String ps = "";
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            int c = cArray[n2];
            ps = String.valueOf(ps) + (char)(processing && c == 44 ? 32 : c);
            if (c == 123 || c == 125) {
                processing = !processing;
            }
            ++n2;
        }
        return ps;
    }

    private AbstractTuple[] parseSmartTuples(Element elt) {
        String text = elt.getTextContent().trim();
        if (text.length() == 0) {
            return null;
        }
        ArrayList<AbstractTuple> list = new ArrayList<AbstractTuple>();
        String[][] stringArray = (String[][])Stream.of(text.split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(tok -> this.replaceInternCommas((String)tok).split("\\s*,\\s*")).toArray(n -> new String[n][]);
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String[] t = stringArray[n3];
            if (Stream.of(t).allMatch(s -> Utilities.isInteger(s) || s.equals("*"))) {
                list.add(new AbstractTuple.OrdinaryTuple(Stream.of(t).mapToInt(s -> s.equals("*") ? 0x7FFFFFFE : Utilities.toInteger(s)).toArray()));
            } else {
                list.add(new AbstractTuple.SmartTuple(Stream.of(t).map(s -> this.parseSmartCondition((String)s)).toArray()));
            }
            ++n3;
        }
        return (AbstractTuple[])list.stream().toArray(AbstractTuple[]::new);
    }

    private boolean parseSymbolicTuple(String[] t, Domains.DomBasic[] doms, AtomicBoolean ab) {
        boolean starred = false;
        int i = 0;
        while (i < t.length) {
            if (t[i].equals("*")) {
                starred = true;
            } else if (doms != null && (doms[i] instanceof Domains.DomSymbolic ? !((Domains.DomSymbolic)doms[i]).contains(t[i]) : !((Domains.Dom)doms[i]).contains(Integer.parseInt(t[i])))) {
                return false;
            }
            ++i;
        }
        if (starred) {
            ab.set(true);
        }
        return true;
    }

    private Object parseTuples(Element elt, TypePrimitive primitive, Domains.DomBasic[] doms, AtomicBoolean ab) {
        String s = elt.getTextContent().trim();
        if (s.length() == 0) {
            return null;
        }
        if (s.charAt(0) != '(') {
            if (primitive == null) {
                return Stream.of(s.split("\\s+")).filter(tok -> doms == null || ((Domains.DomSymbolic)doms[0]).contains((String)tok)).toArray(String[]::new);
            }
            return primitive.parseSeq(s, doms == null ? null : (Domains.Dom)doms[0]);
        }
        if (primitive == null) {
            return Stream.of(s.split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(tok -> tok.split("\\s*,\\s*")).filter(t -> this.parseSymbolicTuple((String[])t, doms, ab)).toArray(n -> new String[n][]);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int leftParenthesis = 0;
        int rightParenthesis = leftParenthesis + 1;
        while (s.charAt(rightParenthesis) != ')') {
            ++rightParenthesis;
        }
        String tok2 = s.substring(leftParenthesis + 1, rightParenthesis).trim();
        long[] tmp = new long[tok2.split("\\s*,\\s*").length];
        while (tok2 != null) {
            if (primitive.parseTuple(tok2, tmp, doms, ab)) {
                int i;
                Object[] t2;
                if (primitive == TypePrimitive.BYTE) {
                    t2 = new byte[tmp.length];
                    i = 0;
                    while (i < t2.length) {
                        t2[i] = (byte)tmp[i];
                        ++i;
                    }
                    list.add(t2);
                } else if (primitive == TypePrimitive.SHORT) {
                    t2 = new short[tmp.length];
                    i = 0;
                    while (i < t2.length) {
                        t2[i] = (short)tmp[i];
                        ++i;
                    }
                    list.add(t2);
                } else if (primitive == TypePrimitive.INT) {
                    t2 = new int[tmp.length];
                    i = 0;
                    while (i < t2.length) {
                        t2[i] = (int)tmp[i];
                        ++i;
                    }
                    list.add(t2);
                } else {
                    list.add(tmp.clone());
                }
            }
            leftParenthesis = rightParenthesis + 1;
            while (leftParenthesis < s.length() && s.charAt(leftParenthesis) != '(') {
                ++leftParenthesis;
            }
            if (leftParenthesis == s.length()) {
                tok2 = null;
                continue;
            }
            rightParenthesis = leftParenthesis + 1;
            while (s.charAt(rightParenthesis) != ')') {
                ++rightParenthesis;
            }
            tok2 = s.substring(leftParenthesis + 1, rightParenthesis).trim();
        }
        return list.size() == 0 ? new long[][]{} : (long[][])list.toArray((Object[])Array.newInstance(list.get(0).getClass(), list.size()));
    }

    private Domains.DomBasic[] domainsFor(XVariables.XVar[] vars) {
        return (Domains.DomBasic[])Stream.of(vars).map(x -> (Domains.DomBasic)x.dom).toArray(Domains.DomBasic[]::new);
    }

    private Domains.DomBasic[] domainsFor(XVariables.XVar[][] varss) {
        Domains.DomBasic[] doms = this.domainsFor(varss[0]);
        XVariables.XVar[][] xVarArray = varss;
        int n = varss.length;
        int n2 = 0;
        while (n2 < n) {
            XVariables.XVar[] vars = xVarArray[n2];
            if (IntStream.range(0, vars.length).anyMatch(i -> doms[i] != xVarArray[i].dom)) {
                return null;
            }
            ++n2;
        }
        return doms;
    }

    private void parseExtension(Element elt, Element[] sons, Object[][] args) {
        boolean smart = elt.getAttribute(Types.TypeAtt.type.name()).equals("smart");
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
        Types.TypeChild typeTuples = Types.TypeChild.valueOf(sons[1].getTagName());
        if (!smart) {
            TypePrimitive primitive;
            XVariables.XVar[] vars;
            XVariables.XVar[] xVarArray = vars = this.leafs.get((int)0).value instanceof XVariables.XVar[] ? (XVariables.XVar[])this.leafs.get((int)0).value : null;
            TypePrimitive typePrimitive = args != null ? TypePrimitive.whichPrimitiveFor((XVariables.XVar[][])args) : (primitive = vars != null ? TypePrimitive.whichPrimitiveFor(vars) : null);
            Domains.DomBasic[] doms = args != null ? this.domainsFor((XVariables.XVar[][])args) : (vars != null ? this.domainsFor(vars) : null);
            AtomicBoolean ab = new AtomicBoolean();
            XConstraints.CChild tuples = this.addLeaf(typeTuples, this.parseTuples(sons[1], primitive, doms, ab));
            if (doms == null || tuples.value instanceof Values.IntegerEntity[]) {
                tuples.flags.add(Types.TypeFlag.UNCLEAN_TUPLES);
            }
            if (ab.get()) {
                tuples.flags.add(Types.TypeFlag.STARRED_TUPLES);
            }
        } else {
            System.out.println("smart");
            XConstraints.CChild tuples = this.addLeaf(typeTuples, this.parseSmartTuples(sons[1]));
            tuples.flags.add(Types.TypeFlag.SMART_TUPLES);
        }
    }

    private XNode<XVariables.XVar> parseExpression(String s) {
        int leftParenthesisPosition = s.indexOf(40);
        if (leftParenthesisPosition == -1) {
            XVariables.XVar var = this.mapForVars.get(s);
            if (var != null) {
                return new XNodeLeaf<XVariables.XVar>(Types.TypeExpr.VAR, var);
            }
            if (s.charAt(0) == '%') {
                long l = Utilities.safeLong(s.substring(1));
                Utilities.control(Utilities.isSafeInt(l), "Bad value (index) for the parameter");
                return new XNodeLeaf<XVariables.XVar>(Types.TypeExpr.PAR, l);
            }
            String[] t = s.split("\\.");
            if (t.length == 2) {
                return new XNodeLeaf<XVariables.XVar>(Types.TypeExpr.DECIMAL, new Values.Decimal(Utilities.safeLong(t[0]), Utilities.safeLong(t[1])));
            }
            if (Character.isDigit(s.charAt(0)) || s.charAt(0) == '+' || s.charAt(0) == '-') {
                return new XNodeLeaf<XVariables.XVar>(Types.TypeExpr.LONG, Utilities.safeLong(s));
            }
            return new XNodeLeaf<XVariables.XVar>(Types.TypeExpr.SYMBOL, s);
        }
        int rightParenthesisPosition = s.lastIndexOf(")");
        Types.TypeExpr operator = Types.TypeExpr.valueOf(s.substring(0, leftParenthesisPosition).toUpperCase());
        if (leftParenthesisPosition == rightParenthesisPosition - 1) {
            Utilities.control(operator == Types.TypeExpr.SET, " Erreur");
            return new XNodeLeaf<XVariables.XVar>(Types.TypeExpr.SET, null);
        }
        String content = s.substring(leftParenthesisPosition + 1, rightParenthesisPosition);
        ArrayList nodes = new ArrayList();
        int right = 0;
        while (right < content.length()) {
            int left = right;
            int nbOpens = 0;
            while (right < content.length()) {
                if (content.charAt(right) == '(') {
                    ++nbOpens;
                } else if (content.charAt(right) == ')') {
                    --nbOpens;
                } else if (content.charAt(right) == ',' && nbOpens == 0) break;
                ++right;
            }
            nodes.add(this.parseExpression(content.substring(left, right).trim()));
            ++right;
        }
        return new XNodeParent<XVariables.XVar>(operator, nodes);
    }

    private void parseIntension(Element elt, Element[] sons) {
        this.addLeaf(Types.TypeChild.function, this.parseExpression((sons.length == 0 ? elt : sons[0]).getTextContent().trim()));
    }

    private void parseSmart(Element elt, Element[] sons) {
        Element[] elementArray = sons;
        int n = sons.length;
        int n2 = 0;
        while (n2 < n) {
            Element son = elementArray[n2];
            this.addLeaf(Types.TypeChild.list, this.parseSequence(son));
            ++n2;
        }
    }

    private void parseRegular(Element elt, Element[] sons) {
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
        Object[][] trans = (Object[][])Stream.of(sons[1].getTextContent().trim().split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(t -> {
            String[] tr = t.split("\\s*,\\s*");
            Long value = Character.isDigit(tr[1].charAt(0)) || tr[1].charAt(0) == '+' || tr[1].charAt(0) == '-' ? Utilities.safeLong(tr[1]) : tr[1];
            return new Object[]{tr[0], value, tr[2]};
        }).toArray(n -> new Object[n][]);
        this.addLeaf(Types.TypeChild.transitions, trans);
        this.addLeaf(Types.TypeChild.start, sons[2].getTextContent().trim());
        this.addLeaf(Types.TypeChild.FINAL, sons[3].getTextContent().trim().split("\\s+"));
    }

    private void parseGrammar(Element elt, Element[] sons) {
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
        this.addLeaf(Types.TypeChild.terminal, sons[1].getTextContent().trim().split("\\s+"));
        String[][][] rrules = (String[][][])Stream.of(sons[2].getTextContent().trim().split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(t -> {
            String[] stringArray;
            String[] sp = t.split("\\s*,\\s*");
            String[] leftWord = sp[0].split("\\s+");
            if (sp.length == 1) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            } else {
                stringArray = sp[1].split("\\s+");
            }
            String[] rightWord = stringArray;
            return new String[][]{leftWord, rightWord};
        }).toArray(n -> new String[n][][]);
        this.addLeaf(Types.TypeChild.rules, rrules);
        this.addLeaf(Types.TypeChild.start, sons[3].getTextContent().trim());
    }

    private void parseMDD(Element elt, Element[] sons, int lastSon) {
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
        Object[][] trans = (Object[][])Stream.of(sons[1].getTextContent().trim().split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(t -> {
            String[] tr = t.split("\\s*,\\s*");
            Long value = Character.isDigit(tr[1].charAt(0)) || tr[1].charAt(0) == '+' || tr[1].charAt(0) == '-' ? Utilities.safeLong(tr[1]) : tr[1];
            return new Object[]{tr[0], value, tr[2]};
        }).toArray(n -> new Object[n][]);
        this.addLeaf(Types.TypeChild.transitions, trans);
    }

    private void parseAllDifferent(Element elt, Element[] sons, int lastSon) {
        if (sons.length == 0) {
            this.addLeaf(Types.TypeChild.list, this.parseSequence(elt));
        } else {
            Types.TypeChild type = Types.TypeChild.valueOf(sons[0].getTagName());
            if (type == Types.TypeChild.matrix) {
                this.addLeaf(type, this.parseDoubleSequenceOfVars(sons[0]));
            } else {
                Element exceptSon = Utilities.isTag(sons[lastSon], Types.TypeChild.except) ? sons[lastSon] : null;
                int i = 0;
                int limit = lastSon - (exceptSon != null ? 1 : 0);
                while (i <= limit) {
                    this.addLeaf(type, this.parseSequence(sons[i]));
                    ++i;
                }
                if (exceptSon != null) {
                    if (lastSon == 1) {
                        this.addLeaf(Types.TypeChild.except, this.leafs.get(0).setVariableInvolved() ? this.parseDoubleSequence(exceptSon, "\\s*\\}\\s*\\{\\s*|\\s*\\{\\s*|\\s*\\}\\s*") : this.parseSequence(exceptSon));
                    } else {
                        this.addLeaf(Types.TypeChild.except, this.parseDoubleSequence(exceptSon, type == Types.TypeChild.list ? "\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*" : (type == Types.TypeChild.set ? "\\s*\\}\\s*\\{\\s*|\\s*\\{\\s*|\\s*\\}\\s*" : "\\s*\\}\\}\\s*\\{\\{\\s*|\\s*\\{\\{\\s*|\\s*\\}\\}\\s*")));
                    }
                }
            }
        }
    }

    private void parseAllEqual(Element elt, Element[] sons, int lastSon) {
        if (sons.length == 0) {
            this.addLeaf(Types.TypeChild.list, this.parseSequence(elt));
        } else {
            Types.TypeChild type = Types.TypeChild.valueOf(sons[0].getTagName());
            int i = 0;
            while (i <= lastSon) {
                this.addLeaf(type, this.parseSequence(sons[i]));
                ++i;
            }
        }
    }

    private void parseAllDistant(Element elt, Element[] sons, int lastSon) {
        Types.TypeChild type = Types.TypeChild.valueOf(sons[0].getTagName());
        int i = 0;
        while (i < lastSon) {
            this.addLeaf(type, this.parseSequence(sons[i]));
            ++i;
        }
        this.addLeaf(Types.TypeChild.condition, this.parseCondition(sons[lastSon]));
    }

    private void parseOrdered(Element elt, Element[] sons, int lastSon) {
        Types.TypeChild type = Types.TypeChild.valueOf(sons[0].getTagName());
        if (type == Types.TypeChild.matrix) {
            this.addLeaf(type, this.parseDoubleSequenceOfVars(sons[0]));
        } else {
            int i = 0;
            while (i < lastSon) {
                this.addLeaf(Types.TypeChild.valueOf(sons[i].getTagName()), this.parseSequence(sons[i]));
                ++i;
            }
        }
        this.addLeaf(Types.TypeChild.operator, (Object)Types.TypeOperator.valOf(sons[lastSon].getTextContent()));
    }

    private void parseLex(Element elt, Element[] sons, int lastSon) {
        this.parseOrdered(elt, sons, lastSon);
    }

    private void parseAllIncomparable(Element elt, Element[] sons, int lastSon) {
        Types.TypeChild type = Types.TypeChild.valueOf(sons[0].getTagName());
        int i = 0;
        while (i <= lastSon) {
            this.addLeaf(type, this.parseSequence(sons[i]));
            ++i;
        }
    }

    private void parseSum(Element elt, Element[] sons, int lastSon) {
        if (Utilities.isTag(sons[0], Types.TypeChild.list)) {
            this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
        } else {
            this.addLeaf(Types.TypeChild.index, this.parseData(sons[0]));
        }
        if (Utilities.isTag(sons[1], Types.TypeChild.coeffs)) {
            this.addLeaf(Types.TypeChild.coeffs, this.parseSequence(sons[1]));
        }
        this.addLeaf(Types.TypeChild.condition, this.parseCondition(sons[lastSon]));
    }

    private void parseCount(Element elt, Element[] sons, int lastSon) {
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
        this.addLeaf(Types.TypeChild.values, this.parseSequence(sons[1]));
        this.addLeaf(Types.TypeChild.condition, this.parseCondition(sons[lastSon]));
    }

    private void parseNValues(Element elt, Element[] sons, int lastSon) {
        Types.TypeChild type = Types.TypeChild.valueOf(sons[0].getTagName());
        Element exceptSon = Utilities.isTag(sons[lastSon - 1], Types.TypeChild.except) ? sons[lastSon - 1] : null;
        int i = 0;
        int limit = lastSon - (exceptSon != null ? 2 : 1);
        while (i <= limit) {
            this.addLeaf(type, this.parseSequence(sons[i]));
            ++i;
        }
        if (exceptSon != null) {
            this.addLeaf(Types.TypeChild.except, lastSon == 2 ? this.parseSequence(exceptSon) : this.parseDoubleSequence(exceptSon, type == Types.TypeChild.list ? "\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*" : (type == Types.TypeChild.set ? "\\s*\\}\\s*\\{\\s*|\\s*\\{\\s*|\\s*\\}\\s*" : "\\s*\\}\\}\\s*\\{\\{\\s*|\\s*\\{\\{\\s*|\\s*\\}\\}\\s*")));
        }
        this.addLeaf(Types.TypeChild.condition, this.parseCondition(sons[lastSon]));
    }

    private void parseCardinality(Element elt, Element[] sons, int lastSon) {
        if (Utilities.isTag(sons[0], Types.TypeChild.matrix)) {
            this.addLeaf(Types.TypeChild.matrix, this.parseDoubleSequenceOfVars(sons[0]));
            this.addLeaf(Types.TypeChild.values, this.parseSequence(sons[1]));
            this.addLeaf(Types.TypeChild.rowOccurs, this.parseDoubleSequenceOfVars(sons[2]));
            this.addLeaf(Types.TypeChild.colOccurs, this.parseDoubleSequenceOfVars(sons[3]));
        } else {
            this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
            this.addLeaf(Types.TypeChild.values, this.parseSequence(sons[1]));
            this.addLeaf(Types.TypeChild.occurs, this.parseSequence(sons[2]));
        }
    }

    private void parseBalance(Element elt, Element[] sons, int lastSon) {
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
        if (Utilities.isTag(sons[1], Types.TypeChild.values)) {
            this.addLeaf(Types.TypeChild.values, this.parseSequence(sons[1]));
        }
        this.addLeaf(Types.TypeChild.condition, this.parseCondition(sons[lastSon]));
    }

    private void parseSpread(Element elt, Element[] sons, int lastSon) {
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
        if (Utilities.isTag(sons[1], Types.TypeChild.total)) {
            this.addLeaf(Types.TypeChild.total, this.parseData(sons[1]));
        }
        this.addLeaf(Types.TypeChild.condition, this.parseCondition(sons[lastSon]));
    }

    private void parseDeviation(Element elt, Element[] sons, int lastSon) {
        this.parseSpread(elt, sons, lastSon);
    }

    private void parseMaximum(Element elt, Element[] sons, int lastSon) {
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
        if (Utilities.isTag(sons[1], Types.TypeChild.index)) {
            this.addLeaf(Types.TypeChild.index, this.parseData(sons[1]));
        }
        if (Utilities.isTag(sons[lastSon], Types.TypeChild.condition)) {
            this.addLeaf(Types.TypeChild.condition, this.parseCondition(sons[lastSon]));
        }
    }

    private void parseMinimum(Element elt, Element[] sons, int lastSon) {
        this.parseMaximum(elt, sons, lastSon);
    }

    private void parseElement(Element elt, Element[] sons, int lastSon) {
        if (Utilities.isTag(sons[0], Types.TypeChild.matrix)) {
            this.addLeaf(Types.TypeChild.matrix, this.parseDoubleSequenceOfVars(sons[0]));
            if (Utilities.isTag(sons[1], Types.TypeChild.index)) {
                this.addLeaf(Types.TypeChild.index, this.parseSequence(sons[1]));
            }
        } else {
            this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
            if (Utilities.isTag(sons[1], Types.TypeChild.index)) {
                this.addLeaf(Types.TypeChild.index, this.parseData(sons[1]));
            }
        }
        this.addLeaf(Types.TypeChild.value, this.parseData(sons[lastSon]));
    }

    private void parseChannel(Element elt, Element[] sons, int lastSon) {
        if (sons.length == 0) {
            this.addLeaf(Types.TypeChild.list, this.parseSequence(elt));
        } else {
            this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
            if (lastSon == 1) {
                if (Utilities.isTag(sons[1], Types.TypeChild.list)) {
                    this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[1]));
                } else {
                    this.addLeaf(Types.TypeChild.value, this.parseData(sons[1]));
                }
            }
        }
    }

    private void parsePermutation(Element elt, Element[] sons, int lastSon) {
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[1]));
        if (lastSon == 2) {
            this.addLeaf(Types.TypeChild.mapping, this.parseSequence(sons[2]));
        }
    }

    private void parsePrecedence(Element elt, Element[] sons, int lastSon) {
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
        this.addLeaf(Types.TypeChild.values, this.parseSequence(sons[1]));
        if (lastSon == 2) {
            this.addLeaf(Types.TypeChild.operator, (Object)Types.TypeOperator.valOf(sons[lastSon].getTextContent()));
        }
    }

    private void parseStretch(Element elt, Element[] sons, int lastSon) {
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
        this.addLeaf(Types.TypeChild.values, this.parseSequence(sons[1]));
        this.addLeaf(Types.TypeChild.widths, this.parseSequence(sons[2]));
        if (lastSon == 3) {
            this.addLeaf(Types.TypeChild.patterns, this.parseDoubleSequence(sons[3], "\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*"));
        }
    }

    private void parseNoOverlap(Element elt, Element[] sons) {
        boolean multiDimensional = sons[1].getTextContent().trim().charAt(0) == '(';
        this.addLeaf(Types.TypeChild.origins, multiDimensional ? this.parseDoubleSequenceOfVars(sons[0]) : this.parseSequence(sons[0]));
        this.addLeaf(Types.TypeChild.lengths, multiDimensional ? this.parseDoubleSequence(sons[1], "\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*") : this.parseSequence(sons[1]));
    }

    private void parseCumulative(Element elt, Element[] sons) {
        int cnt = 0;
        this.addLeaf(Types.TypeChild.origins, this.parseSequence(sons[cnt++]));
        this.addLeaf(Types.TypeChild.lengths, this.parseSequence(sons[cnt++]));
        if (Utilities.isTag(sons[cnt], Types.TypeChild.ends)) {
            this.addLeaf(Types.TypeChild.ends, this.parseSequence(sons[cnt++]));
        }
        this.addLeaf(Types.TypeChild.heights, this.parseSequence(sons[cnt++]));
        if (Utilities.isTag(sons[cnt], Types.TypeChild.machines)) {
            this.addLeaf(Types.TypeChild.machines, this.parseSequence(sons[cnt++]));
            this.addLeaf(Types.TypeChild.conditions, this.parseConditions(sons[cnt++]));
        } else {
            this.addLeaf(Types.TypeChild.condition, this.parseCondition(sons[cnt++]));
        }
    }

    private void parseBinPacking(Element elt, Element[] sons) {
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
        this.addLeaf(Types.TypeChild.sizes, this.parseSequence(sons[1]));
        if (Utilities.isTag(sons[2], Types.TypeChild.condition)) {
            this.addLeaf(Types.TypeChild.condition, this.parseCondition(sons[2]));
        } else {
            this.addLeaf(Types.TypeChild.conditions, this.parseConditions(sons[2]));
        }
    }

    private void parseKnapsack(Element elt, Element[] sons) {
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
        this.addLeaf(Types.TypeChild.weights, this.parseSequence(sons[1]));
        this.addLeaf(Types.TypeChild.profits, this.parseSequence(sons[2]));
        this.addLeaf(Types.TypeChild.limit, this.parseData(sons[3]));
        this.addLeaf(Types.TypeChild.condition, this.parseCondition(sons[4]));
    }

    private XConstraints.CChild listOrGraph(Element elt) {
        return Utilities.isTag(elt, Types.TypeChild.list) ? new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(elt)) : new XConstraints.CChild(Types.TypeChild.graph, this.parseData(elt));
    }

    private void parseCircuit(Element elt, Element[] sons, int lastSon) {
        if (sons.length == 0) {
            this.addLeaf(Types.TypeChild.list, this.parseSequence(elt));
        } else {
            this.leafs.add(this.listOrGraph(sons[0]));
            if (lastSon == 1) {
                this.addLeaf(Types.TypeChild.size, this.parseData(sons[1]));
            }
        }
    }

    private void parseNCircuits(Element elt, Element[] sons, int lastSon) {
        this.leafs.add(this.listOrGraph(sons[0]));
        this.addLeaf(Types.TypeChild.condition, this.parseCondition(sons[1]));
    }

    private void parsePath(Element elt, Element[] sons, int lastSon) {
        this.leafs.add(this.listOrGraph(sons[0]));
        this.addLeaf(Types.TypeChild.start, this.parseData(sons[1]));
        this.addLeaf(Types.TypeChild.FINAL, this.parseData(sons[2]));
        if (lastSon == 3) {
            this.addLeaf(Types.TypeChild.size, this.parseData(sons[3]));
        }
    }

    private void parseNPaths(Element elt, Element[] sons, int lastSon) {
        this.parseNCircuits(elt, sons, lastSon);
    }

    private void parseTree(Element elt, Element[] sons, int lastSon) {
        this.leafs.add(this.listOrGraph(sons[0]));
        this.addLeaf(Types.TypeChild.root, this.parseData(sons[1]));
        if (lastSon == 2) {
            this.addLeaf(Types.TypeChild.size, this.parseData(sons[2]));
        }
    }

    private void parseArbo(Element elt, Element[] sons, int lastSon) {
        this.parseTree(elt, sons, lastSon);
    }

    private void parseNTrees(Element elt, Element[] sons, int lastSon) {
        this.parseNCircuits(elt, sons, lastSon);
    }

    private void parseNArbos(Element elt, Element[] sons, int lastSon) {
        this.parseNCircuits(elt, sons, lastSon);
    }

    private void parseNCliques(Element elt, Element[] sons, int lastSon) {
        this.parseNCircuits(elt, sons, lastSon);
    }

    private void parseClause(Element elt, Element[] sons, int lastSon) {
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons.length == 0 ? elt : sons[0]));
    }

    private void parseInstantiation(Element elt, Element[] sons, int lastSon) {
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
        this.addLeaf(Types.TypeChild.values, this.parseSequence(sons[1]));
    }

    private void parseAllIntersecting(Element elt, Element[] sons) {
        if (sons.length == 0) {
            this.addLeaf(Types.TypeChild.list, this.parseSequence(elt));
        } else {
            this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
            this.addLeaf(Types.TypeChild.condition, this.parseCondition(sons[1]));
        }
    }

    private void parseRange(Element elt, Element[] sons) {
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
        this.addLeaf(Types.TypeChild.index, this.parseData(sons[1]));
        this.addLeaf(Types.TypeChild.image, this.parseData(sons[2]));
    }

    private void parseRoots(Element elt, Element[] sons) {
        this.parseRange(elt, sons);
    }

    private void parsePartition(Element elt, Element[] sons) {
        this.addLeaf(Types.TypeChild.list, this.parseSequence(sons[0]));
        this.addLeaf(Types.TypeChild.value, this.parseData(sons[1]));
    }

    private XConstraints.CChild addLeaf(Types.TypeChild tc, Object value) {
        XConstraints.CChild child = new XConstraints.CChild(tc, value);
        this.leafs.add(child);
        return child;
    }

    private int getIntValueOf(Element element, String attName, int defaultValue) {
        return element.getAttribute(attName).length() > 0 ? Integer.parseInt(element.getAttribute(attName)) : defaultValue;
    }

    private ParsingEntry.CEntry parseCEntry(Element elt, Object[][] args, Element[] sons, int lastSon) {
        if (elt.getTagName().equals("group")) {
            List l = IntStream.range(1, lastSon + 1).mapToObj(i -> this.parseSequence(sons[i])).collect(Collectors.toList());
            Object[][] groupArgs = l.stream().noneMatch(o -> !(o instanceof XVariables.XVar[])) ? (Object[][])l.toArray((T[])new XVariables.XVar[0][]) : (l.stream().noneMatch(o -> !(o instanceof XNode[])) ? (Object[][])l.toArray((T[])new XNode[0][]) : (Object[][])l.toArray((T[])new Object[0][]));
            return new XConstraints.XGroup((XConstraints.CEntryReifiable)this.parseCEntryOuter(sons[0], groupArgs), groupArgs);
        }
        Types.TypeCtr type = Types.TypeCtr.valueOf(elt.getTagName());
        if (type == Types.TypeCtr.slide) {
            XConstraints.CChild[] lists = (XConstraints.CChild[])IntStream.range(0, lastSon).mapToObj(i -> new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[i]))).toArray(XConstraints.CChild[]::new);
            int[] offset = Stream.of(sons).limit(lists.length).mapToInt(s -> this.getIntValueOf((Element)s, Types.TypeAtt.offset.name(), 1)).toArray();
            int[] collect = Stream.of(sons).limit(lists.length).mapToInt(s -> this.getIntValueOf((Element)s, Types.TypeAtt.collect.name(), 1)).toArray();
            if (lists.length == 1) {
                XConstraints.XCtr ctr = (XConstraints.XCtr)this.parseCEntryOuter(sons[lastSon], null);
                Utilities.control(ctr.abstraction.abstractChilds.length == 1, "Other cases must be implemented");
                if (ctr.getType() == Types.TypeCtr.intension) {
                    collect[0] = ((XNode)ctr.childs[0].value).maxParameterNumber() + 1;
                } else {
                    XConstraints.XParameter[] pars = (XConstraints.XParameter[])ctr.abstraction.abstractChilds[0].value;
                    Utilities.control(Stream.of(pars).noneMatch(p -> p.number == -1), "One parameter is %..., which is forbidden in slide");
                    collect[0] = Stream.of(pars).mapToInt(p -> p.number + 1).max().orElseThrow(() -> new RuntimeException());
                }
            }
            Object[][] scopes = XConstraints.XSlide.buildScopes((XVariables.XVar[][])Stream.of(lists).map(ls -> (XVariables.XVar[])ls.value).toArray(n -> new XVariables.XVar[n][]), offset, collect, elt.getAttribute(Types.TypeAtt.circular.name()).equals(Boolean.TRUE.toString()));
            return new XConstraints.XSlide(lists, offset, collect, (XConstraints.XCtr)this.parseCEntryOuter(sons[lastSon], scopes), (XVariables.XVar[][])scopes);
        }
        if (type == Types.TypeCtr.seqbin) {
            XConstraints.CChild list = new XConstraints.CChild(Types.TypeChild.list, this.parseSequence(sons[0]));
            XVariables.XVar[] t = (XVariables.XVar[])list.value;
            Object[][] scopes = (XVariables.XVar[][])IntStream.range(0, t.length - 1).mapToObj(i -> new XVariables.XVar[]{t[i], t[i + 1]}).toArray(n -> new XVariables.XVar[n][]);
            XConstraints.CChild number = new XConstraints.CChild(Types.TypeChild.number, this.parseData(sons[3]));
            return new XConstraints.XSeqbin(list, (XConstraints.XCtr)this.parseCEntryOuter(sons[1], scopes), (XConstraints.XCtr)this.parseCEntryOuter(sons[2], scopes), number, (XVariables.XVar[][])scopes);
        }
        if (type.isLogical() || type.isControl()) {
            return new XConstraints.XLogic(type, (XConstraints.CEntryReifiable[])IntStream.range(0, lastSon + 1).mapToObj(i -> this.parseCEntryOuter(sons[i], args)).toArray(XConstraints.CEntryReifiable[]::new));
        }
        this.leafs = new ArrayList<XConstraints.CChild>();
        if (type == Types.TypeCtr.extension) {
            this.parseExtension(elt, sons, args);
        } else if (type == Types.TypeCtr.intension) {
            this.parseIntension(elt, sons);
        } else if (type == Types.TypeCtr.regular) {
            this.parseRegular(elt, sons);
        } else if (type == Types.TypeCtr.grammar) {
            this.parseGrammar(elt, sons);
        } else if (type == Types.TypeCtr.mdd) {
            this.parseMDD(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.allDifferent) {
            this.parseAllDifferent(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.allEqual) {
            this.parseAllEqual(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.allDistant) {
            this.parseAllDistant(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.ordered) {
            this.parseOrdered(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.lex) {
            this.parseLex(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.allIncomparable) {
            this.parseAllIncomparable(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.sum) {
            this.parseSum(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.count) {
            this.parseCount(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.nValues) {
            this.parseNValues(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.cardinality) {
            this.parseCardinality(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.balance) {
            this.parseBalance(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.spread) {
            this.parseSpread(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.deviation) {
            this.parseDeviation(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.maximum) {
            this.parseMaximum(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.minimum) {
            this.parseMinimum(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.element) {
            this.parseElement(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.channel) {
            this.parseChannel(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.permutation) {
            this.parsePermutation(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.precedence) {
            this.parsePrecedence(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.stretch) {
            this.parseStretch(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.noOverlap) {
            this.parseNoOverlap(elt, sons);
        } else if (type == Types.TypeCtr.cumulative) {
            this.parseCumulative(elt, sons);
        } else if (type == Types.TypeCtr.binPacking) {
            this.parseBinPacking(elt, sons);
        } else if (type == Types.TypeCtr.knapsack) {
            this.parseKnapsack(elt, sons);
        } else if (type == Types.TypeCtr.circuit) {
            this.parseCircuit(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.nCircuits) {
            this.parseNCircuits(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.path) {
            this.parsePath(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.nPaths) {
            this.parseNPaths(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.tree) {
            this.parseTree(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.nTrees) {
            this.parseNTrees(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.arbo) {
            this.parseArbo(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.nArbos) {
            this.parseNArbos(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.nCliques) {
            this.parseNCliques(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.clause) {
            this.parseClause(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.instantiation) {
            this.parseInstantiation(elt, sons, lastSon);
        } else if (type == Types.TypeCtr.allIntersecting) {
            this.parseAllIntersecting(elt, sons);
        } else if (type == Types.TypeCtr.range) {
            this.parseRange(elt, sons);
        } else if (type == Types.TypeCtr.roots) {
            this.parseRoots(elt, sons);
        } else if (type == Types.TypeCtr.partition) {
            this.parsePartition(elt, sons);
        } else if (type == Types.TypeCtr.smart) {
            this.parseSmart(elt, sons);
        }
        return new XConstraints.XCtr(type, this.leafs.toArray(new XConstraints.CChild[this.leafs.size()]));
    }

    private Softening buildSoftening(Element elt, Map<Types.TypeAtt, String> attributes, Condition cost) {
        if (attributes.containsKey((Object)Types.TypeAtt.violationCost)) {
            int violationCost = Utilities.safeInt(Utilities.safeLong(attributes.get((Object)Types.TypeAtt.violationCost)));
            return cost == null ? new Softening.SofteningSimple(violationCost) : new Softening.SofteningSimple(cost, violationCost);
        }
        Types.TypeCtr type = Types.TypeCtr.valueOf(elt.getTagName());
        if (type == Types.TypeCtr.intension) {
            return cost == null ? new Softening.SofteningIntension() : new Softening.SofteningIntension(cost);
        }
        if (type == Types.TypeCtr.extension) {
            int defaultCost = attributes.containsKey((Object)Types.TypeAtt.defaultCost) ? Utilities.safeInt(Utilities.safeLong(attributes.get((Object)Types.TypeAtt.defaultCost))) : -1;
            return cost == null ? new Softening.SofteningExtension(defaultCost) : new Softening.SofteningExtension(cost, defaultCost);
        }
        Types.TypeMeasure typeMeasure = attributes.containsKey((Object)Types.TypeAtt.violationMeasure) ? Types.valueOf(Types.TypeMeasure.class, attributes.get((Object)Types.TypeAtt.violationMeasure)) : null;
        String parameters = attributes.get((Object)Types.TypeAtt.violationParameters);
        return cost == null ? new Softening.SofteningGlobal(typeMeasure, parameters) : new Softening.SofteningGlobal(cost, typeMeasure, parameters);
    }

    private ParsingEntry.CEntry parseCEntryOuter(Element elt, Object[][] args) {
        int i;
        Element[] sons = Utilities.childElementsOf(elt);
        boolean soft = elt.getAttribute(Types.TypeAtt.type.name()).equals("soft");
        int lastSon = sons.length - 1 - (sons.length > 1 && Utilities.isTag(sons[sons.length - 1], Types.TypeChild.cost) ? 1 : 0);
        ParsingEntry.CEntry entry = this.parseCEntry(elt, args, sons, lastSon);
        entry.copyAttributesOf(elt);
        if (entry instanceof XConstraints.XCtr) {
            i = 0;
            while (i <= lastSon) {
                ((XConstraints.XCtr)entry).childs[i].copyAttributesOf(sons[i]);
                ++i;
            }
        } else if (entry instanceof XConstraints.XSlide) {
            i = 0;
            while (i < lastSon) {
                ((XConstraints.XSlide)entry).lists[i].copyAttributesOf(sons[i]);
                ++i;
            }
        }
        if (entry instanceof XConstraints.CEntryReifiable) {
            XConstraints.CEntryReifiable entryReifiable = (XConstraints.CEntryReifiable)entry;
            Map attributes = entryReifiable.attributes;
            if (soft) {
                Condition cost = lastSon == sons.length - 1 ? null : this.parseCondition(sons[sons.length - 1]);
                entryReifiable.softening = this.buildSoftening(elt, attributes, cost);
            }
            if (attributes.containsKey((Object)Types.TypeAtt.reifiedBy)) {
                entryReifiable.reification = new XConstraints.XReification(Types.TypeReification.FULL, this.mapForVars.get(attributes.get((Object)Types.TypeAtt.reifiedBy)));
            } else if (attributes.containsKey((Object)Types.TypeAtt.hreifiedFrom)) {
                entryReifiable.reification = new XConstraints.XReification(Types.TypeReification.HALF_FROM, this.mapForVars.get(attributes.get((Object)Types.TypeAtt.hreifiedFrom)));
            } else if (attributes.containsKey((Object)Types.TypeAtt.hreifiedTo)) {
                entryReifiable.reification = new XConstraints.XReification(Types.TypeReification.HALF_TO, this.mapForVars.get(attributes.get((Object)Types.TypeAtt.hreifiedTo)));
            }
        }
        return entry;
    }

    private void recursiveParsingOfConstraints(Element elt, List<ParsingEntry.CEntry> list) {
        if (elt.getTagName().equals("block")) {
            ArrayList<ParsingEntry.CEntry> blockEntries = new ArrayList<ParsingEntry.CEntry>();
            Stream.of(Utilities.childElementsOf(elt)).forEach(child -> this.recursiveParsingOfConstraints((Element)child, (List<ParsingEntry.CEntry>)blockEntries));
            XConstraints.XBlock ctrBlock = new XConstraints.XBlock(blockEntries);
            ctrBlock.copyAttributesOf(elt);
            if (!Types.TypeClass.intersect(ctrBlock.classes, this.discardedClasses)) {
                list.add(ctrBlock);
            }
        } else {
            ParsingEntry.CEntry entry = this.parseCEntryOuter(elt, null);
            if (!Types.TypeClass.intersect(entry.classes, this.discardedClasses)) {
                list.add(entry);
            }
        }
    }

    private void parseConstraints() {
        Stream.of(Utilities.childElementsOf((Element)this.document.getElementsByTagName("constraints").item(0))).forEach(elt -> this.recursiveParsingOfConstraints((Element)elt, this.cEntries));
    }

    private void parseObjectives() {
        NodeList nl = this.document.getDocumentElement().getElementsByTagName("objectives");
        if (nl.getLength() == 1) {
            Element objectives = (Element)nl.item(0);
            this.typeCombination = this.giveAttributeValue(objectives, Types.TypeAtt.combination.name(), Types.TypeCombination.class, Types.TypeCombination.PARETO);
            Element[] elementArray = Utilities.childElementsOf(objectives);
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element elt = elementArray[n2];
                XObjectives.XObj entry = null;
                boolean minimize = elt.getTagName().equals("minimize");
                Types.TypeObjective type = this.giveAttributeValue(elt, Types.TypeAtt.type.name(), Types.TypeObjective.class, Types.TypeObjective.EXPRESSION);
                if (type == Types.TypeObjective.EXPRESSION) {
                    entry = new XObjectives.OObjectiveExpr(minimize, type, this.parseExpression(elt.getTextContent().trim()));
                } else {
                    Element[] sons = Utilities.childElementsOf(elt);
                    Object[] terms = this.parseSequence(sons.length == 0 ? elt : sons[0]);
                    Values.SimpleValue[] coeffs = sons.length != 2 ? null : Values.SimpleValue.parseSeq(sons[1].getTextContent().trim());
                    entry = new XObjectives.OObjectiveSpecial(minimize, type, terms, coeffs);
                }
                entry.copyAttributesOf(elt);
                if (!Types.TypeClass.intersect(entry.classes, this.discardedClasses)) {
                    this.oEntries.add(entry);
                }
                ++n2;
            }
        }
    }

    private void parseAnnotations() {
        NodeList nl = this.document.getDocumentElement().getElementsByTagName("annotations");
        if (nl.getLength() == 1) {
            Element annotations = (Element)nl.item(0);
            Element[] elementArray = Utilities.childElementsOf(annotations);
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element elt = elementArray[n2];
                if (elt.getTagName().equals("decision")) {
                    XVariables.XVar[] vars = (XVariables.XVar[])this.parseSequence(elt);
                    this.aEntries.put("decision", vars);
                }
                ++n2;
            }
        }
    }

    private void updateVarDegreesWith(List<ParsingEntry.CEntry> list) {
        for (ParsingEntry.CEntry entry : list) {
            if (entry instanceof XConstraints.XBlock) {
                this.updateVarDegreesWith(((XConstraints.XBlock)entry).subentries);
                continue;
            }
            if (entry instanceof XConstraints.XGroup) {
                XConstraints.XGroup group = (XConstraints.XGroup)entry;
                int i = 0;
                while (i < group.argss.length) {
                    XVariables.XVar[] xVarArray = group.getScope(i);
                    int n = xVarArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        XVariables.XVar var = xVarArray[n2];
                        ++var.degree;
                        ++n2;
                    }
                    ++i;
                }
                continue;
            }
            XVariables.XVar[] xVarArray = entry.vars();
            int n = xVarArray.length;
            int n3 = 0;
            while (n3 < n) {
                XVariables.XVar var = xVarArray[n3];
                ++var.degree;
                ++n3;
            }
        }
    }

    private void computeVarDegrees() {
        this.updateVarDegreesWith(this.cEntries);
        for (ParsingEntry.OEntry entry : this.oEntries) {
            if (entry instanceof XObjectives.OObjectiveExpr) {
                for (XVariables.XVar xVar : ((XObjectives.OObjectiveExpr)entry).rootNode.listOfVars()) {
                    ++xVar.degree;
                }
                continue;
            }
            XVariables.XVar[] xVarArray = ((XObjectives.OObjectiveSpecial)entry).vars();
            int n = xVarArray.length;
            int n2 = 0;
            while (n2 < n) {
                XVariables.XVar xVar = xVarArray[n2];
                ++xVar.degree;
                ++n2;
            }
        }
    }

    public XParser(Document document, Types.TypeClass[] discardedClasses) throws Exception {
        this.document = document;
        this.discardedClasses = discardedClasses;
        this.typeFramework = this.giveAttributeValue(document.getDocumentElement(), Types.TypeAtt.type.name(), Types.TypeFramework.class, Types.TypeFramework.CSP);
        this.parseVariables();
        this.parseConstraints();
        this.parseObjectives();
        this.parseAnnotations();
        this.computeVarDegrees();
    }

    public XParser(Document document, String ... discardedClasses) throws Exception {
        this(document, Types.TypeClass.classesFor(discardedClasses));
    }

    public XParser(InputStream inpuStream, Types.TypeClass[] discardedClasses) throws Exception {
        this(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inpuStream), discardedClasses);
    }

    public XParser(InputStream inputStream, String ... discardedClasses) throws Exception {
        this(inputStream, Types.TypeClass.classesFor(discardedClasses));
    }

    public static final class TypePrimitive
    extends Enum<TypePrimitive> {
        public static final /* enum */ TypePrimitive BYTE = new TypePrimitive();
        public static final /* enum */ TypePrimitive SHORT = new TypePrimitive();
        public static final /* enum */ TypePrimitive INT = new TypePrimitive();
        public static final /* enum */ TypePrimitive LONG = new TypePrimitive();
        private static final /* synthetic */ TypePrimitive[] ENUM$VALUES;

        static {
            ENUM$VALUES = new TypePrimitive[]{BYTE, SHORT, INT, LONG};
        }

        public static TypePrimitive whichPrimitiveFor(long inf, long sup) {
            if (-118L <= inf && sup <= 117L) {
                return BYTE;
            }
            if (-32758L <= inf && sup <= 32757L) {
                return SHORT;
            }
            if (-2147483638L <= inf && sup <= 0x7FFFFFF5L) {
                return INT;
            }
            return LONG;
        }

        public static TypePrimitive whichPrimitiveFor(long val) {
            return TypePrimitive.whichPrimitiveFor(val, val);
        }

        static TypePrimitive whichPrimitiveFor(XVariables.XVar[] vars) {
            if (Stream.of(vars).anyMatch(x -> x.type != Types.TypeVar.integer)) {
                return null;
            }
            return TypePrimitive.values()[Stream.of(vars).mapToInt(x -> ((XVariables.XVarInteger)x).whichPrimitive().ordinal()).max().orElse(LONG.ordinal())];
        }

        static TypePrimitive whichPrimitiveFor(XVariables.XVar[][] varss) {
            if (TypePrimitive.whichPrimitiveFor(varss[0]) == null) {
                return null;
            }
            return TypePrimitive.values()[Stream.of(varss).mapToInt(t -> TypePrimitive.whichPrimitiveFor(t).ordinal()).max().orElse(LONG.ordinal())];
        }

        private boolean canRepresent(long val) {
            return this.ordinal() >= TypePrimitive.whichPrimitiveFor(val).ordinal();
        }

        Object parseSeq(String s, Domains.Dom dom) {
            if (s.indexOf("..") != -1) {
                return Values.IntegerEntity.parseSeq(s);
            }
            int nbDiscarded = 0;
            ArrayList<Long> list = new ArrayList<Long>();
            String[] stringArray = s.split("\\s+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String tok = stringArray[n2];
                assert (!tok.equals("*")) : "STAR not handled in unary lists";
                long l = Utilities.safeLong(tok);
                if (this.canRepresent(l) && (dom == null || dom.contains(l))) {
                    list.add(l);
                } else {
                    ++nbDiscarded;
                }
                ++n2;
            }
            if (nbDiscarded > 0) {
                System.out.println(String.valueOf(nbDiscarded) + " discarded values in the unary list " + s);
            }
            if (this == LONG) {
                return list.stream().mapToLong(i -> i).toArray();
            }
            return list.stream().mapToInt(i -> i.intValue()).toArray();
        }

        boolean parseTuple(String s, long[] t, Domains.DomBasic[] doms, AtomicBoolean ab) {
            String[] toks = s.split("\\s*,\\s*");
            assert (toks.length == t.length) : String.valueOf(toks.length) + " " + t.length;
            boolean starred = false;
            int i = 0;
            while (i < toks.length) {
                if (toks[i].equals("*")) {
                    t[i] = this == BYTE ? 126L : (this == SHORT ? 32766L : (this == INT ? 0x7FFFFFFEL : 0x7FFFFFFFFFFFFFFEL));
                    starred = true;
                } else {
                    long l = Utilities.safeLong(toks[i]);
                    if (this.canRepresent(l) && (doms == null || ((Domains.Dom)doms[i]).contains(l))) {
                        t[i] = l;
                    } else {
                        return false;
                    }
                }
                ++i;
            }
            if (starred) {
                ab.set(true);
            }
            return true;
        }

        public static TypePrimitive[] values() {
            TypePrimitive[] typePrimitiveArray = ENUM$VALUES;
            int n = typePrimitiveArray.length;
            TypePrimitive[] typePrimitiveArray2 = new TypePrimitive[n];
            System.arraycopy(ENUM$VALUES, 0, typePrimitiveArray2, 0, n);
            return typePrimitiveArray2;
        }

        public static TypePrimitive valueOf(String string) {
            return Enum.valueOf(TypePrimitive.class, string);
        }
    }
}

