/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.modeler.definitions;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.definitions.ICtr;

public class DefXCSP {
    public String name;
    public List<AbstractMap.SimpleEntry<String, Object>> attributes = new ArrayList<AbstractMap.SimpleEntry<String, Object>>();
    public List<Son> sons = new ArrayList<Son>();
    public boolean possibleSimplification;
    public Map<String, Object> map;

    private String print(List<AbstractMap.SimpleEntry<String, Object>> list) {
        return list.size() == 0 ? "" : " (" + list.stream().map(a -> String.valueOf((String)a.getKey()) + "='" + a.getValue() + "'").collect(Collectors.joining(" ")) + ")";
    }

    private boolean same(List<AbstractMap.SimpleEntry<String, Object>> list1, List<AbstractMap.SimpleEntry<String, Object>> list2) {
        return list1.size() == list2.size() && IntStream.range(0, list1.size()).allMatch(i -> ((String)((AbstractMap.SimpleEntry)list1.get(i)).getKey()).equals(((AbstractMap.SimpleEntry)list2.get(i)).getKey()) && ((AbstractMap.SimpleEntry)list1.get(i)).getValue().equals(((AbstractMap.SimpleEntry)list2.get(i)).getValue()));
    }

    public DefXCSP(String name, boolean possibleSimplification, Map<String, Object> map) {
        this.name = name;
        this.possibleSimplification = possibleSimplification;
        this.map = map;
    }

    public DefXCSP(String name, Map<String, Object> map) {
        this(name, true, map);
    }

    public DefXCSP(String name) {
        this(name, true, null);
    }

    public DefXCSP addSon(String name, Object content) {
        Utilities.control(content != null, "Pb");
        this.sons.add(new Son(name, content));
        return this;
    }

    public DefXCSP addSon(String name, Object content, String attName, Object attValue) {
        Utilities.control(content != null && attValue != null, "Pb");
        this.sons.add(new Son(name, content, attName, attValue));
        return this;
    }

    public DefXCSP addSon(String name, Object content, String attName1, Object attValue1, String attName2, Object attValue2) {
        Utilities.control(content != null && attValue1 != null && attValue2 != null, "Pb");
        this.sons.add(new Son(name, content, attName1, attValue1, attName2, attValue2));
        return this;
    }

    public DefXCSP add(String ... params) {
        Stream.of(params).filter(param -> this.map.get(param) != null).forEach(param -> {
            boolean bl = this.sons.add(new Son((String)param, this.map.get(param)));
        });
        return this;
    }

    public DefXCSP addConditional(String param) {
        return this.map.containsKey(param) ? this.add(param) : this;
    }

    public DefXCSP addOne(String key) {
        String lifted;
        if (key.equals(ICtr.MATRIX)) {
            this.possibleSimplification = false;
            return this.add(key);
        }
        String string = key.equals("lists") ? ICtr.LIST : (key.equals("sets") ? ICtr.SET : (lifted = key.equals("msets") ? ICtr.MSET : null));
        if (lifted == null) {
            return this.add(key);
        }
        Stream.of((Object[])this.map.get(String.valueOf(lifted) + "s")).forEach(o -> {
            DefXCSP defXCSP = this.addSon(lifted, o);
        });
        return this;
    }

    public DefXCSP addListOrLifted() {
        String lifted;
        if (this.map.containsKey(ICtr.MATRIX)) {
            this.possibleSimplification = false;
            return this.add(ICtr.MATRIX);
        }
        String string = this.map.containsKey("lists") ? ICtr.LIST : (this.map.containsKey("sets") ? ICtr.SET : (lifted = this.map.containsKey("msets") ? ICtr.MSET : null));
        if (lifted == null) {
            return this.add(ICtr.LIST);
        }
        Stream.of((Object[])this.map.get(String.valueOf(lifted) + "s")).forEach(o -> {
            DefXCSP defXCSP = this.addSon(lifted, o);
        });
        return this;
    }

    public int[] differencesWith(DefXCSP def) {
        if (!this.name.equals(def.name) || this.attributes.size() != def.attributes.size() || this.sons.size() != def.sons.size() || this.possibleSimplification != def.possibleSimplification) {
            return null;
        }
        if (!this.same(this.attributes, def.attributes)) {
            return null;
        }
        if (IntStream.range(0, this.sons.size()).anyMatch(i -> !this.sons.get((int)i).name.equals(defXCSP.sons.get((int)i).name) || !this.same(this.sons.get((int)i).attributes, defXCSP.sons.get((int)i).attributes))) {
            return null;
        }
        return IntStream.range(0, this.sons.size()).filter(i -> !this.sons.get((int)i).content.toString().equals(defXCSP.sons.get((int)i).content.toString())).toArray();
    }

    public String toString() {
        return String.valueOf(this.name) + " : " + this.sons.stream().map(c -> c.toString()).collect(Collectors.joining(" ")) + this.print(this.attributes);
    }

    public class Son {
        public String name;
        public Object content;
        public List<AbstractMap.SimpleEntry<String, Object>> attributes = new ArrayList<AbstractMap.SimpleEntry<String, Object>>();

        public Son(String name, Object content) {
            this.name = name;
            this.content = content;
        }

        public Son(String name, Object content, String attName, Object attValue) {
            this(name, content);
            this.attributes.add(new AbstractMap.SimpleEntry<String, Object>(attName, attValue));
        }

        public Son(String name, Object content, String attName1, Object attValue1, String attName2, Object attValue2) {
            this(name, content);
            this.attributes.add(new AbstractMap.SimpleEntry<String, Object>(attName1, attValue1));
            this.attributes.add(new AbstractMap.SimpleEntry<String, Object>(attName2, attValue2));
        }

        public String toString() {
            return String.valueOf(this.name) + " : " + this.content.toString() + DefXCSP.this.print(this.attributes);
        }
    }
}

