/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.structures;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Range;
import org.xcsp.common.Utilities;
import org.xcsp.common.structures.Transition;

public final class Transitions {
    private List<Transition> list = new ArrayList<Transition>();

    public static Transitions parse(String transitions) {
        return new Transitions().add(transitions);
    }

    public Transitions add(String transitions) {
        Stream<String> st = Stream.of(transitions.trim().split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L);
        st.forEach(tok -> {
            String[] t = tok.split("\\s*,\\s*");
            Utilities.control(t.length == 3, "Pb with a transition, which is not formed of 3 pieces");
            this.add(t[0], Utilities.isInteger(t[1]) ? Integer.valueOf(Integer.parseInt(t[1])) : t[1], t[2]);
        });
        return this;
    }

    public Transitions add(Transition transition) {
        this.list.add(transition);
        return this;
    }

    public Transitions add(Stream<Transition> transitions) {
        transitions.forEach(t -> {
            Transitions transitions = this.add((Transition)t);
        });
        return this;
    }

    public Transitions add(String firstState, Object symbol, String secondState) {
        return this.add(new Transition(firstState, symbol, secondState));
    }

    public Transitions add(String firstState, int[] symbols, String secondState) {
        IntStream.of(symbols).forEach(v -> {
            Transitions transitions = this.add(new Transition(firstState, v, secondState));
        });
        return this;
    }

    public Transitions add(String firstState, Range range, String secondState) {
        this.add(firstState, range.toArray(), secondState);
        return this;
    }

    public Transition[] toArray() {
        return (Transition[])this.list.stream().toArray(Transition[]::new);
    }

    public String toString() {
        return this.list.stream().map(t -> t.toString()).collect(Collectors.joining());
    }
}

