/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.domains;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;

public class Values {

    public static final class Decimal
    implements SimpleValue {
        public final long integerPart;
        public final long decimalPart;

        public Decimal(long integerPart, long decimalPart) {
            this.integerPart = integerPart;
            this.decimalPart = decimalPart;
        }

        public String toString() {
            return String.valueOf(this.integerPart) + "." + this.decimalPart;
        }
    }

    public static interface IntegerEntity
    extends Comparable<IntegerEntity> {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public static IntegerEntity parse(String s) {
            String[] t = s.split("\\.\\.");
            return t.length == 1 ? new IntegerValue(Utilities.safeLong(t[0])) : new IntegerInterval(Utilities.safeLong(t[0], true), Utilities.safeLong(t[1], true));
        }

        public static IntegerEntity[] parseSeq(String seq) {
            return (IntegerEntity[])Stream.of(seq.split("\\s+")).map(tok -> IntegerEntity.parse(tok)).toArray(IntegerEntity[]::new);
        }

        public static long nValues(IntegerEntity[] pieces) {
            assert (IntStream.range(0, pieces.length - 1).noneMatch(i -> pieces[i].greatest() >= pieces[i + 1].smallest()));
            if (Stream.of(pieces).anyMatch(p -> p.width() == -1L)) {
                return -1L;
            }
            long cnt = 0L;
            try {
                IntegerEntity[] integerEntityArray = pieces;
                int n = pieces.length;
                int n2 = 0;
                while (n2 < n) {
                    IntegerEntity piece = integerEntityArray[n2];
                    cnt = Math.addExact(cnt, piece.width());
                    ++n2;
                }
            }
            catch (ArithmeticException e) {
                return -1L;
            }
            return cnt;
        }

        public static int[] toIntArray(IntegerEntity[] pieces, int limit) {
            long l = IntegerEntity.nValues(pieces);
            if (l == -1L || l > (long)limit) {
                return null;
            }
            int[] values = new int[(int)l];
            int i = 0;
            IntegerEntity[] integerEntityArray = pieces;
            int n = pieces.length;
            int n2 = 0;
            while (n2 < n) {
                IntegerEntity piece = integerEntityArray[n2];
                if (piece instanceof IntegerValue) {
                    values[i++] = Utilities.safeInt(((IntegerValue)piece).v);
                } else {
                    int min = Utilities.safeInt(((IntegerInterval)piece).inf);
                    int max = Utilities.safeInt(((IntegerInterval)piece).sup);
                    int v = min;
                    while (v <= max) {
                        values[i++] = v++;
                    }
                }
                ++n2;
            }
            return values;
        }

        @Override
        default public int compareTo(IntegerEntity p) {
            long l2;
            long l1 = this instanceof IntegerValue ? ((IntegerValue)this).v : ((IntegerInterval)this).inf;
            long l = l2 = p instanceof IntegerValue ? ((IntegerValue)p).v : ((IntegerInterval)p).inf;
            return l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
        }

        public boolean isSingleton();

        public long smallest();

        public long greatest();

        public long width();

        public int compareContains(long var1);
    }

    public static final class IntegerInterval
    implements IntegerEntity {
        public final long inf;
        public final long sup;
        private final long width;

        public IntegerInterval(long inf, long sup) {
            this.inf = inf;
            this.sup = sup;
            Utilities.control(inf <= sup, "Interval problem " + this);
            this.width = inf == Long.MIN_VALUE || sup == Long.MAX_VALUE || !Utilities.checkSafeArithmeticOperation(() -> {
                long l3 = Math.subtractExact(sup + 1L, inf);
            }) ? -1L : sup + 1L - inf;
        }

        @Override
        public boolean isSingleton() {
            return this.inf == this.sup;
        }

        @Override
        public long smallest() {
            return this.inf;
        }

        @Override
        public long greatest() {
            return this.sup;
        }

        @Override
        public long width() {
            return this.width;
        }

        @Override
        public int compareContains(long l) {
            return this.sup < l ? -1 : (this.inf > l ? 1 : 0);
        }

        public String toString() {
            return this.inf == this.sup - 1L ? String.valueOf(this.inf) + " " + this.sup : String.valueOf(this.inf) + ".." + this.sup;
        }
    }

    public static final class IntegerValue
    implements IntegerEntity,
    SimpleValue {
        public final long v;

        public IntegerValue(long v) {
            this.v = v;
        }

        @Override
        public boolean isSingleton() {
            return true;
        }

        @Override
        public long smallest() {
            return this.v;
        }

        @Override
        public long greatest() {
            return this.v;
        }

        @Override
        public long width() {
            return 1L;
        }

        @Override
        public int compareContains(long l) {
            return Long.compare(this.v, l);
        }

        public String toString() {
            return String.valueOf(this.v);
        }
    }

    public static final class Rational
    implements SimpleValue {
        public final long numerator;
        public final long denominator;

        public Rational(long num, long den) {
            this.numerator = num;
            this.denominator = den;
            assert (den != 0L) : "Pb with rational " + this;
        }

        public String toString() {
            return String.valueOf(this.numerator) + "/" + this.denominator;
        }
    }

    public static final class RealInterval {
        public final SimpleValue inf;
        public final SimpleValue sup;
        public final boolean infClosed;
        public final boolean supClosed;

        public static RealInterval parse(String s) {
            boolean infClosed = s.charAt(0) == '[';
            boolean supClosed = s.charAt(s.length() - 1) == '[';
            String[] t = s.split(",");
            SimpleValue inf = SimpleValue.parse(t[0].substring(1), true);
            SimpleValue sup = SimpleValue.parse(t[1].substring(0, t[1].length() - 1), true);
            return new RealInterval(inf, sup, infClosed, supClosed);
        }

        public static RealInterval[] parseSeq(String seq) {
            return (RealInterval[])Stream.of(seq.split("\\s+")).map(tok -> RealInterval.parse(tok)).toArray(RealInterval[]::new);
        }

        protected RealInterval(SimpleValue inf, SimpleValue sup, boolean infClosed, boolean supClosed) {
            this.inf = inf;
            this.sup = sup;
            this.infClosed = infClosed;
            this.supClosed = supClosed;
        }

        public String toString() {
            return String.valueOf(this.infClosed ? "[" : "]") + this.inf + "," + this.sup + (this.supClosed ? "[" : "]");
        }
    }

    public static interface SimpleValue {
        public static SimpleValue parse(String s, boolean checkSpecialValues) {
            String[] t = s.split("/");
            if (t.length == 2) {
                return new Rational(Utilities.safeLong(t[0]), Utilities.safeLong(t[1]));
            }
            t = s.split("\\.");
            if (t.length == 2) {
                return new Decimal(Utilities.safeLong(t[0]), Utilities.safeLong(t[1]));
            }
            return new IntegerValue(Utilities.safeLong(s, checkSpecialValues));
        }

        public static SimpleValue parse(String s) {
            return SimpleValue.parse(s, false);
        }

        public static SimpleValue[] parseSeq(String seq) {
            return (SimpleValue[])Stream.of(seq.split("\\s+")).map(s -> SimpleValue.parse(s)).toArray(SimpleValue[]::new);
        }
    }
}

