/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common;

import org.xcsp.common.Condition;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;

public abstract class Softening {
    public final Condition cost;

    public boolean isCostFunction() {
        return this.cost == null;
    }

    public Softening(Condition cost) {
        this.cost = cost;
    }

    public Softening() {
        this(null);
    }

    public String toString() {
        return "Softening (" + this.getClass().getSimpleName() + ")" + " " + (this.cost == null ? "" : "cost:" + this.cost);
    }

    public static final class SofteningExtension
    extends Softening {
        public final int defaultCost;

        public SofteningExtension(Condition cost, int defaultCost) {
            super(cost);
            this.defaultCost = defaultCost;
            Utilities.control(defaultCost >= -1, "Pb with default cost " + defaultCost);
        }

        public SofteningExtension(int defaultCost) {
            this(null, defaultCost);
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " defaultCost=" + this.defaultCost;
        }
    }

    public static final class SofteningGlobal
    extends Softening {
        public final Types.TypeMeasure type;
        public final String parameters;

        public SofteningGlobal(Condition cost, Types.TypeMeasure type, String parameters) {
            super(cost);
            this.type = type;
            this.parameters = parameters;
        }

        public SofteningGlobal(Condition cost, Types.TypeMeasure type) {
            this(cost, type, null);
        }

        public SofteningGlobal(Types.TypeMeasure type, String parameters) {
            this(null, type, parameters);
        }

        public SofteningGlobal(Types.TypeMeasure type) {
            this(type, null);
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " type=" + (Object)((Object)this.type) + (this.parameters != null ? " parameters=" + this.parameters : "");
        }
    }

    public static final class SofteningIntension
    extends Softening {
        public SofteningIntension(Condition cost) {
            super(cost);
        }

        public SofteningIntension() {
            this(null);
        }
    }

    public static final class SofteningSimple
    extends Softening {
        public final int violationCost;

        public SofteningSimple(Condition cost, int violationCost) {
            super(cost);
            this.violationCost = violationCost;
            Utilities.control(violationCost > 0, "Pb with violation cost " + violationCost);
        }

        public SofteningSimple(int violationCost) {
            this(null, violationCost);
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " violationCost=" + this.violationCost;
        }
    }
}

