/*
 * Decompiled with CFR 0.152.
 */
package objectives;

import dashboard.Arguments;
import interfaces.OptimizationCompatible;
import org.xcsp.common.Types;
import problem.Problem;
import propagation.soft.LowerBoundCapability;
import search.backtrack.SolverBacktrack;
import search.local.SolverLocal;
import utility.Enums;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import variables.Variable;

public abstract class OptimizationPilot {
    private static Long sharedMinBound = Long.MIN_VALUE;
    private static Long sharedMaxBound = Long.MAX_VALUE;
    public final Problem pb;
    public final boolean minimization;
    public final OptimizationCompatible ctr;
    protected long minBound;
    protected long maxBound;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean possiblyUpdateSharedBounds() {
        if (!Arguments.multiThreads) {
            return false;
        }
        boolean modified = false;
        Long l = sharedMinBound;
        synchronized (l) {
            if (this.minBound > sharedMinBound) {
                sharedMinBound = this.minBound;
                modified = true;
            }
        }
        l = sharedMaxBound;
        synchronized (l) {
            if (this.maxBound < sharedMaxBound) {
                sharedMaxBound = this.maxBound;
                modified = true;
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean possiblyUpdateLocalBounds() {
        if (!Arguments.multiThreads) {
            return false;
        }
        boolean modified = false;
        Long l = sharedMinBound;
        synchronized (l) {
            if (sharedMinBound > this.minBound) {
                this.minBound = sharedMinBound;
                modified = true;
            }
        }
        l = sharedMaxBound;
        synchronized (l) {
            if (sharedMaxBound < this.maxBound) {
                this.maxBound = sharedMaxBound;
                modified = true;
            }
        }
        if (modified) {
            Kit.log.fine("New Bounds updated from other workers : " + this.stringBounds());
            this.pb.solver.restarter.forceRootPropagation = true;
        }
        return modified;
    }

    public OptimizationPilot(Problem pb, Types.TypeOptimization opt, OptimizationCompatible ctr) {
        this.pb = pb;
        Kit.control(opt != null);
        this.minimization = opt == Types.TypeOptimization.MINIMIZE;
        this.ctr = ctr;
        this.minBound = Math.max(pb.rs.cp.optimizing.lowerBound, ctr != null ? ctr.minComputableObjectiveValue() : Long.MIN_VALUE);
        this.maxBound = Math.min(pb.rs.cp.optimizing.upperBound, ctr != null ? ctr.maxComputableObjectiveValue() : Long.MAX_VALUE);
    }

    public final long value() {
        assert (Variable.areAllFixed(this.pb.variables));
        if (this.ctr != null) {
            return this.ctr.objectiveValue();
        }
        if (this.pb.solver.propagation instanceof LowerBoundCapability) {
            return ((LowerBoundCapability)((Object)this.pb.solver.propagation)).getLowerBound();
        }
        return ((SolverLocal)this.pb.solver).nMinViolatedCtrs;
    }

    public final boolean isBetterBound(long bound) {
        return this.minimization ? bound <= this.maxBound : bound >= this.minBound;
    }

    protected abstract void shiftLimitWhenSuccess();

    protected abstract void shiftLimitWhenFailure();

    public void afterRun() {
        Kit.control(this.pb.rs.cp.framework == Types.TypeFramework.COP);
        if (this.pb.solver.solManager.lastSolutionRun == this.pb.solver.restarter.numRun) {
            if (this.minimization) {
                this.maxBound = this.pb.solver.solManager.bestBound - 1L;
            } else {
                this.minBound = this.pb.solver.solManager.bestBound + 1L;
            }
            this.possiblyUpdateLocalBounds();
            Kit.control(this.minBound - 1L <= this.maxBound || this.pb.rs.cp.optimizing.upperBound != Long.MAX_VALUE, () -> " minB=" + this.minBound + " maxB=" + this.maxBound);
            this.possiblyUpdateSharedBounds();
            if (this.minBound > this.maxBound) {
                this.pb.solver.stoppingType = Enums.EStopping.FULL_EXPLORATION;
            } else {
                this.shiftLimitWhenSuccess();
            }
        } else if (this.pb.solver.stoppingType == Enums.EStopping.FULL_EXPLORATION) {
            long limit = this.ctr.getLimit();
            if (this.minimization) {
                this.minBound = limit == Long.MAX_VALUE ? Long.MAX_VALUE : limit + 1L;
            } else {
                this.maxBound = limit == Long.MIN_VALUE ? Long.MIN_VALUE : limit - 1L;
            }
            Kit.log.fine("\n  New Bounds: " + this.stringBounds());
            if (this.minBound <= this.maxBound) {
                this.pb.solver.stoppingType = null;
                Kit.control(this.pb.stuff.nValuesRemovedAtConstructionTime == 0, () -> "Not handled for the moment");
                this.pb.solver.restarter.forceRootPropagation = true;
                ((SolverBacktrack)this.pb.solver).restoreProblem();
                this.shiftLimitWhenFailure();
            }
            if (((SolverBacktrack)this.pb.solver).learnerNogoods != null) {
                ((SolverBacktrack)this.pb.solver).learnerNogoods.reset();
            }
        }
    }

    public void shiftLimit(long offset) {
        Kit.control(0L <= offset && this.minBound + offset <= this.maxBound, () -> "offset " + offset + " minBound " + this.minBound + " maxBound " + this.maxBound);
        long newLimit = this.minimization ? this.maxBound - offset : this.minBound + offset;
        Kit.log.finer("  New Limit: " + newLimit + "\n");
        this.ctr.setLimit(newLimit);
    }

    public boolean areBoundsConsistent() {
        return this.minBound <= this.maxBound;
    }

    public final String stringBounds() {
        return (this.minBound == Long.MIN_VALUE ? "-infty" : Long.valueOf(this.minBound)) + ".." + (this.maxBound == Long.MAX_VALUE ? "+infty" : Long.valueOf(this.maxBound));
    }

    public String toString() {
        return (this.minimization ? Types.TypeOptimization.MINIMIZE : Types.TypeOptimization.MAXIMIZE).shortName() + " " + this.ctr.toString();
    }

    public static final class OptimizationPilotDichotomic
    extends OptimizationPilot {
        public OptimizationPilotDichotomic(Problem pb, Types.TypeOptimization opt, OptimizationCompatible ctr) {
            super(pb, opt, ctr);
        }

        @Override
        protected void shiftLimitWhenSuccess() {
            this.shiftLimit((this.maxBound - this.minBound) / 2L);
        }

        @Override
        protected void shiftLimitWhenFailure() {
            this.shiftLimit((this.maxBound - this.minBound) / 2L);
        }
    }

    public static final class OptimizationPilotIncreasing
    extends OptimizationPilot {
        boolean first = true;

        public OptimizationPilotIncreasing(Problem pb, Types.TypeOptimization opt, OptimizationCompatible ctr) {
            super(pb, opt, ctr);
        }

        @Override
        protected void shiftLimitWhenSuccess() {
            if (!this.first) {
                throw new UnreachableCodeException();
            }
            this.ctr.setLimit(this.minimization ? this.minBound : this.maxBound);
            Kit.log.info("limit=" + this.ctr.getLimit());
            this.first = false;
        }

        @Override
        protected void shiftLimitWhenFailure() {
            this.ctr.setLimit(this.minimization ? this.minBound : this.maxBound);
        }
    }

    public static final class OptimizationPilotDecreasing
    extends OptimizationPilot {
        public OptimizationPilotDecreasing(Problem pb, Types.TypeOptimization opt, OptimizationCompatible ctr) {
            super(pb, opt, ctr);
        }

        @Override
        protected void shiftLimitWhenSuccess() {
            this.shiftLimit(0L);
        }

        @Override
        protected void shiftLimitWhenFailure() {
        }
    }

    public static final class OptimizationPilotBasic
    extends OptimizationPilot {
        public final String optimizationExpression;

        public OptimizationPilotBasic(Problem pb, String optimizationExpression) {
            super(pb, Types.TypeOptimization.MINIMIZE, null);
            this.optimizationExpression = optimizationExpression;
        }

        @Override
        protected void shiftLimitWhenSuccess() {
        }

        @Override
        protected void shiftLimitWhenFailure() {
        }

        @Override
        public String toString() {
            return (this.minimization ? Types.TypeOptimization.MINIMIZE : Types.TypeOptimization.MAXIMIZE).shortName() + " " + this.optimizationExpression;
        }
    }
}

