/*
 * Decompiled with CFR 0.152.
 */
package learning;

import learning.LearnerStatesDominance;
import utility.Kit;
import utility.operations.Bit;

public class State {
    public final int[] vids;
    private long[][] domainRepresentations;
    private int watchedVariablePosition0 = -1;
    private int watchedVariablePosition1 = -1;
    private int watchedIndex0 = -1;
    private int watchedIndex1 = -1;

    public int getVariableIdWatchedAt(int watchPosition) {
        return this.vids[watchPosition == 0 ? this.watchedVariablePosition0 : this.watchedVariablePosition1];
    }

    public int getVariablePositionAt(int watchPosition) {
        return watchPosition == 0 ? this.watchedVariablePosition0 : this.watchedVariablePosition1;
    }

    public int getIndexWatchedAt(int watchPosition) {
        return watchPosition == 0 ? this.watchedIndex0 : this.watchedIndex1;
    }

    public long[] getDomainRepresentationOfVariableAtPosition(int position) {
        return this.domainRepresentations[position];
    }

    public int getFirstAbsentIndexFor(int pos) {
        return Bit.firstZeroIn(this.domainRepresentations[pos]);
    }

    public boolean isWatched(int variableId) {
        return this.vids[this.watchedVariablePosition0] == variableId || this.vids[this.watchedVariablePosition1] == variableId;
    }

    public int getWatchPositionOf(int variableId) {
        return this.vids[this.watchedVariablePosition0] == variableId ? 0 : 1;
    }

    public int getVariableIdOfWatchDifferentFrom(int variableId) {
        assert (this.isWatched(variableId));
        return this.vids[this.watchedVariablePosition0] == variableId ? this.vids[this.watchedVariablePosition1] : this.vids[this.watchedVariablePosition0];
    }

    public long[] getDomainRepresentationOfWatchedVariable(int variableId) {
        assert (this.isWatched(variableId));
        int position = this.vids[this.watchedVariablePosition0] == variableId ? this.watchedVariablePosition0 : this.watchedVariablePosition1;
        return this.domainRepresentations[position];
    }

    public long[] getDomainRepresentationAt(int position) {
        return this.domainRepresentations[position];
    }

    public long[] getDomainRepresentationOfWatchedVariableAt(int watchPosition) {
        return this.domainRepresentations[watchPosition == 0 ? this.watchedVariablePosition0 : this.watchedVariablePosition1];
    }

    public void setVariablePosition(int watchPosition, int pos) {
        if (watchPosition == 0) {
            this.watchedVariablePosition0 = pos;
        } else {
            this.watchedVariablePosition1 = pos;
        }
    }

    public void setIndex(int watchPosition, int indexPosition) {
        if (watchPosition == 0) {
            this.watchedIndex0 = indexPosition;
        } else {
            this.watchedIndex1 = indexPosition;
        }
    }

    public void setWatch(int watchPosition, int pos, int indexPosition) {
        if (watchPosition == 0) {
            this.watchedVariablePosition0 = pos;
            this.watchedIndex0 = indexPosition;
        } else {
            this.watchedVariablePosition1 = pos;
            this.watchedIndex1 = indexPosition;
        }
    }

    public State(LearnerStatesDominance stateDominanceManager, int[] variableIndices) {
        this.vids = variableIndices;
        this.domainRepresentations = new long[variableIndices.length][];
        for (int i = 0; i < this.domainRepresentations.length; ++i) {
            this.domainRepresentations[i] = (long[])stateDominanceManager.solver.pb.variables[variableIndices[i]].dom.binaryRepresentation().clone();
        }
        ++stateDominanceManager.nbGeneratedHyperNogoods;
    }

    private State(LearnerStatesDominance stateDominanceManager, State hn, boolean[] proof) {
        int cnt = Kit.countIn(true, proof);
        this.vids = new int[cnt];
        this.domainRepresentations = new long[cnt][];
        cnt = 0;
        for (int i = 0; i < proof.length; ++i) {
            if (!proof[i]) continue;
            this.vids[cnt] = i;
            this.domainRepresentations[cnt] = (long[])stateDominanceManager.solver.pb.variables[i].dom.binaryRepresentation().clone();
            ++cnt;
        }
        ++stateDominanceManager.nbGeneratedHyperNogoods;
    }

    public State(LearnerStatesDominance stateDominanceManager, boolean[] proof) {
        this(stateDominanceManager, null, proof);
    }

    public State(State hn, boolean[] proof) {
        this(null, hn, proof);
    }

    public boolean equals(Object o) {
        int i;
        State hn = (State)o;
        if (this.vids.length != hn.vids.length) {
            return false;
        }
        for (i = 0; i < this.vids.length; ++i) {
            if (this.vids[i] == hn.vids[i]) continue;
            return false;
        }
        for (i = 0; i < this.domainRepresentations.length; ++i) {
            for (int j = 0; j < this.domainRepresentations[i].length; ++j) {
                if (this.domainRepresentations[i][j] == hn.domainRepresentations[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("IPS of size " + this.vids.length + " with watch1 = " + this.watchedVariablePosition0 + " and watch2 = " + this.watchedVariablePosition1 + "\n");
        for (int i = 0; i < this.vids.length; ++i) {
            sb.append(this.vids[i] + " : " + Bit.decrypt(this.domainRepresentations[i]) + " \n");
        }
        return sb.append("end\n").toString();
    }
}

