/*
 * Decompiled with CFR 0.152.
 */
package heuristics.variables.dynamic;

import constraints.Constraint;
import heuristics.variables.HeuristicVariablesDynamic;
import interfaces.ObserverPropagation;
import interfaces.ObserverRuns;
import interfaces.TagMaximize;
import java.util.Arrays;
import search.backtrack.SolverBacktrack;
import utility.Enums;
import utility.sets.SetDense;
import variables.Variable;
import variables.domains.Domain;

public abstract class HeuristicVariablesConflictBased
extends HeuristicVariablesDynamic
implements ObserverRuns,
ObserverPropagation,
TagMaximize {
    private int time;
    private int[] ctime;
    public double[] vscores;
    public double[] cscores;
    double[][] cvscores;
    final double SMOOTHING = 0.995;
    final double ALPHA0 = 0.1;
    final double ALPHA_LIMIT = 0.06;
    final double ALPHA_DECREMENT = 1.0E-6;
    double alpha;

    @Override
    public void reset() {
        this.time = 0;
        Arrays.fill(this.ctime, 0);
        Arrays.fill(this.vscores, 0.0);
        Arrays.fill(this.cscores, 0.0);
        for (double[] t : this.cvscores) {
            Arrays.fill(t, 0.0);
        }
    }

    @Override
    public void beforeRun() {
        if (this.solver.restarter.numRun > 0 && this.solver.restarter.numRun % this.solver.rs.cp.restarting.dataResetPeriod == 0) {
            this.reset();
        }
        this.alpha = 0.1;
        if (this.settings.weighting == Enums.EWeighting.CHS) {
            for (int i = 0; i < this.cscores.length; ++i) {
                int n = i;
                this.cscores[n] = this.cscores[n] * Math.pow(0.995, this.time - this.ctime[i]);
            }
        }
    }

    @Override
    public void afterAssignment(Variable x, int a) {
        if (this.settings.weighting != Enums.EWeighting.VAR && this.settings.weighting != Enums.EWeighting.CHS) {
            for (Constraint c : x.ctrs) {
                if (c.futvars.size() != 1) continue;
                int y = c.futvars.dense[0];
                int n = c.scp[y].num;
                this.vscores[n] = this.vscores[n] - this.cvscores[c.num][y];
            }
        }
    }

    @Override
    public void afterUnassignment(Variable x) {
        if (this.settings.weighting != Enums.EWeighting.VAR && this.settings.weighting != Enums.EWeighting.CHS) {
            for (Constraint c : x.ctrs) {
                if (c.futvars.size() != 2) continue;
                int y = c.futvars.dense[0];
                int n = c.scp[y].num;
                this.vscores[n] = this.vscores[n] + this.cvscores[c.num][y];
            }
        }
    }

    @Override
    public void whenWipeout(Constraint c, Variable x) {
        ++this.time;
        if (this.settings.weighting == Enums.EWeighting.VAR) {
            int n = x.num;
            this.vscores[n] = this.vscores[n] + 1.0;
        } else if (c != null) {
            if (this.settings.weighting == Enums.EWeighting.CHS) {
                double r = 1.0 / (double)(this.time - this.ctime[c.num]);
                double increment = this.alpha * (r - this.cscores[c.num]);
                int n = c.num;
                this.cscores[n] = this.cscores[n] + increment;
                this.alpha = Double.max(0.06, this.alpha - 1.0E-6);
            } else {
                double increment = 1.0;
                int n = c.num;
                this.cscores[n] = this.cscores[n] + increment;
                SetDense futvars = c.futvars;
                for (int i = futvars.limit; i >= 0; --i) {
                    Variable y = c.scp[futvars.dense[i]];
                    if (this.settings.weighting == Enums.EWeighting.CACD) {
                        Domain dom = y.dom;
                        boolean test = false;
                        if (test) {
                            int depth = this.solver.depth();
                            int nRemoved = 0;
                            int a = dom.lastRemoved();
                            while (a != -1 && dom.getRemovedLevelOf(a) == depth) {
                                ++nRemoved;
                                a = dom.prevRemoved(a);
                            }
                            increment = 1.0 / (double)(futvars.size() * (dom.size() + nRemoved));
                        } else {
                            increment = 1.0 / ((double)futvars.size() * (dom.size() == 0 ? 0.5 : (double)dom.size()));
                        }
                    }
                    int n2 = y.num;
                    this.vscores[n2] = this.vscores[n2] + increment;
                    double[] dArray = this.cvscores[c.num];
                    int n3 = futvars.dense[i];
                    dArray[n3] = dArray[n3] + increment;
                }
            }
        }
        this.ctime[c.num] = this.time;
    }

    @Override
    public void whenReduction(Constraint c, Variable x) {
    }

    public HeuristicVariablesConflictBased(SolverBacktrack solver, boolean antiHeuristic) {
        super(solver, antiHeuristic);
        this.ctime = new int[solver.pb.constraints.length];
        this.vscores = new double[solver.pb.variables.length];
        this.cscores = new double[solver.pb.constraints.length];
        this.cvscores = new double[solver.pb.constraints.length][0];
        for (int i = 0; i < this.cvscores.length; ++i) {
            this.cvscores[i] = new double[solver.pb.constraints[i].scp.length];
        }
    }
}

