/*
 * Decompiled with CFR 0.152.
 */
package heuristics.variables.direct;

import heuristics.variables.direct.ActivityImpactAbstract;
import java.util.Arrays;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import variables.Variable;

public final class Impact
extends ActivityImpactAbstract {
    private double[] impacts;

    @Override
    public void beforeRun() {
        super.beforeRun();
        if (this.solver.restarter.numRun != 0 && this.solver.restarter.numRun % this.solver.rs.cp.restarting.dataResetPeriod == 0) {
            Kit.log.info("Reset of impacts");
            Arrays.fill(this.impacts, 0.0);
        }
    }

    public Impact(SolverBacktrack solver, boolean antiHeuristic) {
        super(solver, antiHeuristic);
        this.alpha = 0.1;
        this.impacts = new double[solver.pb.variables.length];
    }

    @Override
    protected void update() {
        double impact = 1.0;
        if (this.solver.depth() > this.lastDepth) {
            for (Variable x : this.solver.futVars) {
                impact *= (double)x.dom.size() / (double)this.lastSizes[x.num];
            }
        } else {
            impact = 0.0;
        }
        this.impacts[this.lastVar.num] = (1.0 - this.alpha) * this.impacts[this.lastVar.num] + this.alpha * impact;
        assert (0.0 <= impact && impact <= 1.0 && 0.0 <= this.impacts[this.lastVar.num] && this.impacts[this.lastVar.num] <= 1.0);
    }

    @Override
    public double scoreOf(Variable x) {
        return this.impacts[x.num];
    }
}

