/*
 * Decompiled with CFR 0.152.
 */
package heuristics.variables.direct;

import heuristics.variables.HeuristicVariables;
import interfaces.ObserverRuns;
import java.util.stream.Stream;
import search.backtrack.SolverBacktrack;
import utility.Enums;
import utility.Kit;
import variables.Variable;

public abstract class ActivityImpactAbstract
extends HeuristicVariables
implements ObserverRuns {
    protected Variable lastVar;
    protected int lastDepth = -1;
    protected int[] lastSizes;
    protected double alpha;

    @Override
    public void beforeRun() {
        this.lastVar = null;
        this.lastDepth = -1;
        for (int i = 0; i < this.solver.pb.variables.length; ++i) {
            this.lastSizes[i] = this.solver.pb.variables[i].dom.size();
        }
    }

    public ActivityImpactAbstract(SolverBacktrack solver, boolean antiHeuristic) {
        super(solver, antiHeuristic);
        this.lastSizes = Stream.of(solver.pb.variables).mapToInt(x -> x.dom.size()).toArray();
        Kit.control(solver.rs.cp.solving.branching == Enums.EBranching.BIN);
        Kit.control(solver.rs.cp.restarting.dataResetPeriod != 0);
    }

    protected abstract void update();

    @Override
    protected Variable bestUnpriorityVar() {
        assert (this.lastVar != null || this.solver.depth() > this.lastDepth) : this.lastVar + " " + this.solver.depth() + " " + this.lastDepth;
        if (this.lastVar != null) {
            this.update();
        }
        this.bestScoredVariable.reset(true);
        this.solver.futVars.execute(x -> {
            if (x.dom.size() > 1 || this.solver.rs.cp.varh.singletonAssignment != Enums.ESingletonAssignment.LAST) {
                this.lastSizes[x.num] = x.dom.size();
                this.bestScoredVariable.update((Variable)x, this.scoreOptimizedOf((Variable)x));
            }
        });
        if (this.bestScoredVariable.variable == null) {
            assert (this.solver.rs.cp.varh.singletonAssignment == Enums.ESingletonAssignment.LAST);
            return this.solver.futVars.first();
        }
        this.lastVar = this.bestScoredVariable.variable.dom.size() == 1 ? null : this.bestScoredVariable.variable;
        this.lastDepth = this.solver.depth();
        return this.bestScoredVariable.variable;
    }
}

