/*
 * Decompiled with CFR 0.152.
 */
package heuristics.variables.direct;

import heuristics.variables.direct.ActivityImpactAbstract;
import java.util.Arrays;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import variables.Variable;

public class Activity
extends ActivityImpactAbstract {
    private double[] activities;

    @Override
    public void beforeRun() {
        super.beforeRun();
        if (this.solver.restarter.numRun != 0 && this.solver.restarter.numRun % this.solver.rs.cp.restarting.dataResetPeriod == 0) {
            Kit.log.info("Reset of activities");
            Arrays.fill(this.activities, 0.0);
        }
    }

    public Activity(SolverBacktrack solver, boolean antiHeuristic) {
        super(solver, antiHeuristic);
        this.alpha = 0.99;
        this.activities = new double[solver.pb.variables.length];
    }

    @Override
    protected void update() {
        if (this.solver.depth() > this.lastDepth) {
            this.solver.futVars.execute(x -> {
                this.activities[x.num] = x.dom.size() != this.lastSizes[x.num] ? this.activities[x.num] + 1.0 : this.activities[x.num] * this.alpha;
            });
        } else {
            int n = this.lastVar.num;
            this.activities[n] = this.activities[n] + 2.0;
        }
    }

    @Override
    public double scoreOf(Variable x) {
        return -this.activities[x.num] / (double)x.dom.size();
    }
}

