/*
 * Decompiled with CFR 0.152.
 */
package heuristics.variables;

import heuristics.variables.HeuristicVariables;
import interfaces.ObserverRuns;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import variables.Variable;

public final class Memory
extends HeuristicVariables
implements ObserverRuns {
    private int[] order;
    private int nbOrdered;
    private int posLastConflict = -1;

    @Override
    public void beforeRun() {
        this.nbOrdered = 0;
    }

    public Memory(SolverBacktrack solver, boolean antiHeuristic) {
        super(solver, antiHeuristic);
        this.order = new int[solver.pb.variables.length];
    }

    @Override
    protected final Variable bestUnpriorityVar() {
        int pos = -1;
        for (int i = 0; i < this.nbOrdered; ++i) {
            if (this.solver.pb.variables[this.order[i]].isAssigned()) continue;
            pos = i;
            break;
        }
        if (pos != -1) {
            if (this.posLastConflict > pos) {
                Kit.control(this.posLastConflict < this.nbOrdered);
                int vid = this.order[pos];
                this.order[pos] = this.order[this.posLastConflict];
                this.order[this.posLastConflict] = vid;
            }
            this.posLastConflict = pos;
        } else {
            this.bestScoredVariable.reset(false);
            this.solver.futVars.execute(x -> this.bestScoredVariable.update((Variable)x, this.scoreOptimizedOf((Variable)x)));
            pos = this.posLastConflict = this.nbOrdered;
            this.order[this.nbOrdered++] = this.bestScoredVariable.variable.num;
        }
        return this.solver.pb.variables[this.order[pos]];
    }

    @Override
    public double scoreOf(Variable x) {
        return x.wdeg() / (double)x.dom.size();
    }
}

