/*
 * Decompiled with CFR 0.152.
 */
package heuristics.variables;

import heuristics.variables.HeuristicVariables;
import interfaces.TagMaximize;
import search.backtrack.SolverBacktrack;
import utility.Enums;
import utility.operations.CombinatorOfTwoInts;
import variables.Variable;

public abstract class HeuristicVariablesDynamic
extends HeuristicVariables {
    private int lastDepthWithOnlySingletons = Integer.MAX_VALUE;

    public HeuristicVariablesDynamic(SolverBacktrack solver, boolean antiHeuristic) {
        super(solver, antiHeuristic);
    }

    @Override
    protected final Variable bestUnpriorityVar() {
        Variable x2;
        assert (this.solver.futVars.size() > 0);
        if (this.solver.rs.cp.solving.branching != Enums.EBranching.BIN && (x2 = this.solver.dr.varOfLastDecisionIf(false)) != null) {
            return x2;
        }
        if (this.settings.lastConflictSize > 0 && (x2 = this.solver.lcReasoner.lastConflictPriorityVar()) != null) {
            return x2;
        }
        this.bestScoredVariable.reset(false);
        if (this.settings.singletonAssignment == Enums.ESingletonAssignment.LAST) {
            if (this.solver.depth() <= this.lastDepthWithOnlySingletons) {
                this.lastDepthWithOnlySingletons = Integer.MAX_VALUE;
                this.solver.futVars.execute(x -> {
                    if (x.dom.size() != 1) {
                        this.bestScoredVariable.update((Variable)x, this.scoreOptimizedOf((Variable)x));
                    }
                });
            }
            if (this.bestScoredVariable.variable == null) {
                this.lastDepthWithOnlySingletons = this.solver.depth();
                return this.solver.futVars.first();
            }
        } else {
            boolean first = this.settings.singletonAssignment == Enums.ESingletonAssignment.FIRST;
            Variable x3 = this.solver.futVars.first();
            while (x3 != null) {
                if (first && x3.dom.size() == 1) {
                    return x3;
                }
                this.bestScoredVariable.update(x3, this.scoreOptimizedOf(x3));
                x3 = this.solver.futVars.next(x3);
            }
        }
        return this.bestScoredVariable.variable;
    }

    public static final class DomThenDeg
    extends HeuristicVariablesDynamic {
        private CombinatorOfTwoInts combinator;

        public DomThenDeg(SolverBacktrack solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
            this.combinator = new CombinatorOfTwoInts(solver.pb.stuff.maxVarDegree());
        }

        @Override
        public double scoreOf(Variable x) {
            return this.combinator.combinedMaxMinLongValueFor(x.dom.size(), x.deg());
        }
    }

    public static final class Dom
    extends HeuristicVariablesDynamic {
        public Dom(SolverBacktrack solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
        }

        @Override
        public double scoreOf(Variable x) {
            return x.dom.size();
        }
    }

    public static final class DDegOnDom
    extends HeuristicVariablesDynamic
    implements TagMaximize {
        public DDegOnDom(SolverBacktrack solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
        }

        @Override
        public double scoreOf(Variable x) {
            return x.ddegOnDom();
        }
    }

    public static final class DDeg
    extends HeuristicVariablesDynamic
    implements TagMaximize {
        public DDeg(SolverBacktrack solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
        }

        @Override
        public double scoreOf(Variable x) {
            return x.ddeg();
        }
    }
}

