/*
 * Decompiled with CFR 0.152.
 */
package heuristics.values;

import constraints.Constraint;
import constraints.CtrHard;
import heuristics.values.HeuristicValues;
import interfaces.TagExperimental;
import propagation.soft.pfc.RDAC;
import utility.Kit;
import variables.Variable;

public abstract class HeuristicValuesDynamic
extends HeuristicValues {
    public HeuristicValuesDynamic(Variable x, boolean antiHeuristic) {
        super(x, antiHeuristic);
    }

    @Override
    public int identifyBestValueIndex() {
        assert (this.dx.size() != 0) : "The domain is empty";
        int bestIdx = this.dx.first();
        double bestScore = this.scoreOf(bestIdx) * (double)this.scoreCoeff;
        int a = this.dx.next(bestIdx);
        while (a != -1) {
            double score = this.scoreOf(a) * (double)this.scoreCoeff;
            if (score > bestScore) {
                bestIdx = a;
                bestScore = score;
            }
            a = this.dx.next(a);
        }
        return bestIdx;
    }

    public static final class SumMinCosts
    extends HeuristicValuesDynamic
    implements TagExperimental {
        private long[] sumMinCosts;

        public SumMinCosts(Variable x, boolean antiHeuristic) {
            super(x, antiHeuristic);
            this.sumMinCosts = ((RDAC)x.pb.solver.propagation).sumMinCosts[x.num];
        }

        @Override
        public double scoreOf(int a) {
            return this.sumMinCosts[a];
        }
    }

    public static final class Aic
    extends HeuristicValuesDynamic
    implements TagExperimental {
        private int[] aic;

        public Aic(Variable x, boolean antiHeuristic) {
            super(x, antiHeuristic);
            this.aic = ((RDAC)x.pb.solver.propagation).aic[x.num];
        }

        @Override
        public double scoreOf(int a) {
            return this.aic[a];
        }
    }

    public static final class Occurrences
    extends HeuristicValuesDynamic {
        public Occurrences(Variable x, boolean antiHeuristic) {
            super(x, antiHeuristic);
        }

        @Override
        public double scoreOf(int a) {
            int v = this.x.dom.toVal(a);
            int cnt = 0;
            for (Variable y : this.x.pb.variables) {
                if (!y.dom.onlyContainsValue(v)) continue;
                ++cnt;
            }
            return cnt;
        }
    }

    public static final class Failures
    extends HeuristicValuesDynamic {
        private int[] nbDecisions;
        private int[] nbFailedDecisions;
        private long[] sumFailedDecisionsHeights;

        public void updateWith(int a, int depth, boolean consistent) {
            int n = a;
            this.nbDecisions[n] = this.nbDecisions[n] + 1;
            if (!consistent) {
                int n2 = a;
                this.nbFailedDecisions[n2] = this.nbFailedDecisions[n2] + 1;
                int n3 = a;
                this.sumFailedDecisionsHeights[n3] = this.sumFailedDecisionsHeights[n3] + (long)depth;
            }
        }

        public Failures(Variable x, boolean antiHeuristic) {
            super(x, antiHeuristic);
            this.nbDecisions = Kit.repeat(1, this.dx.initSize());
            this.nbFailedDecisions = new int[this.dx.initSize()];
            this.sumFailedDecisionsHeights = new long[this.dx.initSize()];
        }

        @Override
        public double scoreOf(int a) {
            return (double)this.nbFailedDecisions[a] / (double)this.nbDecisions[a];
        }
    }

    public static final class Conflicts
    extends HeuristicValuesDynamic {
        public Conflicts(Variable x, boolean antiHeuristic) {
            super(x, antiHeuristic);
        }

        @Override
        public double scoreOf(int a) {
            assert (this.x.isFuture() && this.dx.isPresent(a));
            long nConflicts = 0L;
            for (Constraint c : this.x.ctrs) {
                nConflicts += ((CtrHard)c).nConflictsFor(c.positionOf(this.x), a);
            }
            return nConflicts;
        }
    }
}

