/*
 * Decompiled with CFR 0.152.
 */
package heuristics.values;

import heuristics.values.HeuristicValues;
import interfaces.TagExperimental;
import propagation.soft.pfc.PFC;
import utility.Kit;
import utility.exceptions.MissingImplementationException;
import utility.exceptions.UnreachableCodeException;
import variables.Variable;

public abstract class HeuristicValuesDirect
extends HeuristicValues {
    public HeuristicValuesDirect(Variable x, boolean dummy) {
        super(x, dummy);
    }

    @Override
    protected double scoreOf(int a) {
        throw new UnreachableCodeException("The value must be directly selected without any iteration");
    }

    public static final class MinCost
    extends HeuristicValuesDirect
    implements TagExperimental {
        private int[] argMinSumMinCosts;

        public MinCost(Variable x, boolean dummy) {
            super(x, dummy);
            Kit.control(x.pb.solver.propagation instanceof PFC);
            this.argMinSumMinCosts = ((PFC)x.pb.solver.propagation).argMinSumMinCosts;
        }

        @Override
        public int identifyBestValueIndex() {
            assert (this.dx.isPresent(this.argMinSumMinCosts[this.x.num]));
            return this.argMinSumMinCosts[this.x.num];
        }
    }

    public static final class Values
    extends HeuristicValuesDirect {
        private boolean min;
        private Variable[] others;

        public Values(Variable x, boolean antiHeuristic, Variable[] others) {
            super(x, antiHeuristic);
            this.min = !antiHeuristic;
            this.others = others;
        }

        @Override
        public int identifyBestValueIndex() {
            if (this.dx.size() == 1) {
                return this.dx.first();
            }
            if (this.min) {
                for (Variable y : this.others) {
                    int a;
                    if (y == this.x || y.dom.size() != 1 || (a = this.dx.toPresentIdx(y.dom.firstValue())) < 0) continue;
                    return a;
                }
                return this.dx.first();
            }
            throw new MissingImplementationException();
        }
    }

    public static final class Robin
    extends HeuristicValuesDirect {
        public Robin(Variable x, boolean dummy) {
            super(x, dummy);
        }

        @Override
        public int identifyBestValueIndex() {
            int run = this.x.pb.solver.restarter.numRun;
            if (run % 3 == 0) {
                return this.dx.first();
            }
            if (run % 3 == 1) {
                return this.dx.last();
            }
            return this.dx.random();
        }
    }

    public static final class Rand
    extends HeuristicValuesDirect {
        public Rand(Variable x, boolean dummy) {
            super(x, dummy);
        }

        @Override
        public int identifyBestValueIndex() {
            return this.dx.random();
        }
    }

    public static class ProgressSaving
    extends HeuristicValuesDirect
    implements TagExperimental {
        private int[] progressSaving;

        public ProgressSaving(Variable x, boolean dummy) {
            super(x, dummy);
        }

        @Override
        public int identifyBestValueIndex() {
            int a = this.progressSaving[this.x.num];
            return a != -1 && this.dx.isPresent(a) ? a : this.dx.first();
        }
    }

    public static final class Median
    extends HeuristicValuesDirect {
        public Median(Variable x, boolean dummy) {
            super(x, dummy);
        }

        @Override
        public int identifyBestValueIndex() {
            return this.dx.get(this.dx.size() / 2);
        }
    }

    public static final class Last
    extends HeuristicValuesDirect {
        public Last(Variable x, boolean dummy) {
            super(x, dummy);
        }

        @Override
        public int identifyBestValueIndex() {
            return this.dx.last();
        }
    }

    public static final class First
    extends HeuristicValuesDirect {
        public First(Variable x, boolean dummy) {
            super(x, dummy);
        }

        @Override
        public int identifyBestValueIndex() {
            return this.dx.first();
        }
    }
}

