/*
 * Decompiled with CFR 0.152.
 */
package heuristics.values;

import dashboard.ControlPanel;
import heuristics.Heuristic;
import interfaces.TagExperimental;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import search.Solver;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import variables.Variable;
import variables.domains.Domain;

public abstract class HeuristicValues
extends Heuristic {
    protected final Variable x;
    protected final Domain dx;
    private ControlPanel.SettingValh settings;

    public HeuristicValues(Variable x, boolean antiHeuristic) {
        super(antiHeuristic);
        this.x = x;
        this.dx = x.dom;
        this.settings = x.pb.rs.cp.valh;
    }

    protected abstract double scoreOf(int var1);

    public abstract int identifyBestValueIndex();

    public int bestIndex() {
        if (this.settings.bestSolution != 0) {
            int a;
            Solver solver = this.x.pb.solver;
            if (solver.solManager.nSolutionsFound == 0L) {
                int a2;
                if (((SolverBacktrack)solver).prevSize != 0 && (a2 = ((SolverBacktrack)solver).prevLongestRunBranch[this.x.num]) != -1 && this.dx.isPresent(a2)) {
                    return a2;
                }
            } else if (solver.restarter.numRun % this.settings.bestSolutionGap != 0 && this.dx.isPresent(a = solver.solManager.lastSolution[this.x.num])) {
                return a;
            }
        }
        return this.identifyBestValueIndex();
    }

    public static abstract class HeuristicValuesFixed
    extends HeuristicValues {
        private final int[] fixed;

        public HeuristicValuesFixed(Variable x, boolean antiHeuristic) {
            super(x, antiHeuristic);
            Map<Integer, Double> map = IntStream.range(0, this.dx.initSize()).filter(a -> this.dx.isPresent(a)).boxed().collect(Collectors.toMap(a -> a, a -> this.scoreOf((int)a) * (double)this.scoreCoeff));
            map = Kit.sort(map, (e1, e2) -> (Double)e1.getValue() > (Double)e2.getValue() ? -1 : ((Double)e1.getValue() < (Double)e2.getValue() ? 1 : (Integer)e1.getKey() - (Integer)e2.getKey()));
            this.fixed = map.entrySet().stream().mapToInt(e -> (Integer)e.getKey()).toArray();
        }

        @Override
        public final int identifyBestValueIndex() {
            assert (this.dx.size() > 0) : "The domain is empty";
            for (int a : this.fixed) {
                if (!this.dx.isPresent(a)) continue;
                return a;
            }
            throw new UnreachableCodeException();
        }

        public static final class SRand
        extends HeuristicValuesFixed {
            public SRand(Variable x, boolean antiHeuristic) {
                super(x, antiHeuristic);
            }

            @Override
            public double scoreOf(int a) {
                return this.x.pb.rs.random.nextDouble();
            }
        }

        public static class LetterFrequency
        extends HeuristicValuesFixed
        implements TagExperimental {
            private static int[] letterPositionsFr = new int[]{2, 17, 11, 10, 0, 16, 18, 19, 3, 20, 25, 8, 13, 5, 9, 12, 15, 6, 1, 4, 7, 14, 24, 21, 22, 23};

            public LetterFrequency(Variable x, boolean antiHeuristic) {
                super(x, antiHeuristic);
            }

            @Override
            public double scoreOf(int a) {
                return letterPositionsFr[a];
            }
        }
    }
}

