/*
 * Decompiled with CFR 0.152.
 */
package heuristics.revisions;

import heuristics.Heuristic;
import interfaces.TagMaximize;
import propagation.PropagationQueue;
import variables.Variable;

public abstract class HeuristicRevisions
extends Heuristic {
    protected final PropagationQueue queue;

    public HeuristicRevisions(PropagationQueue queue, boolean antiHeuristic) {
        super(antiHeuristic);
        this.queue = queue;
    }

    public abstract int bestPosition();

    public static abstract class HeuristicRevisionsDynamic
    extends HeuristicRevisions {
        public HeuristicRevisionsDynamic(PropagationQueue queue, boolean antiHeuristic) {
            super(queue, antiHeuristic);
        }

        protected abstract double scoreOf(Variable var1);

        @Override
        public int bestPosition() {
            int bestPos = 0;
            double bestScore = this.scoreOf(this.queue.var(0)) * (double)this.scoreCoeff;
            for (int i = 1; i <= this.queue.limit; ++i) {
                double score = this.scoreOf(this.queue.var(i)) * (double)this.scoreCoeff;
                if (!(score > bestScore)) continue;
                bestPos = i;
                bestScore = score;
            }
            return bestPos;
        }

        public static final class Lexico
        extends HeuristicRevisionsDynamic {
            public Lexico(PropagationQueue queue, boolean antiHeuristic) {
                super(queue, antiHeuristic);
            }

            @Override
            protected double scoreOf(Variable x) {
                return x.num;
            }
        }

        public static final class WDegOnDom
        extends HeuristicRevisionsDynamic
        implements TagMaximize {
            public WDegOnDom(PropagationQueue queue, boolean antiHeuristic) {
                super(queue, antiHeuristic);
            }

            @Override
            protected double scoreOf(Variable x) {
                return x.wdegOnDom();
            }
        }

        public static final class WDeg
        extends HeuristicRevisionsDynamic
        implements TagMaximize {
            public WDeg(PropagationQueue queue, boolean antiHeuristic) {
                super(queue, antiHeuristic);
            }

            @Override
            protected double scoreOf(Variable x) {
                return x.wdeg();
            }
        }

        public static final class DDegOnDom
        extends HeuristicRevisionsDynamic
        implements TagMaximize {
            public DDegOnDom(PropagationQueue queue, boolean antiHeuristic) {
                super(queue, antiHeuristic);
            }

            @Override
            protected double scoreOf(Variable x) {
                return x.ddegOnDom();
            }
        }

        public static final class DDeg
        extends HeuristicRevisionsDynamic
        implements TagMaximize {
            public DDeg(PropagationQueue queue, boolean antiHeuristic) {
                super(queue, antiHeuristic);
            }

            @Override
            protected double scoreOf(Variable x) {
                return x.ddeg();
            }
        }

        public static final class Dom
        extends HeuristicRevisionsDynamic {
            public Dom(PropagationQueue queue, boolean antiHeuristic) {
                super(queue, antiHeuristic);
            }

            @Override
            protected double scoreOf(Variable x) {
                return x.dom.size();
            }
        }
    }

    public static abstract class HeuristicRevisionsDirect
    extends HeuristicRevisions {
        public HeuristicRevisionsDirect(PropagationQueue queue, boolean dummy) {
            super(queue, dummy);
        }

        public static final class Rand
        extends HeuristicRevisionsDirect {
            public Rand(PropagationQueue queue, boolean dummy) {
                super(queue, dummy);
            }

            @Override
            public int bestPosition() {
                return this.queue.propagation.solver.rs.random.nextInt(this.queue.size());
            }
        }

        public static final class Last
        extends HeuristicRevisionsDirect {
            public Last(PropagationQueue queue, boolean dummy) {
                super(queue, dummy);
            }

            @Override
            public int bestPosition() {
                return this.queue.limit;
            }
        }

        public static final class First
        extends HeuristicRevisionsDirect {
            public First(PropagationQueue queue, boolean dummy) {
                super(queue, dummy);
            }

            @Override
            public int bestPosition() {
                return 0;
            }
        }
    }
}

