/*
 * Decompiled with CFR 0.152.
 */
package executables;

import constraints.hard.extension.structures.Bits;
import constraints.hard.extension.structures.ExtensionStructure;
import constraints.hard.intension.CtrEvaluationManager;
import dashboard.Arguments;
import dashboard.ControlPanel;
import dashboard.Output;
import executables.Extraction;
import executables.ResolutionVariants;
import heuristics.revisions.HeuristicRevisions;
import heuristics.values.HeuristicValues;
import heuristics.variables.HeuristicVariables;
import interfaces.ObserverConstruction;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.api.ProblemAPI;
import problem.Problem;
import problems.xcsp3.XCSP3;
import search.Solver;
import search.statistics.StatisticsMultiResolution;
import tools.output.Graphviz;
import utility.Enums;
import utility.Kit;
import utility.Reflector;
import utility.XMLManager;

public class Resolution
extends Thread {
    public static final String VERSION = "AbsCon 2";
    public static final int UNDEFINED = -10;
    private static Resolution[] resolutions;
    public HandlerClasses handlerClasses = new HandlerClasses();
    public final Kit.Stopwatch stopwatch = new Kit.Stopwatch();
    public final Kit.Stopwatch instanceStopwatch = new Kit.Stopwatch();
    public Problem problem;
    public Solver solver;
    public final ControlPanel cp;
    public final Output output;
    public final List<ObserverConstruction> observersConstruction = new ArrayList<ObserverConstruction>();
    public final Random random = new Random();
    private final StatisticsMultiResolution statisticsMultiresolution;
    public AtomicBoolean competitionLock = new AtomicBoolean();
    public Map<String, ExtensionStructure> mapOfExtensionStructures = new HashMap<String, ExtensionStructure>();
    public Map<String, CtrEvaluationManager> mapOfEvaluationManagers = new HashMap<String, CtrEvaluationManager>();
    public int instanceNumber;

    public static synchronized void saveMultithreadResultsFiles(Resolution resolution) {
        String fileName = resolution.output.save(resolution.stopwatch.getWckTime());
        if (fileName != null) {
            String variantParallelName = XMLManager.getAttValueFor(Arguments.lastArgument(), "variantParallel", "name");
            String resultsFileName = resolution.cp.settingXml.dirForCampaign;
            if (resultsFileName != "") {
                resultsFileName = resultsFileName + File.separator;
            }
            resultsFileName = resultsFileName + "results" + File.separator + resolution.output.outputFileNameFrom(resolution.problem.name(), variantParallelName);
            Kit.copy(fileName, resultsFileName);
            Document document = XMLManager.load(resultsFileName);
            XMLManager.modify(document, Enums.TypeOutput.RESOLUTIONS.toString(), "configurationFileName", variantParallelName);
            long totalWCKTime = 0L;
            long totalVisitedNodes = 0L;
            for (Resolution r : resolutions) {
                totalWCKTime += r.instanceStopwatch.getWckTime();
                totalVisitedNodes += r.solver.stats.nVisitedNodes;
            }
            Element root = document.getDocumentElement();
            Element multiThreadedResults = document.createElement("multithreadResults");
            multiThreadedResults.setAttribute("wck", Double.toString((double)totalWCKTime / 1000.0));
            multiThreadedResults.setAttribute("nVisitedNodes", Long.toString(totalVisitedNodes));
            root.appendChild(multiThreadedResults);
            Utilities.save(document, resultsFileName);
        }
    }

    public static boolean isAvailableIn() {
        try {
            return System.in.available() > 0;
        }
        catch (Throwable e) {
            return (Boolean)Kit.exit(e);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0 && !Resolution.isAvailableIn()) {
            new Resolution().cp.settings.display();
        } else {
            Arguments.loadArguments(args);
            String[] variants = ResolutionVariants.loadVariantNames();
            resolutions = new Resolution[variants.length];
            for (int i = 0; i < resolutions.length; ++i) {
                Resolution.resolutions[i] = new Resolution(variants[i]);
                Resolution.resolutions[i].start();
            }
        }
    }

    public void clearMapsUsedByConstraints() {
        this.mapOfExtensionStructures.clear();
        if (Bits.globalMap != null) {
            Bits.globalMap.clear();
        }
        this.mapOfEvaluationManagers.clear();
    }

    public boolean mustPreserveUnaryConstraints() {
        return this.cp.settingCtrs.preserveUnaryCtrs || this instanceof Extraction || this.cp.symmetryBreaking || this.cp.framework == Types.TypeFramework.MAXCSP;
    }

    public boolean isTimeExpiredForCurrentInstance() {
        return this.cp.setingGeneral.timeout <= this.instanceStopwatch.getWckTime();
    }

    public Resolution(String configurationFileName) {
        this.cp = ControlPanel.buildControlPanelFor(configurationFileName);
        this.output = new Output(this, configurationFileName);
        this.observersConstruction.add(this.output);
        this.statisticsMultiresolution = StatisticsMultiResolution.build(this);
    }

    public Resolution() {
        this((String)null);
    }

    public Problem buildProblem(int instanceNumber) {
        this.instanceNumber = instanceNumber;
        this.random.setSeed(this.cp.setingGeneral.seed + (long)instanceNumber);
        ProblemAPI api = null;
        try {
            if (Arguments.problemPackageName.equals(XCSP3.class.getName())) {
                api = (ProblemAPI)Reflector.buildObject(Arguments.problemPackageName);
            } else if (Arguments.problemPackageName.startsWith("problems")) {
                api = (ProblemAPI)Reflector.buildObject(Arguments.problemPackageName);
            } else {
                try {
                    api = (ProblemAPI)Reflector.buildObject("problems." + Arguments.problemPackageName);
                }
                catch (Exception e) {
                    api = (ProblemAPI)Reflector.buildObject(Arguments.problemPackageName);
                }
            }
        }
        catch (Exception e) {
            return (Problem)Kit.exit("The class " + Arguments.problemPackageName + " cannot be found.", e);
        }
        ControlPanel.SettingProblem settings = this.cp.settingProblem;
        this.problem = new Problem(api, settings.variant, settings.data, settings.dataFormat, settings.dataexport, Arguments.argsForPb, this);
        for (ObserverConstruction obs : this.observersConstruction) {
            obs.onConstructionProblemFinished();
        }
        return this.problem;
    }

    protected final Solver buildSolver(Problem problem) {
        Kit.log.config((problem.rs.cp.competitionMode ? "" : "\n") + "  " + "Solver " + this.cp.solving.clazz + " being built..." + (problem.rs.cp.competitionMode ? "\n" : ""));
        this.solver = Reflector.buildObject(this.cp.solving.clazz, Solver.class, this);
        for (ObserverConstruction obs : this.observersConstruction) {
            obs.onConstructionSolverFinished();
        }
        return this.solver;
    }

    private int[] localSearchAtPreprocessing() {
        int[] solution = null;
        this.cp.hardCoding.getClass();
        return solution;
    }

    protected void solveInstance(int instanceNumber) {
        this.clearMapsUsedByConstraints();
        this.observersConstruction.clear();
        this.observersConstruction.add(this.output);
        this.problem = this.buildProblem(instanceNumber);
        if (!this.cp.setingGeneral.saveNetworkGraph.equals("")) {
            Graphviz.saveGraph(this.problem, this.cp.setingGeneral.saveNetworkGraph);
        }
        this.problem.display();
        if (this.cp.competitionMode && this.problem.framework == Types.TypeFramework.COP) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AtomicBoolean atomicBoolean = Resolution.this.competitionLock;
                    synchronized (atomicBoolean) {
                        if (!Resolution.this.competitionLock.get()) {
                            Resolution.this.competitionLock.set(true);
                            System.out.println();
                            if (Resolution.this.solver.solManager.lastSolutionX == null) {
                                System.out.println("s UNKNOWN");
                            } else {
                                System.out.println("v " + Resolution.this.solver.solManager.lastSolutionX);
                                System.out.println("s SATISFIABLE");
                            }
                        }
                    }
                }
            });
        }
        if (this.cp.solving.enablePrepro || this.cp.solving.enableSearch) {
            int[] solution = this.localSearchAtPreprocessing();
            this.solver = this.buildSolver(this.problem);
            if (solution != null) {
                this.solver.solManager.storeSolution(solution);
            }
            this.solver.stoppingType = null;
            this.solver.solve();
            this.solver.solManager.displayFinalResults();
        }
    }

    @Override
    public void run() {
        this.stopwatch.start();
        Kit.log.config("\nAbsCon 2 " + Kit.dateOf(Resolution.class));
        boolean crashed = false;
        for (int i = 0; i < Arguments.nInstancesToSolve; ++i) {
            block6: {
                try {
                    crashed = false;
                    this.solveInstance(i);
                }
                catch (Throwable e) {
                    crashed = true;
                    Kit.log.warning("Instance with exception");
                    if (!this.cp.setingGeneral.makeExceptionsVisible) break block6;
                    e.printStackTrace();
                }
            }
            this.statisticsMultiresolution.update(crashed);
        }
        this.statisticsMultiresolution.outputGlobalStatistics();
        if (Arguments.multiThreads) {
            if (!crashed) {
                Resolution.saveMultithreadResultsFiles(this);
                System.exit(0);
            }
        } else {
            this.output.save(this.stopwatch.getWckTime());
        }
    }

    public static class HandlerClasses {
        private static final String DOT_CLASS = ".class";
        private static final String DOT_JAR = ".jar";
        public Map<Class<?>, Set<Class<?>>> map = new HashMap();

        private HandlerClasses() {
            this.loadClasses();
        }

        private boolean dealWith(Class<?> clazz, Class<?> rootClass) {
            if (rootClass.isAssignableFrom(clazz)) {
                this.map.computeIfAbsent(rootClass, r -> new HashSet()).add(clazz);
                return true;
            }
            return false;
        }

        private boolean dealWith(Class<?> clazz) {
            if (Modifier.isAbstract(clazz.getModifiers())) {
                return false;
            }
            return this.dealWith(clazz, HeuristicVariables.class) || this.dealWith(clazz, HeuristicValues.class) || this.dealWith(clazz, HeuristicRevisions.class);
        }

        private void loadRecursively(File directory, String packageName) throws ClassNotFoundException {
            packageName = packageName.startsWith(".") ? packageName.substring(1) : packageName;
            for (File file : directory.listFiles()) {
                if (file.isDirectory()) {
                    Kit.control(!file.getName().contains("."));
                    this.loadRecursively(file, packageName + "." + file.getName());
                    continue;
                }
                if (!file.getName().endsWith(DOT_CLASS) || file.getName().charAt(0) == '/') continue;
                this.dealWith(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - DOT_CLASS.length())));
            }
        }

        private void loadClasses() {
            try {
                block15: for (String classPathToken : System.getProperty("java.class.path", ".").split(File.pathSeparator)) {
                    if (!classPathToken.endsWith(DOT_JAR)) continue;
                    try {
                        JarInputStream jarFile = new JarInputStream(new FileInputStream(classPathToken));
                        Object object = null;
                        block16: while (true) {
                            try {
                                while (true) {
                                    JarEntry jarEntry;
                                    if ((jarEntry = jarFile.getNextJarEntry()) == null) {
                                        continue block15;
                                    }
                                    if (!jarEntry.getName().endsWith(DOT_CLASS)) continue;
                                    try {
                                        String s = jarEntry.getName().replaceAll("/", "\\.");
                                        this.dealWith(Class.forName(s.substring(0, s.lastIndexOf("."))));
                                        continue block16;
                                    }
                                    catch (Throwable e) {
                                        Kit.log.fine("Impossible to load" + jarEntry.getName());
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Throwable jarEntry) {
                                object = jarEntry;
                                throw jarEntry;
                            }
                        }
                        finally {
                            if (jarFile != null) {
                                if (object != null) {
                                    try {
                                        jarFile.close();
                                    }
                                    catch (Throwable jarEntry) {
                                        ((Throwable)object).addSuppressed(jarEntry);
                                    }
                                } else {
                                    jarFile.close();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                for (Package p : Package.getPackages()) {
                    for (URL url : Collections.list(classLoader.getResources(p.getName().replace('.', '/')))) {
                        if (!url.getProtocol().equals("file") || !new File(url.getFile()).exists()) continue;
                        this.loadRecursively(new File(url.getFile()), p.getName());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            String s = "";
            for (Map.Entry<Class<?>, Set<Class<?>>> entry : this.map.entrySet()) {
                s = s + entry.getKey() + " : " + entry.getValue().stream().map(c -> c.getName()).collect(Collectors.joining(" ")) + "\n";
            }
            return s;
        }
    }
}

