/*
 * Decompiled with CFR 0.152.
 */
package dashboard;

import constraints.Constraint;
import executables.Resolution;
import interfaces.ObserverConstruction;
import interfaces.ObserverRuns;
import interfaces.ObserverSearch;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xcsp.common.Utilities;
import problem.ProblemStuff;
import propagation.order1.AC;
import utility.Enums;
import utility.Kit;
import utility.XMLManager;

public class Output
implements ObserverConstruction,
ObserverSearch,
ObserverRuns {
    public static final String RESULTS_DIRECTORY_NAME = "results";
    public static final String CONFIGURATION_DIRECTORY_NAME = "configurations";
    public static final String CONTEXT_DIRECTORY_NAME = "context";
    public static final String MULTITHREAD_RESULTS = "multithreadResults";
    public static final String CONFIGURATION_FILE_NAME = "configurationFileName";
    public static final String TOTAL_WCK_TIME = "totalWckTime";
    public static final String TOTAL_CPU_TIME = "totalCpuTime";
    public static final String LEVEL = "level";
    public static final String OBJECTIVE = "objective";
    public static final String NUMBER = "number";
    public static final String FRAMEWORK = "framework";
    public static final String NAME = "name";
    public static final String PARAMETERS = "parameters";
    public static final String N_VARIABLES = "nVariables";
    public static final String N_DISCARDED_VARIABLES = "nDiscardedVariables";
    public static final String N_DOMAIN_TYPES = "nDomainTypes";
    public static final String N_CONSTRAINTS = "nConstraints";
    public static final String N_DISCARDED_CONSTRAINTS = "nDiscardedConstraints";
    public static final String N_RELATION_TYPES = "nRelationTypes";
    public static final String N_PRESENT_UNARY_CONSTRAINTS = "nPresentUnaryConstraints";
    public static final String N_REMOVED_UNARY_CONSTRAINTS = "nRemovedUnaryConstraints";
    public static final String N_IGNORED_UNARY_CONSTRAINTS = "nIgnoredUnaryConstraints";
    public static final String N_GLOBAL_CONSTRAINTS = "nGlobalConstraints";
    public static final String N_SPECIFIC_CONSTRAINTS = "nSpecificConstraints";
    public static final String N_MERGED_CONSTRAINTS = "nMergedConstraints";
    public static final String N_UNIVERSAL_CONSTRAINTS = "nUniversalConstraints";
    public static final String N_ADDED_CONSTRAINTS = "nAddedConstraints";
    public static final String N_ISOLATED_VARIABLES = "nIsolatedVariables";
    public static final String N_FIXED_VARIABLES = "nFixedVariables";
    public static final String N_VALUES_REMOVED_AT_CONSTRUCTION = "nValuesRemovedAtConstruction";
    public static final String N_PURGED_VALUES = "nPurgedValues";
    public static final String N_CONFLICTS_STRUCTURES = "nConflictsStructures";
    public static final String N_SHARED_CONFLICTS_STRUCTURES = "nSharedConflictsStructures";
    public static final String N_UNBUILT_CONFLICTS_STRUCTURES = "nUnbuiltConflictsStructures";
    public static final String N_EXTENSION_STRUCTURES = "nExtensionStructures";
    public static final String N_SHARED_EXTENSION_STRUCTURES = "nSharedExtensionStructures";
    public static final String N_SHARED_BINARY_REPRESENTATIONS = "nSharedBinaryRepresentations";
    public static final String N_CONVERTED_CONSTRAINTS = "nConvertedConstraints";
    public static final String N_CONVERT_CONSTRAINTS_CHECKS = "nConvertConstraintsChecks";
    public static final String N_EVALUATION_MANAGERS = "nEvaluationManagers";
    public static final String N_SHARED_EVALUATION_MANAGERS = "nSharedEvaluationManagers";
    public static final String MIN_DEGREE = "minDegree";
    public static final String DEGREES = "degrees";
    public static final String MAX_DEGREE = "maxDegree";
    public static final String DOMAIN_SIZES = "domainSizes";
    public static final String N_TOTAL_VALUES = "nTotalValues";
    public static final String ARITIES = "arities";
    public static final String MAX_CONSTRAINT_TUPLES = "maxConstraintTuples";
    public static final String TYPES = "types";
    public static final String TABLES = "tables";
    public static final String DEFAULT_COSTS = "defaultCosts";
    public static final String N_TOTAL_TUPLES = "nTotalTuples";
    public static final String TOTAL_INITIAL_SPACE = "totalInitialSpace";
    public static final String TOTAL_REDUCED_SPACE = "totalReducedSpace";
    public static final String WCK_MINING = "wckMining";
    public static final String COMPRESSION = "compression";
    public static final String WCK = "wck";
    public static final String CPU = "cpu";
    public static final String MEM = "mem";
    public static final String FREE_MEMORY = "freeMemory";
    public static final String MAX_MEMORY = "maxMemory";
    public static final String ALLOCATED_MEMORY = "allocatedMemory";
    public static final String GUARANTEED_GAC = "guaranteedGAC";
    public static final String N_CONSTRAINT_CHECKS = "nConstraintChecks";
    public static final String N_INITIAL_CHECKS = "nInitialChecks";
    public static final String N_RESTORATIONS = "nRestorations";
    public static final String DEPTH = "depth";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String AVG = "avg";
    public static final String N_EFFECTIVE_FILTERINGS = "nEffectivePFilterings";
    public static final String N_REVISIONS = "nRevisions";
    public static final String N_USELESS_REVISIONS = "nUselessRevisions";
    public static final String N_SINGLETON_TESTS = "nSingletonTests";
    public static final String N_EFFECTIVE_SINGLETON_TESTS = "nEffectiveSingletonTests";
    public static final String N_NC_REMOVALS = "nNCRemovals";
    public static final String N_AC_REMOVALS = "nACRemovals";
    public static final String N_SUB_REMOVALS = "nSUBRemovals";
    public static final String AVG_SUB_REMOVALS = "avgSUBRemovals";
    public static final String N_FOUND_SINGLETONS = "nFoundSingletons";
    public static final String N_BUILT_BRANCHES = "nBuiltBranches";
    public static final String SUM_BRANCH_SIZES = "sumBranchSizes";
    public static final String N_REMOVED_VALUES = "nRemovedValues";
    public static final String N_REMOVED_TUPLES = "nRemovedTuples";
    public static final String N_VALID_SUPPORTS = "nValidSupports";
    public static final String DETECTED_INCONSISTENCY = "detectedInconsistency";
    public static final String GLOBAL_CPU_TIME = "globalCpuTime";
    public static final String RUN = "run";
    public static final String N_ASSIGNMENTS = "nAssignments";
    public static final String N_FAILED_ASSIGNMENTS = "nFailedAssignments";
    public static final String AVG_FAILED_DEPTH = "avgFailedDepth";
    public static final String N_WRONG = "wrong";
    public static final String N_BACKTRACKS = "nBacktracks";
    public static final String N_VISITED_NODES = "nVisitedNodes";
    public static final String N_ADDED_NOGOODS = "nAddedNogoods";
    public static final String N_INFERRED_BACKTRACKS = "nInferredBacktracks";
    public static final String N_INFERRED_REMOVALS = "nInferredRemovals";
    public static final String MAP_SIZE = "mapSize";
    public static final String N_INFERENCES = "nInferences";
    public static final String N_TOO_LARGE_KEYS = "nTooLargeKeys";
    public static final String N_SELIMINABLES = "nSEliminables";
    public static final String N_RELIMINABLES = "nREliminables";
    public static final String N_DELIMINABLES = "nDEliminables";
    public static final String N_IELIMINABLES = "nIEliminables";
    public static final String N_PELIMINABLES = "nPEliminables";
    public static final String N_FILTER_CALLS = "nFilterCalls";
    public static final String AVG_TABLE_PROPORTION = "avgTableProportion";
    public static final String AVG_TABLE_SIZE = "avgTableSize";
    public static final String WALL_CLOCK_TIME_TO_BUILD_PROBLEM = "wckTimeToBuildProblem";
    public static final String WALL_CLOCK_TIME_TO_BUILD_SOLVER = "wckTimeToBuildSolver";
    public static final String BUILDING_CPU_TIME = "buildingCpuTime";
    public static final String BUILDING_WALL_CLOCK_TIME = "buildingWckTime";
    public static final String N_GENERATORS = "nGenerators";
    public static final String SYMMETRY_CPU_TIME = "symmetryCpuTime";
    public static final String SYMMETRY_WALL_CLOCK_TIME = "symmetryWckTime";
    public static final String N_CLIQUES = "nCliques";
    public static final String SOLVING_CPU_TIME = "solvingCpuTime";
    public static final String SOLVING_WALL_CLOCK_TIME = "solvingWckTime";
    public static final String FIRST_SOLUTION_CPU_TIME = "firstSolutionCpuTime";
    public static final String FIRST_SOLUTION_WALL_CLOCK_TIME = "firstSolutionWckTime";
    public static final String EXPIRED_TIME = "expiredTime";
    public static final String TOTAL_EXPLORATION = "totalExploration";
    public static final String N_FOUND_SOLUTIONS = "foundSolutions";
    public static final String BEST_BOUND = "bestBound";
    public static final String BEST_BOUND_CPU_TIME = "bestBoundCpuTime";
    public static final String BEST_BOUND_WALL_CLOCK_TIME = "bestBoundWckTime";
    public static final String STOP = "Stop";
    public static final String N_INSTANCES = "nInstances";
    public static final String PREPRO_CPU_TIME = "preproCpuTime";
    public static final String PREPRO_WCK_TIME = "preproWckTime";
    public static final String SEARCH_CPU_TIME = "searchCpuTime";
    public static final String SEARCH_WCK_TIME = "searchWckTime";
    public static final String MEDIAN_CPU_TIME = "medianCpuTime";
    public static final String N_PREPRO_INCONSISTENCIES = "nPreproInconsistencies";
    public static final String GLOBAL_TIME = "globalTime";
    public static final String MODE = "mode";
    public static final String N_RUNS = "nRuns";
    public static final String N_CORES = "nCores";
    public static final String N_VAVG = "nVAvg";
    public static final String N_CAVG = "nCAvg";
    public static final String LAST_CORES = "lastCores";
    public static final String DATA_SEPARATOR = "  ";
    private final Resolution resolution;
    private Document document;
    private Element root;
    private Element resolElt;
    private Element solverElt;
    private String outputFileName;
    public static final String COMMENT_PREFIX = "  ";

    public static String getOutputFileNamePrefixFrom(String fullInstanceName, String fullConfigurationName) {
        return Kit.getRawInstanceName(fullInstanceName) + (fullConfigurationName != null ? "_" + Kit.getXMLBaseNameOf(fullConfigurationName) + "_" : "");
    }

    public Output(Resolution resolution, String configFileName) {
        this.resolution = resolution;
        if (!resolution.cp.settingXml.dirForCampaign.equals("")) {
            this.document = XMLManager.createNewDocument();
            this.root = this.document.createElement(Enums.TypeOutput.RESOLUTIONS.toString());
            this.root.setAttribute(CONFIGURATION_FILE_NAME, configFileName);
            this.document.appendChild(this.root);
            this.document.normalize();
        }
    }

    public String outputFileNameFrom(String fullInstanceName, String configurationFileName) {
        String hostName = "unknown";
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return Output.getOutputFileNamePrefixFrom(fullInstanceName, configurationFileName) + hostName + "_" + Kit.getFormattedCurrentDate() + ".xml";
    }

    public Element record(Enums.TypeOutput output, Collection<Map.Entry<String, Object>> entries, Element parent) {
        if (this.document == null) {
            return null;
        }
        Element child = Utilities.element(this.document, output.toString(), entries);
        if (parent == null) {
            this.root.appendChild(child);
        } else {
            parent.appendChild(child);
        }
        return child;
    }

    public void beforeLoading() {
        ProblemStuff.MapAtt ia = this.resolution.problem.stuff.instanceAttributes(this.resolution.instanceNumber);
        if (this.outputFileName == null) {
            String name = ia.entries().stream().filter(e -> ((String)e.getKey()).equals(NAME)).map(e -> e.getValue().toString()).findFirst().get();
            this.outputFileName = this.outputFileNameFrom(name, this.resolution.cp.settingsFilename);
        }
        Kit.log.config(ia.toString());
        if (this.document != null) {
            this.resolElt = this.record(Enums.TypeOutput.RESOLUTION, null, this.root);
            this.record(Enums.TypeOutput.INSTANCE, ia.entries(), this.resolElt);
            this.save(this.resolution.instanceStopwatch.getWckTime());
        }
    }

    @Override
    public void onConstructionProblemFinished() {
        Kit.control(this.resolution.problem.variables.length > 0, () -> "No variable in your model");
        ProblemStuff.MapAtt da = this.resolution.problem.stuff.domainsAttributes();
        ProblemStuff.MapAtt va = this.resolution.problem.stuff.variablesAttributes();
        ProblemStuff.MapAtt oa = this.resolution.problem.optimizationPilot != null ? this.resolution.problem.stuff.objsAttributes() : null;
        ProblemStuff.MapAtt ca = this.resolution.problem.stuff.ctrsAttributes();
        this.record(Enums.TypeOutput.DOMAINS, da.entries(), this.resolElt);
        this.record(Enums.TypeOutput.VARIABLES, va.entries(), this.resolElt);
        if (oa != null) {
            this.record(Enums.TypeOutput.OBJECTIVES, oa.entries(), this.resolElt);
        }
        this.record(Enums.TypeOutput.CONSTRAINTS, ca.entries(), this.resolElt);
        Kit.log.config("\n\n" + da.toString());
        Kit.log.config(va.toString());
        if (oa != null) {
            Kit.log.config(oa.toString());
        }
        Kit.log.config(ca.toString());
    }

    @Override
    public void onConstructionSolverFinished() {
        ProblemStuff.MapAtt sa = new ProblemStuff.MapAtt("Solver");
        if (this.resolution.solver.propagation.getClass() == AC.class) {
            sa.put(GUARANTEED_GAC, Constraint.isGuaranteedGACOn(this.resolution.problem.constraints));
        }
        sa.separator();
        sa.put(WCK, (double)this.resolution.instanceStopwatch.getWckTime() / 1000.0);
        sa.put(CPU, this.resolution.stopwatch.getCpuTimeInSeconds());
        sa.put(MEM, Kit.getFormattedUsedMemorySize());
        this.solverElt = this.record(Enums.TypeOutput.SOLVER, sa.entries(), this.resolElt);
        Kit.log.config("\n" + sa.toString());
    }

    @Override
    public final void afterPreprocessing() {
        ProblemStuff.MapAtt pa = this.resolution.solver.stats.preproAttributes();
        this.record(Enums.TypeOutput.PREPROCESSING, pa.entries(), this.solverElt);
        Kit.log.config("\n" + pa.toString() + "\n");
    }

    @Override
    public final void afterRun() {
        ProblemStuff.MapAtt ra = this.resolution.solver.stats.runAttributes();
        this.record(Enums.TypeOutput.RUN, ra.entries(), this.solverElt);
        Kit.log.config(ra.toString());
    }

    @Override
    public final void afterSolving() {
        ProblemStuff.MapAtt ga = this.resolution.solver.stats.globalAttributes();
        this.record(Enums.TypeOutput.GLOBAL, ga.entries(), this.solverElt);
        Kit.log.config(ga.toString());
    }

    public String save(long totalWck) {
        if (this.document == null) {
            return null;
        }
        this.root.setAttribute(TOTAL_WCK_TIME, totalWck + "");
        String dirName = this.resolution.cp.settingXml.dirForCampaign + File.separator + RESULTS_DIRECTORY_NAME;
        File file = new File(dirName);
        if (!file.exists()) {
            file.mkdirs();
        }
        return Utilities.save(this.document, dirName + File.separator + this.outputFileName);
    }
}

