/*
 * Decompiled with CFR 0.152.
 */
package dashboard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;
import problems.xcsp3.XCSP3;
import utility.Kit;
import utility.XMLManager;

public final class Arguments {
    private static final String SETTING_VALUE_PREFIX = "-";
    public static final String DEFAULT_PROBLEMS_PREFIX = "problems";
    public static String[] args;
    public static String[] argsForPb;
    public static final Map<String, String> argsForCp;
    public static boolean multiThreads;
    public static String userSettingsFilename;
    public static String problemPackageName;
    public static int nInstancesToSolve;

    public static String lastArgument() {
        return args[args.length - 1];
    }

    private static int nInstancesToSolveFrom(String token) {
        try {
            if (token.toLowerCase().equals("all")) {
                nInstancesToSolve = Integer.MAX_VALUE;
                return 1;
            }
            if (Utilities.isInteger(token)) {
                int number = Integer.parseInt(token);
                Kit.control(number == -1 || number > 0, () -> "invalid number of instances");
                nInstancesToSolve = number == -1 ? Integer.MAX_VALUE : number;
                return 1;
            }
            nInstancesToSolve = 1;
            return 0;
        }
        catch (NumberFormatException e) {
            return (Integer)Kit.exit("The number of instances to be solved must be a positive  integer, -1 or all (" + token + " is not valid )", e);
        }
    }

    public static void loadArguments(String ... args) {
        argsForCp.clear();
        args = (String[])Stream.of(args).filter(s -> s.length() > 0).toArray(String[]::new);
        Kit.control(args.length > 0);
        Arguments.args = args;
        multiThreads = XMLManager.isXMLFileWithRoot(args[args.length - 1], "variantParallel");
        int cursor = 0;
        userSettingsFilename = XMLManager.isXMLFileWithRoot(args[cursor], "configuration") ? args[cursor++] : "defaultConfiguration";
        cursor += Arguments.nInstancesToSolveFrom(args[cursor]);
        Kit.control(!multiThreads || nInstancesToSolve == 1);
        Kit.control(cursor < args.length && !args[cursor].startsWith(SETTING_VALUE_PREFIX), () -> "The package name or (for XCSP) the instance file name is missing.");
        problemPackageName = args[cursor].endsWith(".xml") || args[cursor].endsWith(".lzma") ? XCSP3.class.getName() : args[cursor++];
        ArrayList<String> list = new ArrayList<String>();
        while (cursor < args.length && (!args[cursor].startsWith(SETTING_VALUE_PREFIX) || Utilities.isInteger(args[cursor]))) {
            list.add(args[cursor++]);
        }
        argsForPb = list.toArray(new String[list.size()]);
        HashSet<String> setOfUserKeys = new HashSet<String>();
        while (cursor < args.length) {
            String key;
            String arg = args[cursor];
            Kit.control(arg.startsWith(SETTING_VALUE_PREFIX), () -> arg + " is not put at the right position");
            int equalPosition = arg.indexOf(61);
            String string = key = equalPosition > 1 ? arg.substring(1, equalPosition) : arg.substring(1);
            String value = equalPosition > 1 ? (equalPosition == arg.length() - 1 ? "" : arg.substring(equalPosition + 1)) : "true";
            Kit.control(!setOfUserKeys.contains(key), () -> "The configuration key " + key + " appears several times.");
            argsForCp.put(key, value);
            setOfUserKeys.add(key);
            ++cursor;
        }
    }

    public static void loadArguments(String[] args, String ... otherArgs) {
        Arguments.loadArguments((String[])Stream.concat(Arrays.stream(args), Arrays.stream(otherArgs)).toArray(String[]::new));
    }

    static {
        argsForCp = new HashMap<String, String>(256);
        nInstancesToSolve = 1;
    }
}

