/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.primitive;

import constraints.hard.primitive.CtrPrimitive;
import interfaces.TagGACGuaranteed;
import interfaces.TagSymmetric;
import interfaces.TagUnsymmetric;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.modeler.entities.CtrEntities;
import problem.Problem;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public abstract class CtrPrimitiveBinary
extends CtrPrimitive
implements TagGACGuaranteed {
    protected final Variable x;
    protected final Variable y;
    protected final Domain dx;
    protected final Domain dy;

    public CtrPrimitiveBinary(Problem pb, Variable x, Variable y) {
        super(pb, (Variable[])pb.api.vars(x, y));
        this.x = x;
        this.y = y;
        this.dx = x.dom;
        this.dy = y.dom;
    }

    public static abstract class CtrPrimitiveBinaryDist
    extends CtrPrimitiveBinary
    implements TagSymmetric {
        protected final int k;

        public static CtrEntities.CtrAlone buildFrom(Problem pb, Variable x, Variable y, Types.TypeConditionOperatorRel op, int k) {
            if (op == Types.TypeConditionOperatorRel.LT) {
                return pb.extension(XNodeParent.lt(XNodeParent.dist(x, y), k));
            }
            if (op == Types.TypeConditionOperatorRel.LE) {
                return pb.extension(XNodeParent.le(XNodeParent.dist(x, y), k));
            }
            if (op == Types.TypeConditionOperatorRel.GE) {
                return pb.addCtr(new DistGE(pb, x, y, k), new Types.TypeClass[0]);
            }
            if (op == Types.TypeConditionOperatorRel.GT) {
                return pb.addCtr(new DistGE(pb, x, y, k + 1), new Types.TypeClass[0]);
            }
            if (op == Types.TypeConditionOperatorRel.EQ) {
                return pb.extension(XNodeParent.eq(XNodeParent.dist(x, y), k));
            }
            Kit.control(op == Types.TypeConditionOperatorRel.NE, () -> "pb");
            return pb.addCtr(new DistNE(pb, x, y, k), new Types.TypeClass[0]);
        }

        public CtrPrimitiveBinaryDist(Problem pb, Variable x, Variable y, int k) {
            super(pb, x, y);
            this.k = k;
            this.defineKey(k);
            Utilities.control(k >= 0, "k should be positive");
        }

        public static class DistNE
        extends CtrPrimitiveBinaryDist {
            @Override
            public final boolean checkValues(int[] t) {
                return Math.abs(t[0] - t[1]) != this.k;
            }

            public DistNE(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            private boolean revise(Domain dom1, Domain dom2) {
                if (dom1.size() == 1) {
                    return dom2.removeValue(dom1.uniqueValue() - this.k, false) && dom2.removeValue(dom1.uniqueValue() + this.k, false);
                }
                if (dom1.size() == 2 && dom1.lastValue() - dom1.firstValue() == 2 * this.k) {
                    return dom2.removeValue(dom1.lastValue() - this.k, false);
                }
                return true;
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return this.revise(this.dx, this.dy) && this.revise(this.dy, this.dx);
            }
        }

        public static class DistGE
        extends CtrPrimitiveBinaryDist {
            @Override
            public boolean checkValues(int[] t) {
                return Math.abs(t[0] - t[1]) >= this.k;
            }

            public DistGE(Problem pb, Variable x, Variable y, int k) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                int stop;
                int start = this.dy.lastValue() - this.k + 1;
                if (start < (stop = this.dy.firstValue() + this.k) && !this.dx.removeValues(Types.TypeConditionOperatorSet.IN, start, stop)) {
                    return false;
                }
                start = this.dx.lastValue() - this.k + 1;
                return start >= (stop = this.dx.firstValue() + this.k) || this.dy.removeValues(Types.TypeConditionOperatorSet.IN, start, stop);
            }
        }
    }

    public static abstract class CtrPrimitiveBinaryAdd
    extends CtrPrimitiveBinary {
        protected final int k;

        public static CtrEntities.CtrAlone buildFrom(Problem pb, Variable x, int k, Types.TypeConditionOperatorRel op, Variable y) {
            if (op == Types.TypeConditionOperatorRel.LT) {
                return pb.addCtr(new LE(pb, x, k + 1, y), new Types.TypeClass[0]);
            }
            if (op == Types.TypeConditionOperatorRel.LE) {
                return pb.addCtr(new LE(pb, x, k, y), new Types.TypeClass[0]);
            }
            if (op == Types.TypeConditionOperatorRel.GE) {
                return pb.addCtr(new GE(pb, x, k, y), new Types.TypeClass[0]);
            }
            if (op == Types.TypeConditionOperatorRel.GT) {
                return pb.addCtr(new GE(pb, x, k - 1, y), new Types.TypeClass[0]);
            }
            if (op == Types.TypeConditionOperatorRel.EQ) {
                return pb.extension(XNodeParent.eq(XNodeParent.add(x, k), y));
            }
            Kit.control(op == Types.TypeConditionOperatorRel.NE, () -> "pb");
            return pb.addCtr(new NE(pb, x, k, y), new Types.TypeClass[0]);
        }

        public CtrPrimitiveBinaryAdd(Problem pb, Variable x, Variable y, int k) {
            super(pb, x, y);
            this.k = k;
            this.defineKey(k);
        }

        public static final class NE
        extends CtrPrimitiveBinaryAdd {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] + this.k != t[1];
            }

            public NE(Problem pb, Variable x, int k, Variable y) {
                super(pb, x, y, k);
            }

            @Override
            public Boolean isSymmetric() {
                return this.k == 0;
            }

            @Override
            public int giveUpperBoundOfMaxNumberOfConflictsFor(Variable x, int a) {
                return 1;
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (this.dx.size() == 1 && !this.dy.removeValue(this.dx.uniqueValue() + this.k, false)) {
                    return false;
                }
                return this.dy.size() != 1 || this.dx.removeValue(this.dy.uniqueValue() - this.k, false);
            }
        }

        public static final class EQ
        extends CtrPrimitiveBinaryAdd {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] + this.k == t[1];
            }

            public EQ(Problem pb, Variable x, int k, Variable y) {
                super(pb, x, y, k);
            }

            @Override
            public Boolean isSymmetric() {
                return this.k == 0;
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                if (!this.dx.removeValues(Types.TypeConditionOperatorSet.NOTIN, this.dy, -this.k)) {
                    return false;
                }
                assert (this.dx.size() <= this.dy.size());
                if (this.dy.size() == this.dx.size()) {
                    return true;
                }
                boolean consistent = this.dy.removeValues(Types.TypeConditionOperatorSet.NOTIN, this.dx, this.k);
                assert (consistent);
                return true;
            }
        }

        public static class GE
        extends CtrPrimitiveBinaryAdd
        implements TagUnsymmetric {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] + this.k >= t[1];
            }

            public GE(Problem pb, Variable x, int k, Variable y) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return this.dx.removeValues(Types.TypeOperatorRel.LT, this.dy.firstValue() - this.k) && this.dy.removeValues(Types.TypeOperatorRel.GT, this.dx.lastValue() + this.k);
            }
        }

        public static class LE
        extends CtrPrimitiveBinaryAdd
        implements TagUnsymmetric {
            @Override
            public final boolean checkValues(int[] t) {
                return t[0] + this.k <= t[1];
            }

            public LE(Problem pb, Variable x, int k, Variable y) {
                super(pb, x, y, k);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                return this.dx.removeValues(Types.TypeOperatorRel.GT, this.dy.lastValue() - this.k) && this.dy.removeValues(Types.TypeOperatorRel.LT, this.dx.firstValue() + this.k);
            }
        }
    }

    public static class Disjonctive
    extends CtrPrimitiveBinary {
        private final int kx;
        private final int ky;

        @Override
        public boolean checkValues(int[] t) {
            return t[0] + this.kx <= t[1] || t[1] + this.ky <= t[0];
        }

        @Override
        public Boolean isSymmetric() {
            return this.kx == this.ky;
        }

        public Disjonctive(Problem pb, Variable x, int kx, Variable y, int ky) {
            super(pb, x, y);
            this.kx = kx;
            this.ky = ky;
            this.defineKey(kx, ky);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            int stop;
            int start = this.dy.lastValue() - this.kx + 1;
            if (start < (stop = this.dy.firstValue() + this.ky) && !this.dx.removeValues(Types.TypeConditionOperatorSet.IN, start, stop)) {
                return false;
            }
            start = this.dx.lastValue() - this.ky + 1;
            return start >= (stop = this.dx.firstValue() + this.kx) || this.dy.removeValues(Types.TypeConditionOperatorSet.IN, start, stop);
        }
    }
}

