/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import interfaces.TagFilteringCompleteAtEachCall;
import interfaces.TagGACGuaranteed;
import java.util.ArrayList;
import java.util.List;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.TreeEvaluator;
import org.xcsp.common.predicates.XNodeParent;
import problem.Problem;
import utility.Kit;
import variables.Variable;
import variables.VariableInteger;

public class SeqBin
extends CtrGlobal
implements TagGACGuaranteed,
TagFilteringCompleteAtEachCall {
    protected final Variable k;
    protected final Variable[] vector;
    protected final TreeEvaluator[] c;
    protected final TreeEvaluator[] b;
    protected final int smallestDomVal;
    private final int[] evaluatedValues = new int[2];
    protected final List<Integer> idxsToPrune = new ArrayList<Integer>();
    protected final CostSet[][] totalCosts;
    protected final CostSet[][] forwardCosts;
    protected final CostSet[][] backwardCosts;
    protected final CostSet costSetOfK;

    public SeqBin(Problem pb, VariableInteger k, VariableInteger[] vector, Types.TypeConditionOperatorRel cOp, Types.TypeConditionOperatorRel bOp) {
        super(pb, (Variable[])pb.api.vars(k, vector));
        int varPos;
        Kit.control(Variable.haveAllSameDomainType(vector));
        k.dom.removeValues(Types.TypeOperatorRel.LT, 1);
        k.dom.removeValues(Types.TypeOperatorRel.GT, vector.length);
        this.k = k;
        this.vector = vector;
        this.c = new TreeEvaluator[vector.length - 1];
        Types.TypeExpr ce = Types.valueOf(Types.TypeExpr.class, cOp.toString());
        int smallestDomVal = vector[vector.length - 1].dom.firstValue();
        int greatestDomVal = vector[vector.length - 1].dom.firstValue();
        for (varPos = 0; varPos < vector.length - 1; ++varPos) {
            XNodeParent<IVar> tree = XNodeParent.build(ce, vector[varPos], vector[varPos + 1]);
            this.c[varPos] = new TreeEvaluator(tree);
            if (smallestDomVal > vector[varPos].dom.firstValue()) {
                smallestDomVal = vector[varPos].dom.firstValue();
            }
            if (greatestDomVal >= vector[varPos].dom.lastValue()) continue;
            greatestDomVal = vector[varPos].dom.lastValue();
        }
        if (bOp == null) {
            this.b = null;
        } else {
            this.b = new TreeEvaluator[vector.length - 1];
            Types.TypeExpr be = Types.valueOf(Types.TypeExpr.class, bOp.toString());
            for (int i = 0; i < this.b.length; ++i) {
                XNodeParent<IVar> tree = XNodeParent.build(be, vector[i], vector[i + 1]);
                this.b[i] = new TreeEvaluator(tree);
            }
        }
        this.smallestDomVal = smallestDomVal;
        this.totalCosts = new CostSet[vector.length][];
        this.forwardCosts = new CostSet[vector.length][];
        this.backwardCosts = new CostSet[vector.length][];
        for (varPos = 0; varPos < vector.length; ++varPos) {
            this.totalCosts[varPos] = new CostSet[greatestDomVal - smallestDomVal + 1];
            this.forwardCosts[varPos] = new CostSet[greatestDomVal - smallestDomVal + 1];
            this.backwardCosts[varPos] = new CostSet[greatestDomVal - smallestDomVal + 1];
            for (int valPos = 0; valPos < this.totalCosts[varPos].length; ++valPos) {
                this.totalCosts[varPos][valPos] = new CostSet(vector.length);
                this.forwardCosts[varPos][valPos] = new CostSet(vector.length);
                this.backwardCosts[varPos][valPos] = new CostSet(vector.length);
            }
        }
        this.costSetOfK = new CostSet(vector.length);
    }

    @Override
    public int[] defineSymmetryMatching() {
        return Kit.range(1, this.scp.length);
    }

    @Override
    public boolean checkValues(int[] vals) {
        if (this.b != null) {
            for (int evalPos = 0; evalPos < this.b.length; ++evalPos) {
                if (this.evaluate(this.b[evalPos], vals[evalPos + 1], vals[evalPos + 2]) == 1L) continue;
                return false;
            }
        }
        return this.checkNumberOfCViolations(vals);
    }

    @Override
    public boolean runPropagator(Variable evt) {
        if (!this.propagateBConstraints()) {
            return false;
        }
        this.pathDP();
        if (!this.pruneK()) {
            return false;
        }
        return this.pruneVector();
    }

    protected boolean checkNumberOfCViolations(int[] vals) {
        int cnt = 1;
        for (int evalPos = 0; evalPos < this.c.length; ++evalPos) {
            cnt = (int)((long)cnt + this.evaluate(this.c[evalPos], vals[evalPos + 1], vals[evalPos + 2]));
        }
        return cnt == vals[0];
    }

    protected long evaluate(TreeEvaluator eval, int operand1, int operand2) {
        this.evaluatedValues[0] = operand1;
        this.evaluatedValues[1] = operand2;
        return eval.evaluate(this.evaluatedValues);
    }

    protected boolean propagateBConstraints() {
        if (this.b != null) {
            int varPos;
            for (varPos = 1; varPos < this.vector.length; ++varPos) {
                this.idxsToPrune.clear();
                int idx = this.vector[varPos].dom.first();
                while (idx != -1) {
                    boolean support = false;
                    int idxPrev = this.vector[varPos - 1].dom.first();
                    while (idxPrev != -1) {
                        if (this.evaluate(this.b[varPos - 1], this.vector[varPos - 1].dom.toVal(idxPrev), this.vector[varPos].dom.toVal(idx)) == 1L) {
                            support = true;
                            break;
                        }
                        idxPrev = this.vector[varPos - 1].dom.next(idxPrev);
                    }
                    if (!support) {
                        this.idxsToPrune.add(idx);
                    }
                    idx = this.vector[varPos].dom.next(idx);
                }
                for (Integer idx2 : this.idxsToPrune) {
                    if (this.vector[varPos].dom.remove(idx2)) continue;
                    return false;
                }
            }
            for (varPos = this.vector.length - 2; varPos >= 0; --varPos) {
                this.idxsToPrune.clear();
                int idx = this.vector[varPos].dom.first();
                while (idx != -1) {
                    boolean support = false;
                    int idxNext = this.vector[varPos + 1].dom.first();
                    while (idxNext != -1) {
                        if (this.evaluate(this.b[varPos], this.vector[varPos].dom.toVal(idx), this.vector[varPos + 1].dom.toVal(idxNext)) == 1L) {
                            support = true;
                            break;
                        }
                        idxNext = this.vector[varPos + 1].dom.next(idxNext);
                    }
                    if (!support) {
                        this.idxsToPrune.add(idx);
                    }
                    idx = this.vector[varPos].dom.next(idx);
                }
                for (Integer idx3 : this.idxsToPrune) {
                    if (this.vector[varPos].dom.remove(idx3)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void pathDP() {
        int val;
        int idx;
        int varPos;
        for (int valPos = 0; valPos < this.totalCosts[0].length; ++valPos) {
            this.backwardCosts[0][valPos].add(0);
            this.forwardCosts[this.forwardCosts.length - 1][valPos].add(0);
        }
        for (varPos = this.forwardCosts.length - 2; varPos >= 0; --varPos) {
            idx = this.vector[varPos].dom.first();
            while (idx != -1) {
                val = this.vector[varPos].dom.toVal(idx);
                this.forwardCosts[varPos][val - this.smallestDomVal].clear();
                int idxNext = this.vector[varPos + 1].dom.first();
                while (idxNext != -1) {
                    int valNext = this.vector[varPos + 1].dom.toVal(idxNext);
                    if (this.b == null || this.evaluate(this.b[varPos], val, valNext) == 1L) {
                        this.forwardCosts[varPos][val - this.smallestDomVal].updateFromArc(this.forwardCosts[varPos + 1][valNext - this.smallestDomVal], (int)this.evaluate(this.c[varPos], val, valNext));
                    }
                    idxNext = this.vector[varPos + 1].dom.next(idxNext);
                }
                idx = this.vector[varPos].dom.next(idx);
            }
        }
        for (varPos = 1; varPos < this.backwardCosts.length; ++varPos) {
            idx = this.vector[varPos].dom.first();
            while (idx != -1) {
                val = this.vector[varPos].dom.toVal(idx);
                this.backwardCosts[varPos][val - this.smallestDomVal].clear();
                int idxPrev = this.vector[varPos - 1].dom.first();
                while (idxPrev != -1) {
                    int valPrev = this.vector[varPos - 1].dom.toVal(idxPrev);
                    if (this.b == null || this.evaluate(this.b[varPos - 1], valPrev, val) == 1L) {
                        this.backwardCosts[varPos][val - this.smallestDomVal].updateFromArc(this.backwardCosts[varPos - 1][valPrev - this.smallestDomVal], (int)this.evaluate(this.c[varPos - 1], valPrev, val));
                    }
                    idxPrev = this.vector[varPos - 1].dom.next(idxPrev);
                }
                idx = this.vector[varPos].dom.next(idx);
            }
        }
        for (varPos = 0; varPos < this.totalCosts.length; ++varPos) {
            idx = this.vector[varPos].dom.first();
            while (idx != -1) {
                int valPos = this.vector[varPos].dom.toVal(idx) - this.smallestDomVal;
                this.totalCosts[varPos][valPos].unionSum(this.forwardCosts[varPos][valPos], this.backwardCosts[varPos][valPos]);
                idx = this.vector[varPos].dom.next(idx);
            }
        }
        this.costSetOfK.clear();
        int idx2 = this.vector[0].dom.first();
        while (idx2 != -1) {
            this.costSetOfK.addAll(this.totalCosts[0][this.vector[0].dom.toVal(idx2) - this.smallestDomVal]);
            idx2 = this.vector[0].dom.next(idx2);
        }
        assert (this.areCostStructuresCoherent());
    }

    protected boolean pruneK() {
        this.idxsToPrune.clear();
        int idx = this.k.dom.first();
        while (idx != -1) {
            if (!this.costSetOfK.contains(this.k.dom.toVal(idx) - 1)) {
                this.idxsToPrune.add(idx);
            }
            idx = this.k.dom.next(idx);
        }
        for (Integer idx2 : this.idxsToPrune) {
            if (this.k.dom.remove(idx2)) continue;
            return false;
        }
        return true;
    }

    protected boolean pruneVector() {
        for (int i = 0; i < this.vector.length; ++i) {
            this.idxsToPrune.clear();
            int idx = this.vector[i].dom.first();
            while (idx != -1) {
                int valPos = this.vector[i].dom.toVal(idx) - this.smallestDomVal;
                boolean support = false;
                int idxK = this.k.dom.first();
                while (idxK != -1) {
                    int valK = this.k.dom.toVal(idxK);
                    if (this.totalCosts[i][valPos].contains(valK - 1)) {
                        support = true;
                        break;
                    }
                    idxK = this.k.dom.next(idxK);
                }
                if (!support) {
                    this.idxsToPrune.add(idx);
                }
                idx = this.vector[i].dom.next(idx);
            }
            for (Integer idx2 : this.idxsToPrune) {
                if (this.vector[i].dom.remove(idx2)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean areCostStructuresCoherent() {
        CostSet currentCostSet = new CostSet(this.vector.length);
        for (int varPos = 0; varPos < this.totalCosts.length; ++varPos) {
            ArrayList<CostSet> costSets = new ArrayList<CostSet>();
            int idx = this.vector[varPos].dom.first();
            while (idx != -1) {
                costSets.add(this.totalCosts[varPos][this.vector[varPos].dom.toVal(idx) - this.smallestDomVal]);
                idx = this.vector[varPos].dom.next(idx);
            }
            currentCostSet.union(costSets.toArray(new CostSet[costSets.size()]));
            if (currentCostSet.equals(this.costSetOfK)) continue;
            return false;
        }
        return true;
    }

    protected class CostSet {
        private boolean[] costs;
        private int size;

        protected CostSet(int size) {
            Kit.control(size > 0);
            this.costs = new boolean[size];
            this.size = size;
        }

        protected void add(int cost) {
            Kit.control(cost >= 0 && cost < this.size);
            this.costs[cost] = true;
        }

        protected void addAll(CostSet other) {
            Kit.control(this.size == other.size);
            for (int i = 0; i < this.size; ++i) {
                if (!other.contains(i)) continue;
                this.add(i);
            }
        }

        protected void remove(int cost) {
            Kit.control(cost >= 0 && cost < this.size);
            this.costs[cost] = false;
        }

        protected boolean contains(int cost) {
            Kit.control(cost >= 0 && cost < this.size);
            return this.costs[cost];
        }

        protected void clear() {
            for (int i = 0; i < this.size; ++i) {
                this.remove(i);
            }
        }

        protected boolean isEmpty() {
            for (int i = 0; i < this.size; ++i) {
                if (!this.contains(i)) continue;
                return false;
            }
            return true;
        }

        protected boolean equals(CostSet other) {
            if (this == other) {
                return true;
            }
            if (this.size != other.size) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.contains(i) == other.contains(i)) continue;
                return false;
            }
            return true;
        }

        protected void unionSum(CostSet set1, CostSet set2) {
            Kit.control(this.size == set1.size && set1.size == set2.size);
            this.clear();
            if (set1.isEmpty()) {
                this.addAll(set2);
            } else if (set2.isEmpty()) {
                this.addAll(set1);
            } else {
                for (int i = 0; i < this.size; ++i) {
                    for (int j = 0; j < this.size; ++j) {
                        if (!set1.contains(i) || !set2.contains(j)) continue;
                        this.add(i + j);
                    }
                }
            }
        }

        protected void updateFromArc(CostSet other, int cost) {
            for (int i = 0; i < other.size; ++i) {
                if (!other.contains(i)) continue;
                this.add(i + cost);
            }
        }

        protected void union(CostSet ... sets) {
            Kit.control(sets.length >= 1 && this.size == sets[0].size);
            for (int i = 0; i < sets.length - 1; ++i) {
                Kit.control(sets[i].size == sets[i + 1].size);
            }
            this.clear();
            block1: for (int j = 0; j < this.size; ++j) {
                for (int i = 0; i < sets.length; ++i) {
                    if (!sets[i].contains(j)) continue;
                    this.add(j);
                    continue block1;
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            boolean first = true;
            for (int i = 0; i < this.size; ++i) {
                if (!this.contains(i)) continue;
                sb.append(first ? Integer.valueOf(i) : "," + i);
                first = false;
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

