/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import interfaces.TagFilteringCompleteAtEachCall;
import interfaces.TagGACGuaranteed;
import interfaces.TagUnsymmetric;
import java.util.Map;
import java.util.stream.IntStream;
import org.xcsp.common.Types;
import org.xcsp.modeler.definitions.ICtr;
import org.xcsp.modeler.definitions.IRootForCtrAndObj;
import problem.Problem;
import utility.Kit;
import variables.Variable;

public abstract class Ordered
extends CtrGlobal
implements TagUnsymmetric,
TagGACGuaranteed,
TagFilteringCompleteAtEachCall,
ICtr.ICtrOrdered {
    protected int[] lengths;

    public static Ordered build(Problem pb, Variable[] x, int[] lengths, Types.TypeOperatorRel op) {
        switch (op) {
            case LT: {
                return new OrderedLT(pb, x, lengths);
            }
            case LE: {
                return new OrderedLE(pb, x, lengths);
            }
            case GE: {
                return new OrderedGE(pb, x, lengths);
            }
        }
        return new OrderedGT(pb, x, lengths);
    }

    public Ordered(Problem pb, Variable[] scp, int[] lengths) {
        super(pb, scp);
        this.lengths = lengths;
        Kit.control(scp.length == lengths.length + 1);
    }

    public Ordered(Problem pb, Variable[] scp) {
        this(pb, scp, new int[scp.length - 1]);
    }

    @Override
    public Map<String, Object> mapXCSP() {
        Map<String, Object> map = IRootForCtrAndObj.map("scope", (Object)this.scp, LIST, (Object)this.compactOrdered(this.scp));
        if (IntStream.of(this.lengths).anyMatch(v -> v != 0)) {
            map.put(LENGTHS, Kit.join((Object)this.lengths, new String[0]));
        }
        map.put(OPERATOR, this.getClass().getSimpleName().substring(Ordered.class.getSimpleName().length()).toLowerCase());
        return map;
    }

    public static final class OrderedGT
    extends Ordered {
        @Override
        public final boolean checkValues(int[] t) {
            return IntStream.range(0, t.length - 1).allMatch(i -> t[i] + this.lengths[i] > t[i + 1]);
        }

        public OrderedGT(Problem pb, Variable[] scp, int[] lengths) {
            super(pb, scp, lengths);
        }

        public OrderedGT(Problem pb, Variable[] scp) {
            super(pb, scp);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            int i;
            for (i = 0; i < this.scp.length - 1; ++i) {
                if (this.scp[i + 1].dom.removeValues(Types.TypeOperatorRel.GE, this.scp[i].dom.lastValue() + this.lengths[i])) continue;
                return false;
            }
            for (i = this.scp.length - 2; i >= 0; --i) {
                if (this.scp[i].dom.removeValues(Types.TypeOperatorRel.LE, this.scp[i + 1].dom.firstValue() - this.lengths[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static final class OrderedGE
    extends Ordered {
        @Override
        public final boolean checkValues(int[] t) {
            return IntStream.range(0, t.length - 1).allMatch(i -> t[i] + this.lengths[i] >= t[i + 1]);
        }

        public OrderedGE(Problem pb, Variable[] scp, int[] lengths) {
            super(pb, scp, lengths);
        }

        public OrderedGE(Problem pb, Variable[] scp) {
            super(pb, scp);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            int i;
            for (i = 0; i < this.scp.length - 1; ++i) {
                if (this.scp[i + 1].dom.removeValues(Types.TypeOperatorRel.GT, this.scp[i].dom.lastValue() + this.lengths[i])) continue;
                return false;
            }
            for (i = this.scp.length - 2; i >= 0; --i) {
                if (this.scp[i].dom.removeValues(Types.TypeOperatorRel.LT, this.scp[i + 1].dom.firstValue() - this.lengths[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static final class OrderedLE
    extends Ordered {
        @Override
        public final boolean checkValues(int[] t) {
            return IntStream.range(0, t.length - 1).allMatch(i -> t[i] + this.lengths[i] <= t[i + 1]);
        }

        public OrderedLE(Problem pb, Variable[] scp, int[] lengths) {
            super(pb, scp, lengths);
        }

        public OrderedLE(Problem pb, Variable[] scp) {
            super(pb, scp);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            int i;
            for (i = this.scp.length - 2; i >= 0; --i) {
                if (this.scp[i].dom.removeValues(Types.TypeOperatorRel.GT, this.scp[i + 1].dom.lastValue() - this.lengths[i])) continue;
                return false;
            }
            for (i = 0; i < this.scp.length - 1; ++i) {
                if (this.scp[i + 1].dom.removeValues(Types.TypeOperatorRel.LT, this.scp[i].dom.firstValue() + this.lengths[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static final class OrderedLT
    extends Ordered {
        @Override
        public final boolean checkValues(int[] t) {
            return IntStream.range(0, t.length - 1).allMatch(i -> t[i] + this.lengths[i] < t[i + 1]);
        }

        public OrderedLT(Problem pb, Variable[] scp, int[] lengths) {
            super(pb, scp, lengths);
        }

        public OrderedLT(Problem pb, Variable[] scp) {
            super(pb, scp);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            int i;
            for (i = this.scp.length - 2; i >= 0; --i) {
                if (this.scp[i].dom.removeValues(Types.TypeOperatorRel.GE, this.scp[i + 1].dom.lastValue() - this.lengths[i])) continue;
                return false;
            }
            for (i = 0; i < this.scp.length - 1; ++i) {
                if (this.scp[i + 1].dom.removeValues(Types.TypeOperatorRel.LE, this.scp[i].dom.firstValue() + this.lengths[i])) continue;
                return false;
            }
            return true;
        }
    }
}

