/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import interfaces.OptimizationCompatible;
import interfaces.TagFilteringCompleteAtEachCall;
import interfaces.TagGACGuaranteed;
import interfaces.TagSymmetric;
import java.util.stream.Stream;
import problem.Problem;
import utility.Kit;
import variables.Variable;

public abstract class ObjVar
extends CtrGlobal
implements OptimizationCompatible,
TagFilteringCompleteAtEachCall,
TagSymmetric,
TagGACGuaranteed {
    protected Variable x;
    protected long limit;
    protected boolean entailed;

    @Override
    public long minComputableObjectiveValue() {
        return Stream.of(this.scp).mapToLong(x -> x.dom.toVal(0)).min().getAsLong();
    }

    @Override
    public long maxComputableObjectiveValue() {
        return Stream.of(this.scp).mapToLong(x -> x.dom.toVal(x.dom.initSize() - 1)).max().getAsLong();
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    public final void setLimit(long newLimit) {
        Kit.control(Integer.MIN_VALUE <= newLimit && newLimit <= Integer.MAX_VALUE);
        this.limit = (int)newLimit;
        this.entailed = false;
    }

    @Override
    public long objectiveValue() {
        return this.x.dom.uniqueValue();
    }

    public ObjVar(Problem pb, Variable x, long limit) {
        super(pb, new Variable[]{x});
        this.x = x;
        this.limit = limit;
    }

    public static final class ObjVarGE
    extends ObjVar {
        @Override
        public boolean checkValues(int[] vals) {
            return (long)vals[0] >= this.limit;
        }

        public ObjVarGE(Problem pb, Variable x, long limit) {
            super(pb, x, limit);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            if (this.entailed) {
                return true;
            }
            Kit.control(this.pb.solver.depth() == 0);
            if (!this.x.dom.removeValuesLessThan(this.limit)) {
                return false;
            }
            this.entailed = true;
            assert (this.x.dom.size() > 0);
            return true;
        }
    }

    public static final class ObjVarLE
    extends ObjVar {
        @Override
        public boolean checkValues(int[] vals) {
            return (long)vals[0] <= this.limit;
        }

        public ObjVarLE(Problem pb, Variable x, long limit) {
            super(pb, x, limit);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            if (this.entailed) {
                return true;
            }
            Kit.control(this.pb.solver.depth() == 0);
            if (!this.x.dom.removeValuesGreaterThan(this.limit)) {
                return false;
            }
            this.entailed = true;
            assert (this.x.dom.size() > 0);
            return true;
        }
    }
}

