/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.global.NValuesAbstract;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Types;
import org.xcsp.modeler.definitions.DefXCSP;
import problem.Problem;
import utility.Kit;
import variables.Variable;
import variables.VariableInteger;
import variables.domains.Domain;

public final class NValuesVar
extends NValuesAbstract {
    protected Variable k;

    @Override
    public boolean checkValues(int[] t) {
        return IntStream.range(0, t.length - 1).map(i -> t[i]).distinct().count() == (long)t[t.length - 1];
    }

    public NValuesVar(Problem pb, Variable[] list, VariableInteger k) {
        super(pb, (Variable[])pb.distinct(pb.vars(new Object[]{list, k})), list);
        Kit.control(Stream.of(list).noneMatch(x -> x == k), () -> "currently, k must not be present in the list");
        this.k = k;
    }

    @Override
    public boolean runPropagator(Variable x) {
        block7: {
            if (x.dom.size() != 1) break block7;
            this.initializeSets();
            if (!this.k.dom.removeValues(Types.TypeOperatorRel.LT, this.fixedVals.size()) || !this.k.dom.removeValues(Types.TypeOperatorRel.GT, this.fixedVals.size() + this.unfixedVars.size())) {
                return false;
            }
            if (this.k.dom.size() == 1) {
                int limit = this.k.dom.uniqueValue();
                if (this.fixedVals.size() == limit) {
                    for (int i = this.unfixedVars.limit; i >= 0; --i) {
                        Domain dom = this.list[this.unfixedVars.dense[i]].dom;
                        if (dom.removeValues(Types.TypeConditionOperatorSet.NOTIN, this.fixedVals)) continue;
                        return false;
                    }
                } else if (this.fixedVals.size() + this.unfixedVars.size() == limit) {
                    for (int i = this.unfixedVars.limit; i >= 0; --i) {
                        Domain dom = this.list[this.unfixedVars.dense[i]].dom;
                        if (dom.removeValues(Types.TypeConditionOperatorSet.IN, this.fixedVals)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public DefXCSP defXCSP() {
        return new DefXCSP(NVALUES).addSon(LIST, this.compact(this.list)).addSon(CONDITION, "(eq," + this.k + ")");
    }
}

