/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.global.CardinalityConstant;
import constraints.hard.global.Matcher;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import utility.Kit;
import utility.sets.SetSparse;
import variables.Variable;
import variables.domains.Domain;

public class MatcherCardinality
extends Matcher {
    private SetSparse[] valToVars;
    private int[] keys;
    private int[] minOccs;
    private int[] maxOccs;
    private SetSparse[] possibleVars;
    private int[] predValue;

    @Override
    public void restoreAtDepthBefore(int depth) {
        super.restoreAtDepthBefore(depth);
    }

    @Override
    public void onConstructionProblemFinished() {
        super.onConstructionProblemFinished();
        this.valToVars = (SetSparse[])IntStream.range(0, this.intervalSize).mapToObj(i -> new SetSparse(this.arity, false)).toArray(SetSparse[]::new);
    }

    public MatcherCardinality(CardinalityConstant ctr, Variable[] scp, int[] keys, int[] minOccs, int[] maxOccs) {
        super(ctr, scp);
        this.keys = keys;
        this.minValue = Math.min(this.minValue, IntStream.of(keys).min().getAsInt());
        this.maxValue = Math.max(this.maxValue, IntStream.of(keys).max().getAsInt());
        this.intervalSize = this.maxValue - this.minValue + 1;
        this.queueBFS = new SetSparse(Math.max(this.arity, this.intervalSize));
        this.predBFS = Kit.repeat(-1, Math.max(this.arity, this.intervalSize));
        this.predValue = Kit.repeat(-1, this.intervalSize);
        this.minOccs = new int[this.intervalSize];
        this.maxOccs = Kit.repeat(Integer.MAX_VALUE, this.intervalSize);
        for (int i = 0; i < keys.length; ++i) {
            this.minOccs[this.normalizedValueOf((int)keys[i])] = minOccs[i];
            this.maxOccs[this.normalizedValueOf((int)keys[i])] = maxOccs[i];
        }
        this.possibleVars = new SetSparse[this.intervalSize];
        for (int u = 0; u < this.intervalSize; ++u) {
            this.possibleVars[u] = new SetSparse(this.arity);
            for (int x = 0; x < this.arity; ++x) {
                if (!scp[x].dom.isPresentValue(this.domainValueOf(u))) continue;
                this.possibleVars[u].add(x);
            }
        }
    }

    private void handleAugmentingPath(int x, int u) {
        while (this.predBFS[u] != -1) {
            int y = this.predBFS[u];
            this.varToVal[x] = u;
            this.valToVars[u].add(x);
            this.valToVars[u].remove(y);
            x = y;
            u = this.predValue[u];
        }
        this.varToVal[x] = u;
        this.valToVars[u].add(x);
    }

    private boolean findMatchingForValue(int u) {
        this.queueBFS.resetTo(u);
        this.predBFS[u] = -1;
        this.visitTime[u] = ++this.time;
        while (!this.queueBFS.isEmpty()) {
            int v = this.queueBFS.shift();
            for (int i = 0; i <= this.possibleVars[v].limit; ++i) {
                int x = this.possibleVars[v].dense[i];
                Domain dom = this.scp[x].dom;
                if (!dom.isPresentValue(this.domainValueOf(v))) continue;
                int w = this.varToVal[x];
                if (w == -1) {
                    this.handleAugmentingPath(x, v);
                    return true;
                }
                if (w == v) continue;
                if (this.valToVars[w].size() > this.minOccs[w] && this.varToVal[x] == w) {
                    this.valToVars[w].remove(x);
                    this.handleAugmentingPath(x, v);
                    return true;
                }
                if (this.visitTime[w] >= this.time) continue;
                this.visitTime[w] = this.time;
                this.queueBFS.add(w);
                this.predBFS[w] = x;
                this.predValue[w] = v;
            }
        }
        return false;
    }

    private boolean findMatchingForVariable(int x) {
        this.queueBFS.resetTo(x);
        this.predBFS[x] = -1;
        this.visitTime[x] = ++this.time;
        while (!this.queueBFS.isEmpty()) {
            int y = this.queueBFS.shift();
            Domain dom = this.scp[y].dom;
            int a = dom.first();
            while (a != -1) {
                int u = this.normalizedValueOf(dom.toVal(a));
                if (this.valToVars[u].size() < this.maxOccs[u]) {
                    while (this.predBFS[y] != -1) {
                        int v = this.varToVal[y];
                        this.varToVal[y] = u;
                        this.valToVars[u].add(y);
                        this.valToVars[v].remove(y);
                        y = this.predBFS[y];
                        u = v;
                    }
                    this.varToVal[y] = u;
                    this.valToVars[u].add(y);
                    return true;
                }
                for (int i = 0; i < this.valToVars[u].size(); ++i) {
                    int z = this.valToVars[u].dense[i];
                    assert (this.varToVal[z] == u);
                    if (this.visitTime[z] >= this.time) continue;
                    this.visitTime[z] = this.time;
                    this.predBFS[z] = y;
                    this.queueBFS.add(z);
                }
                a = dom.next(a);
            }
        }
        return false;
    }

    @Override
    public boolean findMaximumMatching() {
        int x;
        for (x = 0; x < this.arity; ++x) {
            Domain dom = this.scp[x].dom;
            int u = this.varToVal[x];
            if (u != -1 && dom.isPresentValue(this.domainValueOf(u))) continue;
            if (dom.size() == 1) {
                int v = this.normalizedValueOf(dom.firstValue());
                if (u != -1) {
                    this.valToVars[u].remove(x);
                }
                if (this.maxOccs[v] == this.valToVars[v].size()) {
                    this.varToVal[x] = -1;
                    continue;
                }
                this.varToVal[x] = v;
                this.valToVars[v].add(x);
                continue;
            }
            if (u == -1) continue;
            this.valToVars[u].remove(x);
            this.varToVal[x] = -1;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            int u = this.normalizedValueOf(this.keys[i]);
            while (this.valToVars[u].size() < this.minOccs[u]) {
                if (this.findMatchingForValue(u)) continue;
                return false;
            }
        }
        this.unmatchedVars.clear();
        for (x = 0; x < this.arity; ++x) {
            if (this.varToVal[x] == -1) {
                this.unmatchedVars.add(x);
                continue;
            }
            if (this.scp[x].dom.size() != 1 || !this.unfixedVars.isPresent(x)) continue;
            this.unfixedVars.remove(x, this.ctr.pb.solver.depth());
        }
        while (!this.unmatchedVars.isEmpty()) {
            if (this.findMatchingForVariable(this.unmatchedVars.pop())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void computeNeighbors() {
        for (SetSparse set : this.neighborsOfValues) {
            set.clear();
        }
        for (int u = 0; u < this.intervalSize; ++u) {
            if (this.valToVars[u].size() < this.maxOccs[u]) {
                this.neighborsOfT.add(u);
            } else {
                this.neighborsOfT.remove(u);
            }
            if (this.valToVars[u].size() > this.minOccs[u]) {
                this.neighborsOfValues[u].add(this.arity);
            } else {
                this.neighborsOfValues[u].remove(this.arity);
            }
            for (int i = 0; i <= this.possibleVars[u].limit; ++i) {
                int x = this.possibleVars[u].dense[i];
                if (this.scp[x].dom.isPresentValue(this.domainValueOf(u)) && this.varToVal[x] != u) {
                    this.neighborsOfValues[u].add(x);
                    continue;
                }
                this.neighborsOfValues[u].remove(x);
            }
        }
    }

    private void checkMatchingConsistency() {
        Kit.control(IntStream.range(0, this.intervalSize).allMatch(u -> IntStream.range(0, this.valToVars[u].size()).allMatch(i -> this.varToVal[this.valToVars[u].dense[i]] == u)));
        Kit.control(IntStream.range(0, this.arity).allMatch(x -> this.varToVal[x] == -1 || this.valToVars[this.varToVal[x]].isPresent(x)));
    }

    private void checkMatchingValidity() {
        Kit.control(IntStream.range(0, this.arity).allMatch(x -> this.varToVal[x] != -1 && this.scp[x].dom.isPresentValue(this.domainValueOf(this.varToVal[x]))));
        Kit.control(IntStream.range(0, this.intervalSize).allMatch(u -> this.minOccs[u] <= this.valToVars[u].size() && this.valToVars[u].size() <= this.maxOccs[u]));
        this.checkMatchingConsistency();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("varToVal : " + IntStream.of(this.varToVal).mapToObj(u -> this.domainValueOf(u) + " ").collect(Collectors.joining()));
        sb.append("\nvalue2Variables :\n");
        for (int u2 = 0; u2 < this.intervalSize; ++u2) {
            sb.append("Value " + this.domainValueOf(u2) + " : ");
            for (int i = 0; i <= this.valToVars[u2].limit; ++i) {
                sb.append(this.valToVars[u2].dense[i] + " ");
            }
            sb.append("\n");
        }
        sb.append("predVariable : " + Kit.join((Object)this.predBFS, new String[0]) + "\n");
        return sb.toString();
    }
}

