/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import interfaces.TagFilteringCompleteAtEachCall;
import interfaces.TagGACGuaranteed;
import interfaces.TagUnsymmetric;
import org.xcsp.common.Types;
import problem.Problem;
import variables.Variable;
import variables.domains.Domain;

public abstract class Lexicographic
extends CtrGlobal
implements TagUnsymmetric,
TagFilteringCompleteAtEachCall,
TagGACGuaranteed {
    private final Variable[] list1;
    private final Variable[] list2;
    private final int half;
    private final boolean strictOrdering;
    private final int[] times;
    private final int[] vals;
    private int alpha;
    private int time;

    public static Lexicographic buildFrom(Problem pb, Variable[] list1, Variable[] list2, Types.TypeOperatorRel op) {
        switch (op) {
            case LT: {
                return new LexicographicLT(pb, list1, list2);
            }
            case LE: {
                return new LexicographicLE(pb, list1, list2);
            }
            case GE: {
                return new LexicographicLE(pb, list2, list1);
            }
        }
        return new LexicographicLT(pb, list2, list1);
    }

    @Override
    public boolean checkValues(int[] t) {
        for (int i = 0; i < this.half; ++i) {
            int w;
            int v = t[this.positionOf(this.list1[i])];
            if (v < (w = t[this.positionOf(this.list2[i])])) {
                return true;
            }
            if (v <= w) continue;
            return false;
        }
        return !this.strictOrdering;
    }

    public Lexicographic(Problem pb, Variable[] list1, Variable[] list2, boolean strictOrdering) {
        super(pb, (Variable[])pb.distinct(pb.vars(new Object[]{list1, list2})));
        assert (list1.length == list2.length);
        this.list1 = list1;
        this.list2 = list2;
        this.half = list1.length;
        this.strictOrdering = strictOrdering;
        this.times = new int[this.scp.length];
        this.vals = new int[this.scp.length];
        this.defineKey(strictOrdering);
    }

    private void set(int p, int v) {
        this.times[p] = this.time;
        this.vals[p] = v;
    }

    private boolean isConsistentPair(Variable x, int v, Variable y, int w) {
        ++this.time;
        this.set(this.positionOf(x), v);
        this.set(this.positionOf(y), w);
        for (int i = this.alpha + 1; i < this.half; ++i) {
            int max2;
            int p1 = this.positionOf(this.list1[i]);
            int p2 = this.positionOf(this.list2[i]);
            int min1 = this.times[p1] == this.time ? this.vals[p1] : this.list1[i].dom.firstValue();
            int n = max2 = this.times[p2] == this.time ? this.vals[p2] : this.list2[i].dom.lastValue();
            if (min1 < max2) {
                return true;
            }
            if (min1 > max2) {
                return false;
            }
            this.set(p1, min1);
            this.set(p2, max2);
        }
        return !this.strictOrdering;
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        Domain dom2;
        Domain dom1;
        this.alpha = 0;
        while (this.alpha < this.half) {
            dom1 = this.list1[this.alpha].dom;
            dom2 = this.list2[this.alpha].dom;
            if (!dom1.removeValuesGreaterThan(dom2.lastValue()) || !dom2.removeValuesLessThan(dom1.firstValue())) {
                return false;
            }
            if (dom1.size() != 1 || dom2.size() != 1 || dom1.firstValue() != dom2.firstValue()) break;
            ++this.alpha;
        }
        if (this.alpha >= this.half) {
            return !this.strictOrdering;
        }
        dom1 = this.list1[this.alpha].dom;
        dom2 = this.list2[this.alpha].dom;
        int min1 = dom1.firstValue();
        int min2 = dom2.firstValue();
        assert (min1 <= min2);
        if (min1 == min2 && !this.isConsistentPair(this.list1[this.alpha], min1, this.list2[this.alpha], min2) && !dom2.removeValue(min2, false)) {
            return false;
        }
        int max1 = dom1.lastValue();
        int max2 = dom2.lastValue();
        assert (max1 <= max2);
        if (max1 == max2 && !this.isConsistentPair(this.list1[this.alpha], max1, this.list2[this.alpha], max2) && !dom1.removeValue(max1, false)) {
            return false;
        }
        assert (dom1.firstValue() < dom2.lastValue());
        return true;
    }

    public static final class LexicographicLE
    extends Lexicographic {
        public LexicographicLE(Problem pb, Variable[] list1, Variable[] list2) {
            super(pb, list1, list2, false);
        }
    }

    public static final class LexicographicLT
    extends Lexicographic {
        public LexicographicLT(Problem pb, Variable[] list1, Variable[] list2) {
            super(pb, list1, list2, true);
        }
    }
}

