/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import interfaces.OptimizationCompatible;
import interfaces.TagFilteringCompleteAtEachCall;
import interfaces.TagGACGuaranteed;
import interfaces.TagSymmetric;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Types;
import problem.Problem;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public abstract class Extremum
extends CtrGlobal
implements TagFilteringCompleteAtEachCall,
TagGACGuaranteed {
    protected final Variable[] list;

    public Extremum(Problem pb, Variable[] list, Variable ext) {
        super(pb, (Variable[])pb.api.vars(ext, list));
        this.list = list;
    }

    public Extremum(Problem pb, Variable[] list) {
        this(pb, list, null);
    }

    public static abstract class ExtremumCst
    extends Extremum
    implements OptimizationCompatible,
    TagSymmetric {
        protected long limit;
        protected boolean entailed;

        @Override
        public long minComputableObjectiveValue() {
            return Stream.of(this.scp).mapToLong(x -> x.dom.toVal(0)).min().getAsLong();
        }

        @Override
        public long maxComputableObjectiveValue() {
            return Stream.of(this.scp).mapToLong(x -> x.dom.toVal(x.dom.initSize() - 1)).max().getAsLong();
        }

        @Override
        public long getLimit() {
            return this.limit;
        }

        @Override
        public final void setLimit(long newLimit) {
            Kit.control(Integer.MIN_VALUE <= newLimit && newLimit <= Integer.MAX_VALUE);
            this.limit = (int)newLimit;
            this.entailed = false;
        }

        public ExtremumCst(Problem pb, Variable[] list, long limit) {
            super(pb, list);
            this.limit = limit;
        }

        public static abstract class MinimumCst
        extends ExtremumCst {
            @Override
            public long objectiveValue() {
                return Stream.of(this.doms).mapToInt(dom -> dom.uniqueValue()).min().getAsInt();
            }

            public MinimumCst(Problem pb, Variable[] scp, long limit) {
                super(pb, scp, limit);
            }

            public static final class MinimumCstGE
            extends MinimumCst {
                @Override
                public boolean checkValues(int[] vals) {
                    return (long)IntStream.of(vals).min().getAsInt() >= this.limit;
                }

                public MinimumCstGE(Problem pb, Variable[] scp, long limit) {
                    super(pb, scp, limit);
                }

                @Override
                public boolean runPropagator(Variable x) {
                    if (this.entailed) {
                        return true;
                    }
                    assert (this.pb.solver.depth() == 0);
                    for (Variable y : this.scp) {
                        if (y.dom.removeValuesLessThan(this.limit)) continue;
                        return false;
                    }
                    this.entailed = true;
                    return Variable.firstWipeoutVariableIn(this.scp) == null;
                }
            }

            public static final class MinimumCstLE
            extends MinimumCst {
                private int sentinel1 = 0;
                private int sentinel2;

                @Override
                public boolean checkValues(int[] vals) {
                    return (long)IntStream.of(vals).min().getAsInt() <= this.limit;
                }

                public MinimumCstLE(Problem pb, Variable[] scp, long limit) {
                    super(pb, scp, limit);
                    this.sentinel2 = scp.length - 1;
                    Kit.control((long)scp[this.sentinel1].dom.firstValue() <= limit && (long)scp[this.sentinel2].dom.firstValue() <= limit, () -> "unsound sentinels");
                }

                @Override
                public boolean runPropagator(Variable x) {
                    int i;
                    if ((long)this.scp[this.sentinel1].dom.firstValue() > this.limit) {
                        for (i = 0; i < this.scp.length && (i == this.sentinel2 || (long)this.scp[i].dom.firstValue() > this.limit); ++i) {
                        }
                        if (i < this.scp.length) {
                            this.sentinel1 = i;
                        } else {
                            if ((long)this.scp[this.sentinel2].dom.firstValue() > this.limit) {
                                return x.dom.fail();
                            }
                            return this.scp[this.sentinel2].dom.removeValues(Types.TypeOperatorRel.GT, this.limit);
                        }
                    }
                    if ((long)this.scp[this.sentinel2].dom.firstValue() > this.limit) {
                        for (i = 0; i < this.scp.length && (i == this.sentinel1 || (long)this.scp[i].dom.firstValue() > this.limit); ++i) {
                        }
                        if (i < this.scp.length) {
                            this.sentinel2 = i;
                        } else {
                            assert ((long)this.scp[this.sentinel1].dom.firstValue() <= this.limit);
                            return this.scp[this.sentinel2].dom.removeValuesGreaterThan(this.limit);
                        }
                    }
                    return true;
                }
            }
        }

        public static abstract class MaximumCst
        extends ExtremumCst {
            @Override
            public long objectiveValue() {
                return Stream.of(this.doms).mapToInt(dom -> dom.uniqueValue()).max().getAsInt();
            }

            public MaximumCst(Problem pb, Variable[] scp, long limit) {
                super(pb, scp, limit);
            }

            public static final class MaximumCstGE
            extends MaximumCst {
                private int sentinel1 = 0;
                private int sentinel2;

                @Override
                public boolean checkValues(int[] vals) {
                    return (long)IntStream.of(vals).max().getAsInt() >= this.limit;
                }

                public MaximumCstGE(Problem pb, Variable[] scp, long limit) {
                    super(pb, scp, limit);
                    this.sentinel2 = scp.length - 1;
                    Kit.control((long)scp[this.sentinel1].dom.lastValue() >= limit && (long)scp[this.sentinel2].dom.lastValue() >= limit, () -> "unsound sentinels");
                }

                @Override
                public boolean runPropagator(Variable x) {
                    int i;
                    if ((long)this.scp[this.sentinel1].dom.lastValue() < this.limit) {
                        for (i = 0; i < this.scp.length && (i == this.sentinel2 || (long)this.scp[i].dom.lastValue() < this.limit); ++i) {
                        }
                        if (i < this.scp.length) {
                            this.sentinel1 = i;
                        } else {
                            if ((long)this.scp[this.sentinel2].dom.lastValue() < this.limit) {
                                return x.dom.fail();
                            }
                            return this.scp[this.sentinel2].dom.removeValues(Types.TypeOperatorRel.LT, this.limit);
                        }
                    }
                    if ((long)this.scp[this.sentinel2].dom.lastValue() < this.limit) {
                        for (i = 0; i < this.scp.length && (i == this.sentinel1 || (long)this.scp[i].dom.lastValue() < this.limit); ++i) {
                        }
                        if (i < this.scp.length) {
                            this.sentinel2 = i;
                        } else {
                            assert ((long)this.scp[this.sentinel1].dom.lastValue() >= this.limit);
                            return this.scp[this.sentinel2].dom.removeValuesLessThan(this.limit);
                        }
                    }
                    return true;
                }
            }

            public static final class MaximumCstLE
            extends MaximumCst {
                @Override
                public boolean checkValues(int[] vals) {
                    return (long)IntStream.of(vals).max().getAsInt() <= this.limit;
                }

                public MaximumCstLE(Problem pb, Variable[] scp, long limit) {
                    super(pb, scp, limit);
                }

                @Override
                public boolean runPropagator(Variable x) {
                    if (this.entailed) {
                        return true;
                    }
                    Kit.control(this.pb.solver.depth() == 0);
                    for (Variable y : this.scp) {
                        if (y.dom.removeValuesGreaterThan(this.limit)) continue;
                        return false;
                    }
                    this.entailed = true;
                    return Variable.firstWipeoutVariableIn(this.scp) == null;
                }
            }
        }
    }

    public static abstract class ExtremumVar
    extends Extremum {
        protected final Domain domExt;
        protected final Variable[] sentinels;

        protected Variable findSentinelFor(int v, Variable except) {
            for (Variable x : this.list) {
                if (x == except || !x.dom.isPresentValue(v)) continue;
                return x;
            }
            return null;
        }

        protected Variable findSentinelFor(int v) {
            for (Variable x : this.list) {
                if (!x.dom.isPresentValue(v)) continue;
                return x;
            }
            return null;
        }

        @Override
        public int[] defineSymmetryMatching() {
            return IntStream.range(0, this.scp.length).map(i -> i == 0 ? 1 : 2).toArray();
        }

        public ExtremumVar(Problem pb, Variable[] list, Variable ext) {
            super(pb, list, ext);
            this.domExt = ext.dom;
            this.sentinels = new Variable[ext.dom.initSize()];
            int a = this.domExt.first();
            while (a != -1) {
                this.sentinels[a] = this.findSentinelFor(this.domExt.toVal(a));
                a = this.domExt.next(a);
            }
            a = this.domExt.first();
            while (a != -1) {
                if (this.sentinels[a] == null) {
                    this.domExt.removeValueAtConstructionTime(this.domExt.toVal(a));
                }
                a = this.domExt.next(a);
            }
            Kit.control(list.length > 1 && Stream.of(list).noneMatch(x -> x == ext), () -> "vector length = " + list.length);
        }

        public static final class Minimum
        extends ExtremumVar {
            @Override
            public boolean checkValues(int[] t) {
                return t[0] == IntStream.range(1, t.length).map(i -> t[i]).min().getAsInt();
            }

            private int computeLimitForSentinel(Variable sentinel) {
                int a = this.domExt.first();
                while (a != -1) {
                    int v = this.domExt.toVal(a);
                    if (this.sentinels[a] != sentinel || this.findSentinelFor(v, sentinel) != null) {
                        return v;
                    }
                    a = this.domExt.next(a);
                }
                return Integer.MAX_VALUE;
            }

            public Minimum(Problem pb, Variable[] list, Variable min) {
                super(pb, list, min);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                int v;
                int minFirst = Integer.MAX_VALUE;
                int minLast = Integer.MAX_VALUE;
                for (Variable x : this.list) {
                    if (x.dom.firstValue() < minFirst) {
                        minFirst = x.dom.firstValue();
                    }
                    if (x.dom.lastValue() >= minLast) continue;
                    minLast = x.dom.lastValue();
                }
                if (!this.domExt.removeValues(Types.TypeOperatorRel.GT, minLast) || !this.domExt.removeValues(Types.TypeOperatorRel.LT, minFirst)) {
                    return false;
                }
                int sizeBefore = this.domExt.size();
                int a = this.domExt.first();
                while (a != -1) {
                    int v2 = this.domExt.toVal(a);
                    if (!this.sentinels[a].dom.isPresentValue(v2)) {
                        Variable s = this.findSentinelFor(v2);
                        if (s != null) {
                            this.sentinels[a] = s;
                        } else {
                            this.domExt.removeElementary(a);
                        }
                    }
                    a = this.domExt.next(a);
                }
                if (!this.domExt.afterElementaryCalls(sizeBefore)) {
                    return false;
                }
                int firstMin = this.domExt.firstValue();
                for (Variable x : this.list) {
                    if (x.dom.removeValues(Types.TypeOperatorRel.LT, firstMin)) continue;
                    return false;
                }
                Variable sentinel = this.sentinels[this.domExt.first()];
                int valLimit = this.computeLimitForSentinel(sentinel);
                if (valLimit == firstMin) {
                    return true;
                }
                Domain domSentinel = sentinel.dom;
                sizeBefore = domSentinel.size();
                int a2 = domSentinel.next(domSentinel.first());
                while (a2 != -1 && (v = domSentinel.toVal(a2)) < valLimit) {
                    if (!this.domExt.isPresentValue(v)) {
                        domSentinel.removeElementary(a2);
                    }
                    a2 = domSentinel.next(a2);
                }
                return domSentinel.afterElementaryCalls(sizeBefore);
            }
        }

        public static final class Maximum
        extends ExtremumVar {
            @Override
            public boolean checkValues(int[] t) {
                return t[0] == IntStream.range(1, t.length).map(i -> t[i]).max().getAsInt();
            }

            private int computeLimitForSentinel(Variable sentinel) {
                int a = this.domExt.last();
                while (a != -1) {
                    int v = this.domExt.toVal(a);
                    if (this.sentinels[a] != sentinel || this.findSentinelFor(v, sentinel) != null) {
                        return v;
                    }
                    a = this.domExt.prev(a);
                }
                return Integer.MIN_VALUE;
            }

            public Maximum(Problem pb, Variable[] list, Variable max) {
                super(pb, list, max);
            }

            @Override
            public boolean runPropagator(Variable dummy) {
                int v;
                int maxFirst = Integer.MIN_VALUE;
                int maxLast = Integer.MIN_VALUE;
                for (Variable x : this.list) {
                    if (x.dom.firstValue() > maxFirst) {
                        maxFirst = x.dom.firstValue();
                    }
                    if (x.dom.lastValue() <= maxLast) continue;
                    maxLast = x.dom.lastValue();
                }
                if (!this.domExt.removeValues(Types.TypeOperatorRel.LT, maxFirst) || !this.domExt.removeValues(Types.TypeOperatorRel.GT, maxLast)) {
                    return false;
                }
                int sizeBefore = this.domExt.size();
                if (!this.domExt.removeIndexesChecking(a -> {
                    int v = this.domExt.toVal((int)a);
                    if (!this.sentinels[a.intValue()].dom.isPresentValue(v)) {
                        Variable s = this.findSentinelFor(v);
                        if (s == null) {
                            return true;
                        }
                        this.sentinels[a.intValue()] = s;
                    }
                    return false;
                })) {
                    return false;
                }
                int lastMax = this.domExt.lastValue();
                for (Variable x : this.list) {
                    if (x.dom.removeValues(Types.TypeOperatorRel.GT, lastMax)) continue;
                    return false;
                }
                Variable sentinel = this.sentinels[this.domExt.last()];
                int valLimit = this.computeLimitForSentinel(sentinel);
                if (valLimit == lastMax) {
                    return true;
                }
                Domain domSentinel = sentinel.dom;
                sizeBefore = domSentinel.size();
                int a2 = domSentinel.prev(domSentinel.last());
                while (a2 != -1 && (v = domSentinel.toVal(a2)) > valLimit) {
                    if (!this.domExt.isPresentValue(v)) {
                        domSentinel.removeElementary(a2);
                    }
                    a2 = domSentinel.prev(a2);
                }
                return domSentinel.afterElementaryCalls(sizeBefore);
            }
        }
    }
}

