/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import interfaces.ObserverBacktracking;
import interfaces.TagFilteringCompleteAtEachCall;
import interfaces.TagGACUnguaranteed;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Types;
import problem.Problem;
import utility.sets.SetSparse;
import utility.sets.SetSparseReversible;
import variables.Variable;

public final class Cumulative
extends CtrGlobal
implements TagFilteringCompleteAtEachCall,
TagGACUnguaranteed,
ObserverBacktracking.ObserverBacktrackingSystematic {
    private int[] lengths;
    private int[] heights;
    private int limit;
    private SetSparse ticks;
    private int[] offsets;
    private Slot[] slots;
    private int nSlots;
    private SetSparseReversible omega;
    private int[] sortedScpIndexes;

    @Override
    public boolean checkValues(int[] tuple) {
        int min = IntStream.of(tuple).min().getAsInt();
        int max = IntStream.range(0, tuple.length).map(i -> tuple[i] + this.lengths[i]).max().getAsInt();
        return IntStream.rangeClosed(min, max).allMatch(t -> IntStream.range(0, tuple.length).filter(i -> tuple[i] <= t && t < tuple[i] + this.lengths[i]).map(i -> this.heights[i]).sum() <= this.limit);
    }

    @Override
    public void restoreBefore(int depth) {
        this.omega.restoreLimitAtLevel(depth);
    }

    @Override
    public void onConstructionProblemFinished() {
        super.onConstructionProblemFinished();
        this.omega = new SetSparseReversible(this.scp.length, this.pb.variables.length + 1);
    }

    public Cumulative(Problem pb, Variable[] list, int[] lengths, int[] heights, int limit) {
        super(pb, list);
        this.lengths = lengths;
        this.heights = heights;
        this.limit = limit;
        int horizon = IntStream.range(0, this.scp.length).map(i -> this.scp[i].dom.lastValue() + lengths[i]).max().getAsInt() + 1;
        this.ticks = new SetSparse(horizon);
        this.offsets = new int[horizon];
        this.slots = (Slot[])IntStream.range(0, horizon).mapToObj(i -> new Slot()).toArray(Slot[]::new);
        Integer[] t = (Integer[])IntStream.range(0, this.scp.length).mapToObj(i -> new Integer(i)).toArray(Integer[]::new);
        Arrays.sort(t, (i1, i2) -> heights[i1] > heights[i2] ? -1 : (heights[i1] < heights[i2] ? 1 : 0));
        this.sortedScpIndexes = Stream.of(t).mapToInt(i -> i).toArray();
    }

    private int mandatoryStart(int i) {
        return this.scp[i].dom.lastValue();
    }

    private int mandatoryEnd(int i) {
        return this.scp[i].dom.firstValue() + this.lengths[i];
    }

    private Boolean buildTimeTable() {
        int i;
        this.ticks.clear();
        for (int j = this.omega.limit; j >= 0; --j) {
            i = this.omega.dense[j];
            int ms = this.mandatoryStart(i);
            int me = this.mandatoryEnd(i);
            if (me <= ms) continue;
            if (!this.ticks.isPresent(ms)) {
                this.ticks.add(ms);
                this.offsets[ms] = 0;
            }
            int n = ms;
            this.offsets[n] = this.offsets[n] + this.heights[i];
            if (!this.ticks.isPresent(me)) {
                this.ticks.add(me);
                this.offsets[me] = 0;
            }
            int n2 = me;
            this.offsets[n2] = this.offsets[n2] - this.heights[i];
        }
        if (this.ticks.size() == 0) {
            return Boolean.TRUE;
        }
        int nbRelevantTicks = 0;
        for (i = 0; i <= this.ticks.limit; ++i) {
            if (this.offsets[this.ticks.dense[i]] == 0) continue;
            this.slots[nbRelevantTicks++].start = this.ticks.dense[i];
        }
        Arrays.sort(this.slots, 0, nbRelevantTicks, (t1, t2) -> t1.start < t2.start ? -1 : (t1.start > t2.start ? 1 : 0));
        int h = 0;
        for (int k = 0; k < nbRelevantTicks - 1; ++k) {
            if ((h += this.offsets[this.slots[k].start]) > this.limit) {
                return Boolean.FALSE;
            }
            this.slots[k].end = this.slots[k + 1].start;
            this.slots[k].height = h;
        }
        Arrays.sort(this.slots, 0, nbRelevantTicks - 1, (t1, t2) -> t1.height > t2.height ? -1 : (t1.height < t2.height ? 1 : 0));
        this.nSlots = nbRelevantTicks - 1;
        while (this.slots[this.nSlots - 1].height == 0) {
            --this.nSlots;
        }
        return null;
    }

    @Override
    public boolean runPropagator(Variable x) {
        Boolean b = this.buildTimeTable();
        if (b == Boolean.FALSE) {
            return x.dom.fail();
        }
        if (b == Boolean.TRUE) {
            return true;
        }
        if (this.slots[0].height + this.heights[this.sortedScpIndexes[0]] > this.limit) {
            Variable lastPast = this.pb.solver.futVars.lastPast();
            for (int i = 0; i < this.scp.length; ++i) {
                if (this.scp[i].isAssigned() && this.scp[i] != lastPast) continue;
                int ms = this.mandatoryStart(i);
                int me = this.mandatoryEnd(i);
                for (int k = 0; k < this.nSlots && this.slots[k].height + this.heights[i] > this.limit; ++k) {
                    assert (this.slots[k].height != 0);
                    int rs = this.slots[k].start;
                    int re = this.slots[k].end;
                    if (me > ms && me > rs && re > ms || this.scp[i].dom.removeValues(Types.TypeConditionOperatorSet.IN, rs - this.lengths[i] + 1, re)) continue;
                    return false;
                }
            }
        }
        int smin = Integer.MAX_VALUE;
        int emax = -1;
        for (int j = this.futvars.limit; j >= 0; --j) {
            int i = this.futvars.dense[j];
            if (this.scp[i].dom.firstValue() < smin) {
                smin = this.scp[i].dom.firstValue();
            }
            if (emax >= this.scp[i].dom.lastValue() + this.lengths[i]) continue;
            emax = this.scp[i].dom.lastValue() + this.lengths[i];
        }
        int depth = this.pb.solver.depth();
        for (int j = this.omega.limit; j >= 0; --j) {
            int i = this.omega.dense[j];
            if (this.scp[i].dom.size() != 1 || this.scp[i].dom.lastValue() + this.lengths[i] > smin && emax > this.scp[i].dom.firstValue()) continue;
            this.omega.removeAtPosition(j, depth);
        }
        return true;
    }

    private static class Slot {
        int start;
        int end;
        int height;

        private Slot() {
        }

        public String toString() {
            return "(" + this.start + "-" + this.end + ":" + this.height + ")";
        }
    }
}

