/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import interfaces.TagFilteringCompleteAtEachCall;
import interfaces.TagFilteringPartialAtEachCall;
import interfaces.TagGACGuaranteed;
import interfaces.TagSymmetric;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Types;
import problem.Problem;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import utility.sets.SetSparse;
import variables.Variable;
import variables.domains.Domain;

public abstract class Count
extends CtrGlobal {
    protected final int value;
    protected final int k;

    public static Count buildFrom(Problem pb, Variable[] scp, int value, Types.TypeConditionOperatorRel op, int k) {
        switch (op) {
            case LT: {
                return new AtMostK(pb, scp, value, k - 1);
            }
            case LE: {
                return new AtMostK(pb, scp, value, k);
            }
            case GE: {
                return new AtLeastK(pb, scp, value, k);
            }
            case GT: {
                return new AtLeastK(pb, scp, value, k + 1);
            }
            case EQ: {
                return new ExactlyK(pb, scp, value, k);
            }
        }
        throw new UnreachableCodeException("NE is not implemented");
    }

    public Count(Problem pb, Variable[] list, int value, int k) {
        super(pb, list);
        this.value = value;
        this.k = k;
        this.defineKey(value, k);
        Kit.control(0 < k && k < list.length, () -> "Bad value of k=" + k);
        Kit.control(Stream.of(list).allMatch(x -> x.dom.isPresentValue(value) && x.dom.size() > 1), () -> "Badly formed scope.");
    }

    public static final class Exactly1
    extends ExactlyK {
        public Exactly1(Problem pb, Variable[] list, int value) {
            super(pb, list, value, 1);
        }
    }

    public static class ExactlyK
    extends Count
    implements TagSymmetric,
    TagGACGuaranteed,
    TagFilteringCompleteAtEachCall {
        @Override
        public boolean checkValues(int[] t) {
            return Kit.countIn(this.value, t) == this.k;
        }

        public ExactlyK(Problem pb, Variable[] list, int value, int k) {
            super(pb, list, value, k);
        }

        @Override
        public boolean runPropagator(Variable x) {
            int nGuaranteedOccurrences = 0;
            int nPossibleOccurrences = 0;
            for (Variable y : this.scp) {
                if (!y.dom.isPresentValue(this.value)) continue;
                ++nPossibleOccurrences;
                if (y.dom.size() != 1 || ++nGuaranteedOccurrences <= this.k) continue;
                return y.dom.fail();
            }
            if (nGuaranteedOccurrences == this.k) {
                for (int i = this.futvars.limit; i >= 0; --i) {
                    Domain dom = this.scp[this.futvars.dense[i]].dom;
                    if (dom.size() <= 1) continue;
                    dom.removeValue(this.value, false);
                }
                return true;
            }
            if (nPossibleOccurrences < this.k) {
                return x.dom.fail();
            }
            if (nPossibleOccurrences == this.k) {
                for (int i = this.futvars.limit; i >= 0; --i) {
                    Domain dom = this.scp[this.futvars.dense[i]].dom;
                    if (dom.size() <= 1 || !dom.isPresentValue(this.value)) continue;
                    dom.reduceToValue(this.value);
                }
            }
            return true;
        }
    }

    public static final class AtLeast1
    extends AtLeastK {
        private Variable sentinel1;
        private Variable sentinel2;

        public AtLeast1(Problem pb, Variable[] list, int value) {
            super(pb, list, value, 1);
            this.sentinel1 = list[0];
            this.sentinel2 = list[1];
        }

        private Variable findAnotherSentinel() {
            for (Variable x : this.scp) {
                if (x == this.sentinel1 || x == this.sentinel2 || !x.dom.isPresentValue(this.value)) continue;
                return x;
            }
            return null;
        }

        @Override
        public boolean runPropagator(Variable x) {
            if (x == this.sentinel1) {
                if (!this.sentinel1.dom.isPresentValue(this.value)) {
                    Variable sentinel = this.findAnotherSentinel();
                    if (sentinel != null) {
                        this.sentinel1 = sentinel;
                    } else if (!this.sentinel2.dom.reduceToValue(this.value)) {
                        return false;
                    }
                }
            } else if (x == this.sentinel2 && !this.sentinel2.dom.isPresentValue(this.value)) {
                Variable sentinel = this.findAnotherSentinel();
                if (sentinel != null) {
                    this.sentinel2 = sentinel;
                } else if (!this.sentinel1.dom.reduceToValue(this.value)) {
                    return false;
                }
            }
            return true;
        }
    }

    public static class AtLeastK
    extends Count
    implements TagSymmetric,
    TagGACGuaranteed,
    TagFilteringPartialAtEachCall {
        protected SetSparse sentinels;

        @Override
        public boolean checkValues(int[] t) {
            return Kit.countIn(this.value, t) >= this.k;
        }

        public AtLeastK(Problem pb, Variable[] list, int value, int k) {
            super(pb, list, value, k);
            if (k > 1) {
                this.sentinels = new SetSparse(list.length);
                IntStream.range(0, k + 1).forEach(i -> this.sentinels.add(i));
            }
        }

        @Override
        public boolean runPropagator(Variable x) {
            int i;
            int p = this.positionOf(x);
            if (!this.sentinels.isPresent(p) || x.dom.isPresentValue(this.value)) {
                return true;
            }
            int[] dense = this.sentinels.dense;
            for (i = this.sentinels.limit + 1; i < dense.length; ++i) {
                if (!this.scp[dense[i]].dom.isPresentValue(this.value)) continue;
                this.sentinels.swap(p, dense[i]);
                return true;
            }
            for (i = this.sentinels.limit; i >= 0; --i) {
                if (dense[i] == p || this.scp[dense[i]].dom.reduceToValue(this.value)) continue;
                return false;
            }
            return true;
        }
    }

    public static final class AtMost1
    extends AtMostK {
        public AtMost1(Problem pb, Variable[] list, int value) {
            super(pb, list, value, 1);
        }

        @Override
        public boolean runPropagator(Variable x) {
            if (!x.dom.onlyContainsValue(this.value)) {
                return true;
            }
            for (Variable y : this.scp) {
                if (y == x || y.dom.removeValue(this.value, false)) continue;
                return false;
            }
            return true;
        }
    }

    public static class AtMostK
    extends Count
    implements TagSymmetric,
    TagGACGuaranteed,
    TagFilteringPartialAtEachCall {
        @Override
        public boolean checkValues(int[] t) {
            return Kit.countIn(this.value, t) <= this.k;
        }

        public AtMostK(Problem pb, Variable[] list, int value, int k) {
            super(pb, list, value, k);
        }

        @Override
        public boolean runPropagator(Variable x) {
            if (!x.dom.onlyContainsValue(this.value)) {
                return true;
            }
            int cnt = 0;
            for (Variable y : this.scp) {
                if (!y.dom.onlyContainsValue(this.value) || ++cnt <= this.k) continue;
                return x.dom.fail();
            }
            if (cnt == this.k) {
                for (int i = this.futvars.limit; i >= 0; --i) {
                    Domain dom = this.scp[this.futvars.dense[i]].dom;
                    if (dom.size() <= 1) continue;
                    dom.removeValueSafelyIfPresent(this.value);
                }
            }
            return true;
        }
    }
}

