/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import interfaces.ObserverBacktracking;
import interfaces.TagFilteringPartialAtEachCall;
import interfaces.TagGACGuaranteed;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import problem.Problem;
import utility.Kit;
import variables.Variable;

public class AtLeast1Reified
extends CtrGlobal
implements ObserverBacktracking.ObserverBacktrackingSystematic,
TagFilteringPartialAtEachCall,
TagGACGuaranteed {
    private final Variable[] list;
    private final int value;
    private final Variable reif;
    private Variable sentinel1;
    private Variable sentinel2;
    private boolean entailed;

    @Override
    public boolean checkValues(int[] t) {
        boolean b = t[0] == 1;
        for (int i = 1; i < t.length; ++i) {
            if (t[i] != this.value) continue;
            return b;
        }
        return !b;
    }

    @Override
    public void restoreBefore(int depth) {
        this.entailed = false;
    }

    @Override
    public int[] defineSymmetryMatching() {
        return IntStream.range(0, this.scp.length).map(i -> i == 0 ? 1 : 2).toArray();
    }

    public AtLeast1Reified(Problem pb, Variable[] list, int value, Variable reif) {
        super(pb, (Variable[])pb.api.vars(reif, list));
        Kit.control(list.length >= 2 && Variable.areAllDistinct(list) && Variable.areAllInitiallyBoolean(reif));
        Stream.of(list).forEach(x -> Kit.control(x.dom.toPresentIdx(value) != -1, () -> x + " should not be in  " + this + " since its domain does not contain " + value));
        this.list = list;
        this.value = value;
        this.reif = reif;
        this.sentinel1 = list[0];
        this.sentinel2 = list[1];
    }

    private Variable findAnotherSentinel() {
        for (Variable x : this.scp) {
            if (x == this.sentinel1 || x == this.sentinel2 || !x.dom.isPresentValue(this.value)) continue;
            return x;
        }
        return null;
    }

    @Override
    public boolean runPropagator(Variable x) {
        if (this.entailed) {
            return true;
        }
        if (x == this.reif) {
            assert (this.reif.dom.size() == 1);
            if (this.reif.dom.first() == 0) {
                for (Variable y : this.list) {
                    if (y.dom.removeValue(this.value, false)) continue;
                    return false;
                }
                this.entailed = true;
                return true;
            }
        } else if (x.dom.onlyContainsValue(this.value)) {
            if (!this.reif.dom.removeValue(0, false)) {
                return false;
            }
            this.entailed = true;
            return true;
        }
        if (this.reif.dom.size() == 2) {
            if (!this.sentinel1.dom.isPresentValue(this.value)) {
                Variable sentinel = this.findAnotherSentinel();
                if (sentinel == null) {
                    this.reif.dom.remove(1);
                    this.entailed = true;
                    return true;
                }
                this.sentinel1 = sentinel;
            }
        } else {
            Variable sentinel;
            assert (this.reif.dom.first() == 1);
            if (!this.sentinel1.dom.isPresentValue(this.value)) {
                sentinel = this.findAnotherSentinel();
                if (sentinel == null) {
                    return !this.sentinel2.dom.reduceToValue(this.value) ? false : (this.entailed = true);
                }
                this.sentinel1 = sentinel;
            }
            if (!this.sentinel2.dom.isPresentValue(this.value)) {
                sentinel = this.findAnotherSentinel();
                if (sentinel == null) {
                    return !this.sentinel1.dom.reduceToValue(this.value) ? false : (this.entailed = true);
                }
                this.sentinel2 = sentinel;
            }
        }
        return true;
    }
}

