/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import interfaces.ObserverBacktracking;
import interfaces.TagFilteringCompleteAtEachCall;
import interfaces.TagGACGuaranteed;
import interfaces.TagSymmetric;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import problem.Problem;
import utility.Kit;
import utility.sets.SetDense;
import utility.sets.SetSparseReversible;
import variables.Variable;
import variables.domains.Domain;

public final class AllEqual2
extends CtrGlobal
implements ObserverBacktracking.ObserverBacktrackingSystematic,
TagGACGuaranteed,
TagFilteringCompleteAtEachCall,
TagSymmetric {
    private final Map<Integer, Integer> map;
    private SetSparseReversible remainingValues;
    private SetDense lastRemovedValues;

    @Override
    public final boolean checkValues(int[] t) {
        return IntStream.range(0, t.length - 1).allMatch(i -> t[i] == t[i + 1]);
    }

    @Override
    public void restoreBefore(int depth) {
        this.remainingValues.restoreLimitAtLevel(depth);
    }

    @Override
    public void onConstructionProblemFinished() {
        super.onConstructionProblemFinished();
        this.remainingValues = new SetSparseReversible(this.map.size(), this.pb.variables.length + 1);
        this.lastRemovedValues = new SetDense(this.map.size());
    }

    public AllEqual2(Problem pb, Variable[] list) {
        super(pb, list);
        int[] allValues = Variable.setOfvaluesIn(list).stream().mapToInt(v -> v).sorted().toArray();
        this.map = IntStream.range(0, allValues.length).boxed().collect(Collectors.toMap(i -> allValues[i], i -> i, (v1, v2) -> v1 + v2, TreeMap::new));
        Kit.control(allValues.length > 1 && list.length >= 2);
        this.defineKey(new Object[0]);
    }

    @Override
    public boolean runPropagator(Variable x) {
        Variable y;
        if (this.remainingValues.size() == 1) {
            return true;
        }
        Variable variable = y = x.dom.size() == 1 ? x : null;
        if (y == null) {
            for (Variable z : this.scp) {
                if (z.dom.size() != 1) continue;
                y = z;
                break;
            }
        }
        if (y != null) {
            int v = y.dom.uniqueValue();
            for (Variable z : this.scp) {
                if (z == y || z.dom.reduceToValue(v)) continue;
                return false;
            }
            this.remainingValues.reduceTo(this.map.get(v), this.pb.solver.depth());
            return true;
        }
        this.lastRemovedValues.clear();
        for (Domain dom : this.doms) {
            int v;
            int a = dom.lastRemoved();
            while (a != -1 && this.remainingValues.isPresent(this.map.get(v = dom.toVal(a)))) {
                this.lastRemovedValues.add(v);
                a = dom.prevRemoved(a);
            }
        }
        if (this.lastRemovedValues.size() == this.remainingValues.size()) {
            return x.dom.fail();
        }
        for (int j = this.scp.length - 1; j >= 0; --j) {
            this.scp[j].dom.removeValuesIn(this.lastRemovedValues);
        }
        int depth = this.pb.solver.depth();
        for (int i = this.lastRemovedValues.limit; i >= 0; --i) {
            this.remainingValues.remove(this.map.get(this.lastRemovedValues.dense[i]), depth);
        }
        return true;
    }
}

