/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import interfaces.ObserverBacktracking;
import interfaces.TagFilteringCompleteAtEachCall;
import interfaces.TagGACGuaranteed;
import interfaces.TagSymmetric;
import java.util.stream.IntStream;
import problem.Problem;
import utility.Kit;
import utility.sets.SetSparse;
import variables.Variable;

public final class AllEqual
extends CtrGlobal
implements ObserverBacktracking.ObserverBacktrackingSystematic,
TagGACGuaranteed,
TagFilteringCompleteAtEachCall,
TagSymmetric {
    private final int[] frontier;
    private final SetSparse set;
    private int entailedLevel = -1;
    int cnt = 0;

    @Override
    public final boolean checkValues(int[] t) {
        return IntStream.range(0, t.length - 1).allMatch(i -> t[i] == t[i + 1]);
    }

    @Override
    public void restoreBefore(int depth) {
        if (depth == this.entailedLevel) {
            this.entailedLevel = -1;
        }
        if (this.entailedLevel == -1) {
            for (int i = this.scp.length - 1; i >= 0; --i) {
                this.frontier[i] = this.scp[i].dom.lastRemoved();
            }
        }
    }

    public AllEqual(Problem pb, Variable[] list) {
        super(pb, list);
        Kit.control(list.length >= 2 && Variable.haveAllSameDomainType(list));
        this.frontier = Kit.repeat(-1, list.length);
        this.set = new SetSparse(list[0].dom.initSize());
        this.defineKey(new Object[0]);
    }

    @Override
    public boolean runPropagator(Variable x) {
        int i;
        if (this.entailedLevel != -1) {
            return true;
        }
        Variable y = x.dom.size() == 1 ? x : null;
        for (i = this.scp.length - 1; y == null && i >= 0; --i) {
            if (this.scp[i].dom.size() != 1) continue;
            y = this.scp[i];
        }
        if (y != null) {
            int a = x.dom.unique();
            for (int i2 = this.scp.length - 1; i2 >= 0; --i2) {
                if (this.scp[i2].dom.reduceTo(a)) continue;
                return false;
            }
            this.entailedLevel = this.pb.solver.depth();
            return true;
        }
        this.set.clear();
        for (i = this.scp.length - 1; i >= 0; --i) {
            int a = this.scp[i].dom.lastRemoved();
            while (a != this.frontier[i]) {
                this.set.add(a);
                a = this.scp[i].dom.prevRemoved(a);
            }
        }
        for (i = this.scp.length - 1; i >= 0; --i) {
            if (this.scp[i].dom.remove(this.set, true)) continue;
            return false;
        }
        for (i = this.scp.length - 1; i >= 0; --i) {
            this.frontier[i] = this.scp[i].dom.lastRemoved();
        }
        return true;
    }
}

