/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import constraints.Constraint;
import constraints.hard.extension.structures.ExtensionStructureHard;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.xcsp.common.Range;
import org.xcsp.common.Utilities;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public class Table
extends ExtensionStructureHard {
    private static Map<String, int[][]> map = new HashMap<String, int[][]>();
    public int[][] tuples;
    public boolean positive;
    public boolean isShort;

    public static int[][] shortTuplesForElement(Variable[] list, Variable index, int value) {
        Kit.control(Variable.areAllDistinct(list) && !Kit.isPresent(index, list));
        Kit.control(index.dom.areInitValuesExactly(new Range(list.length)) && Variable.areAllDomainsContainingValue(list, value));
        return (int[][])IntStream.range(0, list.length).mapToObj(i -> IntStream.range(0, list.length + 1).map(j -> j == 0 ? i : (j == i + 1 ? value : 0x7FFFFFFE)).toArray()).toArray(x$0 -> new int[x$0][]);
    }

    public static int[][] shortTuplesForElement(Variable[] list, Variable index, Variable value) {
        Kit.control(Variable.areAllDistinct(list) && !Kit.isPresent(index, list) && index != value);
        Kit.control(index.dom.areInitValuesExactly(new Range(list.length)));
        Domain domResult = value.dom;
        int resultPositionInVector = Utilities.indexOf(value, list);
        int arity = resultPositionInVector == -1 ? list.length + 2 : list.length + 1;
        int resultPositionInTuple = resultPositionInVector == -1 ? arity - 1 : resultPositionInVector + 1;
        ArrayList<int[]> tuples = new ArrayList<int[]>();
        for (int i = 0; i < list.length; ++i) {
            Domain dom = list[i].dom;
            int a = dom.first();
            while (a != -1) {
                int v = dom.toVal(a);
                if (domResult.isPresentValue(v)) {
                    int[] tuple = Kit.repeat(0x7FFFFFFE, arity);
                    tuple[0] = i;
                    tuple[i + 1] = v;
                    tuple[resultPositionInTuple] = v;
                    tuples.add(tuple);
                }
                a = dom.next(a);
            }
        }
        return Kit.intArray2D(tuples);
    }

    public static int[][] shortTuplesFordNotEqualVectors(Variable[] t1, Variable[] t2) {
        Kit.control(t1.length == t2.length);
        String key = "NotAllEqualVector " + Variable.signatureFor(t1) + " " + Variable.signatureFor(t2);
        int[][] tuples = map.get(key);
        if (tuples == null) {
            int k = t1.length;
            ArrayList<int[]> list = new ArrayList<int[]>();
            for (int i = 0; i < k; ++i) {
                Domain dom1 = t1[i].dom;
                Domain dom2 = t2[i].dom;
                int a = dom1.first();
                while (a != -1) {
                    int v = dom1.toVal(a);
                    int b = dom2.first();
                    while (b != -1) {
                        int w = dom2.toVal(b);
                        if (v != w) {
                            int[] tuple = Kit.repeat(0x7FFFFFFE, 2 * k);
                            tuple[i] = v;
                            tuple[i + k] = w;
                            list.add(tuple);
                        }
                        b = dom2.next(b);
                    }
                    a = dom1.next(a);
                }
            }
            tuples = Kit.intArray2D(list);
            map.put(key, tuples);
        }
        return tuples;
    }

    public static int[][] addStarInAtPosition(int[][] m, int position) {
        return (int[][])IntStream.range(0, m.length).mapToObj(i -> IntStream.range(0, m[0].length + 1).map(j -> j < position ? m[i][j] : (j == position ? 0x7FFFFFFE : m[i][j - 1])).toArray()).toArray(x$0 -> new int[x$0][]);
    }

    @Override
    public void storeTuples(int[][] m, boolean positive) {
        Constraint c = this.firstRegisteredCtr();
        this.isShort = false;
        if (m.length == 0) {
            this.tuples = new int[0][];
        } else {
            this.tuples = new int[m.length][c.scp.length];
            for (int j = 0; j < c.scp.length; ++j) {
                Domain dom = c.scp[j].dom;
                for (int i = 0; i < m.length; ++i) {
                    int v = m[i][j];
                    assert (m[i].length == c.scp.length);
                    assert (v == 0x7FFFFFFE || dom.toIdx(v) != -1) : Kit.join((Object)m[i], new String[0]) + " j=" + j + " " + c + " " + dom;
                    if (v == 0x7FFFFFFE) {
                        this.isShort = true;
                    }
                    this.tuples[i][j] = v == 0x7FFFFFFE ? 0x7FFFFFFE : dom.toIdx(v);
                }
            }
        }
        this.positive = positive;
        Arrays.sort(this.tuples, Utilities.lexComparatorInt);
    }

    public Table(Constraint c) {
        super(c);
    }

    private boolean isMatching(int[] tuple, int[] idxs) {
        for (int i = 0; i < tuple.length; ++i) {
            if (tuple[i] == 0x7FFFFFFE || tuple[i] == idxs[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkIdxs(int[] t) {
        if (this.isShort) {
            for (int[] tuple : this.tuples) {
                if (!this.isMatching(tuple, t)) continue;
                return true;
            }
            return false;
        }
        return Arrays.binarySearch(this.tuples, t, Utilities.lexComparatorInt) >= 0 == this.positive;
    }

    public String toString() {
        return "Tuples :\n" + Kit.join((Object)this.tuples, new String[0]) + " (" + this.positive + ")";
    }

    @Override
    public int[] computeVariableSymmetryMatching() {
        return this.computeVariableSymmetryMatching(this.tuples, this.positive);
    }
}

