/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import constraints.hard.extension.CtrExtensionSegmented;
import interfaces.ObserverBacktracking;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;
import problem.Problem;
import utility.Kit;
import utility.sets.SetDenseReversible;
import utility.sets.SetSparse;
import variables.Variable;
import variables.domains.Domain;

public final class SegmentedTuple {
    private Variable[] scp;
    private int[] prefixWithValues;
    private int[] prefix;
    public final RestrictionTable[] restrictions;
    private SetSparse[] unsupported;
    private boolean[][] globalac;

    public SegmentedTuple(int[] prefixWithValues, RestrictionTable[] restrictions) {
        this.prefixWithValues = prefixWithValues;
        this.restrictions = restrictions == null ? new RestrictionTable[]{} : restrictions;
    }

    public void attach(CtrExtensionSegmented ctr) {
        this.scp = ctr.scp;
        this.prefixWithValues = this.prefixWithValues != null ? this.prefixWithValues : Kit.repeat(0x7FFFFFFE, this.scp.length);
        this.prefix = IntStream.range(0, this.scp.length).map(i -> this.prefixWithValues[i] == 0x7FFFFFFE ? 0x7FFFFFFE : this.scp[i].dom.toIdx(this.prefixWithValues[i])).toArray();
        this.unsupported = ctr.unsupported;
        assert (Variable.areSortedDomainsIn(this.scp));
        this.globalac = new boolean[ctr.scp.length][];
        for (RestrictionTable restriction : this.restrictions) {
            for (int i2 = 0; i2 < restriction.subscp.length; ++i2) {
                RestrictionTable.access$102(restriction, Stream.of(restriction.subscp).mapToInt(x -> Utilities.indexOf(x, this.scp)).toArray());
                RestrictionTable.access$202(restriction, Stream.of(this.scp).mapToInt(x -> Utilities.indexOf(x, restriction.subscp)).toArray());
                this.globalac[((RestrictionTable)restriction).positionsInScp[i2]] = restriction.ac[i2];
            }
        }
    }

    public boolean contains(int[] tuple) {
        for (int i = 0; i < tuple.length; ++i) {
            if (this.prefix[i] == 0x7FFFFFFE || this.prefix[i] == tuple[i]) continue;
            return false;
        }
        for (RestrictionTable restriction : this.restrictions) {
            if (restriction.contains(tuple)) continue;
            return false;
        }
        return true;
    }

    public final boolean isValid(int[] sVal, int sValSize) {
        for (int i = sValSize - 1; i >= 0; --i) {
            int x = sVal[i];
            int a = this.prefix[x];
            if (a == 0x7FFFFFFE || this.scp[x].dom.isPresent(a)) continue;
            return false;
        }
        for (RestrictionTable restriction : this.restrictions) {
            if (restriction.isValid(sVal, sValSize)) continue;
            return false;
        }
        return true;
    }

    public final int collect(int[] sSup, int sSupSize) {
        for (RestrictionTable restriction : this.restrictions) {
            restriction.collect(sSup, sSupSize);
        }
        for (int i = sSupSize - 1; i >= 0; --i) {
            int x = sSup[i];
            assert (!this.unsupported[x].isEmpty());
            if (this.globalac[x] == null) {
                int a = this.prefix[x];
                if (a == 0x7FFFFFFE) {
                    this.unsupported[x].clear();
                } else {
                    this.unsupported[x].remove(a);
                }
            } else {
                for (int j = this.unsupported[x].limit; j >= 0; --j) {
                    int a = this.unsupported[x].dense[j];
                    if (!this.globalac[x][a]) continue;
                    this.unsupported[x].remove(a);
                }
            }
            if (!this.unsupported[x].isEmpty()) continue;
            sSup[i] = sSup[--sSupSize];
        }
        return sSupSize;
    }

    public String toString() {
        String s = "Split tuple : ";
        s = s + (this.prefix == null ? "" : Kit.join((Object)this.prefix, i -> i == 0x7FFFFFFE ? "*" : i.toString(), new String[0]));
        return s + " : " + Stream.of(this.restrictions).map(r -> r.toString()).collect(Collectors.joining(", "));
    }

    public static class RestrictionTable
    implements ObserverBacktracking.ObserverBacktrackingSystematic {
        private Problem pb;
        private Variable[] subscp;
        private Domain[] subdoms;
        protected int[][] subtable;
        private int[] positionsInScp;
        private int[] positionsInSubscp;
        public SetDenseReversible set;
        protected boolean[][] ac;
        protected int[] cnts;
        private int[] sLocal;
        private int sLocalSize;

        @Override
        public void restoreBefore(int depth) {
            this.set.restoreLimitAtLevel(depth);
        }

        public void onConstructionProblemFinished(Problem pb) {
            this.pb = pb;
            this.set = new SetDenseReversible(this.subtable.length, pb.variables.length + 1);
        }

        public RestrictionTable(Variable[] subscp, int[][] subtable) {
            this.subscp = subscp;
            this.subdoms = (Domain[])Stream.of(subscp).map(x -> x.dom).toArray(Domain[]::new);
            this.subtable = subtable;
            this.ac = Variable.litterals(subscp).booleanArray();
            this.cnts = new int[subscp.length];
            Kit.control(subtable.length > 0);
            this.sLocal = new int[subscp.length];
        }

        private void fillLocal(int[] sGlobal, int sGlobalSize) {
            this.sLocalSize = 0;
            for (int i = sGlobalSize - 1; i >= 0; --i) {
                int x = sGlobal[i];
                int xlocal = this.positionsInSubscp[x];
                if (xlocal == -1) continue;
                this.sLocal[this.sLocalSize++] = xlocal;
            }
        }

        private boolean isValid(int[] subtuple) {
            for (int i = this.sLocalSize - 1; i >= 0; --i) {
                int x = this.sLocal[i];
                int a = subtuple[x];
                if (a == 0x7FFFFFFE || this.subdoms[x].isPresent(a)) continue;
                return false;
            }
            return true;
        }

        public boolean isValid(int[] sVal, int sValSize) {
            int depth = this.pb.solver.depth();
            this.fillLocal(sVal, sValSize);
            for (int i = this.set.limit; i >= 0; --i) {
                int[] subtuple = this.subtable[this.set.dense[i]];
                if (this.isValid(subtuple)) continue;
                this.set.removeAtPosition(i, depth);
            }
            return this.set.size() > 0;
        }

        private void collect(int[] sSup, int sSupSize) {
            this.fillLocal(sSup, sSupSize);
            for (int j = this.sLocalSize - 1; j >= 0; --j) {
                int x = this.sLocal[j];
                this.cnts[x] = this.subdoms[x].size();
                Arrays.fill(this.ac[x], false);
            }
            for (int i = this.set.limit; i >= 0; --i) {
                int[] subtuple = this.subtable[this.set.dense[i]];
                for (int j = this.sLocalSize - 1; j >= 0; --j) {
                    int x = this.sLocal[j];
                    if (this.cnts[x] <= 0) continue;
                    int a = subtuple[x];
                    if (a == 0x7FFFFFFE) {
                        this.cnts[x] = 0;
                        Arrays.fill(this.ac[x], true);
                        this.sLocal[j] = this.sLocal[--this.sLocalSize];
                        continue;
                    }
                    if (this.ac[x][a]) continue;
                    this.ac[x][a] = true;
                    int n = x;
                    this.cnts[n] = this.cnts[n] - 1;
                    if (this.cnts[n] != 0) continue;
                    this.sLocal[j] = this.sLocal[--this.sLocalSize];
                }
            }
        }

        private boolean isMatching(int[] subtuple, int[] tuple) {
            for (int x = 0; x < subtuple.length; ++x) {
                if (subtuple[x] == 0x7FFFFFFE || subtuple[x] == tuple[this.positionsInScp[x]]) continue;
                return false;
            }
            return true;
        }

        public boolean contains(int[] tuple) {
            for (int[] subtuple : this.subtable) {
                if (!this.isMatching(subtuple, tuple)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "\nsubscp=" + Utilities.join(this.subscp) + "\nsubtable=" + Utilities.join(this.subtable);
        }

        static /* synthetic */ int[] access$102(RestrictionTable x0, int[] x1) {
            x0.positionsInScp = x1;
            return x1;
        }

        static /* synthetic */ int[] access$202(RestrictionTable x0, int[] x1) {
            x0.positionsInSubscp = x1;
            return x1;
        }
    }
}

