/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.xcsp.common.structures.Transitions;
import utility.Kit;

public final class MDDNodeCDbef {
    public static int nBuiltNodes;
    public static final MDDNodeCDbef nodeF;
    public static final MDDNodeCDbef nodeT;
    public int id;
    public Map<Integer, MDDNodeCDbef> sons = new HashMap<Integer, MDDNodeCDbef>();

    public int[] sortedKeys() {
        return this.sons.keySet().stream().mapToInt(i -> i).sorted().toArray();
    }

    public String name() {
        return this == nodeF ? "nodeF" : (this == nodeT ? "nodeT" : "n" + this.id);
    }

    public final boolean isLeaf() {
        return this == nodeF || this == nodeT;
    }

    public MDDNodeCDbef(MDDNodeCDbef node, Map<Integer, MDDNodeCDbef> map) {
        this.id = nBuiltNodes++;
        for (int key : node.sons.keySet()) {
            MDDNodeCDbef f = node.sons.get(key);
            if (f == nodeT) {
                this.sons.put(key, nodeT);
                continue;
            }
            if (map.containsKey(f.id)) {
                this.sons.put(key, map.get(f.id));
                continue;
            }
            MDDNodeCDbef m = new MDDNodeCDbef(f, map);
            map.put(f.id, m);
            this.sons.put(key, m);
        }
    }

    public MDDNodeCDbef() {
        this.id = nBuiltNodes++;
    }

    public static MDDNodeCDbef or(int level, MDDNodeCDbef f1, MDDNodeCDbef f2) {
        MDDNodeCDbef r = new MDDNodeCDbef();
        int[] keys1 = f1.sortedKeys();
        int[] keys2 = f2.sortedKeys();
        int i1 = 0;
        int i2 = 0;
        while (i1 < keys1.length && i2 < keys2.length) {
            if (keys1[i1] < keys2[i2]) {
                r.sons.put(keys1[i1], f1.sons.get(keys1[i1]) == nodeT ? nodeT : new MDDNodeCDbef(f1.sons.get(keys1[i1]), new HashMap<Integer, MDDNodeCDbef>()));
                ++i1;
                continue;
            }
            if (keys1[i1] > keys2[i2]) {
                r.sons.put(keys2[i2], f2.sons.get(keys2[i2]) == nodeT ? nodeT : new MDDNodeCDbef(f2.sons.get(keys2[i2]), new HashMap<Integer, MDDNodeCDbef>()));
                ++i2;
                continue;
            }
            r.sons.put(keys1[i1], MDDNodeCDbef.or(level + 1, f1.sons.get(keys1[i1]), f2.sons.get(keys2[i2])));
            ++i1;
            ++i2;
        }
        while (i1 < keys1.length) {
            r.sons.put(keys1[i1], f1.sons.get(keys1[i1]) == nodeT ? nodeT : new MDDNodeCDbef(f1.sons.get(keys1[i1]), new HashMap<Integer, MDDNodeCDbef>()));
            ++i1;
        }
        while (i2 < keys2.length) {
            r.sons.put(keys2[i2], f2.sons.get(keys2[i2]) == nodeT ? nodeT : new MDDNodeCDbef(f2.sons.get(keys2[i2]), new HashMap<Integer, MDDNodeCDbef>()));
            ++i2;
        }
        return r;
    }

    public int[] signature() {
        int[] t = new int[this.sortedKeys().length * 2];
        int nb = 0;
        for (int key : this.sortedKeys()) {
            t[nb++] = key;
            t[nb++] = this.sons.get((Object)Integer.valueOf((int)key)).id;
        }
        return t;
    }

    private void addTuple(int level, int[] tuple) {
        if (level == tuple.length - 1) {
            this.sons.put(tuple[level], nodeT);
        } else {
            this.sons.computeIfAbsent(tuple[level], v -> new MDDNodeCDbef()).addTuple(level + 1, tuple);
        }
    }

    public void addTuple(int[] tuple) {
        this.addTuple(0, tuple);
    }

    public void renameNodeIds(int offset, Map<Integer, MDDNodeCDbef> map) {
        if (this.isLeaf() || map.get(this.id) == this) {
            return;
        }
        this.id += offset;
        map.put(this.id, this);
        for (MDDNodeCDbef son : this.sons.values()) {
            son.renameNodeIds(offset, map);
        }
    }

    public void replaceTrueNode(MDDNodeCDbef newNode) {
        if (this.isLeaf()) {
            return;
        }
        for (int key : this.sons.keySet()) {
            if (this.sons.get(key) == nodeT) {
                this.sons.put(key, newNode);
                continue;
            }
            if (this.sons.get(key) == newNode) continue;
            this.sons.get(key).replaceTrueNode(newNode);
        }
    }

    public int renameNodes(int lastId, Map<Integer, MDDNodeCDbef> map) {
        if (this.isLeaf() || map.get(this.id) == this) {
            return lastId;
        }
        this.id = ++lastId;
        map.put(this.id, this);
        for (MDDNodeCDbef son : this.sons.values()) {
            lastId = son.renameNodes(lastId, map);
        }
        return lastId;
    }

    public int nInternalNodes(Set<Integer> set) {
        if (this.isLeaf() || set.contains(this.id)) {
            return 0;
        }
        set.add(this.id);
        return 1 + this.sons.values().stream().mapToInt(c -> c.nInternalNodes(set)).sum();
    }

    public boolean controlUniqueNodes(Map<Integer, MDDNodeCDbef> map) {
        MDDNodeCDbef node = map.get(this.id);
        if (node == null) {
            map.put(this.id, this);
        } else {
            Kit.control(node == this, () -> "two nodes with the same id in the MDD " + this.id);
        }
        return this.sons == null || this.sons.values().stream().allMatch(n -> n.controlUniqueNodes(map));
    }

    public void transitions(Transitions trs, Map<Integer, MDDNodeCDbef> map) {
        if (this.isLeaf() || map.get(this.id) == this) {
            return;
        }
        map.put(this.id, this);
        for (int key : this.sortedKeys()) {
            trs.add(this.id == 2 ? "r" : "n" + this.id, key, "n" + this.sons.get((Object)Integer.valueOf((int)key)).id);
            this.sons.get(key).transitions(trs, map);
        }
    }

    public int displayTuples(int cnt, List<Integer> list) {
        if (this.isLeaf()) {
            System.out.println(Kit.join(list, new String[0]));
            return cnt + 1;
        }
        for (int key : this.sortedKeys()) {
            list.add(key);
            cnt = this.sons.get(key).displayTuples(cnt, list);
            list.remove(list.size() - 1);
        }
        return cnt;
    }

    public void display(int level, Map<Integer, MDDNodeCDbef> map) {
        if (this.isLeaf() || map.get(this.id) == this) {
            return;
        }
        map.put(this.id, this);
        System.out.println(this.id + "@" + level + " => {" + IntStream.of(this.sortedKeys()).mapToObj(key -> key + ":" + this.sons.get((Object)Integer.valueOf((int)key)).id).collect(Collectors.joining(",")) + "}");
        this.sons.values().stream().filter(n -> n.id > this.id).forEach(n -> n.display(level + 1, map));
    }

    static {
        nodeF = new MDDNodeCDbef();
        nodeT = new MDDNodeCDbef();
    }
}

