/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import constraints.Constraint;
import constraints.hard.extension.structures.ExtensionStructure;
import java.util.HashSet;
import java.util.Set;
import utility.Kit;
import utility.exceptions.MissingImplementationException;
import variables.Variable;
import variables.domains.Domain;

public abstract class ExtensionStructureHard
extends ExtensionStructure {
    public String[][] symbolicTuples;
    public int[][] originalTuples;
    public boolean originalPositive;

    public ExtensionStructureHard(Constraint c) {
        super(c);
    }

    public abstract void storeTuples(int[][] var1, boolean var2);

    public abstract boolean checkIdxs(int[] var1);

    public int[] nextSupport(int vap, int a, int[] current) {
        throw new MissingImplementationException();
    }

    private boolean areSymmetricPositions(Set<Kit.IntArrayHashKey> set, int[][] tuples, int i, int j) {
        Kit.IntArrayHashKey key = new Kit.IntArrayHashKey();
        for (int[] tuple : tuples) {
            key.t = Kit.swap(tuple, i, j);
            boolean b = set.contains(key);
            Kit.swap(tuple, i, j);
            if (b) continue;
            return false;
        }
        return true;
    }

    public int[] computeVariableSymmetryMatching(int[][] tuples, boolean positive) {
        Kit.control(this.firstRegisteredCtr().pb.rs.cp.symmetryBreaking);
        Constraint ctr = this.firstRegisteredCtr();
        if (!Variable.haveAllSameDomainType(ctr.scp)) {
            return Kit.range(1, ctr.scp.length);
        }
        if (ctr.scp.length == 1) {
            return new int[]{1};
        }
        if (ctr.scp.length == 2) {
            Domain dom0 = ctr.scp[0].dom;
            Domain dom1 = ctr.scp[1].dom;
            int[] tmp = ctr.tupleManager.localTuple;
            for (int[] tuple : tuples) {
                tmp[0] = dom0.toIdx(tuple[1]);
                tmp[1] = dom1.toIdx(tuple[0]);
                if (this.checkIdxs(tmp) == positive) continue;
                return new int[]{1, 2};
            }
            return new int[]{1, 1};
        }
        HashSet<Kit.IntArrayHashKey> set = new HashSet<Kit.IntArrayHashKey>();
        for (int[] t : tuples) {
            set.add(new Kit.IntArrayHashKey(t));
        }
        int[] permutation = new int[ctr.scp.length];
        int color = 1;
        for (int i = 0; i < permutation.length; ++i) {
            if (permutation[i] != 0) continue;
            for (int j = i + 1; j < permutation.length; ++j) {
                if (permutation[j] != 0 || !this.areSymmetricPositions(set, tuples, i, j)) continue;
                permutation[j] = color;
            }
            permutation[i] = color++;
        }
        return permutation;
    }

    public int[] computeVariableSymmetryMatching() {
        return Kit.range(1, this.firstRegisteredCtr().scp.length);
    }

    public boolean isSimilarTo(ExtensionStructureHard ext) {
        if (this.originalPositive != ext.originalPositive || this.originalTuples.length != ext.originalTuples.length) {
            return false;
        }
        if (this.originalTuples == ext.originalTuples || this.originalTuples.length == 0) {
            return true;
        }
        if (this.originalTuples.length > 10000) {
            return false;
        }
        int a = this.originalTuples[0].length - 1;
        for (int i = this.originalTuples.length - 1; i >= 0; --i) {
            for (int j = a; j >= 0; --j) {
                if (this.originalTuples[i][j] == ext.originalTuples[i][j]) continue;
                return false;
            }
        }
        return true;
    }
}

