/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension;

import constraints.hard.extension.CtrExtensionSTR1;
import constraints.hard.extension.structures.ExtensionStructureHard;
import constraints.hard.extension.structures.TableCompressed3;
import interfaces.TagExperimental;
import problem.Problem;
import variables.Variable;

public class CtrExtensionSTRCPRS
extends CtrExtensionSTR1
implements TagExperimental {
    protected TableCompressed3 tableCompressed;
    protected int[][] stamps;
    private int time = 1;

    public CtrExtensionSTRCPRS(Problem pb, Variable[] scp) {
        super(pb, scp);
    }

    @Override
    protected ExtensionStructureHard buildExtensionStructure() {
        return new TableCompressed3(this);
    }

    @Override
    protected void initSpecificStructures() {
        super.initSpecificStructures();
        this.tableCompressed = (TableCompressed3)this.extStructure;
        this.stamps = new int[this.tableCompressed.patterns.length][this.scp.length];
    }

    @Override
    protected void beforeFiltering() {
        ++this.time;
        super.beforeFiltering();
    }

    public final boolean checkValidityOfCompressedTuple(int[] tuple) {
        int gap = 0;
        for (int vap = 0; vap < tuple.length; ++vap) {
            int posnc = vap + gap;
            int val = tuple[vap];
            if (val >= 0) {
                if (this.doms[posnc].isPresent(val)) continue;
                return false;
            }
            int[] patternStamps = this.stamps[-val];
            if (patternStamps[posnc] == -this.time) {
                return false;
            }
            int[] pattern = this.tableCompressed.patterns[-val];
            if (patternStamps[posnc] != this.time) {
                for (int i = pattern.length - 1; i >= 0; --i) {
                    if (this.doms[posnc + i].isPresent(pattern[i])) continue;
                    patternStamps[posnc] = -this.time;
                    return false;
                }
                patternStamps[posnc] = this.time;
            }
            gap += pattern.length - 1;
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        this.pb.stuff.updateStatsForSTR(this.set);
        int depth = this.pb.solver.depth();
        this.beforeFiltering();
        for (int i = this.set.limit; i >= 0; --i) {
            int[] compressedTuple = this.tableCompressed.tuples[this.set.dense[i]];
            if (this.checkValidityOfCompressedTuple(compressedTuple)) {
                int[] tuple = this.tableCompressed.decompress(compressedTuple);
                for (int j = this.futvars.limit; j >= 0; --j) {
                    int x = this.futvars.dense[j];
                    int a = tuple[x];
                    if (this.ac[x][a]) continue;
                    --this.cnt;
                    int n = x;
                    this.cnts[n] = this.cnts[n] - 1;
                    this.ac[x][a] = true;
                }
                continue;
            }
            this.set.removeAtPosition(i, depth);
        }
        return this.updateDomains();
    }
}

