/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension;

import constraints.hard.CtrExtension;
import constraints.hard.extension.structures.ExtensionStructureHard;
import constraints.hard.extension.structures.SubTable;
import constraints.hard.extension.structures.Table;
import interfaces.FilteringGlobal;
import interfaces.ObserverBacktracking;
import interfaces.ObserverSearch;
import interfaces.TagGACGuaranteed;
import interfaces.TagPositive;
import java.util.Arrays;
import java.util.stream.IntStream;
import problem.Problem;
import utility.Kit;
import utility.sets.SetSparse;
import utility.sets.SetSparseReversible;
import variables.Variable;
import variables.domains.Domain;

public final class CtrExtensionSTR3
extends CtrExtension
implements FilteringGlobal,
TagGACGuaranteed,
TagPositive,
ObserverBacktracking.ObserverBacktrackingSystematic,
ObserverSearch {
    protected int[][] tuples;
    protected SetSparseReversible set;
    protected int[] frontiers;
    protected boolean[][] ac;
    protected int[] cnts;
    protected int[][][] subtables;
    protected int[][] separators;
    protected short[][][] subtablesShort;
    protected short[][] separatorsShort;
    protected int[] offsetsForMaps;
    protected SetSparseMapSTR3[] separatorsMaps;
    protected LocalSetSparseByte[] deps;

    @Override
    public void restoreBefore(int depth) {
        int a;
        short x;
        int mapIndex;
        int i;
        this.set.restoreLimitAtLevel(depth);
        SetSparseMapSTR3 map = this.separatorsMaps[depth];
        int[] dense = map.dense;
        if (this.separators != null) {
            for (i = map.limit; i >= 0; --i) {
                mapIndex = dense[i];
                x = map.positions[mapIndex];
                a = mapIndex - this.offsetsForMaps[x];
                this.separators[x][a] = map.separators[mapIndex];
            }
        } else {
            for (i = map.limit; i >= 0; --i) {
                mapIndex = dense[i];
                x = map.positions[mapIndex];
                a = mapIndex - this.offsetsForMaps[x];
                this.separatorsShort[x][a] = (short)map.separators[mapIndex];
            }
        }
        map.clear();
        for (i = this.futvars.limit; i >= 0; --i) {
            int x2 = this.futvars.dense[i];
            this.frontiers[x2] = this.doms[x2].lastRemoved();
        }
    }

    public CtrExtensionSTR3(Problem pb, Variable[] scp) {
        super(pb, scp);
    }

    @Override
    public void onConstructionProblemFinished() {
        super.onConstructionProblemFinished();
        this.tuples = ((Table)this.extStructure).tuples;
        this.set = new SetSparseReversible(this.tuples.length, this.pb.variables.length + 1);
        this.offsetsForMaps = new int[this.scp.length];
        for (int i2 = 1; i2 < this.offsetsForMaps.length; ++i2) {
            this.offsetsForMaps[i2] = this.offsetsForMaps[i2 - 1] + this.scp[i2 - 1].dom.initSize();
        }
        int nValues = Variable.nInitValuesFor(this.scp);
        this.separatorsMaps = (SetSparseMapSTR3[])IntStream.rangeClosed(0, this.pb.variables.length).mapToObj(i -> new SetSparseMapSTR3(nValues, false)).toArray(SetSparseMapSTR3[]::new);
        this.deps = (LocalSetSparseByte[])IntStream.range(0, this.set.dense.length).mapToObj(i -> new LocalSetSparseByte(this.scp.length, false)).toArray(LocalSetSparseByte[]::new);
        if (this.set.capacity() >= Short.MAX_VALUE) {
            this.separators = Variable.litterals(this.scp).intArray();
        } else {
            this.separatorsShort = Variable.litterals(this.scp).shortArray();
        }
    }

    @Override
    protected ExtensionStructureHard buildExtensionStructure() {
        return new SubTable(this);
    }

    @Override
    protected void initSpecificStructures() {
        this.ac = Variable.litterals(this.scp).booleanArray();
        this.cnts = new int[this.scp.length];
        this.frontiers = new int[this.scp.length];
        this.subtables = ((SubTable)this.extStructure).subtables;
        this.subtablesShort = ((SubTable)this.extStructure).subtablesShort;
    }

    protected int initializeBeforePropagationAtPreprocessing() {
        int cnt = 0;
        for (int i = 0; i < this.scp.length; ++i) {
            this.cnts[i] = this.doms[i].size();
            cnt += this.cnts[i];
            Arrays.fill(this.ac[i], false);
        }
        return cnt;
    }

    protected boolean updateDomainsAtPreprocessing(int cnt) {
        for (int x = this.scp.length - 1; x >= 0 && cnt > 0; --x) {
            int nRemovals = this.cnts[x];
            if (nRemovals == 0) continue;
            if (!this.scp[x].dom.remove(this.ac[x], nRemovals)) {
                return false;
            }
            cnt -= nRemovals;
        }
        return true;
    }

    protected boolean filterAtPreprocessing() {
        int cnt = this.initializeBeforePropagationAtPreprocessing();
        for (int i = this.set.limit; i >= 0; --i) {
            int[] tuple = this.tuples[this.set.dense[i]];
            if (this.isValid(tuple)) {
                for (int x = this.scp.length - 1; x >= 0; --x) {
                    int a = tuple[x];
                    if (this.ac[x][a]) continue;
                    --cnt;
                    int n = x;
                    this.cnts[n] = this.cnts[n] - 1;
                    this.ac[x][a] = true;
                }
                continue;
            }
            this.set.removeAtPosition(i, 0);
        }
        return this.updateDomainsAtPreprocessing(cnt);
    }

    @Override
    public void beforeSearch() {
        int x;
        this.ac = null;
        this.cnts = null;
        for (int i = 0; i < this.frontiers.length; ++i) {
            this.frontiers[i] = this.doms[i].lastRemoved();
        }
        if (this.subtables != null) {
            for (x = this.scp.length - 1; x >= 0; --x) {
                Domain dom = this.scp[x].dom;
                int a = dom.first();
                while (a != -1) {
                    int[] subtable = this.subtables[x][a];
                    int p = subtable.length - 1;
                    while (!this.set.isPresent(subtable[p])) {
                        --p;
                    }
                    this.separators[x][a] = p;
                    p = 0;
                    while (!this.set.isPresent(subtable[p])) {
                        ++p;
                    }
                    this.deps[subtable[p]].add((byte)x);
                    a = dom.next(a);
                }
            }
        } else {
            for (x = this.scp.length - 1; x >= 0; --x) {
                Domain dom = this.scp[x].dom;
                int a = dom.first();
                while (a != -1) {
                    Kit.control(this.subtablesShort[x][a].length < Short.MAX_VALUE);
                    short[] subtableShort = this.subtablesShort[x][a];
                    int p = subtableShort.length - 1;
                    while (!this.set.isPresent(subtableShort[p])) {
                        --p;
                    }
                    this.separatorsShort[x][a] = (short)p;
                    p = 0;
                    while (!this.set.isPresent(subtableShort[p])) {
                        ++p;
                    }
                    this.deps[subtableShort[p]].add((byte)x);
                    a = dom.next(a);
                }
            }
        }
    }

    protected void suppressInvalidTuplesFromRemovedValuesInDomainAtPosition(int x) {
        Domain dom = this.doms[x];
        if (this.subtables != null) {
            int a = dom.lastRemoved();
            while (a != this.frontiers[x]) {
                int[] t = this.subtables[x][a];
                for (int p = this.separators[x][a]; p >= 0; --p) {
                    this.set.removeIfPresent(t[p]);
                }
                a = dom.prevRemoved(a);
            }
        } else {
            int a = dom.lastRemoved();
            while (a != this.frontiers[x]) {
                short[] t = this.subtablesShort[x][a];
                for (int p = this.separatorsShort[x][a]; p >= 0; --p) {
                    this.set.removeIfPresent(t[p]);
                }
                a = dom.prevRemoved(a);
            }
        }
    }

    protected void supressInvalidTuples() {
        int limitBefore = this.set.limit;
        Variable lastPast = this.pb.solver.futVars.lastPast();
        if (lastPast != null && this.positionOf(lastPast) != -1) {
            this.suppressInvalidTuplesFromRemovedValuesInDomainAtPosition(this.positionOf(lastPast));
        }
        for (int i = this.futvars.limit; i >= 0; --i) {
            this.suppressInvalidTuplesFromRemovedValuesInDomainAtPosition(this.futvars.dense[i]);
        }
        if (this.set.limit < limitBefore && this.set.limits[this.pb.solver.depth()] == -2) {
            this.set.limits[this.pb.solver.depth()] = limitBefore;
        }
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        int separator;
        int p;
        Object[] subtable;
        int a;
        byte x;
        int j;
        LocalSetSparseByte dependencies;
        int i;
        this.pb.stuff.updateStatsForSTR(this.set);
        if (this.ac != null) {
            return this.filterAtPreprocessing();
        }
        SetSparseMapSTR3 map = this.separatorsMaps[this.pb.solver.depth()];
        int limitBefore = this.set.limit;
        this.supressInvalidTuples();
        if (this.subtables != null) {
            for (i = this.set.limit + 1; i <= limitBefore; ++i) {
                int[] tuple = this.tuples[this.set.dense[i]];
                dependencies = this.deps[this.set.dense[i]];
                for (j = dependencies.limit; j >= 0; --j) {
                    x = dependencies.dense[j];
                    if (this.scp[x].isAssigned() || !this.scp[x].dom.isPresent(a = tuple[x])) continue;
                    subtable = this.subtables[x][a];
                    for (p = separator = this.separators[x][a]; p >= 0 && !this.set.isPresent(subtable[p]); --p) {
                    }
                    if (p < 0) {
                        if (this.scp[x].dom.remove(a)) continue;
                        return false;
                    }
                    if (p != separator) {
                        map.add(this.offsetsForMaps[x] + a, x, separator);
                        this.separators[x][a] = p;
                    }
                    dependencies.remove(x);
                    this.deps[subtable[p]].add(x);
                }
            }
        } else {
            for (i = this.set.limit + 1; i <= limitBefore; ++i) {
                int[] supressedTuple = this.tuples[this.set.dense[i]];
                dependencies = this.deps[this.set.dense[i]];
                for (j = dependencies.limit; j >= 0; --j) {
                    x = dependencies.dense[j];
                    if (this.scp[x].isAssigned() || !this.scp[x].dom.isPresent(a = supressedTuple[x])) continue;
                    subtable = this.subtablesShort[x][a];
                    for (p = separator = this.separatorsShort[x][a]; p >= 0 && !this.set.isPresent(subtable[p]); p = (int)((short)(p - 1))) {
                    }
                    if (p < 0) {
                        if (this.scp[x].dom.remove(a)) continue;
                        return false;
                    }
                    if (p != separator) {
                        map.add(this.offsetsForMaps[x] + a, x, separator);
                        this.separatorsShort[x][a] = p;
                    }
                    dependencies.remove(x);
                    this.deps[subtable[p]].add(x);
                }
            }
        }
        for (i = this.futvars.limit; i >= 0; --i) {
            int x2 = this.futvars.dense[i];
            this.frontiers[x2] = this.doms[x2].lastRemoved();
        }
        return true;
    }

    final class LocalSetSparseByte {
        public byte[] dense;
        public byte[] sparse;
        public byte limit;

        public LocalSetSparseByte(int capacity, boolean initiallyFull) {
            Kit.control(0 < capacity && capacity <= 127);
            this.dense = Kit.range((byte)capacity);
            this.sparse = Kit.range((byte)capacity);
            this.limit = (byte)(initiallyFull ? this.dense.length - 1 : -1);
        }

        public boolean isPresent(byte e) {
            return this.sparse[e] <= this.limit;
        }

        public boolean add(byte e) {
            byte i = this.sparse[e];
            if (i <= this.limit) {
                return false;
            }
            this.limit = (byte)(this.limit + 1);
            if (i > this.limit) {
                byte f;
                this.dense[i] = f = this.dense[this.limit];
                this.dense[this.limit] = e;
                this.sparse[e] = this.limit;
                this.sparse[f] = i;
            }
            return true;
        }

        public boolean remove(byte e) {
            byte i = this.sparse[e];
            if (i > this.limit) {
                return false;
            }
            if (i != this.limit) {
                byte f;
                this.dense[i] = f = this.dense[this.limit];
                this.dense[this.limit] = e;
                this.sparse[e] = this.limit;
                this.sparse[f] = i;
            }
            this.limit = (byte)(this.limit - 1);
            return true;
        }
    }

    public final class SetSparseMapSTR3
    extends SetSparse {
        public short[] positions;
        public int[] separators;

        public SetSparseMapSTR3(int capacity, boolean initiallyFull) {
            super(capacity, initiallyFull);
            Kit.control(0 < capacity && capacity <= Short.MAX_VALUE);
            this.positions = Kit.range((short)capacity);
            this.separators = Kit.range(capacity);
        }

        @Override
        public final boolean add(int e) {
            throw new RuntimeException("Must not be called without a second argument");
        }

        public boolean add(int e, int position, int separator) {
            assert (position < 127);
            boolean added = super.add(e);
            if (added) {
                this.positions[e] = (short)position;
                this.separators[e] = separator;
            }
            return added;
        }
    }
}

