/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension;

import constraints.hard.extension.CtrExtensionSTR1;
import interfaces.FilteringGlobal;
import interfaces.ObserverBacktracking;
import interfaces.TagNegative;
import java.util.Arrays;
import problem.Problem;
import variables.Variable;
import variables.domains.Domain;

public class CtrExtensionSTR1NEG
extends CtrExtensionSTR1
implements FilteringGlobal,
TagNegative,
ObserverBacktracking.ObserverBacktrackingSystematic {
    protected int[][] nConflicts;

    public CtrExtensionSTR1NEG(Problem pb, Variable[] scp) {
        super(pb, scp);
    }

    @Override
    protected void initSpecificStructures() {
        super.initSpecificStructures();
        this.nConflicts = Variable.litterals(this.scp).intArray();
    }

    @Override
    protected void beforeFiltering() {
        super.beforeFiltering();
        for (int i = this.futvars.limit; i >= 0; --i) {
            Arrays.fill(this.nConflicts[this.futvars.dense[i]], 0);
        }
    }

    @Override
    public boolean runPropagator(Variable evt) {
        int x;
        this.pb.stuff.updateStatsForSTR(this.set);
        int depth = this.pb.solver.depth();
        this.beforeFiltering();
        for (int i = this.set.limit; i >= 0; --i) {
            int[] tuple = this.tuples[this.set.dense[i]];
            if (this.isValid(tuple)) {
                for (int j = this.futvars.limit; j >= 0; --j) {
                    x = this.futvars.dense[j];
                    int a = tuple[x];
                    int[] nArray = this.nConflicts[x];
                    int n = a;
                    nArray[n] = nArray[n] + 1;
                }
                continue;
            }
            this.set.removeAtPosition(i, depth);
        }
        long nValidTuples = Variable.nValidTuplesBoundedAtMaxValueFor(this.scp);
        for (int i = this.futvars.limit; i >= 0; --i) {
            x = this.futvars.dense[i];
            Domain dom = this.scp[x].dom;
            long limit = nValidTuples / (long)dom.size();
            int a = dom.first();
            while (a != -1) {
                if ((long)this.nConflicts[x][a] != limit) {
                    --this.cnt;
                    int n = x;
                    this.cnts[n] = this.cnts[n] - 1;
                    this.ac[x][a] = true;
                }
                a = dom.next(a);
            }
        }
        return this.updateDomains();
    }
}

