/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension;

import constraints.hard.extension.CtrExtensionRPWC;
import java.util.Arrays;
import problem.Problem;
import utility.Kit;
import variables.Variable;

public final class CtrExtensionRPWC2
extends CtrExtensionRPWC {
    private boolean decremental;
    private int lastDepth;
    private int[] lastSizes;
    private int[][] lastSizesStack;
    private int sValSize;
    private int[] sVal;
    private int sSupSize;
    private int[] sSup;
    protected long nbAssignmentsAtLastCall = 0L;

    private void initializeRestorationStructuresBeforeFiltering() {
        if (this.decremental) {
            int depth = this.pb.solver.depth();
            assert (depth >= this.lastDepth && this.lastDepth >= 0);
            for (int i = this.lastDepth + 1; i <= depth; ++i) {
                System.arraycopy(this.lastSizesStack[this.lastDepth], 0, this.lastSizesStack[i], 0, this.scp.length);
            }
            this.lastSizes = this.lastSizesStack[depth];
            this.lastDepth = depth;
        }
    }

    @Override
    public void restoreBefore(int depth) {
        super.restoreBefore(depth);
        if (!this.decremental) {
            Arrays.fill(this.lastSizes, -2);
        } else {
            this.lastDepth = Math.max(0, Math.min(this.lastDepth, depth - 1));
        }
    }

    public CtrExtensionRPWC2(Problem pb, Variable[] scp) {
        super(pb, scp);
        this.decremental = pb.rs.cp.extension.decremental;
    }

    @Override
    public void onConstructionProblemFinished() {
        super.onConstructionProblemFinished();
        if (!this.decremental) {
            this.lastSizes = Kit.repeat(-2, this.scp.length);
        } else {
            this.lastSizesStack = new int[this.pb.variables.length + 1][this.scp.length];
            Arrays.fill(this.lastSizesStack[0], -2);
        }
    }

    @Override
    protected void initSpecificStructures() {
        super.initSpecificStructures();
        this.sVal = new int[this.scp.length];
        this.sSup = new int[this.scp.length];
    }

    protected void manageLastPastVariable() {
        long nb = this.pb.solver.stats.nAssignments;
        if (this.nbAssignmentsAtLastCall != nb) {
            int x;
            this.nbAssignmentsAtLastCall = nb;
            Variable lastPast = this.pb.solver.futVars.lastPast();
            int n = x = lastPast == null ? -1 : this.positionOf(lastPast);
            if (x != -1) {
                this.sVal[this.sValSize++] = x;
            }
        }
    }

    @Override
    protected final void beforeFiltering() {
        this.initializeRestorationStructuresBeforeFiltering();
        this.sSupSize = 0;
        this.sValSize = 0;
        this.manageLastPastVariable();
        for (int i = this.futvars.limit; i >= 0; --i) {
            int domSize;
            int x = this.futvars.dense[i];
            this.cnts[x] = domSize = this.scp[x].dom.size();
            if (this.lastSizes[x] != domSize) {
                this.sVal[this.sValSize++] = x;
                this.lastSizes[x] = domSize;
            }
            this.sSup[this.sSupSize++] = x;
            Arrays.fill(this.ac[x], false);
        }
    }

    @Override
    protected boolean updateDomains() {
        for (int i = 0; i < this.sSupSize; ++i) {
            int x = this.sSup[i];
            int nRemovals = this.cnts[x];
            assert (nRemovals > 0);
            if (!this.scp[x].dom.remove(this.ac[x], nRemovals)) {
                return false;
            }
            this.lastSizes[x] = this.scp[x].dom.size();
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        this.pb.stuff.updateStatsForSTR(this.set);
        int depth = this.pb.solver.depth();
        this.beforeFiltering();
        this.setIntersectionsToBeChecked();
        for (int i = this.set.limit; i >= 0; --i) {
            int x;
            int j;
            int[] tuple = this.tuples[this.set.dense[i]];
            boolean valid = true;
            for (j = this.sValSize - 1; j >= 0; --j) {
                x = this.sVal[j];
                if (this.doms[x].isPresent(tuple[x])) continue;
                valid = false;
                break;
            }
            if (valid && this.checkStampsFor(tuple)) {
                for (j = this.sSupSize - 1; j >= 0; --j) {
                    x = this.sSup[j];
                    int a = tuple[x];
                    if (this.ac[x][a]) continue;
                    int n = x;
                    this.cnts[n] = this.cnts[n] - 1;
                    if (this.cnts[n] == 0) {
                        this.sSup[j] = this.sSup[--this.sSupSize];
                    }
                    this.ac[x][a] = true;
                }
                continue;
            }
            this.set.removeAtPosition(i, depth);
        }
        this.updateLastTargetTimes();
        return this.updateDomains();
    }
}

