/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension;

import constraints.hard.CtrGlobal;
import constraints.hard.extension.structures.MDDCD;
import constraints.hard.extension.structures.MDDNodeCD;
import interfaces.FilteringGlobal;
import interfaces.ObserverBacktracking;
import interfaces.TagFilteringCompleteAtEachCall;
import interfaces.TagGACGuaranteed;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import problem.Problem;
import utility.Kit;
import utility.sets.SetDenseReversible;
import utility.sets.SetSparseReversible;
import variables.Variable;
import variables.domains.Domain;

public final class CtrExtensionOrMDD
extends CtrGlobal
implements FilteringGlobal,
TagGACGuaranteed,
ObserverBacktracking.ObserverBacktrackingSystematic,
TagFilteringCompleteAtEachCall {
    MDDCD[] mdds;
    MDDNodeCD[] roots;
    SetDenseReversible validMdds;
    protected SetSparseReversible[] sets;
    protected boolean[][] ac;
    protected int[] cnts;
    protected int cnt;
    protected int[][] trueNodes;
    protected int trueTimestamp = 1;
    protected int[] earlyCutoff;

    @Override
    public final boolean checkValues(int[] t) {
        MDDNodeCD[] mDDNodeCDArray = this.roots;
        int n = mDDNodeCDArray.length;
        for (int i = 0; i < n; ++i) {
            MDDNodeCD root;
            MDDNodeCD node = root = mDDNodeCDArray[i];
            int i2 = 0;
            while (!node.isLeaf()) {
                node = node.sons[t[i2]];
                ++i2;
            }
            if (node != MDDNodeCD.nodeT) continue;
            return true;
        }
        return false;
    }

    @Override
    public void restoreBefore(int depth) {
        this.validMdds.restoreLimitAtLevel(depth);
        for (SetSparseReversible set : this.sets) {
            set.restoreLimitAtLevel(depth);
        }
    }

    public CtrExtensionOrMDD(Problem pb, Variable[] scp, MDDCD[] mdds) {
        super(pb, scp);
        Kit.control(scp.length >= 1);
        this.mdds = mdds;
        this.roots = (MDDNodeCD[])Stream.of(mdds).map(m -> m.root).toArray(MDDNodeCD[]::new);
    }

    @Override
    public void onConstructionProblemFinished() {
        super.onConstructionProblemFinished();
        this.trueNodes = (int[][])IntStream.range(0, this.mdds.length).mapToObj(i -> new int[this.mdds[i].nNodes().intValue()]).toArray(x$0 -> new int[x$0][]);
        this.validMdds = new SetDenseReversible(this.mdds.length, this.pb.variables.length + 1);
        this.sets = (SetSparseReversible[])IntStream.range(0, this.mdds.length).mapToObj(i -> new SetSparseReversible(this.mdds[i].nNodes(), false, this.pb.variables.length + 1)).toArray(SetSparseReversible[]::new);
        this.earlyCutoff = new int[this.mdds.length];
        this.ac = Variable.litterals(this.scp).booleanArray();
        this.cnts = new int[this.scp.length];
        for (MDDNodeCD root : this.roots) {
            root.buildSonsClasses();
        }
    }

    protected void beforeFiltering() {
        this.cnt = 0;
        for (int i = this.futvars.limit; i >= 0; --i) {
            int x = this.futvars.dense[i];
            int domSize = this.scp[x].dom.size();
            this.cnt += domSize;
            this.cnts[x] = domSize;
            Arrays.fill(this.ac[x], false);
        }
        ++this.trueTimestamp;
        Arrays.fill(this.earlyCutoff, this.scp.length);
    }

    private boolean manageSuccessfulExploration(int level, int a) {
        int cutoffVariant = this.pb.rs.cp.extension.variant;
        assert (cutoffVariant == 0);
        if (this.scp[level].isFuture() && !this.ac[level][a]) {
            --this.cnt;
            int n = level;
            this.cnts[n] = this.cnts[n] - 1;
            this.ac[level][a] = true;
        }
        return false;
    }

    private boolean exploreMDD(int level, MDDNodeCD node, SetSparseReversible set, int[] trueNodes) {
        boolean supported;
        block11: {
            if (node == MDDNodeCD.nodeT || trueNodes[node.id] == this.trueTimestamp) {
                return true;
            }
            if (node == MDDNodeCD.nodeF || set.isPresent(node.id)) {
                return false;
            }
            Domain dom = this.scp[level].dom;
            supported = false;
            boolean finished = false;
            if (dom.size() < node.nSonsDifferentFromNodeF()) {
                int a = dom.first();
                while (a != -1 && !finished) {
                    if (this.exploreMDD(level + 1, node.sons[a], set, trueNodes)) {
                        supported = true;
                        finished = this.manageSuccessfulExploration(level, a);
                    }
                    a = dom.next(a);
                }
            } else {
                int[][] nArray = node.sonsClasses;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int[] childsClass;
                    for (int a : childsClass = nArray[i]) {
                        if (!dom.isPresent(a) || !this.exploreMDD(level + 1, node.sons[a], set, trueNodes)) continue;
                        supported = true;
                        finished = this.manageSuccessfulExploration(level, a);
                        if (!finished) {
                            continue;
                        }
                        break block11;
                    }
                }
            }
        }
        if (supported) {
            trueNodes[node.id] = this.trueTimestamp;
        } else {
            set.add(node.id, this.pb.solver.depth());
        }
        return supported;
    }

    protected boolean updateDomains() {
        for (int i = this.futvars.limit; i >= 0 && this.cnt > 0; --i) {
            int x = this.futvars.dense[i];
            int nRemovals = this.cnts[x];
            if (nRemovals == 0) continue;
            if (!this.scp[x].dom.remove(this.ac[x], nRemovals)) {
                return false;
            }
            this.cnt -= nRemovals;
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        this.beforeFiltering();
        int depth = this.pb.solver.depth();
        for (int k = this.validMdds.limit; k >= 0; --k) {
            int i = this.validMdds.dense[k];
            if (this.exploreMDD(0, this.roots[i], this.sets[i], this.trueNodes[i])) continue;
            this.validMdds.removeAtPosition(k, depth);
        }
        return this.updateDomains();
    }
}

