/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension;

import constraints.hard.CtrExtension;
import constraints.hard.extension.structures.ExtensionStructureHard;
import constraints.hard.extension.structures.MDDNodeShort;
import constraints.hard.extension.structures.MDDShort;
import interfaces.FilteringGlobal;
import interfaces.ObserverBacktracking;
import interfaces.TagGACGuaranteed;
import interfaces.TagPositive;
import java.util.Arrays;
import java.util.Map;
import org.xcsp.modeler.definitions.DefXCSP;
import org.xcsp.modeler.definitions.ICtr;
import org.xcsp.modeler.definitions.IRootForCtrAndObj;
import problem.Problem;
import utility.Kit;
import utility.sets.SetSparseReversible;
import variables.Variable;
import variables.domains.Domain;

public final class CtrExtensionMDDShort
extends CtrExtension
implements FilteringGlobal,
TagPositive,
TagGACGuaranteed,
ObserverBacktracking.ObserverBacktrackingSystematic,
ICtr.ICtrMdd {
    protected SetSparseReversible set;
    protected boolean[][] ac;
    protected int[] cnts;
    protected int cnt;
    protected int falseTimestamp = 1;
    protected int trueTimestamp = 1;
    protected int[] falseNodes;
    protected int[] trueNodes;
    protected int earlyCutoff;

    @Override
    public void restoreBefore(int depth) {
        if (this.set != null) {
            this.set.restoreLimitAtLevel(depth);
        } else {
            ++this.falseTimestamp;
        }
    }

    public CtrExtensionMDDShort(Problem pb, Variable[] scp) {
        super(pb, scp);
        Kit.control(scp.length >= 1);
    }

    public CtrExtensionMDDShort(Problem pb, Variable[] scp, int[][] tuples) {
        this(pb, scp);
        this.key = this.signature() + " " + tuples + " " + true;
        this.storeTuples(tuples, true);
    }

    public CtrExtensionMDDShort(Problem pb, Variable[] scp, MDDNodeShort root) {
        this(pb, scp);
        this.extStructure = new MDDShort(this, root);
        this.initSpecificStructures();
    }

    @Override
    public void onConstructionProblemFinished() {
        super.onConstructionProblemFinished();
        int nNodes = ((MDDShort)this.extStructure).nNodes();
        this.trueNodes = new int[nNodes];
        if (this.pb.rs.cp.extension.decremental) {
            this.set = new SetSparseReversible(nNodes, false, this.pb.variables.length + 1);
        } else {
            this.falseNodes = new int[nNodes];
        }
    }

    @Override
    protected ExtensionStructureHard buildExtensionStructure() {
        return new MDDShort(this);
    }

    @Override
    protected void initSpecificStructures() {
        this.ac = Variable.litterals(this.scp).booleanArray();
        this.cnts = new int[this.scp.length];
    }

    protected void beforeFiltering() {
        this.cnt = 0;
        for (int i = this.futvars.limit; i >= 0; --i) {
            int x = this.futvars.dense[i];
            int domSize = this.scp[x].dom.size();
            this.cnt += domSize;
            this.cnts[x] = domSize;
            Arrays.fill(this.ac[x], false);
        }
        ++this.trueTimestamp;
        this.earlyCutoff = this.scp.length;
    }

    private boolean manageSuccessfulExploration(int level, int a) {
        if (a == 0x7FFFFFFE) {
            Variable x = this.scp[level];
            if (x.isFuture()) {
                int b = x.dom.first();
                while (b != -1) {
                    if (!this.ac[level][b]) {
                        --this.cnt;
                        int n = level;
                        this.cnts[n] = this.cnts[n] - 1;
                        this.ac[level][b] = true;
                    }
                    b = x.dom.next(b);
                }
            }
            return false;
        }
        int cutoffVariant = this.pb.rs.cp.extension.variant;
        if (cutoffVariant == 2) {
            if (this.scp[level].isFuture()) {
                if (!this.ac[level][a]) {
                    --this.cnt;
                    int n = level;
                    this.cnts[n] = this.cnts[n] - 1;
                    this.ac[level][a] = true;
                    if (this.cnts[level] == 0 && this.earlyCutoff == level + 1) {
                        this.earlyCutoff = level;
                    }
                }
            } else if (this.earlyCutoff == level + 1) {
                this.earlyCutoff = level;
            }
            return level >= this.earlyCutoff;
        }
        if (cutoffVariant == 1) {
            boolean b = false;
            if (this.scp[level].isFuture()) {
                if (!this.ac[level][a]) {
                    --this.cnt;
                    int n = level;
                    this.cnts[n] = this.cnts[n] - 1;
                    this.ac[level][a] = true;
                    if (this.cnts[level] == 0 && this.earlyCutoff == level + 1) {
                        this.earlyCutoff = level;
                        b = true;
                    }
                }
            } else if (this.earlyCutoff == level + 1) {
                this.earlyCutoff = level;
                b = true;
            }
            return b;
        }
        assert (cutoffVariant == 0);
        if (this.scp[level].isFuture() && !this.ac[level][a]) {
            --this.cnt;
            int n = level;
            this.cnts[n] = this.cnts[n] - 1;
            this.ac[level][a] = true;
        }
        return false;
    }

    private boolean exploreMDD(MDDNodeShort node) {
        if (node == MDDNodeShort.nodeT || this.trueNodes[node.id] == this.trueTimestamp) {
            return true;
        }
        if (node == MDDNodeShort.nodeF || this.set != null && this.set.isPresent(node.id) || this.set == null && this.falseNodes[node.id] == this.falseTimestamp) {
            return false;
        }
        Domain dom = this.scp[node.level].dom;
        boolean supported = false;
        boolean finished = false;
        if (this.exploreMDD(node.sons[node.sons.length - 1])) {
            supported = true;
            this.manageSuccessfulExploration(node.level, 0x7FFFFFFE);
        }
        int a = dom.first();
        while (a != -1 && !finished) {
            if (this.exploreMDD(node.sons[a])) {
                supported = true;
                finished = this.manageSuccessfulExploration(node.level, a);
            }
            a = dom.next(a);
        }
        if (supported) {
            this.trueNodes[node.id] = this.trueTimestamp;
        } else if (this.set != null) {
            this.set.add(node.id, this.pb.solver.depth());
        } else {
            this.falseNodes[node.id] = this.falseTimestamp;
        }
        return supported;
    }

    protected boolean updateDomains() {
        for (int i = this.futvars.limit; i >= 0 && this.cnt > 0; --i) {
            int x = this.futvars.dense[i];
            int nRemovals = this.cnts[x];
            if (nRemovals == 0) continue;
            if (!this.scp[x].dom.remove(this.ac[x], nRemovals)) {
                return false;
            }
            this.cnt -= nRemovals;
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        this.beforeFiltering();
        this.exploreMDD(((MDDShort)this.extStructure).root);
        return this.updateDomains();
    }

    @Override
    public Map<String, Object> mapXCSP() {
        return IRootForCtrAndObj.map("scope", (Object)this.scp, LIST, (Object)this.compactOrdered(this.scp), TRANSITIONS, (Object)((MDDShort)this.extStructure).root.getTransitions(Variable.buildDomainsArrayFor(this.scp)));
    }

    @Override
    public DefXCSP defXCSP() {
        return ICtr.ICtrMdd.super.defXCSP();
    }
}

