/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard;

import constraints.CtrHard;
import constraints.hard.ConflictsStructure;
import constraints.hard.intension.CanonicalExpressionParser;
import constraints.hard.intension.CtrEvaluationManager;
import java.util.Map;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Utilities;
import org.xcsp.common.predicates.TreeEvaluator;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.modeler.definitions.ICtr;
import org.xcsp.modeler.definitions.IRootForCtrAndObj;
import problem.Problem;
import utility.Kit;
import variables.Variable;
import variables.VariableInteger;
import variables.VariableSymbolic;

public final class CtrIntension
extends CtrHard
implements ICtr.ICtrIntension {
    public XNodeParent<IVar> tree;
    public CtrEvaluationManager evaluationManager;
    private CanonicalExpressionParser cep;
    private boolean canonize = false;

    @Override
    public int[] defineSymmetryMatching() {
        return this.cep != null ? this.cep.computeSymmetryMatching() : Kit.range(1, this.scp.length);
    }

    private void defineKey() {
        this.cep = null;
        if (this.scp.length > 30 || this.tree.size() > 200) {
            this.key = this.signature().append(' ').append(this.tree.toPostfixExpression(this.tree.vars())).toString();
        } else {
            this.cep = new CanonicalExpressionParser(this.tree);
            this.key = this.signature().append(' ').append(this.cep.key()).toString();
        }
    }

    public CtrIntension(Problem pb, Variable[] scp, XNodeParent<IVar> tree) {
        super(pb, scp);
        this.tree = this.canonize ? (XNodeParent)tree.canonization() : tree;
        Kit.control(Stream.of(scp).allMatch(x -> x instanceof VariableInteger) || Stream.of(scp).allMatch(x -> x instanceof VariableSymbolic));
        this.defineKey();
        if (!pb.rs.mapOfEvaluationManagers.containsKey(this.key)) {
            this.evaluationManager = scp[0] instanceof VariableInteger ? new CtrEvaluationManager(tree) : new CtrEvaluationManager(tree, pb.symbolic.mapOfSymbols);
            this.evaluationManager.register(this);
            this.conflictsStructure = ConflictsStructure.build(this);
            pb.rs.mapOfEvaluationManagers.put(this.key, this.evaluationManager);
        } else {
            this.evaluationManager = pb.rs.mapOfEvaluationManagers.get(this.key);
            this.evaluationManager.register(this);
            this.conflictsStructure = this.evaluationManager.firstRegisteredCtr().conflictsStructure();
            if (this.conflictsStructure != null) {
                this.conflictsStructure.register(this);
            } else {
                this.conflictsStructure = ConflictsStructure.build(this);
            }
        }
    }

    @Override
    public void onConstructionProblemFinished() {
        super.onConstructionProblemFinished();
        for (TreeEvaluator.Evaluator evaluator : this.evaluationManager.evaluators) {
            if (evaluator instanceof TreeEvaluator.F1Evaluator) {
                ((TreeEvaluator.F1Evaluator)evaluator).function = this.pb.stuff.externFunctionArity1;
                continue;
            }
            if (!(evaluator instanceof TreeEvaluator.F2Evaluator)) continue;
            ((TreeEvaluator.F2Evaluator)evaluator).function = this.pb.stuff.externFunctionArity2;
        }
    }

    public void updateWithLessThanOrEqual(Variable v1, Variable v2) {
        Kit.control(this.scp.length == 2 && Utilities.indexOf(v1, this.scp) != -1 && Utilities.indexOf(v2, this.scp) != -1);
        this.setId(this.explicitId() == null ? null : this.explicitId() + "_modified");
        this.tree = this.pb.api.and(this.tree, this.pb.api.le(v1, v2));
        Kit.control(this.tree.exactlyVars(this.scp));
        this.defineKey();
        this.evaluationManager.unregister(this);
        if (this.conflictsStructure != null) {
            this.conflictsStructure.unregister(this);
        }
        if (!this.pb.rs.mapOfEvaluationManagers.containsKey(this.key)) {
            this.evaluationManager = this.scp[0] instanceof VariableInteger ? new CtrEvaluationManager(this.tree) : new CtrEvaluationManager(this.tree, this.pb.symbolic.mapOfSymbols);
            this.evaluationManager.register(this);
            this.conflictsStructure = ConflictsStructure.build(this);
            this.pb.rs.mapOfEvaluationManagers.put(this.key, this.evaluationManager);
        } else {
            this.evaluationManager = this.pb.rs.mapOfEvaluationManagers.get(this.key);
            this.evaluationManager.register(this);
            this.conflictsStructure = this.evaluationManager.firstRegisteredCtr().conflictsStructure();
            if (this.conflictsStructure != null) {
                this.conflictsStructure.register(this);
            }
        }
    }

    @Override
    public final boolean checkValues(int[] vals) {
        return this.evaluationManager.evaluate(vals) == 1L;
    }

    @Override
    public Map<String, Object> mapXCSP() {
        return IRootForCtrAndObj.map("scope", (Object)this.scp, FUNCTION, this.tree);
    }
}

