/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard;

import constraints.Constraint;
import constraints.CtrHard;
import constraints.TupleManager;
import constraints.hard.ConflictsStructure;
import constraints.hard.extension.CtrExtensionCT;
import constraints.hard.extension.CtrExtensionCT2;
import constraints.hard.extension.CtrExtensionMDD;
import constraints.hard.extension.CtrExtensionMDDShort;
import constraints.hard.extension.CtrExtensionSTR2;
import constraints.hard.extension.CtrExtensionSTR2S;
import constraints.hard.extension.CtrExtensionV;
import constraints.hard.extension.structures.Bits;
import constraints.hard.extension.structures.ExtensionStructure;
import constraints.hard.extension.structures.ExtensionStructureHard;
import executables.Resolution;
import interfaces.TagFilteringCompleteAtEachCall;
import interfaces.TagGACGuaranteed;
import interfaces.TagNegative;
import interfaces.TagPositive;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.modeler.definitions.ICtr;
import org.xcsp.modeler.definitions.IRootForCtrAndObj;
import problem.Problem;
import propagation.structures.supporters.SupporterHard;
import utility.Enums;
import utility.Kit;
import utility.Reflector;
import utility.exceptions.MissingImplementationException;
import variables.Variable;
import variables.VariableInteger;
import variables.VariableSymbolic;

public abstract class CtrExtension
extends CtrHard
implements TagGACGuaranteed,
TagFilteringCompleteAtEachCall,
ICtr.ICtrExtension {
    protected ExtensionStructureHard extStructure;

    private static Constraint build(Problem pb, Variable[] scp, boolean positive, boolean presentStar) {
        if (presentStar) {
            if (pb.rs.cp.extension.positive == Enums.EExtension.MDD) {
                return new CtrExtensionMDD(pb, scp);
            }
            if (pb.rs.cp.extension.positive == Enums.EExtension.MDDSHORT) {
                return new CtrExtensionMDDShort(pb, scp);
            }
            if (pb.rs.cp.extension.positive == Enums.EExtension.STR2) {
                return new CtrExtensionSTR2(pb, scp);
            }
            if (pb.rs.cp.extension.positive == Enums.EExtension.STR2S) {
                return new CtrExtensionSTR2S(pb, scp);
            }
            if (pb.rs.cp.extension.positive == Enums.EExtension.CT) {
                return new CtrExtensionCT(pb, scp);
            }
            if (pb.rs.cp.extension.positive == Enums.EExtension.CT2) {
                return new CtrExtensionCT2(pb, scp);
            }
            throw new IllegalArgumentException("Unimplemented table constraint for short tables");
        }
        if (scp.length == 1 || scp.length == 2 && pb.rs.cp.extension.validForBinary) {
            return new CtrExtensionV(pb, scp);
        }
        String suffix = (positive ? pb.rs.cp.extension.positive : pb.rs.cp.extension.negative).toString();
        return Reflector.buildObject(CtrExtension.class.getSimpleName() + suffix, CtrExtension.class, pb, scp);
    }

    private static int[][] reverseTuples(Variable[] variables, int[][] tuples) {
        Kit.control(Variable.areDomainsFull(variables));
        assert (Kit.isLexIncreasing(tuples));
        int cnt = 0;
        TupleManager tupleManager = new TupleManager(Variable.buildDomainsArrayFor(variables));
        int[] idxs = tupleManager.firstValidTuple();
        int[] vals = new int[idxs.length];
        ArrayList<int[]> list = new ArrayList<int[]>();
        do {
            for (int i = vals.length - 1; i >= 0; --i) {
                vals[i] = variables[i].dom.toVal(idxs[i]);
            }
            if (cnt < tuples.length && Arrays.equals(vals, tuples[cnt])) {
                ++cnt;
                continue;
            }
            list.add((int[])vals.clone());
        } while (tupleManager.nextValidTuple() != -1);
        return Kit.intArray2D(list);
    }

    private static boolean isStarPresent(Object tuples) {
        return tuples instanceof int[][] ? Kit.isPresent(0x7FFFFFFE, (int[][])tuples) : Kit.isPresent("*", (String[][])tuples);
    }

    public static CtrExtension build(Problem pb, Variable[] scp, Object tuples, boolean positive, Boolean starred) {
        int[][] ts;
        Kit.control(Stream.of(scp).allMatch(x -> x instanceof VariableInteger) || Stream.of(scp).allMatch(x -> x instanceof VariableSymbolic));
        Kit.control(Array.getLength(tuples) == 0 || Array.getLength(Array.get(tuples, 0)) == scp.length, () -> "Badly formed extensional constraint " + scp.length + " " + Array.getLength(tuples));
        assert (starred == null || starred == Boolean.TRUE == CtrExtension.isStarPresent(tuples)) : starred + " \n" + Kit.join(tuples, new String[0]);
        starred = starred != null ? starred : CtrExtension.isStarPresent(tuples);
        int[][] nArray = ts = scp[0] instanceof VariableInteger ? (int[][])tuples : pb.symbolic.replaceSymbols((String[][])tuples);
        if (scp[0] instanceof VariableInteger && !starred.booleanValue() && (!positive && scp.length <= pb.rs.cp.extension.arityLimitForSwitchingToPositive || positive && scp.length <= pb.rs.cp.extension.arityLimitForSwitchingToNegative)) {
            ts = CtrExtension.reverseTuples(scp, ts);
            positive = !positive;
        }
        CtrExtension c = (CtrExtension)CtrExtension.build(pb, scp, positive, starred);
        String stuffKey = c.signature() + " " + ts + " " + positive;
        c.key = pb.stuff.collectedTuples.computeIfAbsent(stuffKey, k -> c.signature() + "r" + pb.stuff.collectedTuples.size());
        c.storeTuples(ts, positive);
        if (scp[0] instanceof VariableSymbolic) {
            pb.symbolic.store(c, (String[][])tuples);
        }
        return c;
    }

    @Override
    public ExtensionStructureHard extStructure() {
        return this.extStructure;
    }

    protected abstract ExtensionStructureHard buildExtensionStructure();

    @Override
    public void cloneStructures(boolean onlyConflictsStructure) {
        super.cloneStructures(onlyConflictsStructure);
        if (!onlyConflictsStructure && this.extStructure.registeredCtrs().size() > 1) {
            this.extStructure.unregister(this);
            this.extStructure = Reflector.buildObject(this.extStructure.getClass().getSimpleName(), ExtensionStructureHard.class, this, this.extStructure);
        }
    }

    protected void initSpecificStructures() {
    }

    public final void storeTuples(int[][] tuples, boolean positive) {
        Kit.control(positive && this instanceof TagPositive || !positive && this instanceof TagNegative || !(this instanceof TagPositive) && !(this instanceof TagNegative), () -> positive + " " + this.getClass().getName());
        if (tuples != null && this.pb.rs.cp.export) {
            int nShortTuples = 0;
            ArrayList<int[]> list = new ArrayList<int[]>();
            for (int[] tuple : tuples) {
                boolean relevantTuple = true;
                for (int i = 0; i < tuple.length; ++i) {
                    if (tuple[i] == 0x7FFFFFFE) {
                        ++nShortTuples;
                        continue;
                    }
                    if (this.scp[i].dom.toIdx(tuple[i]) >= 0) continue;
                    relevantTuple = false;
                    break;
                }
                if (!relevantTuple) continue;
                list.add(tuple);
            }
            if (nShortTuples > 0) {
                Kit.log.info("When storing tuples for constraint " + this + ", " + nShortTuples + " short tuples found.");
            }
            if (list.size() != tuples.length) {
                Kit.log.info("When storing tuples for constraint " + this + ", " + (tuples.length - list.size()) + " irrelevant tuples found.");
                tuples = Kit.intArray2D(list);
            }
        }
        if (this.supporter != null) {
            ((SupporterHard)this.supporter).reset();
        }
        Map<String, ExtensionStructure> map = this.pb.rs.mapOfExtensionStructures;
        if (this.key == null || !map.containsKey(this.key)) {
            this.extStructure = this.buildExtensionStructure();
            this.extStructure.originalTuples = this.pb.rs.cp.extension.recordOriginalTuples || this.pb.rs.cp.export || this.pb.rs.cp.symmetryBreaking ? tuples : (int[][])null;
            this.extStructure.originalPositive = positive;
            this.extStructure.storeTuples(tuples, positive);
            if (this.key != null) {
                map.put(this.key, this.extStructure);
                if (this.pb.rs.cp.symmetryBreaking) {
                    Constraint.putSymmetryMatching(this.key, this.extStructure.computeVariableSymmetryMatching(tuples, positive));
                }
            }
            if (!(this instanceof CtrExtensionMDDShort)) {
                this.conflictsStructure = ConflictsStructure.build(this, tuples, positive);
            }
        } else {
            this.extStructure = (ExtensionStructureHard)map.get(this.key);
            this.extStructure.register(this);
            this.conflictsStructure = this.extStructure.firstRegisteredCtr().conflictsStructure();
            if (this.conflictsStructure != null) {
                this.conflictsStructure.register(this);
            }
            assert (this.indexesMatchValues == this.extStructure.firstRegisteredCtr().indexesMatchValues);
        }
        this.initSpecificStructures();
    }

    private String searchSimilarBits(Bits bits) {
        Resolution resolution = this.pb.rs;
        for (String key : resolution.mapOfExtensionStructures.keySet()) {
            ExtensionStructure es = resolution.mapOfExtensionStructures.get(key);
            if (!(es instanceof Bits) || this.scp[0].dom.typeIdentifier() != bits.firstRegisteredCtr().scp[0].dom.typeIdentifier() || this.scp[1].dom.typeIdentifier() != bits.firstRegisteredCtr().scp[1].dom.typeIdentifier() || !bits.hasSameSupportsThan((Bits)es)) continue;
            return es.firstRegisteredCtr().key;
        }
        return null;
    }

    @Override
    public int[] defineSymmetryMatching() {
        return this.extStructure.computeVariableSymmetryMatching();
    }

    public CtrExtension(Problem pb, Variable[] scp) {
        super(pb, scp);
    }

    @Override
    public final boolean checkValues(int[] t) {
        return this.checkIndexes(this.toIdxs(t, this.tupleManager.localTuple));
    }

    @Override
    public final boolean checkIndexes(int[] t) {
        ++this.pb.stuff.nCcks;
        return this.extStructure.checkIdxs(t);
    }

    public void logicalAndWithLessThanOrEqual(Variable x, Variable y) {
        throw new MissingImplementationException();
    }

    @Override
    public boolean removeTuple(int ... idxs) {
        if (this.extStructure.removeTuple(idxs)) {
            if (this.conflictsStructure != null) {
                this.conflictsStructure.manageRemovedTuple(idxs);
            }
            return true;
        }
        return false;
    }

    boolean controlTuples(int[][] tuples) {
        return Stream.of(tuples).allMatch(t -> IntStream.range(0, ((int[])t).length).allMatch(i -> t[i] == 0x7FFFFFFE || this.scp[i].dom.isPresentValue(t[i])));
    }

    @Override
    public Map<String, Object> mapXCSP() {
        int[][] tuples = this.scp[0] instanceof VariableInteger ? this.extStructure.originalTuples : (int[][])this.pb.symbolic.mapOfTuples.get(this);
        return IRootForCtrAndObj.map("scope", (Object)this.scp, LIST, (Object)this.compactOrdered(this.scp), "arity", (Object)this.scp.length, "tuples", tuples, "positive", (Object)this.extStructure.originalPositive);
    }
}

