/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard;

import constraints.Constraint;
import constraints.CtrHard;
import constraints.TupleManager;
import constraints.hard.extension.CtrExtensionCT;
import constraints.hard.extension.CtrExtensionCT2;
import constraints.hard.extension.CtrExtensionSTR2;
import dashboard.ControlPanel;
import interfaces.RegisteringCtrs;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public final class ConflictsStructure
implements RegisteringCtrs {
    public static final int LIMIT_FOR_NARY = 10000;
    public static final int LIMIT_FOR_BARY = 1000000;
    private List<Constraint> registeredCtrs = new LinkedList<Constraint>();
    private int[][] nConflicts;
    private int[] nbMaxConflicts;

    private static boolean canBuildConflictsStructureFor(Constraint c, int limit) {
        if (c instanceof CtrExtensionSTR2 || c instanceof CtrExtensionCT || c instanceof CtrExtensionCT2 || c.hugeDomainVars.length > 0) {
            return false;
        }
        ControlPanel cfg = c.pb.rs.cp;
        if (!cfg.mustBuildConflictStructures || c.scp.length == 1 || Kit.getUsedMemory() > 400000000L) {
            return false;
        }
        return Variable.nValidTuples(c.scp, false).compareTo(BigInteger.valueOf(limit)) <= 0;
    }

    public static ConflictsStructure build(Constraint ctr, int[][] tuples, boolean positive) {
        return ConflictsStructure.canBuildConflictsStructureFor(ctr, Integer.MAX_VALUE) ? new ConflictsStructure(ctr).initializeFrom(tuples, positive) : null;
    }

    public static ConflictsStructure build(Constraint ctr) {
        return ConflictsStructure.canBuildConflictsStructureFor(ctr, ctr.scp.length == 2 ? 1000000 : 10000) ? new ConflictsStructure(ctr).initialize() : null;
    }

    @Override
    public List<Constraint> registeredCtrs() {
        return this.registeredCtrs;
    }

    public int[][] nConflicts() {
        return this.nConflicts;
    }

    public int[] nMaxConflicts() {
        return this.nbMaxConflicts;
    }

    public ConflictsStructure(Constraint ctr) {
        this.registeredCtrs.add(ctr);
        this.nbMaxConflicts = new int[ctr.scp.length];
        this.nConflicts = Variable.litterals(ctr.scp).intArray();
    }

    public ConflictsStructure(ConflictsStructure conflictsStructure, Constraint ctr) {
        this.registeredCtrs.add(ctr);
        this.nbMaxConflicts = (int[])conflictsStructure.nbMaxConflicts.clone();
        this.nConflicts = Kit.cloneDeeply(conflictsStructure.nConflicts);
    }

    public final void computeNbMaxConflicts() {
        assert (this.registeredCtrs.size() == 1);
        Constraint ctr = this.firstRegisteredCtr();
        for (int i = 0; i < this.nbMaxConflicts.length; ++i) {
            int max = Integer.MIN_VALUE;
            Domain dom = ctr.scp[i].dom;
            int idx = dom.first();
            while (idx != -1) {
                max = Math.max(max, this.nConflicts[i][idx]);
                idx = dom.next(idx);
            }
            this.nbMaxConflicts[i] = max;
        }
    }

    private ConflictsStructure initializeFrom(int[][] tuples, boolean positive) {
        CtrHard c = (CtrHard)this.firstRegisteredCtr();
        assert (this.registeredCtrs.size() == 1 && !c.usePredefinedMaxNumberOfConflicts());
        Variable[] scp = this.firstRegisteredCtr().scp;
        int nbValidTuples = Variable.nValidTuples(scp, false).intValueExact();
        int[] t = new int[scp.length];
        for (int[] tuple : tuples) {
            if (!Variable.isValidTuple(scp, c.toIdxs(tuple, t), true)) continue;
            for (int i = 0; i < tuple.length; ++i) {
                int[] nArray = this.nConflicts[i];
                int n = scp[i].dom.toIdx(tuple[i]);
                nArray[n] = nArray[n] + 1;
            }
        }
        if (positive) {
            for (int i = 0; i < this.nConflicts.length; ++i) {
                for (int j = 0; j < this.nConflicts[i].length; ++j) {
                    this.nConflicts[i][j] = nbValidTuples / scp[i].dom.size() - this.nConflicts[i][j];
                }
            }
        }
        this.computeNbMaxConflicts();
        assert (this.controlStructures());
        return this;
    }

    private ConflictsStructure initialize() {
        assert (this.registeredCtrs.size() == 1);
        CtrHard c = (CtrHard)this.firstRegisteredCtr();
        if (c.usePredefinedMaxNumberOfConflicts()) {
            for (int i = 0; i < this.nConflicts.length; ++i) {
                Variable x = c.scp[i];
                for (int j = 0; j < this.nConflicts[i].length; ++j) {
                    this.nConflicts[i][j] = c.giveUpperBoundOfMaxNumberOfConflictsFor(x, j);
                }
            }
        } else {
            c.tupleManager.firstValidTuple();
            c.tupleManager.overValidTuples(t -> {
                if (!c.checkIndexes((int[])t)) {
                    for (int i = 0; i < ((int[])t).length; ++i) {
                        int[] nArray = this.nConflicts[i];
                        int n = t[i];
                        nArray[n] = nArray[n] + 1;
                    }
                }
            });
        }
        this.computeNbMaxConflicts();
        assert (this.controlStructures());
        return this;
    }

    private Variable getReducedDomainVariable(Variable[] scope, int[] domainsFrontier) {
        Variable reducedDomainVariable = null;
        for (Variable var : scope) {
            if (var.dom.lastRemoved() == domainsFrontier[var.num]) continue;
            if (reducedDomainVariable == null) {
                reducedDomainVariable = var;
                continue;
            }
            return Variable.TAG;
        }
        return reducedDomainVariable;
    }

    public void updateCounters(int[] domainsFrontier) {
        assert (this.registeredCtrs.size() == 1);
        CtrHard constraint = (CtrHard)this.firstRegisteredCtr();
        if (constraint.usePredefinedMaxNumberOfConflicts()) {
            return;
        }
        Variable reducedDomainVariable = this.getReducedDomainVariable(constraint.scp, domainsFrontier);
        if (reducedDomainVariable == null) {
            return;
        }
        if (reducedDomainVariable == Variable.TAG) {
            return;
        }
        long nb = Variable.nValidTuplesBoundedAtMaxValueFor(constraint.scp, constraint.positionOf(reducedDomainVariable));
        if (nb < (long)(constraint.scp.length == 2 ? 1000000 : 10000)) {
            this.manageRemovedValues(reducedDomainVariable, domainsFrontier[reducedDomainVariable.num]);
        }
    }

    public void manageRemovedValues(Variable x, int sentinel) {
        int nbUpdatesToBeDone;
        CtrHard c = (CtrHard)this.firstRegisteredCtr();
        assert (this.registeredCtrs.size() == 1 && !c.usePredefinedMaxNumberOfConflicts());
        int p = c.positionOf(x);
        TupleManager tupleManager = c.tupleManager;
        Domain dom = x.dom;
        int a = dom.lastRemoved();
        while (a != sentinel && (nbUpdatesToBeDone = this.nConflicts[p][a]) != 0) {
            int[] tuple = tupleManager.firstValidTupleWith(p, a);
            while (true) {
                int pos;
                if (!c.checkIndexes(tuple)) {
                    for (int i = 0; i < tuple.length; ++i) {
                        if (i == p) continue;
                        int[] nArray = this.nConflicts[i];
                        int n = tuple[i];
                        nArray[n] = nArray[n] - 1;
                    }
                    if (--nbUpdatesToBeDone == 0) break;
                }
                Kit.control((pos = tupleManager.nextValidTuple()) != -1, () -> "Should not be reached ");
            }
            a = dom.prevRemoved(a);
        }
        this.computeNbMaxConflicts();
        assert (this.controlStructures());
    }

    public final void manageRemovedTuple(int ... idxs) {
        assert (this.registeredCtrs.size() == 1 && !((CtrHard)this.firstRegisteredCtr()).usePredefinedMaxNumberOfConflicts());
        for (int i = 0; i < idxs.length; ++i) {
            int[] nArray = this.nConflicts[i];
            int n = idxs[i];
            nArray[n] = nArray[n] + 1;
            if (nArray[n] <= this.nbMaxConflicts[i]) continue;
            int n2 = i;
            this.nbMaxConflicts[n2] = this.nbMaxConflicts[n2] + 1;
        }
    }

    public boolean possiblyRemoveValuesFor(Constraint ctr) {
        assert (ctr.pb.solver.depth() == 0 && this.registeredCtrs.contains(ctr));
        long nbValidTuples = Variable.nValidTuplesBoundedAtMaxValueFor(ctr.scp);
        for (int i = 0; i < ctr.scp.length; ++i) {
            int[] nbConflicts = this.nConflicts()[i];
            Domain dom = ctr.scp[i].dom;
            long nbValidTuplesOfValues = nbValidTuples / (long)dom.size();
            int idx = dom.first();
            while (idx != -1) {
                if ((long)nbConflicts[idx] == nbValidTuplesOfValues) {
                    dom.removeElementary(idx);
                }
                idx = dom.next(idx);
            }
            if (dom.size() != 0) continue;
            return false;
        }
        return true;
    }

    public boolean controlStructures() {
        CtrHard c = (CtrHard)this.firstRegisteredCtr();
        if (c.usePredefinedMaxNumberOfConflicts()) {
            return true;
        }
        if (Variable.nValidTuples(c.scp, false).compareTo(BigInteger.valueOf(10000L)) > 0) {
            Kit.log.warning("Too large Cartesian Space for checking ");
            return true;
        }
        IntStream.range(0, this.nConflicts.length).forEach(i -> {
            int max = Integer.MIN_VALUE;
            Domain dom = c.scp[i].dom;
            int a = dom.first();
            while (a != -1) {
                Kit.control((long)this.nConflicts[i][a] == c.nConflictsFor(i, a), () -> "pb with " + c + " " + c.scp[i]);
                max = Math.max(max, this.nConflicts[i][a]);
                a = dom.next(a);
            }
            Kit.control(max == this.nbMaxConflicts[i], () -> "pb with " + c + " " + c.scp[i]);
        });
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("In ").append(this.firstRegisteredCtr()).append(" (nbExploitingConstraints=").append(this.registeredCtrs.size()).append(")\n");
        for (int i = 0; i < this.nConflicts.length; ++i) {
            sb.append("  ").append(i).append(" : nbmaxConflicts=").append(this.nbMaxConflicts[i]).append("  nbConflicts=(").append(Kit.join((Object)this.nConflicts[i], new String[0])).append(")\n");
        }
        return sb.toString();
    }
}

